/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.projectWizard;

import com.intellij.ide.util.newProjectWizard.AbstractProjectWizard;
import com.intellij.ide.util.newProjectWizard.SourcePathsStep;
import com.intellij.ide.util.newProjectWizard.SupportForFrameworksStep;
import com.intellij.ide.util.projectWizard.JavaModuleBuilder;
import com.intellij.ide.util.projectWizard.JavaSettingsStep;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.ProjectBuilder;
import com.intellij.ide.util.projectWizard.ProjectJdkForModuleStep;
import com.intellij.ide.util.projectWizard.ProjectJdkStep;
import com.intellij.ide.util.projectWizard.ProjectNameStep;
import com.intellij.ide.util.projectWizard.ProjectWizardStepFactory;
import com.intellij.ide.util.projectWizard.SettingsStep;
import com.intellij.ide.util.projectWizard.SourcePathsBuilder;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainer;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainerFactory;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectWizardStepFactoryImpl
extends ProjectWizardStepFactory {
    private static final Key<ProjectJdkStep> a = Key.create((String)"ProjectJdkStep");

    public ModuleWizardStep createNameAndLocationStep(WizardContext wizardContext) {
        return new ProjectNameStep(wizardContext);
    }

    public ModuleWizardStep createSourcePathsStep(ModuleWizardStep moduleWizardStep, SourcePathsBuilder sourcePathsBuilder, Icon icon, String string) {
        return null;
    }

    public ModuleWizardStep createSourcePathsStep(WizardContext wizardContext, SourcePathsBuilder sourcePathsBuilder, Icon icon, @NonNls String string) {
        return new SourcePathsStep(sourcePathsBuilder, icon, string);
    }

    public ModuleWizardStep createProjectJdkStep(WizardContext wizardContext, JavaModuleBuilder javaModuleBuilder, Computable<Boolean> computable, Icon icon, String string) {
        return this.createProjectJdkStep(wizardContext, null, javaModuleBuilder, computable, icon, string);
    }

    public ModuleWizardStep createProjectJdkStep(WizardContext wizardContext, SdkType sdkType, final JavaModuleBuilder javaModuleBuilder, final Computable<Boolean> computable, final Icon icon, final @NonNls String string) {
        return new ProjectJdkForModuleStep(wizardContext, sdkType){

            @Override
            public void updateDataModel() {
                super.updateDataModel();
                javaModuleBuilder.setModuleJdk(this.getJdk());
            }

            public boolean isStepVisible() {
                return (Boolean)computable.compute();
            }

            @Override
            public Icon getIcon() {
                return icon;
            }

            public String getName() {
                return "Specify JDK";
            }

            @Override
            public String getHelpId() {
                return string;
            }
        };
    }

    public ModuleWizardStep createProjectJdkStep(final WizardContext wizardContext) {
        ProjectJdkStep projectJdkStep = (ProjectJdkStep)((Object)wizardContext.getUserData(a));
        if (projectJdkStep != null) {
            return projectJdkStep;
        }
        projectJdkStep = new ProjectJdkStep(wizardContext){

            public boolean isStepVisible() {
                Sdk sdk = AbstractProjectWizard.getProjectSdkByDefault(wizardContext);
                if (sdk == null) {
                    return true;
                }
                ProjectBuilder projectBuilder = wizardContext.getProjectBuilder();
                return projectBuilder != null && !projectBuilder.isSuitableSdk(sdk);
            }
        };
        wizardContext.putUserData(a, (Object)projectJdkStep);
        return projectJdkStep;
    }

    @Nullable
    public Sdk getNewProjectSdk(WizardContext wizardContext) {
        return AbstractProjectWizard.getNewProjectJdk(wizardContext);
    }

    public ModuleWizardStep createSupportForFrameworksStep(WizardContext wizardContext, ModuleBuilder moduleBuilder) {
        return this.createSupportForFrameworksStep(wizardContext, moduleBuilder, ModulesProvider.EMPTY_MODULES_PROVIDER);
    }

    public ModuleWizardStep createSupportForFrameworksStep(@NotNull WizardContext wizardContext, @NotNull ModuleBuilder moduleBuilder, @NotNull ModulesProvider modulesProvider) {
        if (wizardContext == null) {
            ProjectWizardStepFactoryImpl.a(0);
        }
        if (moduleBuilder == null) {
            ProjectWizardStepFactoryImpl.a(1);
        }
        if (modulesProvider == null) {
            ProjectWizardStepFactoryImpl.a(2);
        }
        LibrariesContainer librariesContainer = LibrariesContainerFactory.createContainer(wizardContext, modulesProvider);
        return new SupportForFrameworksStep(wizardContext, moduleBuilder, librariesContainer);
    }

    public ModuleWizardStep createJavaSettingsStep(@NotNull SettingsStep settingsStep, @NotNull ModuleBuilder moduleBuilder, @NotNull Condition<SdkTypeId> condition) {
        if (settingsStep == null) {
            ProjectWizardStepFactoryImpl.a(3);
        }
        if (moduleBuilder == null) {
            ProjectWizardStepFactoryImpl.a(4);
        }
        if (condition == null) {
            ProjectWizardStepFactoryImpl.a(5);
        }
        return new JavaSettingsStep(settingsStep, moduleBuilder, condition);
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modulesProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsStep";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleBuilder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkFilter";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/util/projectWizard/ProjectWizardStepFactoryImpl";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createSupportForFrameworksStep";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "createJavaSettingsStep";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

