/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.projectWizard;

import com.intellij.CommonBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import javax.swing.Icon;

public class ProjectWizardUtil {
    private ProjectWizardUtil() {
    }

    public static String findNonExistingFileName(String string, String string2, String string3) {
        int n2 = 0;
        String string4;
        while (new File(string, string4 = (n2 > 0 ? string2 + n2 : string2) + string3).exists()) {
            ++n2;
        }
        return string4;
    }

    public static boolean createDirectoryIfNotExists(String string, String string2, boolean bl2) {
        File file = new File(string2);
        if (!file.exists()) {
            String string3;
            String string4;
            int n2;
            if (bl2 && (n2 = Messages.showOkCancelDialog((String)(string4 = IdeBundle.message((String)"prompt.project.wizard.directory.does.not.exist", (Object[])new Object[]{string, file, string3 = ApplicationNamesInfo.getInstance().getFullProductName()})), (String)IdeBundle.message((String)"title.directory.does.not.exist", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon())) != 0) {
                return false;
            }
            if (!FileUtil.createDirectory((File)file)) {
                Messages.showErrorDialog((String)IdeBundle.message((String)"error.failed.to.create.directory", (Object[])new Object[]{file.getPath()}), (String)CommonBundle.getErrorTitle());
                return false;
            }
        }
        if (SystemInfo.isUnix && !file.canWrite()) {
            Messages.showErrorDialog((String)IdeBundle.message((String)"error.directory.read.only", (Object[])new Object[]{file.getPath()}), (String)CommonBundle.getErrorTitle());
            return false;
        }
        return true;
    }
}

