/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.projectWizard.importSources.util;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.NullableFunction;
import com.intellij.util.text.StringFactory;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.jetbrains.annotations.Nullable;

public abstract class CommonSourceRootDetectionUtil<F> {
    public static final CommonSourceRootDetectionUtil<File> IO_FILE = new CommonSourceRootDetectionUtil<File>(){

        @Override
        protected String getName(File file) {
            return file.getName();
        }

        @Override
        protected File getParentFile(File file) {
            return file.getParentFile();
        }

        @Override
        protected CharSequence loadText(File file) throws IOException {
            return StringFactory.createShared((char[])CommonSourceRootDetectionUtil.a(file));
        }

        @Override
        protected boolean isFile(File file) {
            return file.isFile();
        }
    };
    public static final CommonSourceRootDetectionUtil<VirtualFile> VIRTUAL_FILE = new CommonSourceRootDetectionUtil<VirtualFile>(){

        @Override
        protected String getName(VirtualFile virtualFile) {
            return virtualFile.getName();
        }

        @Override
        protected VirtualFile getParentFile(VirtualFile virtualFile) {
            return virtualFile.getParent();
        }

        @Override
        protected CharSequence loadText(VirtualFile virtualFile) throws IOException {
            return VfsUtilCore.loadText((VirtualFile)virtualFile);
        }

        @Override
        protected boolean isFile(VirtualFile virtualFile) {
            return !virtualFile.isDirectory();
        }
    };

    protected CommonSourceRootDetectionUtil() {
    }

    @Nullable
    public Pair<F, String> suggestRootForFileWithPackageStatement(F f2, F f3, NullableFunction<CharSequence, String> nullableFunction, boolean bl2) {
        CharSequence charSequence;
        if (!this.isFile(f2)) {
            return null;
        }
        try {
            charSequence = this.loadText(f2);
        }
        catch (IOException iOException) {
            return null;
        }
        String string = (String)nullableFunction.fun((Object)charSequence);
        if (string != null) {
            F f4 = this.getParentFile(f2);
            int n2 = string.length();
            while (n2 > 0) {
                boolean bl3;
                int n3 = string.lastIndexOf(46, n2 - 1);
                String string2 = string.substring(n3 + 1, n2);
                String string3 = this.getName(f4);
                boolean bl4 = bl3 = SystemInfo.isFileSystemCaseSensitive ? string3.equals(string2) : string3.equalsIgnoreCase(string2);
                if (!bl3 || f4.equals(f3)) {
                    String string4 = string.substring(0, n2);
                    if (!bl2 && string4.length() > 0) {
                        return null;
                    }
                    return Pair.create(f4, (Object)string4);
                }
                if ((f4 = this.getParentFile(f4)) == null) {
                    return null;
                }
                n2 = n3;
            }
            return Pair.create(f4, (Object)"");
        }
        return null;
    }

    protected abstract String getName(F var1);

    @Nullable
    protected abstract F getParentFile(F var1);

    protected abstract CharSequence loadText(F var1) throws IOException;

    protected abstract boolean isFile(F var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static char[] a(File file) throws IOException {
        InputStream inputStream = CharsetToolkit.inputStreamSkippingBOM((InputStream)new BufferedInputStream(new FileInputStream(file)));
        try (InputStreamReader inputStreamReader = new InputStreamReader(inputStream);){
            char[] cArray = FileUtilRt.loadText((Reader)inputStreamReader, (int)((int)file.length()));
            return cArray;
        }
    }
}

