/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jarFinder;

import com.intellij.codeInsight.AttachSourcesProvider;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.psi.PsiFile;
import com.intellij.util.io.HttpRequests;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractAttachSourceProvider
implements AttachSourcesProvider {
    private static final Logger a = Logger.getInstance(AbstractAttachSourceProvider.class);

    @Nullable
    protected static VirtualFile getJarByPsiFile(@Nullable PsiFile psiFile) {
        VirtualFileSystem virtualFileSystem;
        VirtualFile virtualFile;
        if (psiFile != null && (virtualFile = psiFile.getVirtualFile()) != null && (virtualFileSystem = virtualFile.getFileSystem()) instanceof JarFileSystem) {
            return ((JarFileSystem)virtualFileSystem).getLocalByEntry(virtualFile);
        }
        return null;
    }

    @Nullable
    protected static Library getLibraryFromOrderEntriesList(List<LibraryOrderEntry> list2) {
        if (list2.isEmpty()) {
            return null;
        }
        Library library = list2.get(0).getLibrary();
        if (library == null) {
            return null;
        }
        for (int i2 = 1; i2 < list2.size(); ++i2) {
            if (library.equals(list2.get(i2).getLibrary())) continue;
            return null;
        }
        return library;
    }

    protected void addSourceFile(@Nullable VirtualFile virtualFile, @NotNull Library library) {
        if (library == null) {
            AbstractAttachSourceProvider.a(0);
        }
        if (virtualFile != null && !Arrays.asList(library.getFiles(OrderRootType.SOURCES)).contains(virtualFile)) {
            Library.ModifiableModel modifiableModel = library.getModifiableModel();
            modifiableModel.addRoot(virtualFile, OrderRootType.SOURCES);
            modifiableModel.commit();
        }
    }

    private static /* synthetic */ void a(int n2) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/intellij/jarFinder/AbstractAttachSourceProvider", "addSourceFile"));
    }

    protected static abstract class DownloadSourcesAction
    implements AttachSourcesProvider.AttachSourcesAction {
        protected final Project myProject;
        protected final String myUrl;
        protected final String myMessageGroupId;

        public DownloadSourcesAction(Project project2, String string, String string2) {
            this.myProject = project2;
            this.myUrl = string2;
            this.myMessageGroupId = string;
        }

        public String getName() {
            return "Download Sources";
        }

        public String getBusyText() {
            return "Downloading Sources...";
        }

        protected abstract void storeFile(byte[] var1);

        public ActionCallback perform(List<LibraryOrderEntry> list2) {
            final ActionCallback actionCallback = new ActionCallback();
            Task.Backgroundable backgroundable = new Task.Backgroundable(this.myProject, "Downloading Sources", true){

                public void run(@NotNull ProgressIndicator progressIndicator) {
                    byte[] byArray;
                    if (progressIndicator == null) {
                        1.a(0);
                    }
                    try {
                        a.info("Downloading sources JAR: " + myUrl);
                        progressIndicator.checkCanceled();
                        byArray = HttpRequests.request((String)myUrl).readBytes(progressIndicator);
                    }
                    catch (IOException iOException) {
                        a.warn((Throwable)iOException);
                        ApplicationManager.getApplication().invokeLater(() -> {
                            String string = "Failed to download sources: " + myUrl;
                            new Notification(myMessageGroupId, "Downloading failed", string, NotificationType.ERROR).notify(this.getProject());
                            actionCallback.setDone();
                        });
                        return;
                    }
                    ApplicationManager.getApplication().invokeLater(() -> {
                        try {
                            WriteAction.run(() -> this.storeFile(byArray));
                        }
                        finally {
                            actionCallback.setDone();
                        }
                    });
                }

                public void onCancel() {
                    actionCallback.setRejected();
                }

                private static /* synthetic */ void a(int n2) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/jarFinder/AbstractAttachSourceProvider$DownloadSourcesAction$1", "run"));
                }
            };
            backgroundable.queue();
            return actionCallback;
        }
    }

    protected class AttachExistingSourceAction
    implements AttachSourcesProvider.AttachSourcesAction {
        private final String a;
        private final VirtualFile c;
        private final Library b;

        public AttachExistingSourceAction(VirtualFile virtualFile, Library library, String string) {
            this.c = virtualFile;
            this.b = library;
            this.a = string;
        }

        public String getName() {
            return this.a;
        }

        public String getBusyText() {
            return this.getName();
        }

        public ActionCallback perform(List<LibraryOrderEntry> list2) {
            ApplicationManager.getApplication().assertIsDispatchThread();
            ActionCallback actionCallback = new ActionCallback();
            actionCallback.setDone();
            if (!this.c.isValid()) {
                return actionCallback;
            }
            if (this.b != AbstractAttachSourceProvider.getLibraryFromOrderEntriesList(list2)) {
                return actionCallback;
            }
            WriteAction.run(() -> AbstractAttachSourceProvider.this.addSourceFile(this.c, this.b));
            return actionCallback;
        }
    }
}

