/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jarRepository;

import com.intellij.CommonBundle;
import com.intellij.jarRepository.RemoteRepositoriesConfiguration;
import com.intellij.jarRepository.RemoteRepositoryDescription;
import com.intellij.jarRepository.RepositoryArtifactDescription;
import com.intellij.jarRepository.RepositoryAttachDialog;
import com.intellij.jarRepository.RepositoryLibraryType;
import com.intellij.jarRepository.services.MavenRepositoryServicesManager;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.roots.libraries.NewLibraryConfiguration;
import com.intellij.openapi.roots.libraries.ui.OrderRoot;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditor;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.Processor;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import gnu.trove.THashMap;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.transfer.RepositoryOfflineException;
import org.eclipse.aether.transfer.TransferCancelledException;
import org.eclipse.aether.version.Version;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.aether.ArtifactKind;
import org.jetbrains.idea.maven.aether.ArtifactRepositoryManager;
import org.jetbrains.idea.maven.aether.ProgressConsumer;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryDescription;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryProperties;
import org.jetbrains.jps.model.library.JpsMavenRepositoryLibraryDescriptor;

public class JarRepositoryManager {
    private static final Logger a = Logger.getInstance((String)"#org.jetbrains.idea.maven.utils.library.RepositoryAttachHandler");
    private static final String e = "$MAVEN_REPOSITORY$";
    private static final String c = ".m2/repository";
    private static final AtomicInteger b = new AtomicInteger();
    private static volatile File d;

    public static boolean hasRunningTasks() {
        return b.get() > 0;
    }

    @Nullable
    public static NewLibraryConfiguration chooseLibraryAndDownload(@NotNull Project project2, @Nullable String string, JComponent jComponent) {
        String string2;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        RepositoryAttachDialog repositoryAttachDialog;
        if (project2 == null) {
            JarRepositoryManager.a(0);
        }
        if (!(repositoryAttachDialog = new RepositoryAttachDialog(project2, string, RepositoryAttachDialog.Mode.DOWNLOAD)).showAndGet()) {
            return null;
        }
        String string3 = repositoryAttachDialog.getCoordinateText();
        NewLibraryConfiguration newLibraryConfiguration = JarRepositoryManager.resolveAndDownload(project2, string3, bl4 = repositoryAttachDialog.getAttachSources(), bl3 = repositoryAttachDialog.getAttachJavaDoc(), bl2 = repositoryAttachDialog.getIncludeTransitiveDependencies(), string2 = repositoryAttachDialog.getDirectoryPath(), RemoteRepositoriesConfiguration.getInstance((Project)project2).getRepositories());
        if (newLibraryConfiguration == null) {
            Messages.showErrorDialog((Component)jComponent, (String)("No files were downloaded for " + string3), (String)CommonBundle.getErrorTitle());
        }
        return newLibraryConfiguration;
    }

    @Nullable
    public static NewLibraryConfiguration resolveAndDownload(@NotNull Project project2, String string, boolean bl2, boolean bl3, boolean bl4, String string2, Collection<RemoteRepositoryDescription> collection) {
        RepositoryLibraryProperties repositoryLibraryProperties;
        Collection<OrderRoot> collection2;
        if (project2 == null) {
            JarRepositoryManager.a(1);
        }
        if ((collection2 = JarRepositoryManager.loadDependenciesModal(project2, repositoryLibraryProperties = new RepositoryLibraryProperties(string, bl4), bl2, bl3, string2, collection)) != null && !collection2.isEmpty()) {
            JarRepositoryManager.a(project2, collection2);
            return new NewLibraryConfiguration(RepositoryLibraryDescription.findDescription((RepositoryLibraryProperties)repositoryLibraryProperties).getDisplayName(repositoryLibraryProperties.getVersion()), RepositoryLibraryType.getInstance(), (LibraryProperties)repositoryLibraryProperties){

                public void addRoots(@NotNull LibraryEditor libraryEditor) {
                    if (libraryEditor == null) {
                        1.a(0);
                    }
                    libraryEditor.addRoots(collection2);
                }

                private static /* synthetic */ void a(int n2) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/jarRepository/JarRepositoryManager$1", "addRoots"));
                }
            };
        }
        return null;
    }

    @NotNull
    public static File getLocalRepositoryPath() {
        File file = d;
        if (file != null) {
            File file2 = file;
            if (file2 == null) {
                JarRepositoryManager.a(2);
            }
            return file2;
        }
        String string = PathMacroManager.getInstance((ComponentManager)ApplicationManager.getApplication()).expandPath(e);
        if (!e.equals(string) && (file = new File(string)).exists()) {
            try {
                d = file.getCanonicalFile();
            }
            catch (IOException iOException) {
                d = file;
            }
            File file3 = file;
            if (file3 == null) {
                JarRepositoryManager.a(3);
            }
            return file3;
        }
        String string2 = System.getProperty("user.home", null);
        d = file = string2 != null ? new File(string2, c) : new File(c);
        File file4 = file;
        if (file4 == null) {
            JarRepositoryManager.a(4);
        }
        return file4;
    }

    public static Collection<OrderRoot> loadDependenciesModal(@NotNull Project project2, @NotNull RepositoryLibraryProperties repositoryLibraryProperties, boolean bl2, boolean bl3, @Nullable String string, @Nullable Collection<RemoteRepositoryDescription> collection) {
        if (project2 == null) {
            JarRepositoryManager.a(5);
        }
        if (repositoryLibraryProperties == null) {
            JarRepositoryManager.a(6);
        }
        return JarRepositoryManager.a(project2, repositoryLibraryProperties, bl2, bl3, string, collection, true);
    }

    @Deprecated
    public static Collection<OrderRoot> loadDependencies(@NotNull Project project2, @NotNull RepositoryLibraryProperties repositoryLibraryProperties, boolean bl2, boolean bl3, @Nullable String string, @Nullable Collection<RemoteRepositoryDescription> collection) {
        if (project2 == null) {
            JarRepositoryManager.a(7);
        }
        if (repositoryLibraryProperties == null) {
            JarRepositoryManager.a(8);
        }
        return JarRepositoryManager.a(project2, repositoryLibraryProperties, bl2, bl3, string, collection, false);
    }

    private static Collection<OrderRoot> a(@NotNull Project project2, @NotNull RepositoryLibraryProperties repositoryLibraryProperties, boolean bl2, boolean bl3, @Nullable String string, @Nullable Collection<RemoteRepositoryDescription> list2, boolean bl4) {
        JpsMavenRepositoryLibraryDescriptor jpsMavenRepositoryLibraryDescriptor;
        if (project2 == null) {
            JarRepositoryManager.a(9);
        }
        if (repositoryLibraryProperties == null) {
            JarRepositoryManager.a(10);
        }
        if ((jpsMavenRepositoryLibraryDescriptor = repositoryLibraryProperties.getRepositoryLibraryDescriptor()).getMavenId() != null) {
            if (list2 == null || list2.isEmpty()) {
                list2 = RemoteRepositoriesConfiguration.getInstance((Project)project2).getRepositories();
            }
            if (!list2.isEmpty()) {
                EnumSet<ArtifactKind> enumSet = EnumSet.of(ArtifactKind.ARTIFACT);
                if (bl2) {
                    enumSet.add(ArtifactKind.SOURCES);
                }
                if (bl3) {
                    enumSet.add(ArtifactKind.JAVADOC);
                }
                try {
                    if (bl4) {
                        return JarRepositoryManager.b(project2, "Resolving Maven dependencies...", JarRepositoryManager.a(jpsMavenRepositoryLibraryDescriptor, enumSet, list2, string));
                    }
                    return JarRepositoryManager.a(project2, "Resolving Maven dependencies...", JarRepositoryManager.a(jpsMavenRepositoryLibraryDescriptor, enumSet, list2, string)).get();
                }
                catch (InterruptedException | ExecutionException exception) {
                    a.info((Throwable)exception);
                }
            }
        }
        return Collections.emptyList();
    }

    public static void loadDependenciesAsync(@NotNull Project project2, RepositoryLibraryProperties repositoryLibraryProperties, boolean bl2, boolean bl3, @Nullable List<RemoteRepositoryDescription> list2, @Nullable String string, Consumer<Collection<OrderRoot>> consumer) {
        if (project2 == null) {
            JarRepositoryManager.a(11);
        }
        EnumSet<ArtifactKind> enumSet = EnumSet.of(ArtifactKind.ARTIFACT);
        if (bl2) {
            enumSet.add(ArtifactKind.SOURCES);
        }
        if (bl3) {
            enumSet.add(ArtifactKind.JAVADOC);
        }
        JarRepositoryManager.loadDependenciesAsync(project2, repositoryLibraryProperties.getRepositoryLibraryDescriptor(), enumSet, list2, string, consumer);
    }

    public static void loadDependenciesAsync(@NotNull Project project2, JpsMavenRepositoryLibraryDescriptor jpsMavenRepositoryLibraryDescriptor, Set<ArtifactKind> set, @Nullable List<RemoteRepositoryDescription> list2, @Nullable String string, Consumer<Collection<OrderRoot>> consumer) {
        if (project2 == null) {
            JarRepositoryManager.a(12);
        }
        if (list2 == null || list2.isEmpty()) {
            list2 = RemoteRepositoriesConfiguration.getInstance((Project)project2).getRepositories();
        }
        JarRepositoryManager.a(project2, "Resolving Maven dependencies...", JarRepositoryManager.a(jpsMavenRepositoryLibraryDescriptor, set, list2, string).andThen(collection -> {
            consumer.accept((Collection<OrderRoot>)collection);
            return collection;
        }));
    }

    public static void getAvailableVersionsAsync(Project project2, RepositoryLibraryDescription repositoryLibraryDescription, Consumer<Collection<String>> consumer) {
        List list2 = RemoteRepositoriesConfiguration.getInstance((Project)project2).getRepositories();
        JarRepositoryManager.a(project2, "Looking up available versions for " + repositoryLibraryDescription.getDisplayName(), new VersionResolveJob(repositoryLibraryDescription, list2).andThen(collection -> {
            consumer.accept((Collection<String>)collection);
            return collection;
        }));
    }

    @NotNull
    public static Future<Collection<String>> getAvailableVersions(Project project2, RepositoryLibraryDescription repositoryLibraryDescription) {
        List list2 = RemoteRepositoriesConfiguration.getInstance((Project)project2).getRepositories();
        Future<Collection<String>> future = JarRepositoryManager.a(project2, "Looking up available versions for " + repositoryLibraryDescription.getDisplayName(), new VersionResolveJob(repositoryLibraryDescription, list2));
        if (future == null) {
            JarRepositoryManager.a(13);
        }
        return future;
    }

    private static void a(Project project2, Collection<OrderRoot> collection) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = "The following files were downloaded:";
        stringBuilder.append("<ol>");
        for (OrderRoot orderRoot : collection) {
            stringBuilder.append("<li>");
            stringBuilder.append(orderRoot.getFile().getName());
            stringBuilder.append("</li>");
        }
        stringBuilder.append("</ol>");
        Notifications.Bus.notify((Notification)new Notification("Repository", "The following files were downloaded:", stringBuilder.toString(), NotificationType.INFORMATION), (Project)project2);
    }

    public static void searchArtifacts(final Project project2, String string, final Consumer<Collection<Pair<RepositoryArtifactDescription, RemoteRepositoryDescription>>> consumer) {
        if (string == null || string.length() == 0) {
            return;
        }
        final RepositoryArtifactDescription repositoryArtifactDescription = string.indexOf(58) == -1 && Character.isUpperCase(string.charAt(0)) ? new RepositoryArtifactDescription(null, null, null, "jar", null, string, null) : new RepositoryArtifactDescription(new RepositoryLibraryProperties(string, true), "jar", null);
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project2, "Maven", false){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(@NotNull ProgressIndicator progressIndicator) {
                if (progressIndicator == null) {
                    2.a(0);
                }
                ArrayList<Pair> arrayList = new ArrayList<Pair>();
                try {
                    for (String string : MavenRepositoryServicesManager.getServiceUrls((Project)project2)) {
                        try {
                            List list2 = MavenRepositoryServicesManager.findArtifacts((RepositoryArtifactDescription)repositoryArtifactDescription, (String)string);
                            if (list2.isEmpty()) continue;
                            List list3 = MavenRepositoryServicesManager.getRepositories((String)string);
                            THashMap tHashMap = new THashMap();
                            for (RemoteRepositoryDescription remoteRepositoryDescription : list3) {
                                tHashMap.put(remoteRepositoryDescription.getId(), remoteRepositoryDescription);
                            }
                            for (RemoteRepositoryDescription remoteRepositoryDescription : list2) {
                                RemoteRepositoryDescription remoteRepositoryDescription2 = (RemoteRepositoryDescription)tHashMap.get(remoteRepositoryDescription.getRepositoryId());
                                if (remoteRepositoryDescription2 == null) continue;
                                arrayList.add(Pair.create((Object)remoteRepositoryDescription, (Object)remoteRepositoryDescription2));
                            }
                        }
                        catch (Exception exception) {
                            a.error((Throwable)exception);
                        }
                    }
                }
                finally {
                    ApplicationManager.getApplication().invokeLater(() -> consumer.accept(arrayList));
                }
            }

            private static /* synthetic */ void a(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/jarRepository/JarRepositoryManager$2", "run"));
            }
        });
    }

    public static void searchRepositories(Project project2, final Collection<String> collection, final Processor<Collection<RemoteRepositoryDescription>> processor) {
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project2, "Maven", false){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(@NotNull ProgressIndicator progressIndicator) {
                if (progressIndicator == null) {
                    3.a(0);
                }
                Ref ref = Ref.create(Collections.emptyList());
                try {
                    ArrayList arrayList = new ArrayList();
                    for (String string : collection) {
                        List list2;
                        try {
                            list2 = MavenRepositoryServicesManager.getRepositories((String)string);
                        }
                        catch (Exception exception) {
                            a.warn("Accessing Service at: " + string, (Throwable)exception);
                            continue;
                        }
                        arrayList.addAll(list2);
                    }
                    ref.set(arrayList);
                }
                catch (Exception exception) {
                    a.error((Throwable)exception);
                }
                finally {
                    ApplicationManager.getApplication().invokeLater(() -> processor.process(ref.get()));
                }
            }

            private static /* synthetic */ void a(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/jarRepository/JarRepositoryManager$3", "run"));
            }
        });
    }

    @Nullable
    private static <T> T b(@Nullable Project project2, String string, final Function<ProgressIndicator, T> function) {
        final Ref ref = Ref.create(null);
        new Task.Modal(project2, string, true){

            public void run(@NotNull ProgressIndicator progressIndicator) {
                if (progressIndicator == null) {
                    4.a(0);
                }
                try {
                    b.incrementAndGet();
                    ref.set(function.apply(progressIndicator));
                }
                finally {
                    b.decrementAndGet();
                }
            }

            private static /* synthetic */ void a(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/jarRepository/JarRepositoryManager$4", "run"));
            }
        }.queue();
        return (T)ref.get();
    }

    private static <T> Future<T> a(@Nullable Project project2, String string, Function<ProgressIndicator, T> function) {
        ModalityState modalityState = ModalityState.defaultModalityState();
        return JobExecutor.INSTANCE.submit(() -> {
            try {
                b.incrementAndGet();
                EmptyProgressIndicator emptyProgressIndicator = new EmptyProgressIndicator(modalityState);
                Object object = ProgressManager.getInstance().runProcess(() -> JarRepositoryManager.a(function, (ProgressIndicator)emptyProgressIndicator), (ProgressIndicator)emptyProgressIndicator);
                return object;
            }
            catch (ProcessCanceledException processCanceledException) {
            }
            catch (Throwable throwable) {
                a.info(throwable);
            }
            finally {
                b.decrementAndGet();
            }
            return null;
        });
    }

    private static Collection<String> a(String string, String string2, ArtifactRepositoryManager artifactRepositoryManager) throws Exception {
        try {
            List list2 = artifactRepositoryManager.getAvailableVersions(string, string2, "[0,)", ArtifactKind.ARTIFACT);
            return list2.stream().sorted(Comparator.reverseOrder()).map(Version::toString).collect(Collectors.toCollection(() -> new ArrayList(list2.size())));
        }
        catch (TransferCancelledException transferCancelledException) {
            throw new ProcessCanceledException((Throwable)transferCancelledException);
        }
    }

    private static Function<ProgressIndicator, Collection<OrderRoot>> a(@NotNull JpsMavenRepositoryLibraryDescriptor jpsMavenRepositoryLibraryDescriptor, @NotNull Set<ArtifactKind> set, @NotNull Collection<RemoteRepositoryDescription> collection2, final @Nullable String string) {
        if (jpsMavenRepositoryLibraryDescriptor == null) {
            JarRepositoryManager.a(14);
        }
        if (set == null) {
            JarRepositoryManager.a(15);
        }
        if (collection2 == null) {
            JarRepositoryManager.a(16);
        }
        return new LibraryResolveJob(jpsMavenRepositoryLibraryDescriptor, set, collection2).andThen(collection -> collection.isEmpty() ? Collections.emptyList() : (Collection)new WriteAction<Collection<OrderRoot>>(){

            protected void run(@NotNull Result<Collection<OrderRoot>> result2) throws Throwable {
                if (result2 == null) {
                    5.a(0);
                }
                result2.setResult((Object)JarRepositoryManager.a(collection, string));
            }

            private static /* synthetic */ void a(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/jarRepository/JarRepositoryManager$5", "run"));
            }
        }.execute().getResultObject());
    }

    private static Collection<OrderRoot> a(@NotNull Collection<Artifact> collection, @Nullable String string) {
        if (collection == null) {
            JarRepositoryManager.a(17);
        }
        ArrayList<OrderRoot> arrayList = new ArrayList<OrderRoot>();
        VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
        for (Artifact artifact : collection) {
            try {
                File file;
                File file2 = file = artifact.getFile();
                if (string != null) {
                    file2 = new File(string, file.getName());
                    if (file.exists()) {
                        FileUtil.copy((File)file, (File)file2);
                    }
                }
                virtualFileManager.refreshAndFindFileByUrl(VfsUtilCore.pathToUrl((String)FileUtil.toSystemIndependentName((String)file2.getPath())));
                String string2 = VfsUtil.getUrlForLibraryRoot((File)file2);
                VirtualFile virtualFile = virtualFileManager.refreshAndFindFileByUrl(string2);
                if (virtualFile == null) continue;
                OrderRootType orderRootType = ArtifactKind.JAVADOC.getClassifier().equals(artifact.getClassifier()) ? JavadocOrderRootType.getInstance() : (ArtifactKind.SOURCES.getClassifier().equals(artifact.getClassifier()) ? OrderRootType.SOURCES : OrderRootType.CLASSES);
                arrayList.add(new OrderRoot(virtualFile, orderRootType));
            }
            catch (IOException iOException) {
                a.warn((Throwable)iOException);
            }
        }
        return arrayList;
    }

    private static /* synthetic */ Object a(Function function, ProgressIndicator progressIndicator) {
        return function.apply(progressIndicator);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 13: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jarRepository/JarRepositoryManager";
                break;
            }
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryProps";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "desc";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kinds";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifacts";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jarRepository/JarRepositoryManager";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalRepositoryPath";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableVersions";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "chooseLibraryAndDownload";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "resolveAndDownload";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 13: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "loadDependenciesModal";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "loadDependencies";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "loadDependenciesImpl";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "loadDependenciesAsync";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "newOrderRootResolveJob";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createRoots";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class VersionResolveJob
    extends AetherJob<Collection<String>> {
        @NotNull
        private final RepositoryLibraryDescription b;

        public VersionResolveJob(@NotNull RepositoryLibraryDescription repositoryLibraryDescription, @NotNull List<RemoteRepositoryDescription> list2) {
            if (repositoryLibraryDescription == null) {
                VersionResolveJob.b(0);
            }
            if (list2 == null) {
                VersionResolveJob.b(1);
            }
            super(list2);
            this.b = repositoryLibraryDescription;
        }

        @Override
        protected String getProgressText() {
            return "Loading " + this.b.getDisplayName() + " versions";
        }

        @Override
        protected Collection<String> perform(ProgressIndicator progressIndicator, ArtifactRepositoryManager artifactRepositoryManager) throws Exception {
            return JarRepositoryManager.a(this.b.getGroupId(), this.b.getArtifactId(), artifactRepositoryManager);
        }

        @Override
        protected Collection<String> getDefaultResult() {
            return Collections.emptyList();
        }

        private static /* synthetic */ void b(int n2) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "repositoryLibraryDescription";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "repositories";
                    break;
                }
            }
            objectArray[1] = "com/intellij/jarRepository/JarRepositoryManager$VersionResolveJob";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class LibraryResolveJob
    extends AetherJob<Collection<Artifact>> {
        @NotNull
        private final JpsMavenRepositoryLibraryDescriptor b;
        @NotNull
        private final Set<ArtifactKind> c;

        public LibraryResolveJob(@NotNull JpsMavenRepositoryLibraryDescriptor jpsMavenRepositoryLibraryDescriptor, @NotNull Set<ArtifactKind> set, @NotNull Collection<RemoteRepositoryDescription> collection) {
            if (jpsMavenRepositoryLibraryDescriptor == null) {
                LibraryResolveJob.b(0);
            }
            if (set == null) {
                LibraryResolveJob.b(1);
            }
            if (collection == null) {
                LibraryResolveJob.b(2);
            }
            super(collection);
            this.b = jpsMavenRepositoryLibraryDescriptor;
            this.c = set;
        }

        @Override
        protected boolean canStart() {
            return super.canStart() && this.b.getMavenId() != null;
        }

        @Override
        protected String getProgressText() {
            return "Loading " + RepositoryLibraryDescription.findDescription((JpsMavenRepositoryLibraryDescriptor)this.b).getDisplayName();
        }

        @Override
        protected Collection<Artifact> getDefaultResult() {
            return Collections.emptyList();
        }

        @Override
        protected Collection<Artifact> perform(ProgressIndicator progressIndicator, ArtifactRepositoryManager artifactRepositoryManager) throws Exception {
            String string = this.b.getVersion();
            try {
                return artifactRepositoryManager.resolveDependencyAsArtifact(this.b.getGroupId(), this.b.getArtifactId(), string, this.c, this.b.isIncludeTransitiveDependencies());
            }
            catch (TransferCancelledException transferCancelledException) {
                throw new ProcessCanceledException((Throwable)transferCancelledException);
            }
            catch (RepositoryOfflineException repositoryOfflineException) {
                throw repositoryOfflineException;
            }
            catch (Exception exception) {
                String string2 = this.a(artifactRepositoryManager, string);
                if (Comparing.equal((String)string, (String)string2)) {
                    throw exception;
                }
                try {
                    return artifactRepositoryManager.resolveDependencyAsArtifact(this.b.getGroupId(), this.b.getArtifactId(), string2, this.c, this.b.isIncludeTransitiveDependencies());
                }
                catch (TransferCancelledException transferCancelledException) {
                    throw new ProcessCanceledException((Throwable)transferCancelledException);
                }
            }
        }

        @Nullable
        private String a(ArtifactRepositoryManager artifactRepositoryManager, String string) throws Exception {
            boolean bl2 = "LATEST".equals(string);
            boolean bl3 = "RELEASE".equals(string);
            if (bl2 || bl3) {
                try {
                    for (String string2 : JarRepositoryManager.a(this.b.getGroupId(), this.b.getArtifactId(), artifactRepositoryManager)) {
                        if (bl3 && string2.endsWith("-SNAPSHOT")) continue;
                        return string2;
                    }
                }
                catch (InterruptedException | ExecutionException exception) {
                    a.error("Got unexpected exception while resolving artifact versions", (Throwable)exception);
                }
            }
            return string;
        }

        private static /* synthetic */ void b(int n2) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "desc";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "kinds";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "repositories";
                    break;
                }
            }
            objectArray[1] = "com/intellij/jarRepository/JarRepositoryManager$LibraryResolveJob";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static abstract class AetherJob<T>
    implements Function<ProgressIndicator, T> {
        @NotNull
        private final Collection<RemoteRepositoryDescription> a;

        public AetherJob(@NotNull Collection<RemoteRepositoryDescription> collection) {
            if (collection == null) {
                AetherJob.a(0);
            }
            this.a = collection;
        }

        protected boolean canStart() {
            return !this.a.isEmpty();
        }

        @Override
        public final T apply(final ProgressIndicator progressIndicator) {
            if (this.canStart()) {
                progressIndicator.setText(this.getProgressText());
                progressIndicator.setIndeterminate(true);
                ArrayList<RemoteRepository> arrayList = new ArrayList<RemoteRepository>();
                for (RemoteRepositoryDescription remoteRepositoryDescription : this.a) {
                    arrayList.add(ArtifactRepositoryManager.createRemoteRepository((String)remoteRepositoryDescription.getId(), (String)remoteRepositoryDescription.getUrl()));
                }
                try {
                    return this.perform(progressIndicator, new ArtifactRepositoryManager(JarRepositoryManager.getLocalRepositoryPath(), arrayList, new ProgressConsumer(){

                        public void consume(String string) {
                            progressIndicator.setText(string);
                        }

                        public boolean isCanceled() {
                            return progressIndicator.isCanceled();
                        }
                    }));
                }
                catch (ProcessCanceledException processCanceledException) {
                    throw processCanceledException;
                }
                catch (Exception exception) {
                    a.info((Throwable)exception);
                }
            }
            return this.getDefaultResult();
        }

        protected abstract String getProgressText();

        protected abstract T perform(ProgressIndicator var1, ArtifactRepositoryManager var2) throws Exception;

        protected abstract T getDefaultResult();

        private static /* synthetic */ void a(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "com/intellij/jarRepository/JarRepositoryManager$AetherJob", "<init>"));
        }
    }

    private static class JobExecutor {
        static final ExecutorService INSTANCE = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"RemoteLibraryDownloader");

        private JobExecutor() {
        }
    }
}

