/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jarRepository;

import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.jarRepository.JarRepositoryManager;
import com.intellij.jarRepository.RepositoryArtifactDescription;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.FileChooserDialog;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.aether.version.InvalidVersionSpecificationException;
import org.eclipse.aether.version.Version;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.aether.ArtifactRepositoryManager;
import org.jetbrains.jps.model.library.JpsMavenRepositoryLibraryDescriptor;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class RepositoryAttachDialog
extends DialogWrapper {
    @NonNls
    private static final String f = "Downloaded.Files.Path";
    @NonNls
    private static final String e = "Downloaded.Files.Path.Enabled";
    @NonNls
    private static final String m = "Repository.Attach.JavaDocs";
    @NonNls
    private static final String q = "Repository.Attach.Sources";
    @NotNull
    private final Mode h;
    private final Project c;
    private JBLabel t;
    private JCheckBox b;
    private JCheckBox y;
    private AsyncProcessIcon d;
    private ComboboxWithBrowseButton g;
    private JPanel a;
    private TextFieldWithBrowseButton x;
    private JBCheckBox r;
    private JBLabel j;
    private JPanel p;
    private JBCheckBox u;
    private JPanel n;
    private JBCheckBox w;
    private final JComboBox k;
    private final Map<String, RepositoryArtifactDescription> i;
    private final List<String> v;
    private final String o;
    private String l;
    private boolean s;

    public RepositoryAttachDialog(@NotNull Project project2, @Nullable String string, @NotNull Mode mode) {
        if (project2 == null) {
            RepositoryAttachDialog.a(0);
        }
        if (mode == null) {
            RepositoryAttachDialog.a(1);
        }
        super(project2, true);
        this.b();
        this.i = ContainerUtil.newTroveMap();
        this.v = ContainerUtil.newArrayList();
        this.h = mode;
        this.setTitle(mode == Mode.DOWNLOAD ? "Download Library from Maven Repository" : "Search Library in Maven Repositories");
        this.c = project2;
        this.d.suspend();
        this.j.setText(XmlStringUtil.wrapInHtml((CharSequence)StringUtil.escapeXml((String)"keyword or class name to search by or exact Maven coordinates, i.e. 'spring', 'Logger' or 'ant:ant-junit:1.6.5'")));
        this.t.setPreferredSize(new Dimension(this.t.getFontMetrics(this.t.getFont()).stringWidth("Showing: 1000"), this.t.getPreferredSize().height));
        this.g.setButtonIcon(AllIcons.Actions.Menu_find);
        this.g.getButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RepositoryAttachDialog.this.e();
            }
        });
        this.k = this.g.getComboBox();
        this.k.setModel(new CollectionComboBoxModel(this.v, null));
        this.k.setEditable(true);
        final JTextField jTextField = (JTextField)this.k.getEditor().getEditorComponent();
        jTextField.setColumns(20);
        if (string != null) {
            jTextField.setText(string);
        }
        jTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent documentEvent) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (RepositoryAttachDialog.this.d.isDisposed()) {
                        return;
                    }
                    ApplicationManager.getApplication().invokeLater(() -> {
                        if (RepositoryAttachDialog.this.d.isDisposed()) {
                            return;
                        }
                        RepositoryAttachDialog.a(documentEvent, jTextField);
                        RepositoryAttachDialog.this.a(false);
                    });
                    RepositoryAttachDialog.this.a(false);
                });
            }
        });
        this.k.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl2 = RepositoryAttachDialog.this.k.isPopupVisible();
                if (!(RepositoryAttachDialog.this.s || bl2 && !RepositoryAttachDialog.this.i.isEmpty())) {
                    RepositoryAttachDialog.this.e();
                } else {
                    String string = (String)RepositoryAttachDialog.this.k.getSelectedItem();
                    if (StringUtil.isNotEmpty((String)string)) {
                        ((JTextField)RepositoryAttachDialog.this.k.getEditor().getEditorComponent()).setText(string);
                    }
                }
            }
        });
        VirtualFile virtualFile = !this.c.isDefault() ? this.c.getBaseDir() : null;
        this.o = virtualFile != null ? FileUtil.toSystemDependentName((String)(virtualFile.getPath() + "/lib")) : "";
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)this.c);
        this.r.setSelected(propertiesComponent.isTrueValue(e));
        this.x.setText(StringUtil.notNullize((String)StringUtil.nullize((String)propertiesComponent.getValue(f)), (String)this.o));
        this.x.setEnabled(this.r.isSelected());
        this.r.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RepositoryAttachDialog.this.x.setEnabled(RepositoryAttachDialog.this.r.isSelected());
            }
        });
        this.b.setSelected(propertiesComponent.isTrueValue(m));
        this.y.setSelected(propertiesComponent.isTrueValue(q));
        FileChooserDescriptor fileChooserDescriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        fileChooserDescriptor.putUserData(FileChooserDialog.PREFER_LAST_OVER_TO_SELECT, (Object)Boolean.TRUE);
        this.x.addBrowseFolderListener(ProjectBundle.message((String)"file.chooser.directory.for.downloaded.libraries.title", (Object[])new Object[0]), ProjectBundle.message((String)"file.chooser.directory.for.downloaded.libraries.description", (Object[])new Object[0]), null, fileChooserDescriptor);
        this.a();
        this.p.setVisible(mode == Mode.DOWNLOAD);
        this.n.setVisible(mode == Mode.SEARCH);
        this.init();
    }

    private static void a(DocumentEvent documentEvent, JTextField jTextField) {
        String string;
        if (documentEvent.getType() == DocumentEvent.EventType.INSERT && RepositoryAttachDialog.a(string = jTextField.getText())) {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setValidating(false);
            try {
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                try {
                    Document document = documentBuilder.parse(new InputSource(new StringReader(string)));
                    String string2 = RepositoryAttachDialog.d(document);
                    if (string2 != null) {
                        jTextField.setText(string2);
                    }
                }
                catch (IOException | SAXException exception) {}
            }
            catch (ParserConfigurationException parserConfigurationException) {
                // empty catch block
            }
        }
    }

    public boolean getAttachJavaDoc() {
        return this.b.isSelected();
    }

    public boolean getAttachSources() {
        return this.y.isSelected();
    }

    public boolean getIncludeTransitiveDependencies() {
        return this.h == Mode.DOWNLOAD ? this.u.isSelected() : this.w.isSelected();
    }

    @Nullable
    public String getDirectoryPath() {
        return this.r.isSelected() ? this.x.getText() : null;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.k;
    }

    private void a(boolean bl2) {
        Object object;
        boolean bl3;
        boolean bl4;
        String string = this.l;
        JTextComponent jTextComponent = (JTextComponent)this.k.getEditor().getEditorComponent();
        int n2 = jTextComponent.getCaretPosition();
        this.l = jTextComponent.getText();
        if (!bl2 && Comparing.equal((String)this.l, (String)string)) {
            return;
        }
        int n3 = this.v.size();
        this.v.clear();
        this.s = true;
        boolean bl5 = bl4 = this.i.containsKey(this.l) && Comparing.strEqual((String)((String)this.k.getSelectedItem()), (String)this.l, (boolean)false);
        if (bl4) {
            this.v.addAll(this.i.keySet());
            bl3 = false;
        } else {
            object = this.l.split(" ");
            block0: for (String object2 : this.i.keySet()) {
                for (String string2 : object) {
                    if (!StringUtil.containsIgnoreCase((String)object2, (String)string2)) continue block0;
                }
                this.v.add(object2);
            }
            boolean bl6 = bl3 = !this.v.isEmpty();
            if (!bl3) {
                this.v.addAll(this.i.keySet());
            }
            this.k.setSelectedItem(null);
        }
        object = new ArrayList(this.v.size());
        for (String string3 : this.v) {
            ((ArrayList)object).add(new LibItem(string3));
        }
        Collections.sort(object, (libItem, libItem2) -> Comparing.compare((Comparable)libItem, (Comparable)libItem2));
        this.v.clear();
        Iterator<String> iterator = ((ArrayList)object).iterator();
        while (iterator.hasNext()) {
            LibItem libItem3 = (LibItem)((Object)iterator.next());
            this.v.add(libItem3.coord);
        }
        ((CollectionComboBoxModel)this.k.getModel()).update();
        this.s = false;
        jTextComponent.setText(this.l);
        jTextComponent.setCaretPosition(n2);
        this.a();
        if (bl3) {
            if (n3 < 10 && this.v.size() > n3 && this.k.isPopupVisible()) {
                this.k.setPopupVisible(false);
            }
            if (!this.k.isPopupVisible()) {
                this.k.setPopupVisible(true);
            }
        }
    }

    private boolean e() {
        String string = this.getCoordinateText();
        if (this.d.isRunning() || StringUtil.isEmptyOrSpaces((String)string) || this.i.containsKey(string)) {
            return false;
        }
        this.d.resume();
        JarRepositoryManager.searchArtifacts(this.c, string, collection -> {
            try {
                if (this.d.isDisposed()) {
                    return;
                }
                this.d.suspend();
                int n2 = this.i.size();
                for (Pair pair2 : collection) {
                    RepositoryArtifactDescription repositoryArtifactDescription = (RepositoryArtifactDescription)pair2.first;
                    this.i.put(repositoryArtifactDescription.getGroupId() + ":" + repositoryArtifactDescription.getArtifactId() + ":" + repositoryArtifactDescription.getVersion(), repositoryArtifactDescription);
                }
                this.a(n2 != this.i.size());
            }
            finally {
                this.setOKActionEnabled(true);
            }
        });
        return true;
    }

    private void a() {
        this.t.setText("<html>Found: " + this.i.size() + "<br>Showing: " + this.k.getModel().getSize() + "</html>");
    }

    protected ValidationInfo doValidate() {
        File file;
        if (!this.c()) {
            return new ValidationInfo("Please enter valid coordinate, discover it or select one from the list", (JComponent)this.k);
        }
        if (this.r.isSelected() && (!(file = new File(this.x.getText())).exists() && !file.mkdirs() || !file.isDirectory())) {
            return new ValidationInfo("Please enter valid library files path", (JComponent)this.x.getTextField());
        }
        return super.doValidate();
    }

    protected JComponent createCenterPanel() {
        return null;
    }

    protected JComponent createNorthPanel() {
        return this.a;
    }

    protected void dispose() {
        Disposer.dispose((Disposable)this.d);
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)this.c);
        propertiesComponent.setValue(e, String.valueOf(this.r.isSelected()));
        String string = this.x.getText();
        if (StringUtil.isEmptyOrSpaces((String)string)) {
            string = this.o;
        }
        propertiesComponent.setValue(f, string, this.o);
        propertiesComponent.setValue(m, String.valueOf(this.b.isSelected()));
        propertiesComponent.setValue(q, String.valueOf(this.y.isSelected()));
        super.dispose();
    }

    protected String getDimensionServiceKey() {
        return RepositoryAttachDialog.class.getName() + "-" + (Object)((Object)this.h);
    }

    private boolean c() {
        String string = this.getCoordinateText();
        return string.split(":").length == 3;
    }

    public String getCoordinateText() {
        JTextField jTextField = (JTextField)this.k.getEditor().getEditorComponent();
        return jTextField.getText();
    }

    private void d() {
        this.d = new AsyncProcessIcon("Progress");
    }

    private static boolean a(String string) {
        String string2 = string.trim();
        return string2.startsWith("<dependency>") && string2.endsWith("</dependency>");
    }

    @Nullable
    private static String d(Document document) {
        String string = RepositoryAttachDialog.a(document);
        String string2 = RepositoryAttachDialog.b(document);
        if (string.isEmpty() && string2.isEmpty()) {
            return null;
        }
        String string3 = RepositoryAttachDialog.c(document);
        String string4 = RepositoryAttachDialog.e(document);
        String string5 = string4.isEmpty() ? "" : ":" + string4;
        return string + ":" + string2 + ":" + string3 + string5;
    }

    private static String c(@NotNull Document document) {
        if (document == null) {
            RepositoryAttachDialog.a(2);
        }
        return RepositoryAttachDialog.a(document.getElementsByTagName("version"));
    }

    private static String b(@NotNull Document document) {
        if (document == null) {
            RepositoryAttachDialog.a(3);
        }
        return RepositoryAttachDialog.a(document.getElementsByTagName("artifactId"));
    }

    private static String a(@NotNull Document document) {
        if (document == null) {
            RepositoryAttachDialog.a(4);
        }
        return RepositoryAttachDialog.a(document.getElementsByTagName("groupId"));
    }

    private static String e(@NotNull Document document) {
        if (document == null) {
            RepositoryAttachDialog.a(5);
        }
        return RepositoryAttachDialog.a(document.getElementsByTagName("classifier"));
    }

    private static String a(@NotNull NodeList nodeList) {
        Node node;
        if (nodeList == null) {
            RepositoryAttachDialog.a(6);
        }
        return (node = nodeList.item(0)) != null ? node.getTextContent() : "";
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
        }
        objectArray2[1] = "com/intellij/jarRepository/RepositoryAttachDialog";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getVersion";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getArtifactId";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getGroupId";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getClassifier";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "firstOrEmpty";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private /* synthetic */ void b() {
        JBCheckBox jBCheckBox;
        JPanel jPanel;
        JBCheckBox jBCheckBox2;
        JBCheckBox jBCheckBox3;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel2;
        JBLabel jBLabel;
        JBLabel jBLabel2;
        ComboboxWithBrowseButton comboboxWithBrowseButton;
        JPanel jPanel3;
        this.d();
        this.a = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 15, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.g = comboboxWithBrowseButton = new ComboboxWithBrowseButton();
        jPanel4.add((Component)comboboxWithBrowseButton, new GridConstraints(0, 0, 1, 1, 0, 1, 7, 3, null, null, null));
        AsyncProcessIcon asyncProcessIcon = this.d;
        jPanel4.add((Component)asyncProcessIcon, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.t = jBLabel2 = new JBLabel();
        jBLabel2.setComponentStyle(UIUtil.ComponentStyle.MINI);
        jBLabel2.setFontColor(UIUtil.FontColor.BRIGHTER);
        jBLabel2.setText("Info");
        jPanel4.add((Component)jBLabel2, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        this.j = jBLabel = new JBLabel();
        jBLabel.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        jBLabel.setFontColor(UIUtil.FontColor.BRIGHTER);
        jBLabel.setText("Description");
        jPanel4.add((Component)jBLabel, new GridConstraints(1, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        this.p = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel2, new GridConstraints(1, 0, 2, 2, 0, 3, 3, 3, null, null, null));
        this.x = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        textFieldWithBrowseButton.setText("");
        jPanel2.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel5, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.y = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Sources");
        jCheckBox2.setMnemonic('S');
        jCheckBox2.setDisplayedMnemonicIndex(0);
        jPanel5.add((Component)jCheckBox2, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        this.b = jCheckBox = new JCheckBox();
        jCheckBox.setText("JavaDocs");
        jCheckBox.setMnemonic('D');
        jCheckBox.setDisplayedMnemonicIndex(4);
        jPanel5.add((Component)jCheckBox, new GridConstraints(0, 3, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel5.add((Component)spacer2, new GridConstraints(0, 0, 1, 1, 0, 1, 6, 1, null, null, null));
        this.u = jBCheckBox3 = new JBCheckBox();
        jBCheckBox3.setSelected(true);
        jBCheckBox3.setText("Transitive dependencies");
        jBCheckBox3.setMnemonic('T');
        jBCheckBox3.setDisplayedMnemonicIndex(0);
        jPanel5.add((Component)jBCheckBox3, new GridConstraints(0, 1, 1, 1, 0, 0, 0, 0, null, null, null));
        this.r = jBCheckBox2 = new JBCheckBox();
        jBCheckBox2.setText("Download to:  ");
        jPanel2.add((Component)jBCheckBox2, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.n = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel.add((Component)spacer3, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.w = jBCheckBox = new JBCheckBox();
        jBCheckBox.setSelected(true);
        jBCheckBox.setText("Include transitive dependencies");
        jBCheckBox.setMnemonic('T');
        jBCheckBox.setDisplayedMnemonicIndex(8);
        jPanel.add((Component)jBCheckBox, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.a;
    }

    private static final class LibItem
    implements Comparable<LibItem> {
        final String prefix;
        final Version ver;
        final String coord;

        public LibItem(String string) {
            this.coord = string;
            JpsMavenRepositoryLibraryDescriptor jpsMavenRepositoryLibraryDescriptor = new JpsMavenRepositoryLibraryDescriptor(string);
            this.prefix = jpsMavenRepositoryLibraryDescriptor.getGroupId() + ":" + jpsMavenRepositoryLibraryDescriptor.getArtifactId();
            Version version = null;
            try {
                version = ArtifactRepositoryManager.asVersion((String)jpsMavenRepositoryLibraryDescriptor.getVersion());
            }
            catch (InvalidVersionSpecificationException invalidVersionSpecificationException) {
                // empty catch block
            }
            this.ver = version;
        }

        @Override
        public int compareTo(@NotNull LibItem libItem) {
            int n2;
            if (libItem == null) {
                LibItem.a(0);
            }
            return (n2 = this.prefix.compareTo(libItem.prefix)) != 0 ? n2 : Comparing.compare((Comparable)libItem.ver, (Comparable)this.ver);
        }

        private static /* synthetic */ void a(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "that", "com/intellij/jarRepository/RepositoryAttachDialog$LibItem", "compareTo"));
        }
    }

    public static enum Mode {
        SEARCH,
        DOWNLOAD;

    }
}

