/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.compiler.util;

import com.intellij.compiler.impl.FileSetCompileScope;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.ex.CompileContextEx;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.descriptors.ConfigFile;
import gnu.trove.THashSet;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InspectionValidatorUtil {
    private InspectionValidatorUtil() {
    }

    public static void addDescriptor(@NotNull Collection<VirtualFile> collection, @Nullable ConfigFile configFile) {
        if (collection == null) {
            InspectionValidatorUtil.a(0);
        }
        if (configFile != null) {
            ContainerUtil.addIfNotNull(collection, (Object)configFile.getVirtualFile());
        }
    }

    public static void addFile(@NotNull Collection<VirtualFile> collection, @Nullable PsiFile psiFile) {
        if (collection == null) {
            InspectionValidatorUtil.a(1);
        }
        if (psiFile != null) {
            ContainerUtil.addIfNotNull(collection, (Object)psiFile.getVirtualFile());
        }
    }

    public static Collection<VirtualFile> expandCompileScopeIfNeeded(Collection<VirtualFile> collection, CompileContext compileContext) {
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)compileContext.getProject()).getFileIndex();
        THashSet tHashSet = new THashSet();
        THashSet tHashSet2 = new THashSet();
        for (VirtualFile virtualFile : collection) {
            if (projectFileIndex.getSourceRootForFile(virtualFile) != null) continue;
            tHashSet.add((Object)virtualFile);
            ContainerUtil.addIfNotNull((Collection)tHashSet2, (Object)projectFileIndex.getModuleForFile(virtualFile));
        }
        if (!tHashSet.isEmpty()) {
            ((CompileContextEx)compileContext).addScope(new FileSetCompileScope((Collection<VirtualFile>)tHashSet, (Module[])tHashSet2.toArray((Object[])new Module[tHashSet2.size()])));
        }
        return collection;
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "result";
        objectArray2[1] = "com/intellij/openapi/compiler/util/InspectionValidatorUtil";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addDescriptor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "addFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

