/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.compiler.util;

import com.intellij.compiler.CompilerIOUtil;
import com.intellij.openapi.compiler.ValidityState;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.io.IOUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class PsiElementsValidityState
implements ValidityState {
    private final Map<String, Long> a = new HashMap<String, Long>();

    public void addDependency(String string, Long l2) {
        this.a.put(string, l2);
    }

    public boolean equalsTo(ValidityState validityState) {
        return validityState instanceof PsiElementsValidityState && this.a.equals(((PsiElementsValidityState)validityState).a);
    }

    public void save(DataOutput dataOutput) throws IOException {
        Set<Map.Entry<String, Long>> set = this.a.entrySet();
        dataOutput.writeInt(set.size());
        for (Map.Entry<String, Long> entry : set) {
            IOUtil.writeString((String)entry.getKey(), (DataOutput)dataOutput);
            dataOutput.writeLong(entry.getValue());
        }
    }

    public static PsiElementsValidityState load(DataInput dataInput) throws IOException {
        int n2 = dataInput.readInt();
        PsiElementsValidityState psiElementsValidityState = new PsiElementsValidityState();
        while (n2-- > 0) {
            String string = CompilerIOUtil.readString(dataInput);
            long l2 = dataInput.readLong();
            psiElementsValidityState.addDependency(string, l2);
        }
        return psiElementsValidityState;
    }

    public void addDependency(PsiElement psiElement) {
        VirtualFile virtualFile;
        PsiFile psiFile = psiElement.getContainingFile();
        if (psiFile != null && (virtualFile = psiFile.getVirtualFile()) != null) {
            this.addDependency(virtualFile.getUrl(), virtualFile.getTimeStamp());
        }
    }
}

