/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.action;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.externalSystem.action.ExternalSystemNodeAction;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManagerImpl;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataManagerImpl;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.view.ProjectNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.util.containers.ContainerUtilRt;
import java.util.ArrayList;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class DetachExternalProjectAction
extends ExternalSystemNodeAction<ProjectData> {
    public DetachExternalProjectAction() {
        super(ProjectData.class);
        this.getTemplatePresentation().setText(ExternalSystemBundle.message((String)"action.detach.external.project.text", (Object[])new Object[]{"external"}));
        this.getTemplatePresentation().setDescription(ExternalSystemBundle.message((String)"action.detach.external.project.description", (Object[])new Object[0]));
        this.getTemplatePresentation().setIcon(SystemInfoRt.isMac ? AllIcons.ToolbarDecorator.Mac.Remove : AllIcons.ToolbarDecorator.Remove);
    }

    @Override
    public void update(@NotNull AnActionEvent anActionEvent) {
        if (anActionEvent == null) {
            DetachExternalProjectAction.c(0);
        }
        super.update(anActionEvent);
        if (((Object)((Object)this)).getClass() != DetachExternalProjectAction.class) {
            return;
        }
        ProjectSystemId projectSystemId = this.getSystemId(anActionEvent);
        String string = projectSystemId != null ? projectSystemId.getReadableName() : "external";
        Presentation presentation = anActionEvent.getPresentation();
        presentation.setText(ExternalSystemBundle.message((String)"action.detach.external.project.text", (Object[])new Object[]{string}));
    }

    @Override
    protected boolean isEnabled(AnActionEvent anActionEvent) {
        if (!super.isEnabled(anActionEvent)) {
            return false;
        }
        return ExternalSystemDataKeys.SELECTED_PROJECT_NODE.getData(anActionEvent.getDataContext()) != null;
    }

    @Override
    public void perform(@NotNull Project project2, @NotNull ProjectSystemId projectSystemId, @NotNull ProjectData projectData, @NotNull AnActionEvent anActionEvent) {
        if (project2 == null) {
            DetachExternalProjectAction.c(1);
        }
        if (projectSystemId == null) {
            DetachExternalProjectAction.c(2);
        }
        if (projectData == null) {
            DetachExternalProjectAction.c(3);
        }
        if (anActionEvent == null) {
            DetachExternalProjectAction.c(4);
        }
        anActionEvent.getPresentation().setText(ExternalSystemBundle.message((String)"action.detach.external.project.text", (Object[])new Object[]{projectSystemId.getReadableName()}));
        ProjectNode projectNode = (ProjectNode)ExternalSystemDataKeys.SELECTED_PROJECT_NODE.getData(anActionEvent.getDataContext());
        assert (projectNode != null);
        ExternalSystemApiUtil.getLocalSettings((Project)project2, (ProjectSystemId)projectSystemId).forgetExternalProjects(Collections.singleton(projectData.getLinkedExternalProjectPath()));
        ExternalSystemApiUtil.getSettings((Project)project2, (ProjectSystemId)projectSystemId).unlinkExternalProject(projectData.getLinkedExternalProjectPath());
        ExternalProjectsManagerImpl.getInstance(project2).forgetExternalProjectData(projectSystemId, projectData.getLinkedExternalProjectPath());
        ArrayList arrayList = ContainerUtilRt.newArrayList();
        for (Module module2 : ModuleManager.getInstance((Project)project2).getModules()) {
            if (!ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)projectSystemId, (Module)module2)) continue;
            String string = ExternalSystemApiUtil.getExternalRootProjectPath((Module)module2);
            if (!projectData.getLinkedExternalProjectPath().equals(string)) continue;
            arrayList.add(module2);
        }
        if (!arrayList.isEmpty()) {
            projectNode.getGroup().remove(projectNode);
            ProjectDataManagerImpl.getInstance().removeData(ProjectKeys.MODULE, arrayList, Collections.emptyList(), projectData, project2, false);
        }
    }

    private static /* synthetic */ void c(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectSystemId";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectData";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/externalSystem/action/DetachExternalProjectAction";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "perform";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

