/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.action;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.action.ExternalSystemToggleAction;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ExternalConfigPathAware;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.externalSystem.view.ExternalSystemNode;
import com.intellij.openapi.externalSystem.view.ModuleNode;
import com.intellij.openapi.externalSystem.view.ProjectNode;
import com.intellij.openapi.project.Project;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class IgnoreExternalProjectAction
extends ExternalSystemToggleAction {
    private static final Logger a = Logger.getInstance(IgnoreExternalProjectAction.class);

    public IgnoreExternalProjectAction() {
        this.getTemplatePresentation().setText(ExternalSystemBundle.message((String)"action.ignore.external.project.text", (Object[])new Object[]{"external"}));
        this.getTemplatePresentation().setDescription(ExternalSystemBundle.message((String)"action.ignore.external.project.description", (Object[])new Object[]{"external"}));
    }

    public void setSelected(AnActionEvent anActionEvent, boolean bl2) {
        ProjectSystemId projectSystemId = this.getSystemId(anActionEvent);
        ExternalSystemNode<ExternalConfigPathAware> externalSystemNode = IgnoreExternalProjectAction.a(anActionEvent);
        if (projectSystemId == null || externalSystemNode == null || externalSystemNode.getData() == null) {
            return;
        }
        externalSystemNode.setIgnored(bl2);
        Project project2 = this.getProject(anActionEvent);
        String string = externalSystemNode.getData().getLinkedExternalProjectPath();
        ExternalProjectInfo externalProjectInfo = ExternalSystemUtil.getExternalProjectInfo(project2, projectSystemId, string);
        if (externalProjectInfo == null || externalProjectInfo.getExternalProjectStructure() == null) {
            if (a.isDebugEnabled()) {
                a.debug(String.format("external project data not found, path: %s, data: %s", string, externalProjectInfo));
            }
            return;
        }
        DataNode dataNode = externalProjectInfo.getExternalProjectStructure();
        ((ProjectDataManager)ServiceManager.getService(ProjectDataManager.class)).importData(dataNode, project2, true);
    }

    @Override
    public boolean isSelected(AnActionEvent anActionEvent) {
        String string;
        boolean bl2 = super.isSelected(anActionEvent);
        ProjectSystemId projectSystemId = this.getSystemId(anActionEvent);
        String string2 = string = projectSystemId != null ? projectSystemId.getReadableName() : "external";
        if (bl2) {
            this.setText(anActionEvent, ExternalSystemBundle.message((String)"action.unignore.external.project.text", (Object[])new Object[]{string}));
            this.setDescription(anActionEvent, ExternalSystemBundle.message((String)"action.unignore.external.project.description", (Object[])new Object[]{string}));
        } else {
            this.setText(anActionEvent, ExternalSystemBundle.message((String)"action.ignore.external.project.text", (Object[])new Object[]{string}));
            this.setDescription(anActionEvent, ExternalSystemBundle.message((String)"action.ignore.external.project.description", (Object[])new Object[]{string}));
        }
        return bl2;
    }

    @Override
    protected boolean isEnabled(AnActionEvent anActionEvent) {
        if (!super.isEnabled(anActionEvent)) {
            return false;
        }
        return IgnoreExternalProjectAction.a(anActionEvent) != null;
    }

    @Override
    protected boolean doIsSelected(AnActionEvent anActionEvent) {
        ExternalSystemNode<ExternalConfigPathAware> externalSystemNode = IgnoreExternalProjectAction.a(anActionEvent);
        if (externalSystemNode == null) {
            return false;
        }
        return externalSystemNode.isIgnored();
    }

    @Nullable
    private static ExternalSystemNode<ExternalConfigPathAware> a(AnActionEvent anActionEvent) {
        List list2 = (List)ExternalSystemDataKeys.SELECTED_NODES.getData(anActionEvent.getDataContext());
        if (list2 == null || list2.size() != 1) {
            return null;
        }
        ExternalSystemNode externalSystemNode = (ExternalSystemNode)list2.get(0);
        return externalSystemNode instanceof ModuleNode || externalSystemNode instanceof ProjectNode ? externalSystemNode : null;
    }
}

