/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.action;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.externalSystem.ExternalSystemUiAware;
import com.intellij.openapi.externalSystem.action.ExternalSystemNodeAction;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ExternalConfigPathAware;
import com.intellij.openapi.externalSystem.model.project.ExternalEntityData;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

public class OpenExternalConfigAction
extends ExternalSystemNodeAction<ExternalConfigPathAware> {
    public OpenExternalConfigAction() {
        super(ExternalConfigPathAware.class);
        this.getTemplatePresentation().setText(ExternalSystemBundle.message((String)"action.open.config.text", (Object[])new Object[]{"external"}));
        this.getTemplatePresentation().setDescription(ExternalSystemBundle.message((String)"action.open.config.description", (Object[])new Object[]{"external"}));
    }

    @Override
    protected boolean isEnabled(AnActionEvent anActionEvent) {
        if (!super.isEnabled(anActionEvent)) {
            return false;
        }
        ExternalEntityData externalEntityData = this.getExternalData(anActionEvent, ExternalEntityData.class);
        if (!(externalEntityData instanceof ExternalConfigPathAware)) {
            return false;
        }
        VirtualFile virtualFile = this.getExternalConfig((ExternalConfigPathAware)externalEntityData, externalEntityData.getOwner());
        if (virtualFile == null) {
            return false;
        }
        ProjectSystemId projectSystemId = this.getSystemId(anActionEvent);
        anActionEvent.getPresentation().setText(ExternalSystemBundle.message((String)"action.open.config.text", (Object[])new Object[]{projectSystemId.getReadableName()}));
        anActionEvent.getPresentation().setDescription(ExternalSystemBundle.message((String)"action.open.config.description", (Object[])new Object[]{projectSystemId.getReadableName()}));
        ExternalSystemUiAware externalSystemUiAware = this.getExternalSystemUiAware(anActionEvent);
        if (externalSystemUiAware != null) {
            anActionEvent.getPresentation().setIcon(externalSystemUiAware.getProjectIcon());
        }
        return true;
    }

    @Override
    protected void perform(@NotNull Project project2, @NotNull ProjectSystemId projectSystemId, @NotNull ExternalConfigPathAware externalConfigPathAware, @NotNull AnActionEvent anActionEvent) {
        VirtualFile virtualFile;
        if (project2 == null) {
            OpenExternalConfigAction.c(0);
        }
        if (projectSystemId == null) {
            OpenExternalConfigAction.c(1);
        }
        if (externalConfigPathAware == null) {
            OpenExternalConfigAction.c(2);
        }
        if (anActionEvent == null) {
            OpenExternalConfigAction.c(3);
        }
        if ((virtualFile = this.getExternalConfig(externalConfigPathAware, projectSystemId)) != null) {
            OpenFileDescriptor openFileDescriptor = new OpenFileDescriptor(project2, virtualFile);
            FileEditorManager.getInstance((Project)project2).openTextEditor(openFileDescriptor, true);
        }
    }

    private static /* synthetic */ void c(int n2) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "systemId";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "configPathAware";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "e";
                break;
            }
        }
        objectArray[1] = "com/intellij/openapi/externalSystem/action/OpenExternalConfigAction";
        objectArray[2] = "perform";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

