/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.execution;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemJdkException;
import com.intellij.openapi.externalSystem.service.execution.InvalidJavaHomeException;
import com.intellij.openapi.externalSystem.service.execution.InvalidSdkException;
import com.intellij.openapi.externalSystem.service.execution.ProjectJdkNotFoundException;
import com.intellij.openapi.externalSystem.service.execution.UndefinedJavaHomeException;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.impl.JavaAwareProjectJdkTableImpl;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.EnvironmentUtil;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemJdkUtil {
    public static final String USE_INTERNAL_JAVA = "#JAVA_INTERNAL";
    public static final String USE_PROJECT_JDK = "#USE_PROJECT_JDK";
    public static final String USE_JAVA_HOME = "#JAVA_HOME";

    @Nullable
    public static Sdk getJdk(@Nullable Project project2, @Nullable String string) throws ExternalSystemJdkException {
        if (string == null) {
            return null;
        }
        if (USE_INTERNAL_JAVA.equals(string)) {
            return JavaAwareProjectJdkTableImpl.getInstanceEx().getInternalJdk();
        }
        if (USE_PROJECT_JDK.equals(string)) {
            Sdk sdk;
            if (project2 != null) {
                Module[] moduleArray;
                sdk = ProjectRootManager.getInstance((Project)project2).getProjectSdk();
                if (sdk != null) {
                    return sdk;
                }
                for (Module module2 : moduleArray = ModuleManager.getInstance((Project)project2).getModules()) {
                    Sdk sdk2 = ModuleRootManager.getInstance((Module)module2).getSdk();
                    if (sdk2 == null || !(sdk2.getSdkType() instanceof JavaSdkType)) continue;
                    return sdk2;
                }
            }
            if (project2 == null || project2.isDefault()) {
                sdk = ProjectJdkTable.getInstance().findMostRecentSdkOfType((SdkTypeId)JavaSdk.getInstance());
                return sdk != null ? sdk : JavaAwareProjectJdkTableImpl.getInstanceEx().getInternalJdk();
            }
            throw new ProjectJdkNotFoundException();
        }
        if (USE_JAVA_HOME.equals(string)) {
            String string2 = (String)EnvironmentUtil.getEnvironmentMap().get("JAVA_HOME");
            if (StringUtil.isEmptyOrSpaces((String)string2)) {
                throw new UndefinedJavaHomeException();
            }
            if (!ExternalSystemJdkUtil.isValidJdk(string2)) {
                throw new InvalidJavaHomeException(string2);
            }
            return JavaSdk.getInstance().createJdk("", string2);
        }
        Sdk sdk = ProjectJdkTable.getInstance().findJdk(string);
        if (sdk != null) {
            String string3 = sdk.getHomePath();
            if (!ExternalSystemJdkUtil.isValidJdk(string3)) {
                throw new InvalidSdkException(string3);
            }
            return sdk;
        }
        return null;
    }

    @NotNull
    public static Pair<String, Sdk> getAvailableJdk(@Nullable Project project2) throws ExternalSystemJdkException {
        String string;
        Object object;
        Sdk sdk2;
        JavaSdk javaSdk = JavaSdk.getInstance();
        if (project2 != null && (sdk2 = (Sdk)(object = Stream.concat(Stream.of(ProjectRootManager.getInstance((Project)project2).getProjectSdk()), Stream.of(ModuleManager.getInstance((Project)project2).getModules()).map(module2 -> ModuleRootManager.getInstance((Module)module2).getSdk()))).filter(sdk -> sdk != null && sdk.getSdkType() == javaSdk && ExternalSystemJdkUtil.isValidJdk(sdk.getHomePath())).findFirst().orElse(null)) != null) {
            Pair pair2 = Pair.pair((Object)USE_PROJECT_JDK, (Object)sdk2);
            if (pair2 == null) {
                ExternalSystemJdkUtil.a(0);
            }
            return pair2;
        }
        object = ProjectJdkTable.getInstance().getSdksOfType((SdkTypeId)javaSdk);
        sdk2 = object.stream().filter(sdk -> ExternalSystemJdkUtil.isValidJdk(sdk.getHomePath())).max(javaSdk.versionComparator()).orElse(null);
        if (sdk2 != null) {
            Pair pair3 = Pair.pair((Object)sdk2.getName(), (Object)sdk2);
            if (pair3 == null) {
                ExternalSystemJdkUtil.a(1);
            }
            return pair3;
        }
        if (!ApplicationManager.getApplication().isUnitTestMode() && ExternalSystemJdkUtil.isValidJdk(string = (String)EnvironmentUtil.getEnvironmentMap().get("JAVA_HOME"))) {
            Pair pair4 = Pair.pair((Object)USE_JAVA_HOME, (Object)javaSdk.createJdk("", string));
            if (pair4 == null) {
                ExternalSystemJdkUtil.a(2);
            }
            return pair4;
        }
        Pair pair5 = Pair.pair((Object)USE_INTERNAL_JAVA, (Object)JavaAwareProjectJdkTableImpl.getInstanceEx().getInternalJdk());
        if (pair5 == null) {
            ExternalSystemJdkUtil.a(3);
        }
        return pair5;
    }

    public static boolean checkForJdk(@NotNull Project project2, @Nullable String string) {
        if (project2 == null) {
            ExternalSystemJdkUtil.a(4);
        }
        try {
            Sdk sdk = ExternalSystemJdkUtil.getJdk(project2, string);
            return sdk != null && sdk.getHomePath() != null && JdkUtil.checkForJdk((String)sdk.getHomePath());
        }
        catch (ExternalSystemJdkException externalSystemJdkException) {
            return false;
        }
    }

    public static boolean isValidJdk(@Nullable String string) {
        return !StringUtil.isEmptyOrSpaces((String)string) && (JdkUtil.checkForJdk((String)string) || JdkUtil.checkForJre((String)string));
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 4: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/execution/ExternalSystemJdkUtil";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableJdk";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/execution/ExternalSystemJdkUtil";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkForJdk";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

