/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.execution;

import com.intellij.build.process.BuildProcessHandler;
import com.intellij.execution.process.AnsiEscapeDecoder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTask;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.StreamUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemProcessHandler
extends BuildProcessHandler
implements AnsiEscapeDecoder.ColoredTextAcceptor,
Disposable {
    private static final Logger d = Logger.getInstance(ExternalSystemProcessHandler.class);
    private final String b;
    @Nullable
    private ExternalSystemTask e;
    private final AnsiEscapeDecoder a;
    @Nullable
    private OutputStream c;

    public ExternalSystemProcessHandler(@NotNull ExternalSystemTask externalSystemTask, String string) {
        if (externalSystemTask == null) {
            ExternalSystemProcessHandler.a(0);
        }
        this.a = new AnsiEscapeDecoder();
        this.e = externalSystemTask;
        this.b = string;
        if (externalSystemTask instanceof UserDataHolder) {
            try {
                PipedInputStream pipedInputStream = new PipedInputStream();
                this.c = new PipedOutputStream(pipedInputStream);
                ((UserDataHolder)externalSystemTask).putUserData(ExternalSystemRunConfiguration.RUN_INPUT_KEY, (Object)pipedInputStream);
            }
            catch (IOException iOException) {
                d.warn("Unable to setup process input", (Throwable)iOException);
            }
        }
    }

    @Override
    public String getExecutionName() {
        return this.b;
    }

    public void notifyTextAvailable(@NotNull String string, @NotNull Key key) {
        if (string == null) {
            ExternalSystemProcessHandler.a(1);
        }
        if (key == null) {
            ExternalSystemProcessHandler.a(2);
        }
        this.a.escapeText(string, key, (AnsiEscapeDecoder.ColoredTextAcceptor)this);
    }

    protected void destroyProcessImpl() {
        if (this.e != null) {
            this.e.cancel(new ExternalSystemTaskNotificationListener[0]);
        }
        this.closeInput();
    }

    protected void detachProcessImpl() {
        this.notifyProcessDetached();
        this.closeInput();
    }

    public boolean detachIsDefault() {
        return false;
    }

    @Nullable
    public OutputStream getProcessInput() {
        return this.c;
    }

    public void notifyProcessTerminated(int n2) {
        super.notifyProcessTerminated(n2);
        this.closeInput();
    }

    public void coloredTextAvailable(@NotNull String string, @NotNull Key key) {
        if (string == null) {
            ExternalSystemProcessHandler.a(3);
        }
        if (key == null) {
            ExternalSystemProcessHandler.a(4);
        }
        super.notifyTextAvailable(string, key);
    }

    protected void closeInput() {
        if (this.e instanceof UserDataHolder) {
            ((UserDataHolder)this.e).putUserData(ExternalSystemRunConfiguration.RUN_INPUT_KEY, null);
        }
        StreamUtil.closeStream((Closeable)this.c);
        this.c = null;
    }

    public void dispose() {
        this.e = null;
        this.detachProcessImpl();
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/externalSystem/service/execution/ExternalSystemProcessHandler";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "notifyTextAvailable";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "coloredTextAvailable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

