/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.execution;

import com.intellij.execution.configuration.EnvironmentVariablesComponent;
import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.ExternalSystemUiAware;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.service.execution.TaskCompletionProvider;
import com.intellij.openapi.externalSystem.service.ui.ExternalProjectPathField;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemSettingsControl;
import com.intellij.openapi.externalSystem.util.ExternalSystemUiUtil;
import com.intellij.openapi.externalSystem.util.PaintAwarePanel;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.GridBag;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemTaskSettingsControl
implements ExternalSystemSettingsControl<ExternalSystemTaskExecutionSettings> {
    @NotNull
    private final ProjectSystemId c;
    @NotNull
    private final Project d;
    private JBLabel l;
    private ExternalProjectPathField h;
    private JBLabel e;
    private EditorTextField k;
    private JBLabel j;
    private RawCommandLineEditor f;
    private JBLabel b;
    private RawCommandLineEditor a;
    private EnvironmentVariablesComponent i;
    @Nullable
    private ExternalSystemTaskExecutionSettings g;

    public ExternalSystemTaskSettingsControl(@NotNull Project project2, @NotNull ProjectSystemId projectSystemId) {
        if (project2 == null) {
            ExternalSystemTaskSettingsControl.a(0);
        }
        if (projectSystemId == null) {
            ExternalSystemTaskSettingsControl.a(1);
        }
        this.d = project2;
        this.c = projectSystemId;
    }

    public void setOriginalSettings(@Nullable ExternalSystemTaskExecutionSettings externalSystemTaskExecutionSettings) {
        this.g = externalSystemTaskExecutionSettings;
    }

    @Override
    public void fillUi(@NotNull PaintAwarePanel paintAwarePanel, int n2) {
        if (paintAwarePanel == null) {
            ExternalSystemTaskSettingsControl.a(2);
        }
        this.l = new JBLabel(ExternalSystemBundle.message((String)"run.configuration.settings.label.project", (Object[])new Object[]{this.c.getReadableName()}));
        ExternalSystemManager externalSystemManager = ExternalSystemApiUtil.getManager((ProjectSystemId)this.c);
        FileChooserDescriptor fileChooserDescriptor = null;
        if (externalSystemManager instanceof ExternalSystemUiAware) {
            fileChooserDescriptor = ((ExternalSystemUiAware)externalSystemManager).getExternalProjectConfigDescriptor();
        }
        if (fileChooserDescriptor == null) {
            fileChooserDescriptor = FileChooserDescriptorFactory.createSingleLocalFileDescriptor();
        }
        String string = ExternalSystemBundle.message((String)"settings.label.select.project", (Object[])new Object[]{this.c.getReadableName()});
        this.h = new ExternalProjectPathField(this.d, this.c, fileChooserDescriptor, string){

            public Dimension getPreferredSize() {
                return ExternalSystemTaskSettingsControl.this.f == null ? super.getPreferredSize() : ExternalSystemTaskSettingsControl.this.f.getTextField().getPreferredSize();
            }
        };
        paintAwarePanel.add((Component)this.l, ExternalSystemUiUtil.getLabelConstraints(0));
        paintAwarePanel.add((Component)((Object)this.h), ExternalSystemUiUtil.getFillLineConstraints(0));
        this.e = new JBLabel(ExternalSystemBundle.message((String)"run.configuration.settings.label.tasks", (Object[])new Object[0]));
        this.k = new EditorTextField("", this.d, (FileType)PlainTextFileType.INSTANCE);
        paintAwarePanel.add((Component)this.e, ExternalSystemUiUtil.getLabelConstraints(0));
        GridBag gridBag = ExternalSystemUiUtil.getFillLineConstraints(0);
        gridBag.insets.right = this.h.getButton().getPreferredSize().width + 8;
        paintAwarePanel.add((Component)this.k, gridBag);
        new TaskCompletionProvider(this.d, this.c, this.h).apply(this.k);
        this.j = new JBLabel(ExternalSystemBundle.message((String)"run.configuration.settings.label.vmoptions", (Object[])new Object[0]));
        this.f = new RawCommandLineEditor();
        this.f.setDialogCaption(ExternalSystemBundle.message((String)"run.configuration.settings.label.vmoptions", (Object[])new Object[0]));
        paintAwarePanel.add((Component)this.j, ExternalSystemUiUtil.getLabelConstraints(0));
        paintAwarePanel.add((Component)this.f, ExternalSystemUiUtil.getFillLineConstraints(0));
        this.b = new JBLabel(ExternalSystemBundle.message((String)"run.configuration.settings.label.arguments", (Object[])new Object[0]));
        this.a = new RawCommandLineEditor();
        this.a.setDialogCaption(ExternalSystemBundle.message((String)"run.configuration.settings.label.arguments", (Object[])new Object[0]));
        paintAwarePanel.add((Component)this.b, ExternalSystemUiUtil.getLabelConstraints(0));
        paintAwarePanel.add((Component)this.a, ExternalSystemUiUtil.getFillLineConstraints(0));
        this.i = new EnvironmentVariablesComponent();
        JBLabel jBLabel = this.i.getLabel();
        jBLabel.remove((Component)jBLabel);
        paintAwarePanel.add((Component)jBLabel, ExternalSystemUiUtil.getLabelConstraints(0));
        paintAwarePanel.add((Component)this.i, ExternalSystemUiUtil.getFillLineConstraints(0));
    }

    @Override
    public void reset() {
        this.h.setText("");
        this.k.setText("");
        this.f.setText("");
        this.a.setText("");
        this.i.setEnvData(EnvironmentVariablesData.DEFAULT);
        this.showUi(true);
        if (this.g == null) {
            return;
        }
        String string = this.g.getExternalProjectPath();
        if (StringUtil.isEmpty((String)string)) {
            string = "";
        }
        this.h.setText(string);
        this.k.setText(StringUtil.join((Collection)this.g.getTaskNames(), (String)" "));
        this.f.setText(this.g.getVmOptions());
        this.a.setText(this.g.getScriptParameters());
        this.i.setEnvData(EnvironmentVariablesData.create((Map)this.g.getEnv(), (boolean)this.g.isPassParentEnvs()));
    }

    @Override
    public boolean isModified() {
        if (this.g == null) {
            return false;
        }
        return !Comparing.equal((String)ExternalSystemApiUtil.normalizePath((String)this.h.getText()), (String)ExternalSystemApiUtil.normalizePath((String)this.g.getExternalProjectPath())) || !Comparing.equal((String)ExternalSystemApiUtil.normalizePath((String)this.k.getText()), (String)ExternalSystemApiUtil.normalizePath((String)StringUtil.join((Collection)this.g.getTaskNames(), (String)" "))) || !Comparing.equal((String)ExternalSystemApiUtil.normalizePath((String)this.f.getText()), (String)ExternalSystemApiUtil.normalizePath((String)this.g.getVmOptions())) || !Comparing.equal((String)ExternalSystemApiUtil.normalizePath((String)this.a.getText()), (String)ExternalSystemApiUtil.normalizePath((String)this.g.getScriptParameters())) || this.i.isPassParentEnvs() != this.g.isPassParentEnvs() || !this.i.getEnvs().equals(this.g.getEnv());
    }

    @Override
    public void apply(@NotNull ExternalSystemTaskExecutionSettings externalSystemTaskExecutionSettings) {
        if (externalSystemTaskExecutionSettings == null) {
            ExternalSystemTaskSettingsControl.a(3);
        }
        String string = this.h.getText();
        externalSystemTaskExecutionSettings.setExternalProjectPath(string);
        externalSystemTaskExecutionSettings.setTaskNames(StringUtil.split((String)this.k.getText(), (String)" "));
        externalSystemTaskExecutionSettings.setVmOptions(this.f.getText());
        externalSystemTaskExecutionSettings.setScriptParameters(this.a.getText());
        externalSystemTaskExecutionSettings.setPassParentEnvs(this.i.isPassParentEnvs());
        externalSystemTaskExecutionSettings.setEnv((Map)ContainerUtil.newHashMap((Map)this.i.getEnvs()));
    }

    @Override
    public boolean validate(@NotNull ExternalSystemTaskExecutionSettings externalSystemTaskExecutionSettings) throws ConfigurationException {
        if (externalSystemTaskExecutionSettings == null) {
            ExternalSystemTaskSettingsControl.a(4);
        }
        String string = this.h.getText();
        if (this.g == null) {
            throw new ConfigurationException(String.format("Can't store external task settings into run configuration. Reason: target run configuration is undefined. Tasks: '%s', external project: '%s', vm options: '%s', arguments: '%s'", this.k.getText(), string, this.f.getText(), this.a.getText()));
        }
        return true;
    }

    @Override
    public void disposeUIResources() {
        ExternalSystemUiUtil.disposeUi(this);
    }

    @Override
    public void showUi(boolean bl2) {
        ExternalSystemUiUtil.showUi(this, bl2);
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalSystemId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "canvas";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/externalSystem/service/execution/ExternalSystemTaskSettingsControl";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "fillUi";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "apply";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "validate";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

