/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.autoimport;

import com.intellij.ProjectTopics;
import com.intellij.ide.file.BatchFileChangeListener;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.notification.NotificationsConfiguration;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.externalSystem.ExternalSystemAutoImportAware;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTask;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListenerAdapter;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskState;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.externalSystem.service.execution.ProgressExecutionMode;
import com.intellij.openapi.externalSystem.service.internal.ExternalSystemProcessingManager;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemProgressNotificationManager;
import com.intellij.openapi.externalSystem.service.project.ExternalProjectRefreshCallback;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.externalSystem.service.project.autoimport.ExternalSystemProjectsWatcher;
import com.intellij.openapi.externalSystem.service.project.autoimport.FileChangeListenerBase;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemLocalSettings;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.FileDocumentManagerImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.util.PathUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import gnu.trove.THashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.CRC32;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemProjectsWatcherImpl
extends ExternalSystemTaskNotificationListenerAdapter
implements ExternalSystemProjectsWatcher {
    private static final Logger a = Logger.getInstance(ExternalSystemProjectsWatcherImpl.class);
    private static final ExtensionPointName<Contributor> k = ExtensionPointName.create((String)"com.intellij.externalProjectWatcherContributor");
    private static final Key<Long> i = Key.create((String)"ExternalSystemProjectsWatcher.CRC_WITHOUT_SPACES_CURRENT");
    private static final Key<Long> j = Key.create((String)"ExternalSystemProjectsWatcher.CRC_WITHOUT_SPACES_BEFORE_LAST_IMPORT");
    private static final int h = 1000;
    private static final int p = 2000;
    private final Project l;
    private final Set<Document> m = new THashSet();
    private final MergingUpdateQueue e;
    private final List<ExternalSystemAutoImportAware> b;
    private final MergingUpdateQueue g;
    private final Map<ProjectSystemId, MyNotification> o;
    private final MultiMap<String, String> c = MultiMap.createConcurrentSet();
    private final MultiMap<VirtualFilePointer, String> d = MultiMap.createConcurrentSet();
    private final List<LocalFileSystem.WatchRequest> n = new ArrayList<LocalFileSystem.WatchRequest>();
    private final MergingUpdateQueue f;

    public ExternalSystemProjectsWatcherImpl(Project project2) {
        this.l = project2;
        this.e = new MergingUpdateQueue("ExternalSystemProjectsWatcher: Document changes queue", 1000, false, MergingUpdateQueue.ANY_COMPONENT, (Disposable)this.l);
        this.f = new MergingUpdateQueue("ExternalSystemProjectsWatcher: Refresh requests queue", 2000, false, MergingUpdateQueue.ANY_COMPONENT, (Disposable)this.l, null, false);
        this.b = ContainerUtil.newArrayList();
        for (ExternalSystemManager externalSystemManager : ExternalSystemApiUtil.getAllManagers()) {
            if (!(externalSystemManager instanceof ExternalSystemAutoImportAware)) continue;
            this.b.add((ExternalSystemAutoImportAware)externalSystemManager);
            NotificationsConfiguration.getNotificationsConfiguration().register(externalSystemManager.getSystemId().getReadableName() + " Import", NotificationDisplayType.STICKY_BALLOON, false);
        }
        this.g = new MergingUpdateQueue("ExternalSystemProjectsWatcher: Notifier queue", 500, false, MergingUpdateQueue.ANY_COMPONENT, (Disposable)this.l);
        this.o = ContainerUtil.newConcurrentMap();
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this.l).subscribe(BatchFileChangeListener.TOPIC, (Object)new BatchFileChangeListener(){

            public void batchChangeStarted(Project project2) {
                ExternalSystemProjectsWatcherImpl.this.f.suspend();
            }

            public void batchChangeCompleted(Project project2) {
                ExternalSystemProjectsWatcherImpl.this.f.resume();
            }
        });
    }

    public void markDirtyAllExternalProjects() {
        this.a().forEach(this::a);
        for (Contributor contributor : (Contributor[])k.getExtensions()) {
            contributor.markDirtyAllExternalProjects(this.l);
        }
    }

    public void markDirty(Module module2) {
        this.b(ExternalSystemApiUtil.getExternalProjectPath((Module)module2));
        for (Contributor contributor : (Contributor[])k.getExtensions()) {
            contributor.markDirty(module2);
        }
    }

    public void markDirty(String string) {
        this.b(string);
    }

    public synchronized void start() {
        if (ExternalSystemUtil.isNoBackgroundMode()) {
            return;
        }
        this.g.activate();
        MessageBusConnection messageBusConnection = this.l.getMessageBus().connect((Disposable)this.e);
        messageBusConnection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new MyFileChangeListener(this));
        ExternalSystemProjectsWatcherImpl.b(this.e, this.l);
        this.e.activate();
        this.f.activate();
        DocumentListener documentListener = new DocumentListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void documentChanged(DocumentEvent documentEvent) {
                Document document = documentEvent.getDocument();
                VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
                if (virtualFile == null) {
                    return;
                }
                String string = ExternalSystemProjectsWatcherImpl.this.a(virtualFile);
                if (string == null) {
                    return;
                }
                Set set = ExternalSystemProjectsWatcherImpl.this.m;
                synchronized (set) {
                    ExternalSystemProjectsWatcherImpl.this.m.add(document);
                }
                ExternalSystemProjectsWatcherImpl.this.e.queue(new Update((Object)ExternalSystemProjectsWatcherImpl.this){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        Document[] documentArray;
                        Set set = ExternalSystemProjectsWatcherImpl.this.m;
                        synchronized (set) {
                            documentArray = ExternalSystemProjectsWatcherImpl.this.m.toArray(Document.EMPTY_ARRAY);
                            ExternalSystemProjectsWatcherImpl.this.m.clear();
                        }
                        ExternalSystemUtil.invokeLater(ExternalSystemProjectsWatcherImpl.this.l, () -> new WriteAction(){

                            protected void run(@NotNull Result result2) {
                                if (result2 == null) {
                                    1.a(0);
                                }
                                for (Document document : documentArray) {
                                    PsiDocumentManager.getInstance((Project)ExternalSystemProjectsWatcherImpl.this.l).commitDocument(document);
                                    ((FileDocumentManagerImpl)FileDocumentManager.getInstance()).saveDocument(document, false);
                                }
                            }

                            private static /* synthetic */ void a(int n2) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/openapi/externalSystem/service/project/autoimport/ExternalSystemProjectsWatcherImpl$2$1$1", "run"));
                            }
                        }.execute());
                    }
                });
            }
        };
        EditorFactory.getInstance().getEventMulticaster().addDocumentListener(documentListener, (Disposable)messageBusConnection);
        ((ExternalSystemProgressNotificationManager)ServiceManager.getService(ExternalSystemProgressNotificationManager.class)).addNotificationListener((ExternalSystemTaskNotificationListener)this);
        this.a(true);
        Disposer.register((Disposable)this.e, () -> this.d.clear());
    }

    public synchronized void stop() {
        Disposer.dispose((Disposable)this.e);
        Disposer.dispose((Disposable)this.g);
        Disposer.dispose((Disposable)this.f);
        this.o.clear();
        ((ExternalSystemProgressNotificationManager)ServiceManager.getService(ExternalSystemProgressNotificationManager.class)).removeNotificationListener((ExternalSystemTaskNotificationListener)this);
    }

    public void onStart(@NotNull ExternalSystemTaskId externalSystemTaskId, final String string) {
        if (externalSystemTaskId == null) {
            ExternalSystemProjectsWatcherImpl.a(0);
        }
        if (externalSystemTaskId.getType() == ExternalSystemTaskType.RESOLVE_PROJECT) {
            final ProjectSystemId projectSystemId = externalSystemTaskId.getProjectSystemId();
            for (String string2 : ContainerUtil.newArrayList((Iterable)this.c.get((Object)string))) {
                VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)new File(string2), (boolean)false);
                if (virtualFile == null || virtualFile.isDirectory()) continue;
                virtualFile.putUserData(j, virtualFile.getUserData(i));
            }
            this.g.queue(new Update(Pair.create((Object)projectSystemId, (Object)string)){

                public void run() {
                    ExternalSystemProjectsWatcherImpl.this.a(true, projectSystemId, string);
                }
            });
        }
    }

    public void onSuccess(@NotNull ExternalSystemTaskId externalSystemTaskId) {
        if (externalSystemTaskId == null) {
            ExternalSystemProjectsWatcherImpl.a(1);
        }
        if (externalSystemTaskId.getType() == ExternalSystemTaskType.RESOLVE_PROJECT) {
            this.a(false);
        }
    }

    private void b(String string) {
        this.a(string, true);
    }

    private void a(String string, boolean bl2) {
        if (ExternalSystemUtil.isNoBackgroundMode()) {
            return;
        }
        Pair<ExternalSystemManager, ExternalProjectSettings> pair2 = this.a(string);
        if (pair2 == null) {
            return;
        }
        this.a(pair2, bl2);
    }

    private void a(@NotNull Pair<ExternalSystemManager, ExternalProjectSettings> pair2) {
        if (pair2 == null) {
            ExternalSystemProjectsWatcherImpl.a(2);
        }
        this.a(pair2, true);
    }

    private void a(@NotNull Pair<ExternalSystemManager, ExternalProjectSettings> pair2, boolean bl2) {
        if (pair2 == null) {
            ExternalSystemProjectsWatcherImpl.a(3);
        }
        if (ExternalSystemUtil.isNoBackgroundMode()) {
            return;
        }
        ExternalSystemManager externalSystemManager = (ExternalSystemManager)pair2.first;
        final String string = ((ExternalProjectSettings)pair2.second).getExternalProjectPath();
        final ProjectSystemId projectSystemId = externalSystemManager.getSystemId();
        boolean bl3 = ((ExternalProjectSettings)pair2.second).isUseAutoImport();
        if (bl3) {
            ExternalSystemTaskState externalSystemTaskState;
            ExternalSystemTask externalSystemTask = ((ExternalSystemProcessingManager)ServiceManager.getService(ExternalSystemProcessingManager.class)).findTask(ExternalSystemTaskType.RESOLVE_PROJECT, projectSystemId, string);
            ExternalSystemTaskState externalSystemTaskState2 = externalSystemTaskState = externalSystemTask == null ? null : externalSystemTask.getState();
            if (externalSystemTaskState == null || externalSystemTaskState.isStopped()) {
                this.a(string, projectSystemId, bl2);
            } else if (externalSystemTaskState != ExternalSystemTaskState.NOT_STARTED) {
                Object object;
                Object object2;
                if (externalSystemManager instanceof ExternalSystemAutoImportAware && (object2 = (Long)((AbstractExternalSystemLocalSettings)externalSystemManager.getLocalSettingsProvider().fun((Object)this.l)).getExternalConfigModificationStamps().get(string)) != null) {
                    object = ((ExternalSystemAutoImportAware)externalSystemManager).getAffectedExternalProjectFiles(string, this.l);
                    long l2 = object.stream().mapToLong(File::lastModified).sum();
                    if ((Long)object2 != l2) {
                        return;
                    }
                }
                object2 = (ExternalSystemProgressNotificationManager)ServiceManager.getService(ExternalSystemProgressNotificationManager.class);
                object = new ExternalSystemTaskNotificationListenerAdapter((ExternalSystemProgressNotificationManager)object2, string, projectSystemId, bl2){
                    final /* synthetic */ ExternalSystemProgressNotificationManager val$progressManager;
                    final /* synthetic */ String val$projectPath;
                    final /* synthetic */ ProjectSystemId val$systemId;
                    final /* synthetic */ boolean val$reportRefreshError;
                    {
                        this.val$progressManager = externalSystemProgressNotificationManager;
                        this.val$projectPath = string;
                        this.val$systemId = projectSystemId;
                        this.val$reportRefreshError = bl2;
                    }

                    public void onEnd(@NotNull ExternalSystemTaskId externalSystemTaskId) {
                        if (externalSystemTaskId == null) {
                            4.a(0);
                        }
                        this.val$progressManager.removeNotificationListener((ExternalSystemTaskNotificationListener)this);
                        ExternalSystemProjectsWatcherImpl.this.a(this.val$projectPath, this.val$systemId, this.val$reportRefreshError);
                    }

                    private static /* synthetic */ void a(int n2) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/externalSystem/service/project/autoimport/ExternalSystemProjectsWatcherImpl$4", "onEnd"));
                    }
                };
                object2.addNotificationListener(externalSystemTask.getId(), (ExternalSystemTaskNotificationListener)object);
            }
        } else {
            a.debug("Scheduling new external project update notification", new Throwable("Schedule update call trace"));
            this.g.queue(new Update(Pair.create((Object)projectSystemId, (Object)string)){

                public void run() {
                    ExternalSystemProjectsWatcherImpl.this.a(false, projectSystemId, string);
                }
            });
        }
    }

    private void a(final String string, final ProjectSystemId projectSystemId, final boolean bl2) {
        this.f.queue(new Update(Pair.create((Object)projectSystemId, (Object)string)){

            public void run() {
                ExternalSystemProjectsWatcherImpl.a(ExternalSystemProjectsWatcherImpl.this.l, string, projectSystemId, bl2);
            }
        });
    }

    private void a(boolean bl2) {
        SmartList smartList = new SmartList();
        this.d.clear();
        LocalFileSystem.getInstance().removeWatchedRoots(this.n);
        HashMap hashMap = ContainerUtil.newHashMap();
        for (ExternalSystemManager externalSystemManager : ExternalSystemApiUtil.getAllManagers()) {
            if (!(externalSystemManager instanceof ExternalSystemAutoImportAware)) continue;
            ExternalSystemAutoImportAware externalSystemAutoImportAware = (ExternalSystemAutoImportAware)externalSystemManager;
            for (ExternalProjectSettings externalProjectSettings : ((AbstractExternalSystemSettings)externalSystemManager.getSettingsProvider().fun((Object)this.l)).getLinkedProjectsSettings()) {
                Object object2;
                List list2 = externalSystemAutoImportAware.getAffectedExternalProjectFiles(externalProjectSettings.getExternalProjectPath(), this.l);
                long l2 = 0L;
                for (Object object2 : list2) {
                    l2 += ((File)object2).lastModified();
                }
                Map map = ((AbstractExternalSystemLocalSettings)externalSystemManager.getLocalSettingsProvider().fun((Object)this.l)).getExternalConfigModificationStamps();
                if (bl2 && this.l.getUserData(ExternalSystemDataKeys.NEWLY_CREATED_PROJECT) != Boolean.TRUE && this.l.getUserData(ExternalSystemDataKeys.NEWLY_IMPORTED_PROJECT) != Boolean.TRUE && l2 != (Long)(object2 = Long.valueOf((object2 = (Long)map.get(externalProjectSettings.getExternalProjectPath())) == null ? -1L : (Long)object2))) {
                    this.b(externalProjectSettings.getExternalProjectPath());
                }
                map.put(externalProjectSettings.getExternalProjectPath(), l2);
                object2 = list2.iterator();
                while (object2.hasNext()) {
                    String string;
                    File file = (File)object2.next();
                    if (file == null || (string = ExternalSystemProjectsWatcherImpl.a(file)) == null) continue;
                    smartList.add(string);
                    String string2 = VfsUtilCore.pathToUrl((String)string);
                    VirtualFilePointer virtualFilePointer = (VirtualFilePointer)hashMap.get(string2);
                    if (virtualFilePointer == null) {
                        virtualFilePointer = VirtualFilePointerManager.getInstance().create(string2, (Disposable)this.e, null);
                        hashMap.put(string2, virtualFilePointer);
                        VirtualFile virtualFile = virtualFilePointer.getFile();
                        if (virtualFile != null) {
                            Long l3 = (Long)virtualFile.getUserData(j);
                            if (l3 != null) {
                                map.put(string, l3);
                            } else {
                                UIUtil.invokeLaterIfNeeded(() -> {
                                    Long l2 = this.b(virtualFile);
                                    virtualFile.putUserData(j, (Object)l2);
                                    map.put(string, l2);
                                });
                            }
                        }
                    }
                    this.d.putValue((Object)virtualFilePointer, (Object)externalProjectSettings.getExternalProjectPath());
                }
            }
        }
        this.n.addAll(LocalFileSystem.getInstance().addRootsToWatch((Collection)smartList, false));
    }

    @Nullable
    private String a(VirtualFile virtualFile) {
        String string = virtualFile.getPath();
        return this.c(string);
    }

    @Nullable
    private String c(String string) {
        ExternalSystemAutoImportAware externalSystemAutoImportAware;
        String string2 = null;
        Iterator<ExternalSystemAutoImportAware> iterator = this.b.iterator();
        while (iterator.hasNext() && (string2 = (externalSystemAutoImportAware = iterator.next()).getAffectedExternalProjectPath(string, this.l)) == null) {
        }
        if (string2 != null) {
            this.c.putValue(string2, (Object)string);
        }
        return string2;
    }

    private void a(boolean bl2, @NotNull ProjectSystemId projectSystemId, @NotNull String string) {
        if (projectSystemId == null) {
            ExternalSystemProjectsWatcherImpl.a(4);
        }
        if (string == null) {
            ExternalSystemProjectsWatcherImpl.a(5);
        }
        MyNotification myNotification = this.o.get(projectSystemId);
        if (bl2) {
            if (myNotification == null) {
                return;
            }
            myNotification.c.remove(string);
            if (myNotification.c.isEmpty()) {
                myNotification.expire();
            }
        } else {
            if (myNotification != null && !myNotification.isExpired()) {
                myNotification.c.add(string);
                return;
            }
            myNotification = new MyNotification(this.l, this.o, projectSystemId, string);
            this.o.put(projectSystemId, myNotification);
            Notifications.Bus.notify((Notification)myNotification, (Project)this.l);
        }
    }

    private static void a(final @NotNull Project project2, String string, ProjectSystemId projectSystemId, boolean bl2) {
        if (project2 == null) {
            ExternalSystemProjectsWatcherImpl.a(6);
        }
        ExternalSystemUtil.refreshProject(project2, projectSystemId, string, new ExternalProjectRefreshCallback(){

            public void onSuccess(@Nullable DataNode<ProjectData> dataNode) {
                if (dataNode != null) {
                    ((ProjectDataManager)ServiceManager.getService(ProjectDataManager.class)).importData(dataNode, project2, true);
                }
            }

            public void onFailure(@NotNull String string, @Nullable String string2) {
                if (string == null) {
                    7.a(0);
                }
            }

            private static /* synthetic */ void a(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/intellij/openapi/externalSystem/service/project/autoimport/ExternalSystemProjectsWatcherImpl$7", "onFailure"));
            }
        }, false, ProgressExecutionMode.IN_BACKGROUND_ASYNC, bl2);
    }

    private static void b(final MergingUpdateQueue mergingUpdateQueue, Project project2) {
        ApplicationManager.getApplication().runReadAction(() -> {
            EditorEventMulticaster editorEventMulticaster = EditorFactory.getInstance().getEventMulticaster();
            editorEventMulticaster.addCaretListener(new CaretListener(){

                public void caretPositionChanged(CaretEvent caretEvent) {
                    mergingUpdateQueue.restartTimer();
                }
            }, (Disposable)mergingUpdateQueue);
            editorEventMulticaster.addDocumentListener(new DocumentListener(){

                public void documentChanged(DocumentEvent documentEvent) {
                    mergingUpdateQueue.restartTimer();
                }
            }, (Disposable)mergingUpdateQueue);
            project2.getMessageBus().connect((Disposable)mergingUpdateQueue).subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){
                int beforeCalled;

                public void beforeRootsChange(ModuleRootEvent moduleRootEvent) {
                    if (this.beforeCalled++ == 0) {
                        mergingUpdateQueue.suspend();
                    }
                }

                public void rootsChanged(ModuleRootEvent moduleRootEvent) {
                    if (this.beforeCalled == 0) {
                        return;
                    }
                    if (--this.beforeCalled == 0) {
                        mergingUpdateQueue.resume();
                        mergingUpdateQueue.restartTimer();
                    }
                }
            });
        });
    }

    @Nullable
    private Pair<ExternalSystemManager, ExternalProjectSettings> a(String string) {
        ExternalProjectSettings[] externalProjectSettingsArray = new ExternalProjectSettings[1];
        Optional<ExternalSystemManager> optional = ExternalSystemApiUtil.getAllManagers().stream().filter(externalSystemManager -> {
            externalProjectSettingsArray[0] = ((AbstractExternalSystemSettings)externalSystemManager.getSettingsProvider().fun((Object)this.l)).getLinkedProjectSettings(string);
            return externalProjectSettingsArray[0] != null;
        }).findAny();
        if (!optional.isPresent()) {
            return null;
        }
        ExternalSystemManager externalSystemManager2 = optional.get();
        return Pair.create((Object)externalSystemManager2, (Object)externalProjectSettingsArray[0]);
    }

    @NotNull
    private List<Pair<ExternalSystemManager, ExternalProjectSettings>> a() {
        List<Pair<ExternalSystemManager, ExternalProjectSettings>> list2 = ExternalSystemApiUtil.getAllManagers().stream().flatMap(externalSystemManager -> ((AbstractExternalSystemSettings)externalSystemManager.getSettingsProvider().fun((Object)this.l)).getLinkedProjectsSettings().stream().map(externalProjectSettings -> Pair.create((Object)externalSystemManager, (Object)externalProjectSettings))).collect(Collectors.toList());
        if (list2 == null) {
            ExternalSystemProjectsWatcherImpl.a(7);
        }
        return list2;
    }

    @Nullable
    private static String a(@NotNull File file) {
        String string;
        if (file == null) {
            ExternalSystemProjectsWatcherImpl.a(8);
        }
        return (string = PathUtil.getCanonicalPath((String)file.getAbsolutePath())) == null ? null : FileUtil.toSystemIndependentName((String)string);
    }

    @NotNull
    private Long b(VirtualFile virtualFile) {
        Long l2;
        PsiFile psiFile = PsiManager.getInstance((Project)this.l).findFile(virtualFile);
        if (psiFile != null) {
            final CRC32 cRC32 = new CRC32();
            ApplicationManager.getApplication().runReadAction(() -> psiFile.acceptChildren((PsiElementVisitor)new PsiRecursiveElementVisitor(){

                public void visitElement(PsiElement psiElement) {
                    String string;
                    if (psiElement instanceof LeafElement && !(psiElement instanceof PsiWhiteSpace) && !(psiElement instanceof PsiComment) && !(string = psiElement.getText()).trim().isEmpty()) {
                        int n2 = string.length();
                        for (int i2 = 0; i2 < n2; ++i2) {
                            cRC32.update(string.charAt(i2));
                        }
                    }
                    super.visitElement(psiElement);
                }
            }));
            l2 = cRC32.getValue();
        } else {
            l2 = virtualFile.getModificationStamp();
        }
        Long l3 = l2;
        if (l3 == null) {
            ExternalSystemProjectsWatcherImpl.a(9);
        }
        return l3;
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 7: 
            case 9: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linkedProject";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "systemId";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPath";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/project/autoimport/ExternalSystemProjectsWatcherImpl";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/autoimport/ExternalSystemProjectsWatcherImpl";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findLinkedProjectsSettings";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateCrc";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "onStart";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "onSuccess";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "scheduleUpdate";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doUpdateNotifications";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "scheduleRefresh";
                break;
            }
            case 7: 
            case 9: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getNormalizedPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @ApiStatus.Experimental
    public static interface Contributor {
        public void markDirtyAllExternalProjects(@NotNull Project var1);

        public void markDirty(@NotNull Module var1);
    }

    private class MyFileChangeListener
    extends FileChangeListenerBase {
        private final ExternalSystemProjectsWatcherImpl b;
        private MultiMap<String, String> d = MultiMap.createSet();
        private List<VirtualFile> a;
        private List<VirtualFile> c;

        public MyFileChangeListener(ExternalSystemProjectsWatcherImpl externalSystemProjectsWatcherImpl2) {
            this.b = externalSystemProjectsWatcherImpl2;
        }

        @Override
        protected boolean isRelevant(String string) {
            if (!this.d.get((Object)string).isEmpty()) {
                return true;
            }
            for (VirtualFilePointer virtualFilePointer : ExternalSystemProjectsWatcherImpl.this.d.keySet()) {
                VirtualFile virtualFile = virtualFilePointer.getFile();
                if (virtualFile == null || !FileUtil.pathsEqual((String)string, (String)virtualFile.getPath())) continue;
                for (String string2 : ExternalSystemProjectsWatcherImpl.this.d.get((Object)virtualFilePointer)) {
                    this.d.putValue((Object)string, (Object)string2);
                    ExternalSystemProjectsWatcherImpl.this.c.putValue((Object)string2, (Object)string);
                }
                return true;
            }
            String string3 = ExternalSystemProjectsWatcherImpl.this.c(string);
            if (string3 != null) {
                this.d.putValue((Object)string, (Object)string3);
            }
            return string3 != null;
        }

        @Override
        protected void updateFile(VirtualFile virtualFile, VFileEvent vFileEvent) {
            this.a(virtualFile, vFileEvent, false);
        }

        @Override
        protected void deleteFile(VirtualFile virtualFile, VFileEvent vFileEvent) {
            this.a(virtualFile, vFileEvent, true);
        }

        private void a(VirtualFile virtualFile, VFileEvent vFileEvent, boolean bl2) {
            this.c();
            if (bl2) {
                this.c.add(virtualFile);
            } else if (this.a(virtualFile, vFileEvent)) {
                this.a.add(virtualFile);
            } else {
                for (String string : this.d.get((Object)virtualFile.getPath())) {
                    this.a(string);
                }
            }
        }

        private void a(String string) {
            for (Object object : ContainerUtil.newArrayList((Iterable)ExternalSystemProjectsWatcherImpl.this.c.get((Object)string))) {
                VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)new File((String)object), (boolean)false);
                if (virtualFile != null && Objects.equals(virtualFile.getUserData(j), virtualFile.getUserData(i))) continue;
                return;
            }
            ProjectSystemId projectSystemId = null;
            for (VirtualFile virtualFile : ExternalSystemApiUtil.getAllManagers()) {
                if (((AbstractExternalSystemSettings)virtualFile.getSettingsProvider().fun((Object)ExternalSystemProjectsWatcherImpl.this.l)).getLinkedProjectSettings(string) == null) continue;
                projectSystemId = virtualFile.getSystemId();
            }
            if (projectSystemId != null) {
                Object object;
                object = projectSystemId;
                ExternalSystemProjectsWatcherImpl.this.g.queue(new Update(Pair.create(object, (Object)string), (ProjectSystemId)object, string){
                    final /* synthetic */ ProjectSystemId val$finalSystemId;
                    final /* synthetic */ String val$externalProjectPath;
                    {
                        this.val$finalSystemId = projectSystemId;
                        this.val$externalProjectPath = string;
                        super(object);
                    }

                    public void run() {
                        ExternalSystemProjectsWatcherImpl.this.a(true, this.val$finalSystemId, this.val$externalProjectPath);
                    }
                });
            }
        }

        private boolean a(VirtualFile virtualFile, VFileEvent vFileEvent) {
            if (!virtualFile.isValid() || !(vFileEvent instanceof VFileContentChangeEvent)) {
                return true;
            }
            Long l2 = ExternalSystemProjectsWatcherImpl.this.b(virtualFile);
            virtualFile.putUserData(i, (Object)l2);
            Long l3 = (Long)virtualFile.getUserData(j);
            if (l3 == null) {
                virtualFile.putUserData(j, (Object)l2);
                return true;
            }
            return !l2.equals(l3);
        }

        @Override
        protected void apply() {
            if (this.a()) {
                this.a.removeAll(this.c);
                this.a(ContainerUtil.concat(this.a, this.c));
            }
            this.b();
        }

        private boolean a() {
            return this.a != null;
        }

        private void a(List<VirtualFile> list2) {
            list2.stream().flatMap(virtualFile -> this.d.get((Object)virtualFile.getPath()).stream()).distinct().forEach(string -> this.b.a(string, false));
        }

        private void c() {
            if (this.a()) {
                return;
            }
            this.a = new ArrayList<VirtualFile>();
            this.c = new ArrayList<VirtualFile>();
        }

        private void b() {
            this.a = null;
            this.c = null;
            this.d.clear();
        }
    }

    private static class MyNotification
    extends Notification {
        private final ProjectSystemId a;
        private final Map<ProjectSystemId, MyNotification> b;
        private final Set<String> c;

        public MyNotification(final Project project2, Map<ProjectSystemId, MyNotification> map, final ProjectSystemId projectSystemId, String string) {
            super(projectSystemId.getReadableName() + " Import", ExternalSystemBundle.message((String)"import.needed", (Object[])new Object[]{projectSystemId.getReadableName()}), "", NotificationType.INFORMATION, null);
            this.a = projectSystemId;
            this.b = map;
            this.c = ContainerUtil.newHashSet((Object[])new String[]{string});
            this.addAction((AnAction)new NotificationAction(ExternalSystemBundle.message((String)"import.importChanged", (Object[])new Object[0])){

                public void actionPerformed(@NotNull AnActionEvent anActionEvent, @NotNull Notification notification) {
                    if (anActionEvent == null) {
                        1.a(0);
                    }
                    if (notification == null) {
                        1.a(1);
                    }
                    this.a(notification, project2, projectSystemId, false);
                }

                private static /* synthetic */ void a(int n2) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n2) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "e";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "notification";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/openapi/externalSystem/service/project/autoimport/ExternalSystemProjectsWatcherImpl$MyNotification$1";
                    objectArray[2] = "actionPerformed";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            this.addAction((AnAction)new NotificationAction(ExternalSystemBundle.message((String)"import.enableAutoImport", (Object[])new Object[0])){

                public void actionPerformed(@NotNull AnActionEvent anActionEvent, @NotNull Notification notification) {
                    if (anActionEvent == null) {
                        2.a(0);
                    }
                    if (notification == null) {
                        2.a(1);
                    }
                    this.a(notification, project2, projectSystemId, true);
                }

                private static /* synthetic */ void a(int n2) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n2) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "e";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "notification";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/openapi/externalSystem/service/project/autoimport/ExternalSystemProjectsWatcherImpl$MyNotification$2";
                    objectArray[2] = "actionPerformed";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }

        public void expire() {
            super.expire();
            this.c.clear();
            this.b.remove(this.a);
        }

        private void a(@NotNull Notification notification, Project project2, ProjectSystemId projectSystemId, boolean bl2) {
            if (notification == null) {
                MyNotification.a(0);
            }
            this.c.stream().map(string -> ExternalSystemApiUtil.getSettings((Project)project2, (ProjectSystemId)projectSystemId).getLinkedProjectSettings(string)).distinct().filter(Objects::nonNull).forEach(externalProjectSettings -> {
                if (bl2) {
                    externalProjectSettings.setUseAutoImport(true);
                }
                ExternalSystemProjectsWatcherImpl.a(project2, externalProjectSettings.getExternalProjectPath(), projectSystemId, !bl2);
            });
            notification.expire();
        }

        private static /* synthetic */ void a(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/openapi/externalSystem/service/project/autoimport/ExternalSystemProjectsWatcherImpl$MyNotification", "doAction"));
        }
    }
}

