/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.SettingsSavingComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalTaskPojo;
import com.intellij.openapi.externalSystem.model.internal.InternalExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.project.ExternalConfigPathAware;
import com.intellij.openapi.externalSystem.model.project.ExternalProjectPojo;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.task.TaskData;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManager;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataManagerImpl;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemLocalSettings;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.Alarm;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.XCollection;
import com.intellij.util.xmlb.annotations.XMap;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="ExternalProjectsData", storages={@Storage(value="$WORKSPACE_FILE$")})
public class ExternalProjectsDataStorage
implements SettingsSavingComponent,
PersistentStateComponent<State> {
    private static final Logger e = Logger.getInstance(ExternalProjectsDataStorage.class);
    private static final String g = ExternalProjectsDataStorage.class.getSimpleName() + ".2";
    @NotNull
    private final Project a;
    private final Alarm f;
    @NotNull
    private final Map<Pair<ProjectSystemId, File>, InternalExternalProjectInfo> c;
    private final AtomicBoolean d;
    private State b;

    public static ExternalProjectsDataStorage getInstance(@NotNull Project project2) {
        if (project2 == null) {
            ExternalProjectsDataStorage.a(0);
        }
        return (ExternalProjectsDataStorage)ServiceManager.getService((Project)project2, ExternalProjectsDataStorage.class);
    }

    public ExternalProjectsDataStorage(@NotNull Project project2) {
        if (project2 == null) {
            ExternalProjectsDataStorage.a(1);
        }
        this.c = ConcurrentCollectionFactory.createMap(ExternalSystemUtil.HASHING_STRATEGY);
        this.d = new AtomicBoolean();
        this.b = new State();
        this.a = project2;
        this.f = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this.a);
    }

    public ExternalProjectsDataStorage(@NotNull Project project2, @NotNull Alarm alarm) {
        if (project2 == null) {
            ExternalProjectsDataStorage.a(2);
        }
        if (alarm == null) {
            ExternalProjectsDataStorage.a(3);
        }
        this.c = ConcurrentCollectionFactory.createMap(ExternalSystemUtil.HASHING_STRATEGY);
        this.d = new AtomicBoolean();
        this.b = new State();
        this.a = project2;
        this.f = alarm;
    }

    public synchronized void load() {
        this.c.clear();
        long l2 = System.currentTimeMillis();
        try {
            Collection<InternalExternalProjectInfo> collection = ExternalProjectsDataStorage.a(this.a);
            if (collection.isEmpty() && this.a.getUserData(ExternalSystemDataKeys.NEWLY_CREATED_PROJECT) != Boolean.TRUE && this.a()) {
                this.b();
            }
            for (InternalExternalProjectInfo internalExternalProjectInfo : collection) {
                if (ExternalProjectsDataStorage.a(internalExternalProjectInfo)) {
                    this.c.put((Pair<ProjectSystemId, File>)Pair.create((Object)internalExternalProjectInfo.getProjectSystemId(), (Object)new File(internalExternalProjectInfo.getExternalProjectPath())), internalExternalProjectInfo);
                    if (internalExternalProjectInfo.getLastImportTimestamp() == internalExternalProjectInfo.getLastSuccessfulImportTimestamp()) continue;
                    this.a(internalExternalProjectInfo.getExternalProjectPath());
                    continue;
                }
                String string = internalExternalProjectInfo.getNullSafeExternalProjectPath();
                if (string == null) continue;
                this.a(string);
            }
        }
        catch (IOException iOException) {
            e.debug((Throwable)iOException);
            this.b();
        }
        this.c();
        long l3 = System.currentTimeMillis();
        e.info("Loaded external projects data in " + (l3 - l2) + " millis");
    }

    private boolean a() {
        return ExternalSystemApiUtil.getAllManagers().stream().anyMatch(externalSystemManager -> !((AbstractExternalSystemSettings)externalSystemManager.getSettingsProvider().fun((Object)this.a)).getLinkedProjectsSettings().isEmpty());
    }

    private void b() {
        ExternalProjectsManager.getInstance((Project)this.a).getExternalProjectsWatcher().markDirtyAllExternalProjects();
    }

    private void a(String string) {
        ExternalProjectsManager.getInstance((Project)this.a).getExternalProjectsWatcher().markDirty(string);
    }

    private static boolean a(InternalExternalProjectInfo internalExternalProjectInfo) {
        try {
            DataNode<ProjectData> dataNode = internalExternalProjectInfo.getExternalProjectStructure();
            if (dataNode == null) {
                return false;
            }
            ProjectDataManagerImpl.getInstance().ensureTheDataIsReadyToUse(dataNode);
            return internalExternalProjectInfo.getExternalProjectPath().equals(((ProjectData)dataNode.getData()).getLinkedExternalProjectPath());
        }
        catch (Exception exception) {
            e.warn((Throwable)exception);
            return false;
        }
    }

    public synchronized void save() {
        if (!this.d.compareAndSet(true, false)) {
            return;
        }
        this.f.cancelAllRequests();
        this.f.addRequest((Runnable)new MySaveTask(this.a, this.c.values()), 0);
    }

    synchronized void update(@NotNull ExternalProjectInfo externalProjectInfo) {
        if (externalProjectInfo == null) {
            ExternalProjectsDataStorage.a(4);
        }
        this.restoreInclusionSettings((DataNode<ProjectData>)externalProjectInfo.getExternalProjectStructure());
        ProjectSystemId projectSystemId = externalProjectInfo.getProjectSystemId();
        String string = externalProjectInfo.getExternalProjectPath();
        DataNode dataNode = externalProjectInfo.getExternalProjectStructure();
        long l2 = externalProjectInfo.getLastSuccessfulImportTimestamp();
        long l3 = externalProjectInfo.getLastImportTimestamp();
        Pair pair2 = Pair.create((Object)projectSystemId, (Object)new File(string));
        InternalExternalProjectInfo internalExternalProjectInfo = this.c.get(pair2);
        if (internalExternalProjectInfo != null) {
            l3 = externalProjectInfo.getLastImportTimestamp();
            if (l2 == -1L) {
                l2 = internalExternalProjectInfo.getLastSuccessfulImportTimestamp();
            }
            dataNode = externalProjectInfo.getExternalProjectStructure() == null ? internalExternalProjectInfo.getExternalProjectStructure() : externalProjectInfo.getExternalProjectStructure().graphCopy();
        } else {
            dataNode = dataNode != null ? dataNode.graphCopy() : null;
        }
        InternalExternalProjectInfo internalExternalProjectInfo2 = new InternalExternalProjectInfo(projectSystemId, string, (DataNode<ProjectData>)dataNode);
        internalExternalProjectInfo2.setLastImportTimestamp(l3);
        internalExternalProjectInfo2.setLastSuccessfulImportTimestamp(l2);
        this.c.put((Pair<ProjectSystemId, File>)pair2, internalExternalProjectInfo2);
        this.d.set(true);
    }

    synchronized void restoreInclusionSettings(@Nullable DataNode<ProjectData> dataNode2) {
        if (dataNode2 == null) {
            return;
        }
        String string = ((ProjectData)dataNode2.getData()).getLinkedExternalProjectPath();
        ProjectState projectState = this.b.map.get(string);
        if (projectState == null) {
            return;
        }
        ExternalSystemApiUtil.visit(dataNode2, dataNode -> {
            DataNode<ExternalConfigPathAware> dataNode2 = ExternalProjectsDataStorage.c(dataNode);
            assert (dataNode2 != null);
            ModuleState moduleState = projectState.map.get(((ExternalConfigPathAware)dataNode2.getData()).getLinkedExternalProjectPath());
            dataNode.setIgnored(ExternalProjectsDataStorage.a(projectState, moduleState, dataNode.getKey()));
        });
    }

    synchronized void saveInclusionSettings(@Nullable DataNode<ProjectData> dataNode2) {
        MultiMap multiMap;
        if (dataNode2 == null) {
            return;
        }
        MultiMap multiMap2 = MultiMap.create();
        MultiMap multiMap3 = MultiMap.create();
        ExternalSystemApiUtil.visit(dataNode2, dataNode -> {
            DataNode<ExternalConfigPathAware> dataNode2 = ExternalProjectsDataStorage.c(dataNode);
            if (dataNode2 != null) {
                String string = ((ExternalConfigPathAware)dataNode2.getData()).getLinkedExternalProjectPath();
                if (dataNode2.isIgnored() || dataNode.isIgnored()) {
                    multiMap3.putValue((Object)string, (Object)dataNode.getKey().getDataType());
                } else {
                    multiMap2.putValue((Object)string, (Object)dataNode.getKey().getDataType());
                }
            }
        });
        ProjectState projectState = new ProjectState();
        if (multiMap2.size() < multiMap3.size()) {
            projectState.isInclusion = true;
            multiMap = multiMap2;
        } else {
            projectState.isInclusion = false;
            multiMap = multiMap3;
        }
        for (String string : multiMap.keySet()) {
            projectState.map.put(string, new ModuleState(multiMap.get((Object)string)));
        }
        this.b.map.put(((ProjectData)dataNode2.getData()).getLinkedExternalProjectPath(), projectState);
        this.d.set(true);
    }

    @Nullable
    synchronized ExternalProjectInfo get(@NotNull ProjectSystemId projectSystemId, @NotNull String string) {
        if (projectSystemId == null) {
            ExternalProjectsDataStorage.a(5);
        }
        if (string == null) {
            ExternalProjectsDataStorage.a(6);
        }
        return this.c.get(Pair.create((Object)projectSystemId, (Object)new File(string)));
    }

    synchronized void remove(@NotNull ProjectSystemId projectSystemId, @NotNull String string) {
        InternalExternalProjectInfo internalExternalProjectInfo;
        if (projectSystemId == null) {
            ExternalProjectsDataStorage.a(7);
        }
        if (string == null) {
            ExternalProjectsDataStorage.a(8);
        }
        if ((internalExternalProjectInfo = this.c.remove(Pair.create((Object)projectSystemId, (Object)new File(string)))) != null) {
            this.d.set(true);
        }
    }

    @NotNull
    synchronized Collection<ExternalProjectInfo> list(@NotNull ProjectSystemId projectSystemId) {
        if (projectSystemId == null) {
            ExternalProjectsDataStorage.a(9);
        }
        List list2 = ContainerUtil.mapNotNull(this.c.values(), internalExternalProjectInfo -> {
            if (projectSystemId == null) {
                ExternalProjectsDataStorage.a(33);
            }
            return projectSystemId.equals((Object)internalExternalProjectInfo.getProjectSystemId()) ? internalExternalProjectInfo : null;
        });
        if (list2 == null) {
            ExternalProjectsDataStorage.a(10);
        }
        return list2;
    }

    private void c() {
        for (ExternalSystemManager externalSystemManager : ExternalSystemApiUtil.getAllManagers()) {
            ProjectSystemId projectSystemId = externalSystemManager.getSystemId();
            AbstractExternalSystemLocalSettings abstractExternalSystemLocalSettings = (AbstractExternalSystemLocalSettings)externalSystemManager.getLocalSettingsProvider().fun((Object)this.a);
            Map map = abstractExternalSystemLocalSettings.getAvailableProjects();
            Map map2 = abstractExternalSystemLocalSettings.getAvailableTasks();
            for (Map.Entry entry : map.entrySet()) {
                ExternalProjectSettings externalProjectSettings;
                ExternalProjectPojo externalProjectPojo = (ExternalProjectPojo)entry.getKey();
                String string = externalProjectPojo.getPath();
                Pair pair2 = Pair.create((Object)projectSystemId, (Object)new File(string));
                InternalExternalProjectInfo internalExternalProjectInfo = this.c.get(pair2);
                if (internalExternalProjectInfo == null) {
                    externalProjectSettings = ExternalProjectsDataStorage.a(projectSystemId, externalProjectPojo, (Collection)entry.getValue(), map2);
                    internalExternalProjectInfo = new InternalExternalProjectInfo(projectSystemId, string, (DataNode<ProjectData>)externalProjectSettings);
                    this.c.put((Pair<ProjectSystemId, File>)pair2, internalExternalProjectInfo);
                    ExternalProjectsManager.getInstance((Project)this.a).getExternalProjectsWatcher().markDirty(string);
                    this.d.set(true);
                }
                if ((externalProjectSettings = ((AbstractExternalSystemSettings)externalSystemManager.getSettingsProvider().fun((Object)this.a)).getLinkedProjectSettings(string)) == null || !ContainerUtil.isEmpty((Collection)externalProjectSettings.getModules())) continue;
                Set set = ContainerUtil.map2Set((Collection)ExternalSystemApiUtil.findAllRecursively(internalExternalProjectInfo.getExternalProjectStructure(), (Key)ProjectKeys.MODULE), dataNode -> ((ModuleData)dataNode.getData()).getLinkedExternalProjectPath());
                externalProjectSettings.setModules(set);
            }
        }
    }

    private static DataNode<ProjectData> a(@NotNull ProjectSystemId projectSystemId, @NotNull ExternalProjectPojo externalProjectPojo, @NotNull Collection<ExternalProjectPojo> collection, @NotNull Map<String, Collection<ExternalTaskPojo>> map) {
        if (projectSystemId == null) {
            ExternalProjectsDataStorage.a(11);
        }
        if (externalProjectPojo == null) {
            ExternalProjectsDataStorage.a(12);
        }
        if (collection == null) {
            ExternalProjectsDataStorage.a(13);
        }
        if (map == null) {
            ExternalProjectsDataStorage.a(14);
        }
        ProjectData projectData = new ProjectData(projectSystemId, externalProjectPojo.getName(), externalProjectPojo.getPath(), externalProjectPojo.getPath());
        DataNode dataNode = new DataNode(ProjectKeys.PROJECT, (Object)projectData, null);
        for (ExternalProjectPojo externalProjectPojo2 : collection) {
            String string = externalProjectPojo2.getPath();
            ModuleData moduleData = new ModuleData(externalProjectPojo2.getName(), projectSystemId, "JAVA_MODULE", externalProjectPojo2.getName(), string, string);
            DataNode dataNode2 = dataNode.createChild(ProjectKeys.MODULE, (Object)moduleData);
            Collection<ExternalTaskPojo> collection2 = map.get(string);
            if (collection2 == null) continue;
            for (ExternalTaskPojo externalTaskPojo : collection2) {
                TaskData taskData = new TaskData(projectSystemId, externalTaskPojo.getName(), string, externalTaskPojo.getDescription());
                dataNode2.createChild(ProjectKeys.TASK, (Object)taskData);
            }
        }
        return dataNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void a(@NotNull Project project2, @NotNull Collection<InternalExternalProjectInfo> collection) throws IOException {
        Object object;
        Path path;
        if (project2 == null) {
            ExternalProjectsDataStorage.a(15);
        }
        if (collection == null) {
            ExternalProjectsDataStorage.a(16);
        }
        if (!FileUtil.createParentDirs((File)(path = ExternalProjectsDataStorage.b(project2)).toFile())) {
            throw new IOException("Unable to save " + path);
        }
        Object object2 = collection.iterator();
        while (object2.hasNext()) {
            object = object2.next();
            if (!ExternalProjectsDataStorage.a((InternalExternalProjectInfo)object)) {
                object2.remove();
                continue;
            }
            ExternalSystemApiUtil.visit(((InternalExternalProjectInfo)object).getExternalProjectStructure(), dataNode -> {
                try {
                    dataNode.checkIsSerializable();
                }
                catch (IOException iOException) {
                    dataNode.clear(true);
                }
            });
        }
        object2 = new DataOutputStream(new BufferedOutputStream(Files.newOutputStream(path, new OpenOption[0])));
        try {
            ((DataOutputStream)object2).writeUTF(g);
            ((DataOutputStream)object2).writeInt(collection.size());
            object = new ObjectOutputStream((OutputStream)object2);
            try {
                for (InternalExternalProjectInfo internalExternalProjectInfo : collection) {
                    ((ObjectOutputStream)object).writeObject(internalExternalProjectInfo);
                }
            }
            finally {
                ((ObjectOutputStream)object).close();
            }
        }
        finally {
            ((FilterOutputStream)object2).close();
        }
    }

    @Nullable
    private static DataNode<ExternalConfigPathAware> c(@NotNull DataNode dataNode) {
        if (dataNode == null) {
            ExternalProjectsDataStorage.a(17);
        }
        if ((ProjectKeys.MODULE.equals((Object)dataNode.getKey()) || ProjectKeys.PROJECT.equals((Object)dataNode.getKey())) && dataNode.getData() instanceof ExternalConfigPathAware) {
            return dataNode;
        }
        DataNode dataNode2 = ExternalSystemApiUtil.findParent((DataNode)dataNode, (Key)ProjectKeys.MODULE);
        if (dataNode2 == null) {
            dataNode2 = ExternalSystemApiUtil.findParent((DataNode)dataNode, (Key)ProjectKeys.PROJECT);
        }
        return dataNode2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private static Collection<InternalExternalProjectInfo> a(@NotNull Project project2) throws IOException {
        if (project2 == null) {
            ExternalProjectsDataStorage.a(18);
        }
        SmartList smartList = new SmartList();
        Path path = ExternalProjectsDataStorage.b(project2);
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            SmartList smartList2 = smartList;
            if (smartList2 == null) {
                ExternalProjectsDataStorage.a(19);
            }
            return smartList2;
        }
        try (DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(Files.newInputStream(path, new OpenOption[0])));){
            String string = dataInputStream.readUTF();
            if (!g.equals(string)) {
                SmartList smartList3 = smartList;
                SmartList smartList4 = smartList3;
                if (smartList4 == null) {
                    ExternalProjectsDataStorage.a(20);
                }
                return smartList4;
            }
            int n2 = dataInputStream.readInt();
            try (ObjectInputStream objectInputStream = new ObjectInputStream(dataInputStream);){
                for (int i2 = 0; i2 < n2; ++i2) {
                    InternalExternalProjectInfo internalExternalProjectInfo = (InternalExternalProjectInfo)objectInputStream.readObject();
                    smartList.add((Object)internalExternalProjectInfo);
                }
            }
        }
        SmartList smartList5 = smartList;
        if (smartList5 == null) {
            ExternalProjectsDataStorage.a(21);
        }
        return smartList5;
    }

    @NotNull
    private static Path b(@NotNull Project project2) {
        if (project2 == null) {
            ExternalProjectsDataStorage.a(22);
        }
        Path path = ExternalProjectsDataStorage.getProjectConfigurationDir(project2).resolve("project.dat");
        if (path == null) {
            ExternalProjectsDataStorage.a(23);
        }
        return path;
    }

    @NotNull
    public static Path getProjectConfigurationDir(@NotNull Project project2) {
        if (project2 == null) {
            ExternalProjectsDataStorage.a(24);
        }
        Path path = ProjectUtil.getExternalConfigurationDir((Project)project2);
        if (path == null) {
            ExternalProjectsDataStorage.a(25);
        }
        return path;
    }

    @Nullable
    public synchronized State getState() {
        return this.b;
    }

    public synchronized void loadState(@NotNull State state) {
        if (state == null) {
            ExternalProjectsDataStorage.a(26);
        }
        this.b = state == null ? new State() : state;
    }

    synchronized void setIgnored(@NotNull DataNode<?> dataNode2, boolean bl2) {
        DataNode dataNode3;
        if (dataNode2 == null) {
            ExternalProjectsDataStorage.a(27);
        }
        DataNode dataNode4 = dataNode3 = ProjectKeys.PROJECT.equals((Object)dataNode2.getKey()) ? dataNode2 : ExternalSystemApiUtil.findParent(dataNode2, (Key)ProjectKeys.PROJECT);
        if (dataNode3 == null) {
            return;
        }
        ExternalSystemApiUtil.visit((DataNode)dataNode2, dataNode -> dataNode.setIgnored(bl2));
        this.saveInclusionSettings((DataNode<ProjectData>)dataNode3);
    }

    synchronized boolean isIgnored(@NotNull String string, @NotNull String string2, @NotNull Key key) {
        ProjectState projectState;
        if (string == null) {
            ExternalProjectsDataStorage.a(28);
        }
        if (string2 == null) {
            ExternalProjectsDataStorage.a(29);
        }
        if (key == null) {
            ExternalProjectsDataStorage.a(30);
        }
        if ((projectState = this.b.map.get(string)) == null) {
            return false;
        }
        ModuleState moduleState = projectState.map.get(string2);
        return ExternalProjectsDataStorage.a(projectState, moduleState, key);
    }

    private static boolean a(@NotNull ProjectState projectState, @Nullable ModuleState moduleState, @NotNull Key<?> key) {
        if (projectState == null) {
            ExternalProjectsDataStorage.a(31);
        }
        if (key == null) {
            ExternalProjectsDataStorage.a(32);
        }
        return projectState.isInclusion ^ (moduleState != null && moduleState.set.contains(key.getDataType()));
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 10: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 25: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alarm";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalProjectInfo";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectSystemId";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalProjectPath";
                break;
            }
            case 10: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/project/manage/ExternalProjectsDataStorage";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "systemId";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootProject";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childProjects";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "availableTasks";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalProjects";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataNode";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootProjectPath";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modulePath";
                break;
            }
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectState";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/manage/ExternalProjectsDataStorage";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "list";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "load";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectConfigurationFile";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectConfigurationDir";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "list";
                break;
            }
            case 10: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 25: {
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "convert";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "doSave";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "resolveProjectNode";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getProjectConfigurationFile";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getProjectConfigurationDir";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "setIgnored";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "isIgnored";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "lambda$list$3";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MySaveTask
    implements Runnable {
        private Project a;
        private Collection<InternalExternalProjectInfo> b;

        public MySaveTask(Project project2, Collection<InternalExternalProjectInfo> collection) {
            this.a = project2;
            this.b = ContainerUtil.map(collection, internalExternalProjectInfo -> (InternalExternalProjectInfo)internalExternalProjectInfo.copy());
        }

        @Override
        public void run() {
            try {
                ExternalProjectsDataStorage.a(this.a, this.b);
            }
            catch (IOException iOException) {
                e.debug((Throwable)iOException);
            }
        }
    }

    static class ModuleState {
        @Property(surroundWithTag=false)
        @XCollection(elementName="id")
        public final Set<String> set = ContainerUtil.newConcurrentSet();

        public ModuleState() {
        }

        public ModuleState(Collection<String> collection) {
            this.set.addAll(collection);
        }
    }

    static class ProjectState {
        @Property(surroundWithTag=false)
        @XMap(keyAttributeName="path", entryTagName="dataType")
        public final Map<String, ModuleState> map = ContainerUtil.newConcurrentMap();
        public boolean isInclusion;

        ProjectState() {
        }
    }

    static class State {
        @Property(surroundWithTag=false)
        @MapAnnotation(surroundWithTag=false, surroundValueWithTag=false, surroundKeyWithTag=false, keyAttributeName="path", entryTagName="projectState")
        public final Map<String, ProjectState> map = ContainerUtil.newConcurrentMap();

        State() {
        }
    }
}

