/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.ExternalSystemModulePropertyManager;
import com.intellij.openapi.externalSystem.importing.ImportSpec;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.autoimport.ExternalSystemProjectsWatcher;
import com.intellij.openapi.externalSystem.service.project.autoimport.ExternalSystemProjectsWatcherImpl;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsDataStorage;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManager;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsState;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalSystemKeymapExtension;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalSystemRunManagerListener;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalSystemShortcutsManager;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalSystemTaskActivator;
import com.intellij.openapi.externalSystem.service.project.manage.TaskActivationState;
import com.intellij.openapi.externalSystem.util.CompositeRunnable;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.externalSystem.view.ExternalProjectsView;
import com.intellij.openapi.externalSystem.view.ExternalProjectsViewImpl;
import com.intellij.openapi.externalSystem.view.ExternalProjectsViewState;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.ExternalStorageConfigurationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.impl.ModuleRootManagerImpl;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="ExternalProjectsManager", storages={@Storage(value="$WORKSPACE_FILE$")})
public class ExternalProjectsManagerImpl
implements ExternalProjectsManager,
PersistentStateComponent<ExternalProjectsState>,
Disposable {
    private static final Logger g = Logger.getInstance(ExternalProjectsManager.class);
    private final AtomicBoolean h;
    private final AtomicBoolean f;
    private final CompositeRunnable a;
    @NotNull
    private ExternalProjectsState b;
    @NotNull
    private final Project e;
    private final ExternalSystemRunManagerListener k;
    private final ExternalSystemTaskActivator c;
    private final ExternalSystemShortcutsManager j;
    private final List<ExternalProjectsView> i;
    private ExternalSystemProjectsWatcherImpl d;

    public ExternalProjectsManagerImpl(@NotNull Project project2) {
        if (project2 == null) {
            ExternalProjectsManagerImpl.a(0);
        }
        this.h = new AtomicBoolean();
        this.f = new AtomicBoolean();
        this.a = new CompositeRunnable();
        this.b = new ExternalProjectsState();
        this.i = new SmartList();
        this.e = project2;
        this.j = new ExternalSystemShortcutsManager(project2);
        Disposer.register((Disposable)this, (Disposable)this.j);
        this.c = new ExternalSystemTaskActivator(project2);
        this.k = new ExternalSystemRunManagerListener(this);
        this.d = new ExternalSystemProjectsWatcherImpl(this.e);
    }

    public static ExternalProjectsManagerImpl getInstance(@NotNull Project project2) {
        if (project2 == null) {
            ExternalProjectsManagerImpl.a(1);
        }
        ExternalProjectsManager externalProjectsManager = (ExternalProjectsManager)ServiceManager.getService((Project)project2, ExternalProjectsManager.class);
        return (ExternalProjectsManagerImpl)externalProjectsManager;
    }

    @Nullable
    public static Project setupCreatedProject(@Nullable Project project2) {
        if (project2 != null) {
            ExternalProjectsManagerImpl.getInstance(project2).setStoreExternally(true);
        }
        return project2;
    }

    public void setStoreExternally(boolean bl2) {
        ExternalStorageConfigurationManager.getInstance((Project)this.e).setEnabled(bl2);
        try {
            for (Module module2 : ModuleManager.getInstance((Project)this.e).getModules()) {
                if (module2.isDisposed()) continue;
                ExternalSystemModulePropertyManager.getInstance((Module)module2).swapStore();
                ((ModuleRootManagerImpl)ModuleRootManager.getInstance((Module)module2)).stateChanged();
            }
        }
        catch (Exception exception) {
            g.warn((Throwable)exception);
        }
    }

    @NotNull
    public Project getProject() {
        Project project2 = this.e;
        if (project2 == null) {
            ExternalProjectsManagerImpl.a(2);
        }
        return project2;
    }

    public ExternalSystemShortcutsManager getShortcutsManager() {
        return this.j;
    }

    public ExternalSystemTaskActivator getTaskActivator() {
        return this.c;
    }

    public ExternalSystemProjectsWatcher getExternalProjectsWatcher() {
        return this.d;
    }

    public void registerView(@NotNull ExternalProjectsView externalProjectsView) {
        if (externalProjectsView == null) {
            ExternalProjectsManagerImpl.a(3);
        }
        assert (this.getExternalProjectsView(externalProjectsView.getSystemId()) == null);
        this.i.add(externalProjectsView);
        if (externalProjectsView instanceof ExternalProjectsViewImpl) {
            ExternalProjectsViewImpl externalProjectsViewImpl = (ExternalProjectsViewImpl)externalProjectsView;
            externalProjectsViewImpl.loadState(this.b.getExternalSystemsState().get(externalProjectsView.getSystemId().getId()).getProjectsViewState());
            externalProjectsViewImpl.init();
        }
    }

    @Nullable
    public ExternalProjectsView getExternalProjectsView(@NotNull ProjectSystemId projectSystemId) {
        if (projectSystemId == null) {
            ExternalProjectsManagerImpl.a(4);
        }
        for (ExternalProjectsView externalProjectsView : this.i) {
            if (!externalProjectsView.getSystemId().equals((Object)projectSystemId)) continue;
            return externalProjectsView;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        if (this.f.getAndSet(true)) {
            return;
        }
        this.d.start();
        ExternalProjectsDataStorage.getInstance(this.e).load();
        this.k.attach();
        this.j.init();
        for (ExternalSystemManager externalSystemManager : ExternalSystemApiUtil.getAllManagers()) {
            Collection<ExternalProjectInfo> collection = ExternalProjectsDataStorage.getInstance(this.e).list(externalSystemManager.getSystemId());
            for (ExternalProjectInfo externalProjectInfo : collection) {
                if (externalProjectInfo.getExternalProjectStructure() == null) continue;
                Collection collection2 = ExternalSystemApiUtil.findAllRecursively((DataNode)externalProjectInfo.getExternalProjectStructure(), (Key)ProjectKeys.TASK);
                this.j.scheduleKeymapUpdate(collection2);
            }
            if (collection.isEmpty()) continue;
            this.j.scheduleRunConfigurationKeymapUpdate(externalSystemManager.getSystemId());
        }
        this.c.init();
        AtomicBoolean atomicBoolean = this.h;
        synchronized (atomicBoolean) {
            this.h.set(true);
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                this.a.run();
                this.a.clear();
            });
        }
    }

    public void refreshProject(@NotNull String string, @NotNull ImportSpec importSpec) {
        if (string == null) {
            ExternalProjectsManagerImpl.a(5);
        }
        if (importSpec == null) {
            ExternalProjectsManagerImpl.a(6);
        }
        ExternalSystemUtil.refreshProject(string, importSpec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runWhenInitialized(Runnable runnable) {
        AtomicBoolean atomicBoolean = this.h;
        synchronized (atomicBoolean) {
            if (this.h.get()) {
                ApplicationManager.getApplication().executeOnPooledThread(runnable);
            } else {
                this.a.add(runnable);
            }
        }
    }

    public void updateExternalProjectData(ExternalProjectInfo externalProjectInfo) {
        ExternalProjectsDataStorage.getInstance(this.e).update(externalProjectInfo);
        if (externalProjectInfo.getExternalProjectStructure() != null) {
            ProjectData projectData = (ProjectData)externalProjectInfo.getExternalProjectStructure().getData();
            ExternalSystemUtil.scheduleExternalViewStructureUpdate(this.e, projectData.getOwner());
            Collection collection = ExternalSystemApiUtil.findAllRecursively((DataNode)externalProjectInfo.getExternalProjectStructure(), (Key)ProjectKeys.TASK);
            this.j.scheduleKeymapUpdate(collection);
            this.j.scheduleRunConfigurationKeymapUpdate(projectData.getOwner());
        }
    }

    public void forgetExternalProjectData(@NotNull ProjectSystemId projectSystemId, @NotNull String string) {
        if (projectSystemId == null) {
            ExternalProjectsManagerImpl.a(7);
        }
        if (string == null) {
            ExternalProjectsManagerImpl.a(8);
        }
        ExternalProjectsDataStorage.getInstance(this.e).remove(projectSystemId, string);
        ExternalSystemUtil.scheduleExternalViewStructureUpdate(this.e, projectSystemId);
    }

    @NotNull
    public ExternalProjectsState getState() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        for (ExternalProjectsView externalProjectsView : this.i) {
            if (!(externalProjectsView instanceof ExternalProjectsViewImpl)) continue;
            ExternalProjectsViewState externalProjectsViewState = ((ExternalProjectsViewImpl)externalProjectsView).getState();
            ExternalProjectsState.State state = this.b.getExternalSystemsState().get(externalProjectsView.getSystemId().getId());
            assert (state != null);
            state.setProjectsViewState(externalProjectsViewState);
        }
        ExternalProjectsState externalProjectsState = this.b;
        if (externalProjectsState == null) {
            ExternalProjectsManagerImpl.a(9);
        }
        return externalProjectsState;
    }

    @NotNull
    public ExternalProjectsStateProvider getStateProvider() {
        ExternalProjectsStateProvider externalProjectsStateProvider = new ExternalProjectsStateProvider(){

            @Override
            public List<ExternalProjectsStateProvider.TasksActivation> getAllTasksActivation() {
                SmartList smartList = new SmartList();
                Map<String, ProjectSystemId> map = ExternalSystemApiUtil.getAllManagers().stream().collect(Collectors.toMap(externalSystemManager -> externalSystemManager.getSystemId().getId(), externalSystemManager -> externalSystemManager.getSystemId()));
                for (Map.Entry<String, ExternalProjectsState.State> entry : ExternalProjectsManagerImpl.this.b.getExternalSystemsState().entrySet()) {
                    ProjectSystemId projectSystemId = map.get(entry.getKey());
                    if (projectSystemId == null) continue;
                    for (Map.Entry<String, TaskActivationState> entry2 : entry.getValue().getExternalSystemsTaskActivation().entrySet()) {
                        smartList.add(new ExternalProjectsStateProvider.TasksActivation(projectSystemId, entry2.getKey(), entry2.getValue()));
                    }
                }
                return smartList;
            }

            @Override
            public List<ExternalProjectsStateProvider.TasksActivation> getTasksActivation(@NotNull ProjectSystemId projectSystemId) {
                if (projectSystemId == null) {
                    1.a(0);
                }
                Set<Map.Entry<String, TaskActivationState>> set = ExternalProjectsManagerImpl.this.b.getExternalSystemsState().get(projectSystemId.getId()).getExternalSystemsTaskActivation().entrySet();
                return ContainerUtil.map(set, entry -> {
                    if (projectSystemId == null) {
                        1.a(4);
                    }
                    return new ExternalProjectsStateProvider.TasksActivation(projectSystemId, (String)entry.getKey(), (TaskActivationState)entry.getValue());
                });
            }

            @Override
            public TaskActivationState getTasksActivation(@NotNull ProjectSystemId projectSystemId, @NotNull String string) {
                if (projectSystemId == null) {
                    1.a(1);
                }
                if (string == null) {
                    1.a(2);
                }
                return ExternalProjectsManagerImpl.this.b.getExternalSystemsState().get(projectSystemId.getId()).getExternalSystemsTaskActivation().get(string);
            }

            @Override
            public Map<String, TaskActivationState> getProjectsTasksActivationMap(@NotNull ProjectSystemId projectSystemId) {
                if (projectSystemId == null) {
                    1.a(3);
                }
                return ExternalProjectsManagerImpl.this.b.getExternalSystemsState().get(projectSystemId.getId()).getExternalSystemsTaskActivation();
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n2) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "systemId";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "projectPath";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/manage/ExternalProjectsManagerImpl$1";
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getTasksActivation";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getProjectsTasksActivationMap";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$getTasksActivation$2";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (externalProjectsStateProvider == null) {
            ExternalProjectsManagerImpl.a(10);
        }
        return externalProjectsStateProvider;
    }

    public boolean isIgnored(@NotNull ProjectSystemId projectSystemId, @NotNull String string) {
        ExternalProjectInfo externalProjectInfo;
        if (projectSystemId == null) {
            ExternalProjectsManagerImpl.a(11);
        }
        if (string == null) {
            ExternalProjectsManagerImpl.a(12);
        }
        if ((externalProjectInfo = ExternalSystemUtil.getExternalProjectInfo(this.e, projectSystemId, string)) == null) {
            return true;
        }
        return ExternalProjectsDataStorage.getInstance(this.e).isIgnored(externalProjectInfo.getExternalProjectPath(), string, ProjectKeys.MODULE);
    }

    public void setIgnored(@NotNull DataNode<?> dataNode, boolean bl2) {
        if (dataNode == null) {
            ExternalProjectsManagerImpl.a(13);
        }
        ExternalProjectsDataStorage.getInstance(this.e).setIgnored(dataNode, bl2);
        ExternalSystemKeymapExtension.updateActions(this.e, ExternalSystemApiUtil.findAllRecursively(dataNode, (Key)ProjectKeys.TASK));
    }

    public void loadState(@NotNull ExternalProjectsState externalProjectsState) {
        if (externalProjectsState == null) {
            ExternalProjectsManagerImpl.a(14);
        }
        this.b = externalProjectsState;
        if (this.b.storeExternally) {
            this.b.storeExternally = false;
            ExternalStorageConfigurationManager.getInstance((Project)this.e).setEnabled(true);
        }
    }

    public void dispose() {
        this.i.clear();
        this.k.detach();
        if (this.d != null) {
            this.d.stop();
        }
        this.d = null;
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: 
            case 9: 
            case 10: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/project/manage/ExternalProjectsManagerImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalProjectsView";
                break;
            }
            case 4: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "systemId";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalProjectPath";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importSpec";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectSystemId";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linkedProjectPath";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPath";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataNode";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/manage/ExternalProjectsManagerImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getStateProvider";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: 
            case 9: 
            case 10: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "registerView";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getExternalProjectsView";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "refreshProject";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "forgetExternalProjectData";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isIgnored";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setIgnored";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface ExternalProjectsStateProvider {
        public List<TasksActivation> getAllTasksActivation();

        public List<TasksActivation> getTasksActivation(@NotNull ProjectSystemId var1);

        public TaskActivationState getTasksActivation(@NotNull ProjectSystemId var1, @NotNull String var2);

        public Map<String, TaskActivationState> getProjectsTasksActivationMap(@NotNull ProjectSystemId var1);

        public static class TasksActivation {
            public final ProjectSystemId systemId;
            public final String projectPath;
            public final TaskActivationState state;

            public TasksActivation(ProjectSystemId projectSystemId, String string, TaskActivationState taskActivationState) {
                this.systemId = projectSystemId;
                this.projectPath = string;
                this.state = taskActivationState;
            }
        }
    }
}

