/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.execution.Executor;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.EmptyAction;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.ExternalSystemUiAware;
import com.intellij.openapi.externalSystem.action.ExternalSystemAction;
import com.intellij.openapi.externalSystem.action.ExternalSystemActionUtil;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalTaskExecutionInfo;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.task.TaskData;
import com.intellij.openapi.externalSystem.service.execution.AbstractExternalSystemTaskConfigurationType;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManagerImpl;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalSystemShortcutsManager;
import com.intellij.openapi.externalSystem.service.ui.SelectExternalTaskDialog;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemUiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.keymap.KeymapExtension;
import com.intellij.openapi.keymap.KeymapGroup;
import com.intellij.openapi.keymap.KeymapGroupFactory;
import com.intellij.openapi.keymap.impl.ui.ActionsTreeUtil;
import com.intellij.openapi.keymap.impl.ui.Group;
import com.intellij.openapi.keymap.impl.ui.Hyperlink;
import com.intellij.openapi.keymap.impl.ui.KeymapListener;
import com.intellij.openapi.keymap.impl.ui.KeymapPanel;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashSet;
import icons.ExternalSystemIcons;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemKeymapExtension
implements KeymapExtension {
    /*
     * WARNING - void declaration
     */
    public KeymapGroup createGroup(Condition<AnAction> condition, final Project project2) {
        void var10_25;
        MyExternalSystemAction myExternalSystemAction;
        MultiMap multiMap;
        KeymapGroup keymapGroup = KeymapGroupFactory.getInstance().createGroup(ExternalSystemBundle.message((String)"external.system.keymap.group", (Object[])new Object[0]), ExternalSystemIcons.TaskGroup);
        for (AnAction anAction : multiMap = ActionsTreeUtil.getActions((String)"ExternalSystem.Actions")) {
            ActionsTreeUtil.addAction((KeymapGroup)keymapGroup, (AnAction)anAction, condition);
        }
        if (project2 == null) {
            return keymapGroup;
        }
        MultiMap multiMap2 = MultiMap.create();
        for (ExternalSystemManager externalSystemManager : ExternalSystemApiUtil.getAllManagers()) {
            multiMap2.putValues((Object)externalSystemManager.getSystemId(), (Collection)ContainerUtil.emptyList());
        }
        ActionManager actionManager = ActionManager.getInstance();
        if (actionManager != null) {
            for (String object22 : actionManager.getActionIds(ExternalSystemKeymapExtension.getActionPrefix(project2, null))) {
                AnAction anAction = actionManager.getAction(object22);
                if (!(anAction instanceof MyExternalSystemAction) || condition != null && !condition.value((Object)actionManager.getActionOrStub(object22))) continue;
                myExternalSystemAction = (MyExternalSystemAction)anAction;
                multiMap2.putValue((Object)myExternalSystemAction.getSystemId(), (Object)object22);
            }
        }
        HashMap hashMap = ContainerUtil.newHashMap();
        for (ProjectSystemId projectSystemId : multiMap2.keySet()) {
            if (hashMap.containsKey(projectSystemId)) continue;
            Icon icon = ExternalSystemUiUtil.getUiAware(projectSystemId).getProjectIcon();
            KeymapGroup keymapGroup2 = KeymapGroupFactory.getInstance().createGroup(projectSystemId.getReadableName(), icon);
            hashMap.put(projectSystemId, keymapGroup2);
        }
        for (Map.Entry entry : multiMap2.entrySet()) {
            Collection collection = (Collection)entry.getValue();
            final ProjectSystemId projectSystemId = (ProjectSystemId)entry.getKey();
            myExternalSystemAction = (KeymapGroup)hashMap.get(projectSystemId);
            if (myExternalSystemAction == null) continue;
            for (String string : collection) {
                myExternalSystemAction.addActionId(string);
            }
            if (!(myExternalSystemAction instanceof Group)) continue;
            Icon icon = SystemInfoRt.isMac ? AllIcons.ToolbarDecorator.Mac.Add : AllIcons.ToolbarDecorator.Add;
            ((Group)myExternalSystemAction).addHyperlink(new Hyperlink(icon, "Choose a task to assign a shortcut"){

                public void onClick(MouseEvent mouseEvent) {
                    SelectExternalTaskDialog selectExternalTaskDialog = new SelectExternalTaskDialog(projectSystemId, project2);
                    if (selectExternalTaskDialog.showAndGet() && selectExternalTaskDialog.getResult() != null) {
                        KeymapPanel keymapPanel;
                        TaskData taskData = (TaskData)selectExternalTaskDialog.getResult().second;
                        String string = (String)selectExternalTaskDialog.getResult().first;
                        ExternalSystemTaskAction externalSystemTaskAction = (ExternalSystemTaskAction)ExternalSystemKeymapExtension.getOrRegisterAction(project2, string, taskData);
                        ((KeymapListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(KeymapListener.CHANGE_TOPIC)).processCurrentKeymapChanged();
                        Settings settings = (Settings)Settings.KEY.getData(DataManager.getInstance().getDataContext(mouseEvent.getComponent()));
                        KeymapPanel keymapPanel2 = keymapPanel = settings != null ? (KeymapPanel)settings.find(KeymapPanel.class) : null;
                        if (keymapPanel != null) {
                            keymapPanel.showOption("");
                            keymapPanel.selectAction(externalSystemTaskAction.b);
                        }
                    }
                }
            });
        }
        for (KeymapGroup keymapGroup2 : hashMap.values()) {
            if (!ExternalSystemKeymapExtension.a(condition, keymapGroup2)) continue;
            keymapGroup.addGroup(keymapGroup2);
        }
        Iterator<Object> iterator = (ActionsProvider[])ActionsProvider.EP_NAME.getExtensions();
        int n2 = ((Iterator<Object>)iterator).length;
        boolean bl2 = false;
        while (var10_25 < n2) {
            Iterator<Object> iterator2 = iterator[var10_25];
            myExternalSystemAction = iterator2.createGroup(condition, project2);
            if (ExternalSystemKeymapExtension.a(condition, (KeymapGroup)myExternalSystemAction)) {
                keymapGroup.addGroup((KeymapGroup)myExternalSystemAction);
            }
            ++var10_25;
        }
        return keymapGroup;
    }

    public static void updateActions(Project project2, Collection<DataNode<TaskData>> collection) {
        ExternalSystemKeymapExtension.clearActions(project2, collection);
        ExternalSystemKeymapExtension.a(project2, collection);
    }

    public static ExternalSystemAction getOrRegisterAction(Project project2, String string, TaskData taskData) {
        ExternalSystemTaskAction externalSystemTaskAction = new ExternalSystemTaskAction(project2, string, taskData);
        ActionManager actionManager = ActionManager.getInstance();
        AnAction anAction = actionManager.getAction(externalSystemTaskAction.getId());
        if (anAction instanceof ExternalSystemTaskAction && externalSystemTaskAction.equals(anAction)) {
            return (ExternalSystemAction)anAction;
        }
        actionManager.unregisterAction(externalSystemTaskAction.getId());
        actionManager.registerAction(externalSystemTaskAction.getId(), (AnAction)externalSystemTaskAction);
        return externalSystemTaskAction;
    }

    private static boolean a(Condition<AnAction> condition, KeymapGroup keymapGroup) {
        Group group;
        EmptyAction emptyAction = new EmptyAction();
        return condition == null || condition.value((Object)emptyAction) || !(keymapGroup instanceof Group) || (group = (Group)keymapGroup).getSize() > 1 || condition.value((Object)new EmptyAction(group.getName(), null, null));
    }

    private static void a(Project project2, Collection<DataNode<TaskData>> collection) {
        ActionManager actionManager = ActionManager.getInstance();
        ExternalSystemShortcutsManager externalSystemShortcutsManager = ExternalProjectsManagerImpl.getInstance(project2).getShortcutsManager();
        if (actionManager != null) {
            for (DataNode<TaskData> dataNode : collection) {
                DataNode dataNode2 = ExternalSystemApiUtil.findParent(dataNode, (Key)ProjectKeys.MODULE);
                if (dataNode2 == null || dataNode2.isIgnored()) continue;
                TaskData taskData = (TaskData)dataNode.getData();
                ExternalSystemTaskAction externalSystemTaskAction = new ExternalSystemTaskAction(project2, ((ModuleData)dataNode2.getData()).getInternalName(), taskData);
                actionManager.unregisterAction(externalSystemTaskAction.getId());
                if (!externalSystemShortcutsManager.hasShortcuts(taskData.getLinkedExternalProjectPath(), taskData.getName())) continue;
                actionManager.registerAction(externalSystemTaskAction.getId(), (AnAction)externalSystemTaskAction);
            }
        }
    }

    public static void clearActions(Project project2) {
        ActionManager actionManager = ActionManager.getInstance();
        if (actionManager != null) {
            for (String string : actionManager.getActionIds(ExternalSystemKeymapExtension.getActionPrefix(project2, null))) {
                actionManager.unregisterAction(string);
            }
        }
    }

    public static void clearActions(Project project2, Collection<DataNode<TaskData>> collection) {
        ActionManager actionManager = ActionManager.getInstance();
        if (actionManager != null) {
            HashSet hashSet = ContainerUtil.newHashSet();
            for (Object object : collection) {
                hashSet.add(((TaskData)object.getData()).getLinkedExternalProjectPath());
            }
            for (Object object : hashSet) {
                for (String string : actionManager.getActionIds(ExternalSystemKeymapExtension.getActionPrefix(project2, object))) {
                    AnAction anAction = actionManager.getAction(string);
                    if (anAction instanceof ExternalSystemRunConfigurationAction) continue;
                    actionManager.unregisterAction(string);
                }
            }
        }
    }

    public static String getActionPrefix(@NotNull Project project2, @Nullable String string) {
        if (project2 == null) {
            ExternalSystemKeymapExtension.a(0);
        }
        return ExternalProjectsManagerImpl.getInstance(project2).getShortcutsManager().getActionId(string, null);
    }

    public static void updateRunConfigurationActions(Project project2, ProjectSystemId projectSystemId) {
        AnAction anAction;
        AbstractExternalSystemTaskConfigurationType abstractExternalSystemTaskConfigurationType = ExternalSystemUtil.findConfigurationType(projectSystemId);
        if (abstractExternalSystemTaskConfigurationType == null) {
            return;
        }
        ActionManager actionManager = ActionManager.getInstance();
        for (String string : actionManager.getActionIds(ExternalSystemKeymapExtension.getActionPrefix(project2, null))) {
            anAction = actionManager.getAction(string);
            if (!(anAction instanceof ExternalSystemRunConfigurationAction)) continue;
            actionManager.unregisterAction(string);
        }
        THashSet tHashSet = new THashSet((Collection)RunManager.getInstance((Project)project2).getConfigurationSettingsList((ConfigurationType)abstractExternalSystemTaskConfigurationType));
        ExternalSystemShortcutsManager externalSystemShortcutsManager = ExternalProjectsManagerImpl.getInstance(project2).getShortcutsManager();
        for (String string : tHashSet) {
            anAction = new ExternalSystemRunConfigurationAction(project2, (RunnerAndConfigurationSettings)string);
            String string2 = anAction.getId();
            actionManager.unregisterAction(string2);
            if (!externalSystemShortcutsManager.hasShortcuts(string2)) continue;
            actionManager.registerAction(string2, anAction);
        }
    }

    public static ExternalSystemAction getOrRegisterAction(Project project2, RunnerAndConfigurationSettings runnerAndConfigurationSettings) {
        ActionManager actionManager = ActionManager.getInstance();
        ExternalSystemRunConfigurationAction externalSystemRunConfigurationAction = new ExternalSystemRunConfigurationAction(project2, runnerAndConfigurationSettings);
        String string = externalSystemRunConfigurationAction.getId();
        actionManager.unregisterAction(string);
        actionManager.registerAction(string, (AnAction)externalSystemRunConfigurationAction);
        return externalSystemRunConfigurationAction;
    }

    private static /* synthetic */ void a(int n2) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/manage/ExternalSystemKeymapExtension", "getActionPrefix"));
    }

    private static class ExternalSystemRunConfigurationAction
    extends MyExternalSystemAction {
        private final String b;
        private final String d;
        private final RunnerAndConfigurationSettings c;
        private final ProjectSystemId a;

        public ExternalSystemRunConfigurationAction(Project project2, RunnerAndConfigurationSettings runnerAndConfigurationSettings) {
            this.c = runnerAndConfigurationSettings;
            ExternalSystemRunConfiguration externalSystemRunConfiguration = (ExternalSystemRunConfiguration)runnerAndConfigurationSettings.getConfiguration();
            this.a = externalSystemRunConfiguration.getSettings().getExternalSystemId();
            ExternalSystemUiAware externalSystemUiAware = ExternalSystemUiUtil.getUiAware(this.a);
            this.d = externalSystemUiAware.getProjectRepresentationName(externalSystemRunConfiguration.getSettings().getExternalProjectPath(), null);
            String string = ExternalSystemKeymapExtension.getActionPrefix(project2, externalSystemRunConfiguration.getSettings().getExternalProjectPath());
            this.b = string + runnerAndConfigurationSettings.getName();
            Presentation presentation = this.getTemplatePresentation();
            presentation.setText(this.c.getName(), false);
            presentation.setIcon(externalSystemRunConfiguration.getIcon());
        }

        @Override
        protected boolean isEnabled(AnActionEvent anActionEvent) {
            return this.hasProject(anActionEvent);
        }

        public void actionPerformed(@NotNull AnActionEvent anActionEvent) {
            if (anActionEvent == null) {
                ExternalSystemRunConfigurationAction.b(0);
            }
            ProgramRunnerUtil.executeConfiguration((RunnerAndConfigurationSettings)this.c, (Executor)DefaultRunExecutor.getRunExecutorInstance());
        }

        public String toString() {
            return this.c.toString();
        }

        @Override
        public String getGroup() {
            return this.d;
        }

        @Override
        public ProjectSystemId getSystemId() {
            return this.a;
        }

        @Override
        public String getId() {
            return this.b;
        }

        private static /* synthetic */ void b(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/externalSystem/service/project/manage/ExternalSystemKeymapExtension$ExternalSystemRunConfigurationAction", "actionPerformed"));
        }
    }

    private static class ExternalSystemTaskAction
    extends MyExternalSystemAction {
        private final String b;
        private final String a;
        private final TaskData c;

        public ExternalSystemTaskAction(Project project2, String string, TaskData taskData) {
            this.a = string;
            this.c = taskData;
            this.b = ExternalSystemKeymapExtension.getActionPrefix(project2, taskData.getLinkedExternalProjectPath()) + taskData.getName();
            Presentation presentation = this.getTemplatePresentation();
            presentation.setText(this.c.getName() + " (" + string + ")", false);
            presentation.setDescription(this.c.getOwner().getReadableName() + " task action");
            presentation.setIcon(ExternalSystemIcons.Task);
        }

        @Override
        protected boolean isEnabled(AnActionEvent anActionEvent) {
            return this.hasProject(anActionEvent);
        }

        public void actionPerformed(@NotNull AnActionEvent anActionEvent) {
            if (anActionEvent == null) {
                ExternalSystemTaskAction.b(0);
            }
            ExternalTaskExecutionInfo externalTaskExecutionInfo = ExternalSystemActionUtil.buildTaskInfo(this.c);
            ExternalSystemUtil.runTask(externalTaskExecutionInfo.getSettings(), externalTaskExecutionInfo.getExecutorId(), this.getProject(anActionEvent), this.c.getOwner());
        }

        public TaskData getTaskData() {
            return this.c;
        }

        public String toString() {
            return this.c.toString();
        }

        @Override
        public String getGroup() {
            return this.a;
        }

        @Override
        public ProjectSystemId getSystemId() {
            return this.c.getOwner();
        }

        @Override
        public String getId() {
            return this.b;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof ExternalSystemTaskAction)) {
                return false;
            }
            ExternalSystemTaskAction externalSystemTaskAction = (ExternalSystemTaskAction)((Object)object);
            if (this.b != null ? !this.b.equals(externalSystemTaskAction.b) : externalSystemTaskAction.b != null) {
                return false;
            }
            if (this.a != null ? !this.a.equals(externalSystemTaskAction.a) : externalSystemTaskAction.a != null) {
                return false;
            }
            return this.c.equals((Object)externalSystemTaskAction.c);
        }

        public int hashCode() {
            int n2 = this.b != null ? this.b.hashCode() : 0;
            n2 = 31 * n2 + (this.a != null ? this.a.hashCode() : 0);
            n2 = 31 * n2 + this.c.hashCode();
            return n2;
        }

        private static /* synthetic */ void b(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/externalSystem/service/project/manage/ExternalSystemKeymapExtension$ExternalSystemTaskAction", "actionPerformed"));
        }
    }

    private static abstract class MyExternalSystemAction
    extends ExternalSystemAction {
        private MyExternalSystemAction() {
        }

        public abstract String getId();

        public abstract String getGroup();

        public abstract ProjectSystemId getSystemId();
    }

    public static interface ActionsProvider {
        public static final ExtensionPointName<ActionsProvider> EP_NAME = ExtensionPointName.create((String)"com.intellij.externalSystemKeymapProvider");

        public KeymapGroup createGroup(Condition<AnAction> var1, Project var2);
    }
}

