/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.task.TaskData;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalSystemKeymapExtension;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapManagerListener;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemShortcutsManager
implements Disposable {
    private static final String b = "ExternalSystem_";
    @NotNull
    private final Project c;
    private ExternalSystemKeyMapListener d;
    private final List<Listener> a;

    public ExternalSystemShortcutsManager(@NotNull Project project2) {
        if (project2 == null) {
            ExternalSystemShortcutsManager.a(0);
        }
        this.a = ContainerUtil.createLockFreeCopyOnWriteList();
        this.c = project2;
    }

    public void init() {
        this.d = new ExternalSystemKeyMapListener();
    }

    public String getActionId(@Nullable String string, @Nullable String string2) {
        StringBuilder stringBuilder = new StringBuilder(b);
        stringBuilder.append(this.c.getLocationHash());
        if (string != null) {
            String string3 = FileUtil.toSystemIndependentName((String)string);
            File file = new File(string3);
            stringBuilder.append(file.isFile() && file.getParentFile() != null ? file.getParentFile().getName() : file.getName());
            stringBuilder.append(Integer.toHexString(string3.hashCode()));
            if (string2 != null) {
                stringBuilder.append(string2);
            }
        }
        return stringBuilder.toString();
    }

    public String getDescription(@Nullable String string, @Nullable String string2) {
        Shortcut[] shortcutArray = this.a(string, string2);
        if (shortcutArray.length == 0) {
            return "";
        }
        return KeymapUtil.getShortcutsText((Shortcut[])shortcutArray);
    }

    public boolean hasShortcuts(@Nullable String string, @Nullable String string2) {
        return this.a(string, string2).length > 0;
    }

    public boolean hasShortcuts(@NotNull String string) {
        Keymap keymap;
        if (string == null) {
            ExternalSystemShortcutsManager.a(1);
        }
        return (keymap = KeymapManager.getInstance().getActiveKeymap()).getShortcuts(string).length > 0;
    }

    @NotNull
    private Shortcut[] a(@Nullable String string, @Nullable String string2) {
        String string3 = this.getActionId(string, string2);
        if (string3 == null) {
            if (Shortcut.EMPTY_ARRAY == null) {
                ExternalSystemShortcutsManager.a(2);
            }
            return Shortcut.EMPTY_ARRAY;
        }
        Keymap keymap = KeymapManager.getInstance().getActiveKeymap();
        Shortcut[] shortcutArray = keymap.getShortcuts(string3);
        if (shortcutArray == null) {
            ExternalSystemShortcutsManager.a(3);
        }
        return shortcutArray;
    }

    private void a() {
        for (Listener listener : this.a) {
            listener.shortcutsUpdated();
        }
    }

    public void addListener(Listener listener) {
        this.a.add(listener);
    }

    public void scheduleKeymapUpdate(Collection<DataNode<TaskData>> collection) {
        ExternalSystemKeymapExtension.updateActions(this.c, collection);
    }

    public void scheduleRunConfigurationKeymapUpdate(@NotNull ProjectSystemId projectSystemId) {
        if (projectSystemId == null) {
            ExternalSystemShortcutsManager.a(4);
        }
        ExternalSystemKeymapExtension.updateRunConfigurationActions(this.c, projectSystemId);
    }

    public void dispose() {
        if (this.d != null) {
            this.d.a();
        }
        ExternalSystemKeymapExtension.clearActions(this.c);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: 
            case 3: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionId";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/project/manage/ExternalSystemShortcutsManager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalSystemId";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/manage/ExternalSystemShortcutsManager";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortcuts";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "hasShortcuts";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "scheduleRunConfigurationKeymapUpdate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ExternalSystemKeyMapListener
    implements KeymapManagerListener,
    Keymap.Listener {
        private Keymap a;

        private ExternalSystemKeyMapListener() {
            KeymapManager keymapManager = KeymapManager.getInstance();
            if (keymapManager != null) {
                this.a(keymapManager.getActiveKeymap());
                keymapManager.addKeymapManagerListener((KeymapManagerListener)this, (Disposable)ExternalSystemShortcutsManager.this);
            }
        }

        public void activeKeymapChanged(Keymap keymap) {
            this.a(keymap);
            ExternalSystemShortcutsManager.this.a();
        }

        private void a(Keymap keymap) {
            if (this.a != null) {
                this.a.removeShortcutChangeListener((Keymap.Listener)this);
            }
            this.a = keymap;
            if (this.a != null) {
                this.a.addShortcutChangeListener((Keymap.Listener)this);
            }
        }

        public void onShortcutChanged(String string) {
            ExternalSystemShortcutsManager.this.a();
        }

        private void a() {
            this.a(null);
        }
    }

    public static interface Listener {
        public void shortcutsUpdated();
    }
}

