/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.LibraryData;
import com.intellij.openapi.externalSystem.model.project.LibraryPathType;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.ExternalLibraryPathTypeMapper;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.IdeUIModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemConstants;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Order(value=-2147483646)
public class LibraryDataService
extends AbstractProjectDataService<LibraryData, Library> {
    private static final Logger b = Logger.getInstance(LibraryDataService.class);
    @NotNull
    public static final NotNullFunction<String, File> PATH_TO_FILE = string -> new File((String)string);
    @NotNull
    private final ExternalLibraryPathTypeMapper a;

    public LibraryDataService(@NotNull ExternalLibraryPathTypeMapper externalLibraryPathTypeMapper) {
        if (externalLibraryPathTypeMapper == null) {
            LibraryDataService.a(0);
        }
        this.a = externalLibraryPathTypeMapper;
    }

    @NotNull
    public Key<LibraryData> getTargetDataKey() {
        Key key = ProjectKeys.LIBRARY;
        if (key == null) {
            LibraryDataService.a(1);
        }
        return key;
    }

    public void importData(@NotNull Collection<DataNode<LibraryData>> collection, @Nullable ProjectData projectData, @NotNull Project project2, @NotNull IdeModifiableModelsProvider ideModifiableModelsProvider) {
        if (collection == null) {
            LibraryDataService.a(2);
        }
        if (project2 == null) {
            LibraryDataService.a(3);
        }
        if (ideModifiableModelsProvider == null) {
            LibraryDataService.a(4);
        }
        for (DataNode<LibraryData> dataNode : collection) {
            this.a((LibraryData)dataNode.getData(), ideModifiableModelsProvider);
        }
    }

    private void a(@NotNull LibraryData libraryData, @NotNull IdeModifiableModelsProvider ideModifiableModelsProvider) {
        if (libraryData == null) {
            LibraryDataService.a(5);
        }
        if (ideModifiableModelsProvider == null) {
            LibraryDataService.a(6);
        }
        Map<OrderRootType, Collection<File>> map = this.prepareLibraryFiles(libraryData);
        String string = libraryData.getInternalName();
        Library library = ideModifiableModelsProvider.getLibraryByName(string);
        if (library != null) {
            this.a(libraryData, library, ideModifiableModelsProvider);
            return;
        }
        library = ideModifiableModelsProvider.createLibrary(string, ExternalSystemApiUtil.toExternalSource((ProjectSystemId)libraryData.getOwner()));
        Library.ModifiableModel modifiableModel = ideModifiableModelsProvider.getModifiableLibraryModel(library);
        LibraryDataService.registerPaths(libraryData.isUnresolved(), map, modifiableModel, string);
    }

    @NotNull
    public Map<OrderRootType, Collection<File>> prepareLibraryFiles(@NotNull LibraryData libraryData) {
        if (libraryData == null) {
            LibraryDataService.a(7);
        }
        HashMap hashMap = ContainerUtilRt.newHashMap();
        for (LibraryPathType libraryPathType : LibraryPathType.values()) {
            Set set = libraryData.getPaths(libraryPathType);
            if (set.isEmpty()) continue;
            hashMap.put(this.a.map(libraryPathType), ContainerUtil.map((Collection)set, PATH_TO_FILE));
        }
        HashMap hashMap2 = hashMap;
        if (hashMap2 == null) {
            LibraryDataService.a(8);
        }
        return hashMap2;
    }

    static void registerPaths(boolean bl2, @NotNull Map<OrderRootType, Collection<File>> map, @NotNull Library.ModifiableModel modifiableModel, @NotNull String string) {
        if (map == null) {
            LibraryDataService.a(9);
        }
        if (modifiableModel == null) {
            LibraryDataService.a(10);
        }
        if (string == null) {
            LibraryDataService.a(11);
        }
        for (Map.Entry<OrderRootType, Collection<File>> entry : map.entrySet()) {
            for (File file : entry.getValue()) {
                Object[] objectArray;
                VirtualFile[] virtualFileArray;
                VirtualFile virtualFile;
                VirtualFile virtualFile2 = virtualFile = bl2 ? null : ExternalSystemUtil.refreshAndFindFileByIoFile(file);
                if (virtualFile == null) {
                    if (!bl2 && ExternalSystemConstants.VERBOSE_PROCESSING && entry.getKey() == OrderRootType.CLASSES) {
                        b.warn(String.format("Can't find %s of the library '%s' at path '%s'", entry.getKey(), string, file.getAbsolutePath()));
                    }
                    if (ArrayUtil.contains((String)(virtualFileArray = VfsUtil.getUrlForLibraryRoot((File)file)), (String[])(objectArray = modifiableModel.getUrls(entry.getKey())))) continue;
                    modifiableModel.addRoot((String)virtualFileArray, entry.getKey());
                    continue;
                }
                if (virtualFile.isDirectory()) {
                    virtualFileArray = modifiableModel.getFiles(entry.getKey());
                    if (ArrayUtil.contains((Object)virtualFile, (Object[])virtualFileArray)) continue;
                    modifiableModel.addRoot(virtualFile, entry.getKey());
                    continue;
                }
                virtualFileArray = virtualFile;
                if (virtualFile.getFileType() instanceof ArchiveFileType && (virtualFileArray = JarFileSystem.getInstance().getJarRootForLocalFile(virtualFile)) == null) {
                    b.warn(String.format("Can't parse contents of the JAR file at path '%s' for the library '%s''", file.getAbsolutePath(), string));
                    continue;
                }
                objectArray = modifiableModel.getFiles(entry.getKey());
                if (ArrayUtil.contains((Object)virtualFileArray, (Object[])objectArray)) continue;
                modifiableModel.addRoot((VirtualFile)virtualFileArray, entry.getKey());
            }
        }
    }

    public void postProcess(@NotNull Collection<DataNode<LibraryData>> collection, @Nullable ProjectData projectData, @NotNull Project project2, @NotNull IdeModifiableModelsProvider ideModifiableModelsProvider) {
        if (collection == null) {
            LibraryDataService.a(12);
        }
        if (project2 == null) {
            LibraryDataService.a(13);
        }
        if (ideModifiableModelsProvider == null) {
            LibraryDataService.a(14);
        }
        if (projectData == null) {
            return;
        }
        if (ideModifiableModelsProvider instanceof IdeUIModifiableModelsProvider) {
            return;
        }
        List list2 = ContainerUtil.newSmartList();
        LibraryTable.ModifiableModel modifiableModel = ideModifiableModelsProvider.getModifiableProjectLibrariesModel();
        final HashMap hashMap = ContainerUtil.newHashMap();
        final HashSet hashSet = ContainerUtil.newHashSet();
        RootPolicy<Void> rootPolicy = new RootPolicy<Void>(){

            public Void visitLibraryOrderEntry(@NotNull LibraryOrderEntry libraryOrderEntry, Void void_) {
                if (libraryOrderEntry == null) {
                    1.a(0);
                }
                if (libraryOrderEntry.isModuleLevel()) {
                    return null;
                }
                Library library = libraryOrderEntry.getLibrary();
                if (library == null) {
                    library = (Library)hashMap.get(libraryOrderEntry.getLibraryName());
                }
                if (library != null) {
                    hashSet.remove(library);
                }
                return null;
            }

            private static /* synthetic */ void a(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideDependency", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDataService$1", "visitLibraryOrderEntry"));
            }
        };
        for (Library library2 : modifiableModel.getLibraries()) {
            if (!ExternalSystemApiUtil.isExternalSystemLibrary((Library)library2, (ProjectSystemId)projectData.getOwner())) continue;
            hashMap.put(library2.getName(), library2);
            hashSet.add(library2);
        }
        for (Library library : ideModifiableModelsProvider.getModules()) {
            for (OrderEntry orderEntry : ideModifiableModelsProvider.getOrderEntries((Module)library)) {
                orderEntry.accept((RootPolicy)rootPolicy, null);
            }
        }
        for (Library library : hashSet) {
            if (ideModifiableModelsProvider.isSubstituted(library.getName())) continue;
            list2.add(library);
        }
        for (Library library : list2) {
            Library library2;
            String string = library.getName();
            if (string == null || (library2 = modifiableModel.getLibraryByName(string)) == null) continue;
            modifiableModel.removeLibrary(library2);
        }
    }

    private void a(@NotNull LibraryData libraryData, @NotNull Library library, @NotNull IdeModifiableModelsProvider ideModifiableModelsProvider) {
        if (libraryData == null) {
            LibraryDataService.a(15);
        }
        if (library == null) {
            LibraryDataService.a(16);
        }
        if (ideModifiableModelsProvider == null) {
            LibraryDataService.a(17);
        }
        if (libraryData.isUnresolved()) {
            return;
        }
        HashMap hashMap = ContainerUtilRt.newHashMap();
        HashMap hashMap2 = ContainerUtilRt.newHashMap();
        for (Object object : LibraryPathType.values()) {
            Object object2 = this.a.map((LibraryPathType)object);
            HashSet hashSet = ContainerUtilRt.newHashSet((Iterable)libraryData.getPaths((LibraryPathType)object));
            hashMap2.put(object2, hashSet);
            HashSet hashSet2 = ContainerUtilRt.newHashSet();
            hashMap.put(object2, hashSet2);
            for (VirtualFile virtualFile : library.getFiles(object2)) {
                String string = ExternalSystemApiUtil.getLocalFileSystemPath((VirtualFile)virtualFile);
                if (hashSet.remove(string)) continue;
                hashSet2.add(virtualFile.getUrl());
            }
        }
        if (hashMap.isEmpty() && hashMap2.isEmpty()) {
            return;
        }
        Library.ModifiableModel modifiableModel = ideModifiableModelsProvider.getModifiableLibraryModel(library);
        for (Map.Entry entry : hashMap.entrySet()) {
            for (Object object2 : (Set)entry.getValue()) {
                modifiableModel.removeRoot((String)object2, (OrderRootType)entry.getKey());
            }
        }
        for (Map.Entry entry : hashMap2.entrySet()) {
            Object object;
            object = ContainerUtilRt.newHashMap();
            object.put(entry.getKey(), ContainerUtil.map((Collection)((Collection)entry.getValue()), PATH_TO_FILE));
            LibraryDataService.registerPaths(libraryData.isUnresolved(), (Map<OrderRootType, Collection<File>>)object, modifiableModel, libraryData.getInternalName());
        }
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 8: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapper";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/project/manage/LibraryDataService";
                break;
            }
            case 2: 
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toImport";
                break;
            }
            case 3: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 6: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelsProvider";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryFiles";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryName";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalLibrary";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideLibrary";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/manage/LibraryDataService";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetDataKey";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareLibraryFiles";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 8: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "importData";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "importLibrary";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "prepareLibraryFiles";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "registerPaths";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "postProcess";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "syncPaths";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

