/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.task;

import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalTaskPojo;
import com.intellij.openapi.externalSystem.model.project.ExternalConfigPathAware;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.task.TaskData;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalSystemKeymapExtension;
import com.intellij.openapi.externalSystem.service.task.AbstractToolWindowService;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemLocalSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.project.Project;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

@Order(value=-2147483644)
public class ToolWindowTaskService
extends AbstractToolWindowService<TaskData> {
    @NotNull
    public static final Function<DataNode<TaskData>, ExternalTaskPojo> MAPPER = dataNode -> ExternalTaskPojo.from((TaskData)((TaskData)dataNode.getData()));
    public static final NullableFunction<DataNode<TaskData>, ExternalConfigPathAware> TASK_HOLDER_RETRIEVAL_STRATEGY = dataNode -> {
        ModuleData moduleData = (ModuleData)dataNode.getData(ProjectKeys.MODULE);
        return moduleData == null ? (ExternalConfigPathAware)dataNode.getData(ProjectKeys.PROJECT) : moduleData;
    };

    @NotNull
    public Key<TaskData> getTargetDataKey() {
        Key key = ProjectKeys.TASK;
        if (key == null) {
            ToolWindowTaskService.b(0);
        }
        return key;
    }

    @Override
    protected void processData(@NotNull Collection<DataNode<TaskData>> collection, @NotNull Project project2) {
        Object object2;
        if (collection == null) {
            ToolWindowTaskService.b(1);
        }
        if (project2 == null) {
            ToolWindowTaskService.b(2);
        }
        if (collection.isEmpty()) {
            return;
        }
        ProjectSystemId projectSystemId = ((TaskData)collection.iterator().next().getData()).getOwner();
        ExternalSystemManager externalSystemManager = ExternalSystemApiUtil.getManager((ProjectSystemId)projectSystemId);
        assert (externalSystemManager != null);
        ExternalSystemKeymapExtension.updateActions(project2, collection);
        MultiMap multiMap = ContainerUtil.groupBy(collection, TASK_HOLDER_RETRIEVAL_STRATEGY);
        HashMap hashMap = ContainerUtilRt.newHashMap();
        for (Object object2 : multiMap.entrySet()) {
            hashMap.put(((ExternalConfigPathAware)object2.getKey()).getLinkedExternalProjectPath(), ContainerUtilRt.map2List((Collection)((Collection)object2.getValue()), MAPPER));
        }
        AbstractExternalSystemLocalSettings abstractExternalSystemLocalSettings = (AbstractExternalSystemLocalSettings)externalSystemManager.getLocalSettingsProvider().fun((Object)project2);
        object2 = ContainerUtilRt.newHashMap((Map)abstractExternalSystemLocalSettings.getAvailableTasks());
        object2.putAll(hashMap);
        abstractExternalSystemLocalSettings.setAvailableTasks((Map)object2);
    }

    private static /* synthetic */ void b(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: 
            case 2: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/task/ToolWindowTaskService";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodes";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetDataKey";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/task/ToolWindowTaskService";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "processData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

