/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionToolbarPosition;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.externalSystem.ExternalSystemUiAware;
import com.intellij.openapi.externalSystem.importing.ExternalProjectStructureCustomizer;
import com.intellij.openapi.externalSystem.importing.ExternalProjectStructureCustomizerImpl;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.Identifiable;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ModuleDependencyData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataManagerImpl;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemUiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonUpdater;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.CheckboxTreeAdapter;
import com.intellij.ui.CheckboxTreeBase;
import com.intellij.ui.CheckboxTreeListener;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.ToggleActionButton;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.CachedValueImpl;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.tree.TreeUtil;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalProjectDataSelectorDialog
extends DialogWrapper {
    private static final int d = 50;
    private static final Set<? extends Key<?>> f = ContainerUtil.set((Object[])new Key[]{ProjectKeys.PROJECT, ProjectKeys.MODULE});
    private static final com.intellij.openapi.util.Key<DataNode> i = com.intellij.openapi.util.Key.create((String)"modifiedData");
    private static final com.intellij.openapi.util.Key<DataNodeCheckedTreeNode> g = com.intellij.openapi.util.Key.create((String)"connectedUiNode");
    @NotNull
    private Project s;
    private JBLoadingPanel b;
    private JPanel t;
    private JPanel e;
    private JBLabel u;
    private JBLabel m;
    private ExternalSystemUiAware o;
    private ExternalProjectInfo n;
    private final Set<Key<?>> c;
    private final Set<Key<?>> j;
    private final Set<Key<? extends Identifiable>> v;
    @Nullable
    private final Object q;
    private CheckboxTree r;
    private final MultiMap<DataNode<Identifiable>, DataNode<Identifiable>> l;
    private final SimpleModificationTracker h;
    private final CachedValue<SelectionState> p;
    private boolean k;
    private int a;

    public ExternalProjectDataSelectorDialog(@NotNull Project project2, @NotNull ExternalProjectInfo externalProjectInfo) {
        if (project2 == null) {
            ExternalProjectDataSelectorDialog.a(0);
        }
        if (externalProjectInfo == null) {
            ExternalProjectDataSelectorDialog.a(1);
        }
        this(project2, externalProjectInfo, null);
    }

    public ExternalProjectDataSelectorDialog(@NotNull Project project2, @NotNull ExternalProjectInfo externalProjectInfo, @Nullable Object object) {
        if (project2 == null) {
            ExternalProjectDataSelectorDialog.a(2);
        }
        if (externalProjectInfo == null) {
            ExternalProjectDataSelectorDialog.a(3);
        }
        super(project2, true);
        this.i();
        this.l = MultiMap.create((TObjectHashingStrategy)TObjectHashingStrategy.IDENTITY);
        this.h = new SimpleModificationTracker();
        this.p = new CachedValueImpl(() -> CachedValueProvider.Result.createSingleDependency((Object)this.g(), (Object)this.h));
        this.s = project2;
        this.c = ExternalProjectDataSelectorDialog.c();
        this.j = ExternalProjectDataSelectorDialog.f();
        this.v = ExternalProjectDataSelectorDialog.j();
        this.q = object;
        this.a(externalProjectInfo);
    }

    private void a(@NotNull ExternalProjectInfo externalProjectInfo) {
        if (externalProjectInfo == null) {
            ExternalProjectDataSelectorDialog.a(4);
        }
        ProjectDataManagerImpl.getInstance().ensureTheDataIsReadyToUse(externalProjectInfo.getExternalProjectStructure());
        this.n = externalProjectInfo;
        this.o = ExternalSystemUiUtil.getUiAware(this.n.getProjectSystemId());
        this.r = this.b();
        this.a();
        this.r.addCheckboxTreeListener((CheckboxTreeListener)new CheckboxTreeAdapter(){

            public void nodeStateChanged(@NotNull CheckedTreeNode checkedTreeNode) {
                if (checkedTreeNode == null) {
                    1.a(0);
                }
                ExternalProjectDataSelectorDialog.this.a();
            }

            private static /* synthetic */ void a(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/openapi/externalSystem/service/ui/ExternalProjectDataSelectorDialog$1", "nodeStateChanged"));
            }
        });
        String string = this.n.getProjectSystemId().getReadableName();
        this.setTitle(String.format("%s Project Data To Import", string));
        this.init();
    }

    public boolean hasMultipleDataToSelect() {
        Object object = this.r.getModel().getRoot();
        if (object instanceof CheckedTreeNode && ((CheckedTreeNode)object).getChildCount() == 1) {
            return false;
        }
        return this.a > 1;
    }

    private void a() {
        this.h.incModificationCount();
        this.m.setText(((SelectionState)this.p.getValue()).message);
    }

    @Nullable
    protected JComponent createCenterPanel() {
        ToolbarDecorator toolbarDecorator = ToolbarDecorator.createDecorator((JTree)this.r).addExtraAction((AnActionButton)new SelectAllButton()).addExtraAction((AnActionButton)new UnselectAllButton()).addExtraAction((AnActionButton)new ShowSelectedOnlyButton()).addExtraAction((AnActionButton)new SelectRequiredButton()).setToolbarPosition(ActionToolbarPosition.BOTTOM).setToolbarBorder((Border)JBUI.Borders.empty());
        this.e.add(toolbarDecorator.createPanel());
        this.b = new JBLoadingPanel((LayoutManager)new BorderLayout(), this.getDisposable());
        this.b.add((Component)this.t, (Object)"Center");
        return this.b;
    }

    private void d() {
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.r.getModel();
        Object object = defaultTreeModel.getRoot();
        if (!(object instanceof CheckedTreeNode)) {
            return;
        }
        CheckedTreeNode checkedTreeNode = (CheckedTreeNode)object;
        Couple<CheckedTreeNode> couple = this.e();
        CheckedTreeNode checkedTreeNode2 = (CheckedTreeNode)couple.first;
        List list2 = TreeUtil.listChildren((TreeNode)checkedTreeNode2);
        checkedTreeNode.removeAllChildren();
        TreeUtil.addChildrenTo((MutableTreeNode)checkedTreeNode, (List)list2);
        defaultTreeModel.reload();
    }

    protected void doOKAction() {
        this.b.setLoadingText("Please wait...");
        this.b.startLoading();
        final DataNode dataNode2 = this.n.getExternalProjectStructure();
        if (dataNode2 != null) {
            boolean[] blArray = new boolean[]{false};
            ExternalSystemApiUtil.visit((DataNode)dataNode2, dataNode -> {
                DataNode dataNode2 = (DataNode)dataNode.getUserData(i);
                if (dataNode2 != null) {
                    if (dataNode.isIgnored() != dataNode2.isIgnored()) {
                        dataNode.setIgnored(dataNode2.isIgnored());
                        blArray[0] = true;
                    }
                    dataNode.removeUserData(i);
                    dataNode.removeUserData(g);
                }
            });
            if (blArray[0]) {
                DataNode dataNode3 = (DataNode)ContainerUtil.find((Iterable)dataNode2.getChildren(), dataNode -> !dataNode.isIgnored());
                dataNode2.setIgnored(dataNode3 == null);
                ExternalSystemUtil.invokeLater(this.s, ModalityState.NON_MODAL, () -> {
                    ProjectData projectData = (ProjectData)dataNode2.getData();
                    String string = ExternalSystemBundle.message((String)"progress.refresh.text", (Object[])new Object[]{projectData.getExternalName(), projectData.getOwner().getReadableName()});
                    new Task.Backgroundable(this.s, string, true, PerformInBackgroundOption.DEAF){

                        public void run(@NotNull ProgressIndicator progressIndicator) {
                            if (progressIndicator == null) {
                                2.a(0);
                            }
                            ((ProjectDataManager)ServiceManager.getService(ProjectDataManager.class)).importData(dataNode2, this.myProject, false);
                        }

                        private static /* synthetic */ void a(int n2) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/externalSystem/service/ui/ExternalProjectDataSelectorDialog$2", "run"));
                        }
                    }.queue();
                });
            }
        }
        super.doOKAction();
    }

    public void doCancelAction() {
        ExternalSystemApiUtil.visit((DataNode)this.n.getExternalProjectStructure(), dataNode -> {
            dataNode.removeUserData(i);
            dataNode.removeUserData(g);
        });
        super.doCancelAction();
    }

    private CheckboxTree b() {
        Couple<CheckedTreeNode> couple = this.e();
        CheckedTreeNode checkedTreeNode = (CheckedTreeNode)couple.first;
        CheckboxTree checkboxTree = new CheckboxTree(new CheckboxTree.CheckboxTreeCellRenderer(true, false){

            public void customizeRenderer(JTree jTree, Object object, boolean bl2, boolean bl3, boolean bl4, int n2, boolean bl5) {
                Object object2;
                Enumeration enumeration;
                if (!(object instanceof DataNodeCheckedTreeNode)) {
                    return;
                }
                DataNodeCheckedTreeNode dataNodeCheckedTreeNode = (DataNodeCheckedTreeNode)((Object)object);
                String string = null;
                boolean bl6 = false;
                if (dataNodeCheckedTreeNode.isChecked()) {
                    enumeration = dataNodeCheckedTreeNode.children();
                    while (enumeration.hasMoreElements()) {
                        object2 = enumeration.nextElement();
                        if (!(object2 instanceof DataNodeCheckedTreeNode) || ((DataNodeCheckedTreeNode)((Object)object2)).isChecked()) continue;
                        this.myCheckbox.setEnabled(false);
                        break;
                    }
                    if (ExternalProjectDataSelectorDialog.this.v.contains(dataNodeCheckedTreeNode.d.getKey()) && StringUtil.isNotEmpty(object2 = StringUtil.join((Collection)ExternalProjectDataSelectorDialog.this.l.get((Object)dataNodeCheckedTreeNode.d), dataNode -> {
                        DataNodeCheckedTreeNode dataNodeCheckedTreeNode = (DataNodeCheckedTreeNode)((Object)((Object)dataNode.getUserData(g)));
                        return dataNodeCheckedTreeNode != null && !dataNodeCheckedTreeNode.isChecked() ? ((Identifiable)dataNode.getData()).getId() : null;
                    }, (String)"<br>"))) {
                        bl6 = true;
                        string = "There are not selected module dependencies of the module: <br><b>" + object2 + "</b>";
                    }
                }
                enumeration = this.getTextRenderer();
                enumeration.setIcon(dataNodeCheckedTreeNode.a);
                enumeration.append(dataNodeCheckedTreeNode.c, bl6 ? SimpleTextAttributes.ERROR_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES);
                if (!StringUtil.isEmptyOrSpaces((String)dataNodeCheckedTreeNode.b)) {
                    object2 = dataNodeCheckedTreeNode.b;
                    if (dataNodeCheckedTreeNode.b.length() > 50) {
                        object2 = dataNodeCheckedTreeNode.b.substring(0, 50) + "...";
                    }
                    enumeration.append(" (" + object2 + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
                    this.setToolTipText(StringUtil.isEmpty((String)string) ? dataNodeCheckedTreeNode.b : string);
                } else {
                    this.setToolTipText(StringUtil.isNotEmpty(string) ? string : null);
                }
            }
        }, checkedTreeNode, new CheckboxTreeBase.CheckPolicy(true, true, false, false));
        TreeUtil.expand((JTree)checkboxTree, (int)1);
        if (couple.second != null) {
            TreeUtil.selectNode((JTree)checkboxTree, (TreeNode)((TreeNode)couple.second));
        } else {
            checkboxTree.setSelectionRow(0);
        }
        return checkboxTree;
    }

    private Couple<CheckedTreeNode> e() {
        Object object;
        Object object2;
        Object object32;
        Object object42;
        THashMap tHashMap = ContainerUtil.newIdentityTroveMap();
        DataNodeCheckedTreeNode[] dataNodeCheckedTreeNodeArray = new DataNodeCheckedTreeNode[]{null};
        DataNodeCheckedTreeNode[] dataNodeCheckedTreeNodeArray2 = new DataNodeCheckedTreeNode[]{null};
        MultiMap multiMap = MultiMap.create();
        HashMap hashMap = ContainerUtil.newHashMap();
        for (Object object42 : ExternalSystemApiUtil.findAllRecursively((DataNode)this.n.getExternalProjectStructure(), (Key)ProjectKeys.MODULE_DEPENDENCY)) {
            object32 = (ModuleDependencyData)object42.getData();
            multiMap.putValue((Object)object32.getOwnerModule().getId(), (Object)((ModuleData)object32.getTarget()).getId());
        }
        Object object5 = new int[]{0};
        ExternalSystemApiUtil.visit((DataNode)this.n.getExternalProjectStructure(), arg_0 -> this.a((int[])object5, (Map)tHashMap, hashMap, dataNodeCheckedTreeNodeArray, dataNodeCheckedTreeNodeArray2, arg_0));
        this.a = (int)object5[0];
        this.l.clear();
        for (Object object32 : multiMap.keySet()) {
            object2 = multiMap.get(object32);
            object = (DataNode)hashMap.get(object32);
            if (object == null) continue;
            this.l.putValues(object, (Collection)ContainerUtil.mapNotNull((Collection)object2, hashMap::get));
        }
        object42 = new CheckedTreeNode(null);
        object32 = (DataNodeCheckedTreeNode)((Object)tHashMap.get(this.n.getExternalProjectStructure()));
        object2 = "root module";
        if (dataNodeCheckedTreeNodeArray2[0] != null && object32 != null) {
            dataNodeCheckedTreeNodeArray2[0].b = (String)object2;
            if (!object32.isNodeChild((TreeNode)((Object)dataNodeCheckedTreeNodeArray2[0]))) {
                object32.add((MutableTreeNode)((Object)dataNodeCheckedTreeNodeArray2[0]));
            }
        }
        object = object32 != null ? TreeUtil.listChildren((TreeNode)object32) : ContainerUtil.emptyList();
        Collections.sort(object, (arg_0, arg_1) -> ExternalProjectDataSelectorDialog.a((String)object2, arg_0, arg_1));
        TreeUtil.addChildrenTo((MutableTreeNode)object42, (List)object);
        return Couple.of((Object)object42, (Object)((Object)dataNodeCheckedTreeNodeArray[0]));
    }

    @NotNull
    private static Set<Key<?>> f() {
        HashSet hashSet = ContainerUtil.newHashSet(f);
        for (ExternalProjectStructureCustomizer externalProjectStructureCustomizer : (ExternalProjectStructureCustomizer[])ExternalProjectStructureCustomizer.EP_NAME.getExtensions()) {
            hashSet.addAll(externalProjectStructureCustomizer.getPublicDataKeys());
        }
        HashSet hashSet2 = hashSet;
        if (hashSet2 == null) {
            ExternalProjectDataSelectorDialog.a(5);
        }
        return hashSet2;
    }

    @NotNull
    private static Set<Key<?>> c() {
        HashSet hashSet = ContainerUtil.newHashSet(f);
        for (ExternalProjectStructureCustomizer externalProjectStructureCustomizer : (ExternalProjectStructureCustomizer[])ExternalProjectStructureCustomizer.EP_NAME.getExtensions()) {
            hashSet.addAll(externalProjectStructureCustomizer.getIgnorableDataKeys());
        }
        HashSet hashSet2 = hashSet;
        if (hashSet2 == null) {
            ExternalProjectDataSelectorDialog.a(6);
        }
        return hashSet2;
    }

    @NotNull
    private static Set<Key<? extends Identifiable>> j() {
        HashSet hashSet = ContainerUtil.newHashSet();
        hashSet.add(ProjectKeys.MODULE);
        for (ExternalProjectStructureCustomizer externalProjectStructureCustomizer : (ExternalProjectStructureCustomizer[])ExternalProjectStructureCustomizer.EP_NAME.getExtensions()) {
            hashSet.addAll(externalProjectStructureCustomizer.getDependencyAwareDataKeys());
        }
        HashSet hashSet2 = hashSet;
        if (hashSet2 == null) {
            ExternalProjectDataSelectorDialog.a(7);
        }
        return hashSet2;
    }

    @NotNull
    private static DataNode d(@NotNull DataNode dataNode) {
        DataNode dataNode2;
        if (dataNode == null) {
            ExternalProjectDataSelectorDialog.a(8);
        }
        if ((dataNode2 = (DataNode)dataNode.getUserData(i)) == null) {
            dataNode2 = dataNode.nodeCopy();
            dataNode.putUserData(i, (Object)dataNode2);
        }
        DataNode dataNode3 = dataNode2;
        if (dataNode3 == null) {
            ExternalProjectDataSelectorDialog.a(9);
        }
        return dataNode3;
    }

    private SelectionState g() {
        boolean bl2 = this.k();
        String string = "";
        Object object2 = this.r.getModel().getRoot();
        if (object2 instanceof CheckedTreeNode) {
            int[] nArray = new int[]{0};
            TreeUtil.traverse((TreeNode)((CheckedTreeNode)object2), object -> {
                if (object instanceof DataNodeCheckedTreeNode && ((DataNodeCheckedTreeNode)((Object)((Object)object))).isChecked() && this.v.contains(((DataNodeCheckedTreeNode)((Object)((Object)object))).d.getKey())) {
                    nArray[0] = nArray[0] + 1;
                }
                return true;
            });
            string = String.format("%1$d Modules. %2$d selected", this.a, nArray[0]);
        }
        return new SelectionState(bl2, string);
    }

    private boolean k() {
        for (DataNode dataNode : this.l.keySet()) {
            DataNodeCheckedTreeNode dataNodeCheckedTreeNode = (DataNodeCheckedTreeNode)((Object)dataNode.getUserData(g));
            assert (dataNodeCheckedTreeNode != null);
            if (!dataNodeCheckedTreeNode.isChecked()) continue;
            for (DataNode dataNode2 : this.l.get((Object)dataNode)) {
                DataNodeCheckedTreeNode dataNodeCheckedTreeNode2 = (DataNodeCheckedTreeNode)((Object)dataNode2.getUserData(g));
                assert (dataNodeCheckedTreeNode2 != null);
                if (dataNodeCheckedTreeNode2.isChecked()) continue;
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ int a(String string, TreeNode treeNode, TreeNode treeNode2) {
        if (treeNode instanceof DataNodeCheckedTreeNode && treeNode2 instanceof DataNodeCheckedTreeNode) {
            if (string.equals(((DataNodeCheckedTreeNode)((Object)treeNode)).b)) {
                return -1;
            }
            if (string.equals(((DataNodeCheckedTreeNode)((Object)treeNode2)).b)) {
                return 1;
            }
            return StringUtil.naturalCompare((String)((DataNodeCheckedTreeNode)((Object)treeNode)).c, (String)((DataNodeCheckedTreeNode)((Object)treeNode2)).c);
        }
        return 0;
    }

    private /* synthetic */ void a(int[] nArray, Map map, Map map2, DataNodeCheckedTreeNode[] dataNodeCheckedTreeNodeArray, DataNodeCheckedTreeNode[] dataNodeCheckedTreeNodeArray2, DataNode dataNode) {
        Key key = dataNode.getKey();
        if (!this.j.contains(key)) {
            return;
        }
        DataNode dataNode2 = ExternalProjectDataSelectorDialog.d(dataNode);
        if (this.v.contains(key)) {
            nArray[0] = nArray[0] + 1;
        }
        if (dataNode2.isIgnored() && this.k) {
            return;
        }
        DataNodeCheckedTreeNode dataNodeCheckedTreeNode = (DataNodeCheckedTreeNode)((Object)map.get(dataNode));
        if (dataNodeCheckedTreeNode == null) {
            CheckedTreeNode checkedTreeNode;
            Identifiable identifiable;
            dataNodeCheckedTreeNode = new DataNodeCheckedTreeNode(dataNode);
            if (this.v.contains(key)) {
                identifiable = (Identifiable)dataNode.getData();
                map2.put(identifiable.getId(), dataNode);
            }
            if (this.q != null && this.q.equals(dataNode.getData())) {
                dataNodeCheckedTreeNodeArray[0] = dataNodeCheckedTreeNode;
            }
            if (dataNode.getData() instanceof ModuleData && key.equals((Object)ProjectKeys.MODULE) && this.n.getExternalProjectPath().equals(((ModuleData)dataNode.getData()).getLinkedExternalProjectPath())) {
                dataNodeCheckedTreeNodeArray2[0] = dataNodeCheckedTreeNode;
            }
            dataNodeCheckedTreeNode.setEnabled(this.c.contains(key));
            map.put(dataNode, dataNodeCheckedTreeNode);
            identifiable = dataNode.getParent();
            if (identifiable != null && (checkedTreeNode = (CheckedTreeNode)map.get(identifiable)) != null) {
                checkedTreeNode.add((MutableTreeNode)((Object)dataNodeCheckedTreeNode));
            }
        }
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectInfo";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/ui/ExternalProjectDataSelectorDialog";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/ui/ExternalProjectDataSelectorDialog";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPublicKeys";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getIgnorableKeys";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencyAwareDataKeys";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifiableDataNode";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getModifiableDataNode";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void i() {
        JBLabel jBLabel;
        JBLabel jBLabel2;
        JPanel jPanel;
        JPanel jPanel2;
        this.t = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(5, 5));
        ((Component)jPanel2).setEnabled(true);
        jPanel2.setMinimumSize(new Dimension(300, 100));
        jPanel2.setOpaque(false);
        jPanel2.setPreferredSize(new Dimension(400, 300));
        this.e = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel.setAutoscrolls(true);
        jPanel.setMinimumSize(new Dimension(0, 0));
        jPanel.setPreferredSize(new Dimension(0, 0));
        jPanel2.add((Component)jPanel, "Center");
        this.m = jBLabel2 = new JBLabel();
        jPanel.add((Component)jBLabel2, "South");
        this.u = jBLabel = new JBLabel();
        jBLabel.setText("Please select the modules/data to include in the project.");
        jPanel2.add((Component)jBLabel, "North");
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.t;
    }

    private class SelectRequiredButton
    extends AnActionButton {
        public SelectRequiredButton() {
            super("Select Required", "select modules depended on currently selected modules", AllIcons.Actions.IntentionBulb);
            this.addCustomUpdater(new AnActionButtonUpdater(){

                public boolean isEnabled(AnActionEvent anActionEvent) {
                    return ((SelectionState)((ExternalProjectDataSelectorDialog)ExternalProjectDataSelectorDialog.this).p.getValue()).isRequiredSelectionEnabled;
                }
            });
        }

        public void actionPerformed(AnActionEvent anActionEvent) {
            boolean bl2 = ExternalProjectDataSelectorDialog.this.k;
            if (bl2) {
                ExternalProjectDataSelectorDialog.this.k = false;
                ExternalProjectDataSelectorDialog.this.d();
            }
            ExternalProjectDataSelectorDialog.this.r.clearSelection();
            for (DataNode dataNode : ExternalProjectDataSelectorDialog.this.l.keySet()) {
                DataNodeCheckedTreeNode dataNodeCheckedTreeNode = (DataNodeCheckedTreeNode)((Object)dataNode.getUserData(g));
                assert (dataNodeCheckedTreeNode != null);
                if (!dataNodeCheckedTreeNode.isChecked()) continue;
                for (DataNode dataNode2 : ExternalProjectDataSelectorDialog.this.l.get((Object)dataNode)) {
                    DataNodeCheckedTreeNode dataNodeCheckedTreeNode2 = (DataNodeCheckedTreeNode)((Object)dataNode2.getUserData(g));
                    assert (dataNodeCheckedTreeNode2 != null);
                    ExternalProjectDataSelectorDialog.this.r.setNodeState((CheckedTreeNode)dataNodeCheckedTreeNode2, true);
                }
            }
            if (bl2) {
                ExternalProjectDataSelectorDialog.this.k = true;
                ExternalProjectDataSelectorDialog.this.d();
            }
            ExternalProjectDataSelectorDialog.this.a();
        }

        public boolean displayTextInToolbar() {
            return true;
        }
    }

    private class ShowSelectedOnlyButton
    extends ToggleActionButton {
        public ShowSelectedOnlyButton() {
            super("Show Selected Only", AllIcons.Actions.ShowHiddens);
        }

        public boolean isSelected(AnActionEvent anActionEvent) {
            return ExternalProjectDataSelectorDialog.this.k;
        }

        public void setSelected(AnActionEvent anActionEvent, boolean bl2) {
            ExternalProjectDataSelectorDialog.this.k = bl2;
            ExternalProjectDataSelectorDialog.this.d();
        }
    }

    private class UnselectAllButton
    extends AnActionButton {
        public UnselectAllButton() {
            super("Unselect All", AllIcons.Actions.Unselectall);
        }

        public void actionPerformed(AnActionEvent anActionEvent) {
            DefaultTreeModel defaultTreeModel = (DefaultTreeModel)ExternalProjectDataSelectorDialog.this.r.getModel();
            Object object = defaultTreeModel.getRoot();
            if (!(object instanceof CheckedTreeNode)) {
                return;
            }
            if (!ExternalProjectDataSelectorDialog.this.k) {
                ExternalProjectDataSelectorDialog.this.r.setNodeState((CheckedTreeNode)object, false);
            } else {
                ExternalProjectDataSelectorDialog.this.k = false;
                ExternalProjectDataSelectorDialog.this.d();
                ExternalProjectDataSelectorDialog.this.r.setNodeState((CheckedTreeNode)object, false);
                ExternalProjectDataSelectorDialog.this.k = true;
                ExternalProjectDataSelectorDialog.this.d();
            }
        }
    }

    private class SelectAllButton
    extends AnActionButton {
        public SelectAllButton() {
            super("Select All", AllIcons.Actions.Selectall);
        }

        public void actionPerformed(AnActionEvent anActionEvent) {
            DefaultTreeModel defaultTreeModel = (DefaultTreeModel)ExternalProjectDataSelectorDialog.this.r.getModel();
            Object object = defaultTreeModel.getRoot();
            if (!(object instanceof CheckedTreeNode)) {
                return;
            }
            if (!ExternalProjectDataSelectorDialog.this.k) {
                ExternalProjectDataSelectorDialog.this.r.setNodeState((CheckedTreeNode)object, true);
            } else {
                ExternalProjectDataSelectorDialog.this.k = false;
                ExternalProjectDataSelectorDialog.this.d();
                ExternalProjectDataSelectorDialog.this.r.setNodeState((CheckedTreeNode)object, true);
                ExternalProjectDataSelectorDialog.this.k = true;
            }
        }
    }

    private static class SelectionState {
        boolean isRequiredSelectionEnabled;
        @Nullable
        String message;

        public SelectionState(boolean bl2, @Nullable String string) {
            this.isRequiredSelectionEnabled = bl2;
            this.message = string;
        }
    }

    private class DataNodeCheckedTreeNode
    extends CheckedTreeNode {
        private final DataNode d;
        @Nullable
        private Icon a;
        private String c;
        @Nullable
        private String b;

        private DataNodeCheckedTreeNode(DataNode dataNode) {
            super((Object)dataNode);
            this.d = dataNode;
            dataNode.putUserData(g, (Object)this);
            DataNode dataNode2 = (DataNode)dataNode.getUserData(i);
            assert (dataNode2 != null);
            this.isChecked = !dataNode2.isIgnored();
            Icon icon = null;
            boolean bl2 = false;
            ExternalProjectStructureCustomizer externalProjectStructureCustomizer = new ExternalProjectStructureCustomizerImpl();
            for (ExternalProjectStructureCustomizer externalProjectStructureCustomizer2 : (Couple<String>)ExternalProjectStructureCustomizer.EP_NAME.getExtensions()) {
                Icon icon2 = externalProjectStructureCustomizer2.suggestIcon(dataNode, ExternalProjectDataSelectorDialog.this.o);
                if (!bl2 && icon2 != null) {
                    if (icon != null) {
                        bl2 = true;
                        icon = null;
                    } else {
                        icon = icon2;
                    }
                }
                if (!externalProjectStructureCustomizer2.getPublicDataKeys().contains(dataNode.getKey())) continue;
                externalProjectStructureCustomizer = externalProjectStructureCustomizer2;
                break;
            }
            this.a = icon != null ? icon : ((ExternalProjectStructureCustomizer)externalProjectStructureCustomizer).suggestIcon(dataNode, ExternalProjectDataSelectorDialog.this.o);
            Couple<String> couple = ((ExternalProjectStructureCustomizer)externalProjectStructureCustomizer).getRepresentationName(dataNode);
            this.c = (String)couple.first;
            this.b = (String)couple.second;
            if (this.c == null) {
                this.c = dataNode.getKey().toString();
            }
        }

        public void setChecked(final boolean bl2) {
            DataNode dataNode2;
            TreePath[] treePathArray;
            Object object;
            super.setChecked(bl2);
            if (bl2) {
                object = this;
                treePathArray = null;
                while (((DataNodeCheckedTreeNode)((Object)object)).parent instanceof DataNodeCheckedTreeNode) {
                    if (treePathArray == null && ExternalProjectDataSelectorDialog.this.v.contains(((DataNodeCheckedTreeNode)((Object)object)).d.getKey())) {
                        treePathArray = object;
                    }
                    object = (DataNodeCheckedTreeNode)((Object)((DataNodeCheckedTreeNode)((Object)object)).parent);
                }
                ((DataNodeCheckedTreeNode)((Object)object)).isChecked = true;
                dataNode2 = ExternalProjectDataSelectorDialog.d(((DataNodeCheckedTreeNode)((Object)object)).d);
                dataNode2.setIgnored(false);
                if (treePathArray != null) {
                    treePathArray.isChecked = true;
                }
                ExternalSystemApiUtil.visit((DataNode)(treePathArray == null ? this.d : treePathArray.d), dataNode -> {
                    DataNode dataNode2 = ExternalProjectDataSelectorDialog.d(dataNode);
                    dataNode2.setIgnored(false);
                });
            } else {
                ExternalSystemApiUtil.visit((DataNode)this.d, dataNode -> {
                    DataNode dataNode2 = ExternalProjectDataSelectorDialog.d(dataNode);
                    dataNode2.setIgnored(true);
                });
                if (ExternalProjectDataSelectorDialog.this.k) {
                    object = (DefaultTreeModel)ExternalProjectDataSelectorDialog.this.r.getModel();
                    treePathArray = ExternalProjectDataSelectorDialog.this.r.getSelectionPaths();
                    ((DefaultTreeModel)object).removeNodeFromParent((MutableTreeNode)((Object)this));
                    ExternalProjectDataSelectorDialog.this.r.addSelectionPaths(treePathArray);
                }
            }
            if (!bl2 && this.parent instanceof DataNodeCheckedTreeNode && this.d.getKey().equals((Object)ProjectKeys.MODULE) && ((DataNodeCheckedTreeNode)((Object)this.parent)).d.getKey().equals((Object)ProjectKeys.PROJECT)) {
                object = ((DataNodeCheckedTreeNode)((Object)this.parent)).d;
                treePathArray = (ProjectData)object.getData();
                dataNode2 = (ModuleData)this.d.getData();
                if (dataNode2.getLinkedExternalProjectPath().equals(treePathArray.getLinkedExternalProjectPath()) && ExternalSystemApiUtil.findAll((DataNode)object, (Key)ProjectKeys.MODULE).size() == 1) {
                    ((DataNodeCheckedTreeNode)((Object)this.parent)).setChecked(false);
                }
            }
            boolean bl3 = ((Object)(object = (DataNodeCheckedTreeNode[])ExternalProjectDataSelectorDialog.this.r.getSelectedNodes(DataNodeCheckedTreeNode.class, (Tree.NodeFilter)new Tree.NodeFilter<DataNodeCheckedTreeNode>(){

                public boolean accept(DataNodeCheckedTreeNode dataNodeCheckedTreeNode) {
                    return ExternalProjectDataSelectorDialog.this.v.contains(dataNodeCheckedTreeNode.d.getKey()) && bl2 != dataNodeCheckedTreeNode.isChecked();
                }
            }))).length == 0 && ExternalProjectDataSelectorDialog.this.v.contains(this.d.getKey());
            ExternalProjectDataSelectorDialog.this.a();
            if (((SelectionState)((ExternalProjectDataSelectorDialog)ExternalProjectDataSelectorDialog.this).p.getValue()).isRequiredSelectionEnabled && bl3) {
                this.a(bl2);
            }
        }

        private void a(boolean bl2) {
            Object object;
            Object object2;
            List list2 = ContainerUtil.newSmartList();
            for (Object object3 : TreeUtil.collectSelectedObjectsOfType((JTree)ExternalProjectDataSelectorDialog.this.r, DataNode.class)) {
                if (!ExternalProjectDataSelectorDialog.this.v.contains(object3.getKey())) continue;
                list2.add(object3);
            }
            HashSet hashSet = ContainerUtil.newHashSet();
            for (Object object4 : list2) {
                if (bl2) {
                    hashSet.addAll(ContainerUtil.filter((Collection)ExternalProjectDataSelectorDialog.this.l.get(object4), dataNode -> {
                        DataNodeCheckedTreeNode dataNodeCheckedTreeNode = (DataNodeCheckedTreeNode)((Object)((Object)dataNode.getUserData(g)));
                        return dataNodeCheckedTreeNode != null && !dataNodeCheckedTreeNode.isChecked();
                    }));
                    continue;
                }
                for (Object object5 : ExternalProjectDataSelectorDialog.this.l.keySet()) {
                    object2 = (DataNodeCheckedTreeNode)((Object)object5.getUserData(g));
                    if (object2 != null && !object2.isChecked() || !(object = ExternalProjectDataSelectorDialog.this.l.get(object5)).contains(object4)) continue;
                    hashSet.add(object5);
                }
            }
            if (!hashSet.isEmpty() && !list2.isEmpty()) {
                Object object4;
                Object object3;
                object3 = StringUtil.join((Collection)list2, dataNode -> ((Identifiable)dataNode.getData()).getId(), (String)", ");
                object4 = StringUtil.join((Collection)hashSet, dataNode -> ((Identifiable)dataNode.getData()).getId(), (String)"<br>");
                String string = !bl2 ? String.format("<html>The following module%s <br><b>%s</b><br>%s enabled and depend%s on selected modules. <br>Would you like to disable %s too?</html>", hashSet.size() == 1 ? "" : "s", object4, hashSet.size() == 1 ? "is" : "are", hashSet.size() == 1 ? "s" : "", hashSet.size() == 1 ? "it" : "them") : String.format("<html>The following module%s on which <b>%s</b> depend%s %s disabled:<br><b>%s</b><br>Would you like to enable %s?</html>", hashSet.size() == 1 ? "" : "s", object3, list2.size() == 1 ? "s" : "", hashSet.size() == 1 ? "is" : "are", object4, hashSet.size() == 1 ? "it" : "them");
                if (Messages.showOkCancelDialog((String)string, (String)(bl2 ? "Enable Dependant Modules" : "Disable Modules with Dependency on this"), (Icon)Messages.getQuestionIcon()) == 0) {
                    Object object5;
                    object5 = ContainerUtil.mapNotNull((Collection)hashSet, dataNode -> (DataNodeCheckedTreeNode)((Object)((Object)dataNode.getUserData(g))));
                    object2 = object5.iterator();
                    while (object2.hasNext()) {
                        object = (DataNodeCheckedTreeNode)((Object)object2.next());
                        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)ExternalProjectDataSelectorDialog.this.r.getModel();
                        ExternalProjectDataSelectorDialog.this.r.addSelectionPath(new TreePath(defaultTreeModel.getPathToRoot((TreeNode)object)));
                    }
                    object2 = object5.iterator();
                    while (object2.hasNext()) {
                        object = (DataNodeCheckedTreeNode)((Object)object2.next());
                        ((DataNodeCheckedTreeNode)((Object)object)).setChecked(bl2);
                    }
                }
            }
        }
    }
}

