/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.view;

import com.intellij.execution.Location;
import com.intellij.execution.RunManagerListener;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.ide.util.treeView.TreeState;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.ExternalSystemUiAware;
import com.intellij.openapi.externalSystem.action.ExternalSystemActionUtil;
import com.intellij.openapi.externalSystem.action.ExternalSystemViewGearAction;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalTaskExecutionInfo;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.task.TaskData;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemTaskLocation;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManagerImpl;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalSystemShortcutsManager;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalSystemTaskActivator;
import com.intellij.openapi.externalSystem.settings.ExternalSystemSettingsListener;
import com.intellij.openapi.externalSystem.settings.ExternalSystemSettingsListenerAdapter;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUiUtil;
import com.intellij.openapi.externalSystem.view.ExternalProjectsStructure;
import com.intellij.openapi.externalSystem.view.ExternalProjectsView;
import com.intellij.openapi.externalSystem.view.ExternalProjectsViewState;
import com.intellij.openapi.externalSystem.view.ExternalSystemNode;
import com.intellij.openapi.externalSystem.view.ExternalSystemViewContributor;
import com.intellij.openapi.externalSystem.view.ModuleNode;
import com.intellij.openapi.externalSystem.view.ProjectNode;
import com.intellij.openapi.externalSystem.view.RunConfigurationNode;
import com.intellij.openapi.externalSystem.view.TaskNode;
import com.intellij.openapi.externalSystem.view.TasksNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerAdapter;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.openapi.wm.impl.ToolWindowImpl;
import com.intellij.pom.Navigatable;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.treeStructure.SimpleTree;
import com.intellij.util.DisposeAwareRunnable;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.awt.Component;
import java.awt.event.InputEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JTree;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalProjectsViewImpl
extends SimpleToolWindowPanel
implements DataProvider,
ExternalProjectsView,
Disposable {
    public static final Logger LOG = Logger.getInstance(ExternalProjectsViewImpl.class);
    @NotNull
    private final Project i;
    @NotNull
    private final ExternalProjectsManagerImpl e;
    @NotNull
    private final ToolWindowEx g;
    @NotNull
    private final ProjectSystemId h;
    @NotNull
    private final ExternalSystemUiAware j;
    @NotNull
    private final Set<ExternalProjectsView.Listener> a;
    @Nullable
    private ExternalProjectsStructure c;
    private SimpleTree b;
    @NotNull
    private final NotificationGroup f;
    private ExternalProjectsViewState d;

    public ExternalProjectsViewImpl(@NotNull Project project2, @NotNull ToolWindowEx toolWindowEx, @NotNull ProjectSystemId projectSystemId) {
        if (project2 == null) {
            ExternalProjectsViewImpl.a(0);
        }
        if (toolWindowEx == null) {
            ExternalProjectsViewImpl.a(1);
        }
        if (projectSystemId == null) {
            ExternalProjectsViewImpl.a(2);
        }
        super(true, true);
        this.a = ContainerUtil.newHashSet();
        this.d = new ExternalProjectsViewState();
        this.i = project2;
        this.g = toolWindowEx;
        this.h = projectSystemId;
        this.j = ExternalSystemUiUtil.getUiAware(projectSystemId);
        this.e = ExternalProjectsManagerImpl.getInstance(this.i);
        String string = toolWindowEx instanceof ToolWindowImpl ? ((ToolWindowImpl)toolWindowEx).getId() : this.h.getReadableName();
        String string2 = "notification.group.id." + projectSystemId.getId().toLowerCase(Locale.ENGLISH);
        NotificationGroup notificationGroup = NotificationGroup.findRegisteredGroup((String)string2);
        this.f = notificationGroup != null ? notificationGroup : NotificationGroup.toolWindowGroup((String)string2, (String)string);
    }

    @Nullable
    public Object getData(@NonNls String string) {
        if (ExternalSystemDataKeys.VIEW.is(string)) {
            return this;
        }
        if (PlatformDataKeys.HELP_ID.is(string)) {
            return "reference.toolwindows.gradle";
        }
        if (CommonDataKeys.PROJECT.is(string)) {
            return this.i;
        }
        if (CommonDataKeys.VIRTUAL_FILE.is(string)) {
            return this.n();
        }
        if (CommonDataKeys.VIRTUAL_FILE_ARRAY.is(string)) {
            return this.f();
        }
        if (Location.DATA_KEY.is(string)) {
            return this.c();
        }
        if (CommonDataKeys.NAVIGATABLE_ARRAY.is(string)) {
            return this.k();
        }
        if (ExternalSystemDataKeys.EXTERNAL_SYSTEM_ID.is(string)) {
            return this.h;
        }
        if (ExternalSystemDataKeys.UI_AWARE.is(string)) {
            return this.j;
        }
        if (ExternalSystemDataKeys.SELECTED_PROJECT_NODE.is(string)) {
            return this.o();
        }
        if (ExternalSystemDataKeys.SELECTED_NODES.is(string)) {
            return this.a(ExternalSystemNode.class);
        }
        if (ExternalSystemDataKeys.PROJECTS_TREE.is(string)) {
            return this.b;
        }
        if (ExternalSystemDataKeys.NOTIFICATION_GROUP.is(string)) {
            return this.f;
        }
        return super.getData(string);
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project2 = this.i;
        if (project2 == null) {
            ExternalProjectsViewImpl.a(3);
        }
        return project2;
    }

    @Override
    @NotNull
    public ExternalSystemUiAware getUiAware() {
        ExternalSystemUiAware externalSystemUiAware = this.j;
        if (externalSystemUiAware == null) {
            ExternalProjectsViewImpl.a(4);
        }
        return externalSystemUiAware;
    }

    @Override
    public ExternalSystemShortcutsManager getShortcutsManager() {
        return this.e.getShortcutsManager();
    }

    @Override
    public ExternalSystemTaskActivator getTaskActivator() {
        return this.e.getTaskActivator();
    }

    @Override
    @NotNull
    public ProjectSystemId getSystemId() {
        ProjectSystemId projectSystemId = this.h;
        if (projectSystemId == null) {
            ExternalProjectsViewImpl.a(5);
        }
        return projectSystemId;
    }

    @NotNull
    public NotificationGroup getNotificationGroup() {
        NotificationGroup notificationGroup = this.f;
        if (notificationGroup == null) {
            ExternalProjectsViewImpl.a(6);
        }
        return notificationGroup;
    }

    public void init() {
        Disposer.register((Disposable)this.i, (Disposable)this);
        this.j();
        ToolWindowManagerEx toolWindowManagerEx = ToolWindowManagerEx.getInstanceEx((Project)this.i);
        ToolWindowManagerAdapter toolWindowManagerAdapter = new ToolWindowManagerAdapter(){
            boolean wasVisible = false;

            public void stateChanged() {
                if (ExternalProjectsViewImpl.this.g.isDisposed()) {
                    return;
                }
                boolean bl2 = ExternalProjectsViewImpl.this.g.isVisible();
                if (!bl2 || this.wasVisible) {
                    this.wasVisible = bl2;
                    return;
                }
                ExternalProjectsViewImpl.this.scheduleStructureUpdate();
                this.wasVisible = true;
            }
        };
        toolWindowManagerEx.addToolWindowManagerListener((ToolWindowManagerListener)toolWindowManagerAdapter, (Disposable)this.i);
        this.getShortcutsManager().addListener(new ExternalSystemShortcutsManager.Listener(){

            @Override
            public void shortcutsUpdated() {
                ExternalProjectsViewImpl.this.d();
                ExternalProjectsViewImpl.this.b(() -> {
                    assert (ExternalProjectsViewImpl.this.c != null);
                    ExternalProjectsViewImpl.this.c.updateNodes(RunConfigurationNode.class);
                });
            }
        });
        this.getTaskActivator().addListener(new ExternalSystemTaskActivator.Listener(){

            @Override
            public void tasksActivationChanged() {
                ExternalProjectsViewImpl.this.d();
                ExternalProjectsViewImpl.this.b(() -> {
                    assert (ExternalProjectsViewImpl.this.c != null);
                    ExternalProjectsViewImpl.this.c.updateNodes(RunConfigurationNode.class);
                });
            }
        });
        this.i.getMessageBus().connect((Disposable)this).subscribe(RunManagerListener.TOPIC, (Object)new RunManagerListener(){

            private void a() {
                ExternalProjectsViewImpl.this.b(() -> {
                    assert (ExternalProjectsViewImpl.this.c != null);
                    ExternalProjectsViewImpl.this.c.visitNodes(ModuleNode.class, moduleNode -> moduleNode.updateRunConfigurations());
                });
            }

            public void runConfigurationAdded(@NotNull RunnerAndConfigurationSettings runnerAndConfigurationSettings) {
                if (runnerAndConfigurationSettings == null) {
                    4.a(0);
                }
                this.a();
            }

            public void runConfigurationRemoved(@NotNull RunnerAndConfigurationSettings runnerAndConfigurationSettings) {
                if (runnerAndConfigurationSettings == null) {
                    4.a(1);
                }
                this.a();
            }

            public void runConfigurationChanged(@NotNull RunnerAndConfigurationSettings runnerAndConfigurationSettings) {
                if (runnerAndConfigurationSettings == null) {
                    4.a(2);
                }
                this.a();
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "settings";
                objectArray2[1] = "com/intellij/openapi/externalSystem/view/ExternalProjectsViewImpl$4";
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "runConfigurationAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "runConfigurationRemoved";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "runConfigurationChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        ExternalSystemApiUtil.subscribe((Project)this.i, (ProjectSystemId)this.h, (ExternalSystemSettingsListener)new ExternalSystemSettingsListenerAdapter(){

            public void onUseAutoImportChange(boolean bl2, @NotNull String string) {
                if (string == null) {
                    5.a(0);
                }
                ExternalProjectsViewImpl.this.b(() -> {
                    if (string == null) {
                        5.a(1);
                    }
                    assert (ExternalProjectsViewImpl.this.c != null);
                    List<ProjectNode> list2 = ExternalProjectsViewImpl.this.c.getNodes(ProjectNode.class);
                    for (ProjectNode projectNode : list2) {
                        ProjectData projectData = (ProjectData)projectNode.getData();
                        if (projectData == null || !projectData.getLinkedExternalProjectPath().equals(string)) continue;
                        projectNode.updateProject();
                        break;
                    }
                });
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "linkedProjectPath";
                objectArray2[1] = "com/intellij/openapi/externalSystem/view/ExternalProjectsViewImpl$5";
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onUseAutoImportChange";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$onUseAutoImportChange$0";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.g.setAdditionalGearActions(this.i());
        this.scheduleStructureUpdate();
    }

    @Override
    public void handleDoubleClickOrEnter(@NotNull ExternalSystemNode externalSystemNode, @Nullable String string, InputEvent inputEvent) {
        if (externalSystemNode == null) {
            ExternalProjectsViewImpl.a(7);
        }
        if (string != null) {
            ExternalSystemActionUtil.executeAction(string, inputEvent);
        }
        for (ExternalProjectsView.Listener listener : this.a) {
            listener.onDoubleClickOrEnter(externalSystemNode, inputEvent);
        }
    }

    @Override
    public void addListener(@NotNull ExternalProjectsView.Listener listener) {
        if (listener == null) {
            ExternalProjectsViewImpl.a(8);
        }
        this.a.add(listener);
    }

    private ActionGroup i() {
        String[] stringArray;
        ActionManager actionManager = ActionManager.getInstance();
        DefaultActionGroup defaultActionGroup = new DefaultActionGroup();
        for (String string : stringArray = new String[]{"ExternalSystem.GroupTasks", "ExternalSystem.ShowInheritedTasks", "ExternalSystem.ShowIgnored"}) {
            final AnAction anAction = actionManager.getAction(string);
            if (!(anAction instanceof ExternalSystemViewGearAction)) continue;
            ((ExternalSystemViewGearAction)anAction).setView(this);
            defaultActionGroup.add(anAction);
            Disposer.register((Disposable)this.i, (Disposable)new Disposable(){

                public void dispose() {
                    ((ExternalSystemViewGearAction)anAction).setView(null);
                }
            });
        }
        return defaultActionGroup;
    }

    private void a() {
        this.c = new ExternalProjectsStructure(this.i, this.b);
        Disposer.register((Disposable)this, (Disposable)this.c);
        this.c.init(this);
    }

    private void j() {
        this.b = new SimpleTree();
        this.b.getSelectionModel().setSelectionMode(4);
        final ActionManager actionManager = ActionManager.getInstance();
        ActionToolbar actionToolbar = actionManager.createActionToolbar(this.h.getReadableName() + " View Toolbar", (ActionGroup)((DefaultActionGroup)actionManager.getAction("ExternalSystemView.ActionsToolbar")), true);
        actionToolbar.setTargetComponent((JComponent)this.b);
        this.setToolbar(actionToolbar.getComponent());
        this.setContent(ScrollPaneFactory.createScrollPane((Component)this.b));
        this.b.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component component, int n2, int n3) {
                ActionGroup actionGroup;
                String string = this.a(ExternalProjectsViewImpl.this.a(ExternalSystemNode.class));
                if (string != null && (actionGroup = (ActionGroup)actionManager.getAction(string)) != null) {
                    actionManager.createActionPopupMenu("", actionGroup).getComponent().show(component, n2, n3);
                }
            }

            @Nullable
            private String a(Collection<? extends ExternalSystemNode> collection) {
                String string = null;
                for (ExternalSystemNode externalSystemNode : collection) {
                    String string2 = externalSystemNode.getMenuId();
                    if (string2 == null) {
                        return null;
                    }
                    if (string == null) {
                        string = string2;
                        continue;
                    }
                    if (string.equals(string2)) continue;
                    return null;
                }
                return string;
            }
        });
    }

    public void scheduleStructureUpdate() {
        this.b(() -> {
            Collection collection = ProjectDataManager.getInstance().getExternalProjectsData(this.i, this.h);
            List list2 = ContainerUtil.mapNotNull((Collection)collection, externalProjectInfo -> externalProjectInfo.getExternalProjectStructure());
            assert (this.c != null);
            this.c.updateProjects(list2);
        });
    }

    protected boolean isUnitTestMode() {
        return ApplicationManager.getApplication().isUnitTestMode();
    }

    public static void invokeLater(Project project2, Runnable runnable) {
        ExternalProjectsViewImpl.invokeLater(project2, ModalityState.defaultModalityState(), runnable);
    }

    public static void invokeLater(Project project2, ModalityState modalityState, Runnable runnable) {
        if (ExternalProjectsViewImpl.isNoBackgroundMode()) {
            runnable.run();
        } else {
            ApplicationManager.getApplication().invokeLater(DisposeAwareRunnable.create((Runnable)runnable, (Project)project2), modalityState);
        }
    }

    public static boolean isNoBackgroundMode() {
        return ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isHeadlessEnvironment();
    }

    @Override
    public void updateUpTo(ExternalSystemNode externalSystemNode) {
        ExternalProjectsStructure externalProjectsStructure = this.getStructure();
        if (externalProjectsStructure != null) {
            externalProjectsStructure.updateUpTo(externalSystemNode);
        }
    }

    @Override
    @Nullable
    public ExternalProjectsStructure getStructure() {
        return this.c;
    }

    @Override
    @NotNull
    public List<ExternalSystemNode<?>> createNodes(@NotNull ExternalProjectsView externalProjectsView, @Nullable ExternalSystemNode<?> externalSystemNode, @NotNull DataNode<?> dataNode) {
        if (externalProjectsView == null) {
            ExternalProjectsViewImpl.a(9);
        }
        if (dataNode == null) {
            ExternalProjectsViewImpl.a(10);
        }
        SmartList smartList = new SmartList();
        MultiMap multiMap = ExternalSystemApiUtil.group((Collection)dataNode.getChildren());
        for (ExternalSystemViewContributor externalSystemViewContributor : (ExternalSystemViewContributor[])ExternalSystemViewContributor.EP_NAME.getExtensions()) {
            if (!externalSystemViewContributor.getSystemId().equals((Object)ProjectSystemId.IDE) && !externalSystemViewContributor.getSystemId().equals((Object)externalProjectsView.getSystemId())) continue;
            ContainerUtil.KeyOrderedMultiMap keyOrderedMultiMap = new ContainerUtil.KeyOrderedMultiMap();
            for (Key<?> key : externalSystemViewContributor.getKeys()) {
                ContainerUtil.putIfNotNull(key, (Collection)multiMap.get(key), (MultiMap)keyOrderedMultiMap);
            }
            if (keyOrderedMultiMap.isEmpty()) continue;
            List<ExternalSystemNode<?>> list2 = externalSystemViewContributor.createNodes(externalProjectsView, (MultiMap<Key<?>, DataNode<?>>)keyOrderedMultiMap);
            smartList.addAll(list2);
            if (externalSystemNode == null) continue;
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                ExternalSystemNode externalSystemNode2 = (ExternalSystemNode)iterator.next();
                externalSystemNode2.setParent(externalSystemNode);
            }
        }
        SmartList smartList2 = smartList;
        if (smartList2 == null) {
            ExternalProjectsViewImpl.a(11);
        }
        return smartList2;
    }

    @Nullable
    public ExternalProjectsViewState getState() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.c != null) {
            try {
                this.d.treeState = new Element("root");
                TreeState.createOn((JTree)this.b).writeExternal(this.d.treeState);
            }
            catch (WriteExternalException writeExternalException) {
                LOG.warn((Throwable)writeExternalException);
            }
        }
        return this.d;
    }

    public void loadState(ExternalProjectsViewState externalProjectsViewState) {
        this.d = externalProjectsViewState;
    }

    @Override
    public boolean getShowIgnored() {
        return this.d.showIgnored;
    }

    public void setShowIgnored(boolean bl2) {
        if (this.d.showIgnored != bl2) {
            this.d.showIgnored = bl2;
            this.scheduleStructureUpdate();
        }
    }

    @Override
    public boolean getGroupTasks() {
        return this.d.groupTasks;
    }

    @Override
    public boolean useTasksNode() {
        return true;
    }

    public void setGroupTasks(boolean bl2) {
        if (this.d.groupTasks != bl2) {
            this.d.groupTasks = bl2;
            this.g();
        }
    }

    @Override
    public boolean showInheritedTasks() {
        return this.d.showInheritedTasks;
    }

    public void setShowInheritedTasks(boolean bl2) {
        if (this.d.showInheritedTasks != bl2) {
            this.d.showInheritedTasks = bl2;
            this.scheduleStructureUpdate();
        }
    }

    private void g() {
        this.b(() -> {
            assert (this.c != null);
            List<TasksNode> list2 = this.c.getNodes(TasksNode.class);
            for (TasksNode tasksNode : list2) {
                tasksNode.cleanUpCache();
                this.updateUpTo(tasksNode);
            }
        });
    }

    private void d() {
        this.b(() -> {
            assert (this.c != null);
            this.c.updateNodes(TaskNode.class);
        });
    }

    private void b(Runnable runnable) {
        if (this.isUnitTestMode()) {
            runnable.run();
            return;
        }
        ExternalProjectsViewImpl.invokeLater(this.i, () -> {
            boolean bl2;
            if (!this.g.isVisible()) {
                return;
            }
            boolean bl3 = bl2 = this.c == null;
            if (bl2) {
                this.a();
            }
            this.b.setPaintBusy(true);
            try {
                runnable.run();
                if (bl2) {
                    this.e();
                }
            }
            finally {
                this.b.setPaintBusy(false);
            }
        });
    }

    private void e() {
        TreeState.createFrom((Element)this.d.treeState).applyTo((JTree)this.b);
    }

    private <T extends ExternalSystemNode> List<T> a(Class<T> clazz) {
        return this.c != null ? this.c.getSelectedNodes(this.b, clazz) : ContainerUtil.emptyList();
    }

    private List<ProjectNode> h() {
        return this.a(ProjectNode.class);
    }

    @Nullable
    private ProjectNode o() {
        List<ProjectNode> list2 = this.h();
        return list2.size() == 1 ? list2.get(0) : null;
    }

    @Nullable
    private ExternalSystemTaskLocation c() {
        List<ExternalSystemNode> list2 = this.a(ExternalSystemNode.class);
        if (list2.isEmpty()) {
            return null;
        }
        List list3 = ContainerUtil.newSmartList();
        ExternalTaskExecutionInfo externalTaskExecutionInfo = new ExternalTaskExecutionInfo();
        String string = null;
        for (ExternalSystemNode externalSystemNode : list2) {
            Object t2 = externalSystemNode.getData();
            if (!(t2 instanceof TaskData)) continue;
            TaskData taskData = (TaskData)t2;
            if (string == null) {
                string = taskData.getLinkedExternalProjectPath();
            } else if (!taskData.getLinkedExternalProjectPath().equals(string)) {
                return null;
            }
            externalTaskExecutionInfo.getSettings().getTaskNames().add(taskData.getName());
            externalTaskExecutionInfo.getSettings().getTaskDescriptions().add(taskData.getDescription());
            list3.add(taskData);
        }
        if (list3.isEmpty()) {
            return null;
        }
        externalTaskExecutionInfo.getSettings().setExternalSystemIdString(this.h.toString());
        externalTaskExecutionInfo.getSettings().setExternalProjectPath(string);
        return ExternalSystemTaskLocation.create(this.i, this.h, string, externalTaskExecutionInfo);
    }

    private VirtualFile n() {
        ExternalSystemNode externalSystemNode2;
        for (ExternalSystemNode externalSystemNode2 : this.a(ExternalSystemNode.class)) {
            VirtualFile virtualFile = externalSystemNode2.getVirtualFile();
            if (virtualFile == null || !virtualFile.isValid()) continue;
            return virtualFile;
        }
        ProjectNode projectNode = this.o();
        if (projectNode == null) {
            return null;
        }
        externalSystemNode2 = projectNode.getVirtualFile();
        if (externalSystemNode2 == null || !externalSystemNode2.isValid()) {
            return null;
        }
        return externalSystemNode2;
    }

    private Object f() {
        ArrayList<VirtualFile> arrayList = new ArrayList<VirtualFile>();
        for (ExternalSystemNode externalSystemNode : this.a(ExternalSystemNode.class)) {
            VirtualFile virtualFile = externalSystemNode.getVirtualFile();
            if (virtualFile == null || !virtualFile.isValid()) continue;
            arrayList.add(virtualFile);
        }
        return arrayList.isEmpty() ? null : VfsUtilCore.toVirtualFileArray(arrayList);
    }

    private Object k() {
        ArrayList<Navigatable> arrayList = new ArrayList<Navigatable>();
        for (ExternalSystemNode externalSystemNode : this.a(ExternalSystemNode.class)) {
            Navigatable navigatable = externalSystemNode.getNavigatable();
            if (navigatable == null) continue;
            arrayList.add(navigatable);
        }
        return arrayList.isEmpty() ? null : arrayList.toArray(new Navigatable[0]);
    }

    public void dispose() {
        this.a.clear();
        this.c = null;
        this.b = null;
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 11: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalSystemId";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/view/ExternalProjectsViewImpl";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalProjectsView";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataNode";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/view/ExternalProjectsViewImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getUiAware";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemId";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotificationGroup";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createNodes";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 11: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "handleDoubleClickOrEnter";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createNodes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

