/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.view;

import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.externalSystem.ExternalSystemUiAware;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManager;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalSystemShortcutsManager;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalSystemTaskActivator;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.externalSystem.view.ExternalProjectsStructure;
import com.intellij.openapi.externalSystem.view.ExternalProjectsView;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.SimpleTree;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Color;
import java.awt.event.InputEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ExternalSystemNode<T>
extends SimpleNode
implements Comparable<ExternalSystemNode> {
    public static final int BUILTIN_TASKS_DATA_NODE_ORDER = 10;
    public static final int BUILTIN_DEPENDENCIES_DATA_NODE_ORDER = 20;
    public static final int BUILTIN_RUN_CONFIGURATIONS_DATA_NODE_ORDER = 30;
    public static final int BUILTIN_MODULE_DATA_NODE_ORDER = 40;
    @NotNull
    public static final Comparator<ExternalSystemNode> ORDER_AWARE_COMPARATOR = new Comparator<ExternalSystemNode>(){

        @Override
        public int compare(@NotNull ExternalSystemNode externalSystemNode, @NotNull ExternalSystemNode externalSystemNode2) {
            int n2;
            int n3;
            if (externalSystemNode == null) {
                1.a(0);
            }
            if (externalSystemNode2 == null) {
                1.a(1);
            }
            if ((n3 = this.a(externalSystemNode)) == (n2 = this.a(externalSystemNode2))) {
                return externalSystemNode.compareTo(externalSystemNode2);
            }
            return n3 < n2 ? -1 : 1;
        }

        private int a(@NotNull Comparable comparable) {
            Order order;
            if (comparable == null) {
                1.a(2);
            }
            if ((order = comparable.getClass().getAnnotation(Order.class)) != null) {
                return order.value();
            }
            return 0;
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o1";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o2";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/externalSystem/view/ExternalSystemNode$1";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "compare";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getOrder";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    protected static final ExternalSystemNode[] NO_CHILDREN = new ExternalSystemNode[0];
    private final ExternalProjectsView f;
    private final List<ExternalSystemNode<?>> e;
    protected DataNode<T> myDataNode;
    @Nullable
    private ExternalSystemNode d;
    private ExternalSystemNode[] g;
    private ExternalProjectsStructure.ErrorLevel a;
    private final List<String> c;
    private ExternalProjectsStructure.ErrorLevel b;

    public ExternalSystemNode(@NotNull ExternalProjectsView externalProjectsView, @Nullable ExternalSystemNode externalSystemNode) {
        if (externalProjectsView == null) {
            ExternalSystemNode.a(0);
        }
        this(externalProjectsView, externalSystemNode, null);
    }

    public ExternalSystemNode(@NotNull ExternalProjectsView externalProjectsView, @Nullable ExternalSystemNode externalSystemNode, @Nullable DataNode<T> dataNode) {
        if (externalProjectsView == null) {
            ExternalSystemNode.a(1);
        }
        super(externalProjectsView.getProject(), null);
        this.e = ContainerUtil.newArrayList();
        this.a = ExternalProjectsStructure.ErrorLevel.NONE;
        this.c = ContainerUtil.newArrayList();
        this.b = null;
        this.f = externalProjectsView;
        this.myDataNode = dataNode;
        this.d = externalSystemNode;
    }

    public boolean isAutoExpandNode() {
        SimpleNode simpleNode = this.getParent();
        return simpleNode != null && simpleNode.getChildCount() == 1;
    }

    public void setParent(@Nullable ExternalSystemNode externalSystemNode) {
        this.d = externalSystemNode;
    }

    @Nullable
    public T getData() {
        return (T)(this.myDataNode != null ? this.myDataNode.getData() : null);
    }

    public NodeDescriptor getParentDescriptor() {
        return this.d;
    }

    protected ExternalProjectsView getExternalProjectsView() {
        return this.f;
    }

    protected ExternalSystemUiAware getUiAware() {
        return this.f.getUiAware();
    }

    protected ExternalProjectsStructure getStructure() {
        return this.f.getStructure();
    }

    protected ExternalSystemShortcutsManager getShortcutsManager() {
        return this.f.getShortcutsManager();
    }

    protected ExternalSystemTaskActivator getTaskActivator() {
        return this.f.getTaskActivator();
    }

    @Nullable
    public <DataType extends ExternalSystemNode> DataType findParent(Class<DataType> clazz) {
        ExternalSystemNode externalSystemNode = this;
        while ((externalSystemNode = externalSystemNode.d) != null && !clazz.isInstance(externalSystemNode)) {
        }
        return (DataType)externalSystemNode;
    }

    @Nullable
    public <DataType> DataType findParentData(Class<DataType> clazz) {
        ExternalSystemNode externalSystemNode = this;
        do {
            if ((externalSystemNode = externalSystemNode.d) != null) continue;
            return null;
        } while (externalSystemNode.getData() == null || !clazz.isInstance(externalSystemNode.getData()));
        return (DataType)externalSystemNode.getData();
    }

    public boolean isVisible() {
        return this.getDisplayKind() != ExternalProjectsStructure.DisplayKind.NEVER && (!this.isIgnored() || this.f.getShowIgnored());
    }

    public boolean isIgnored() {
        if (this.myDataNode != null) {
            return this.myDataNode.isIgnored();
        }
        SimpleNode simpleNode = this.getParent();
        return simpleNode instanceof ExternalSystemNode && ((ExternalSystemNode)simpleNode).isIgnored();
    }

    public void setIgnored(boolean bl2) {
        if (this.myDataNode != null) {
            ExternalProjectsManager.getInstance((Project)this.f.getProject()).setIgnored(this.myDataNode, bl2);
        }
    }

    public ExternalProjectsStructure.DisplayKind getDisplayKind() {
        Class<? extends ExternalSystemNode>[] classArray = this.getStructure().getVisibleNodesClasses();
        if (classArray == null) {
            return ExternalProjectsStructure.DisplayKind.NORMAL;
        }
        for (Class<? extends ExternalSystemNode> clazz : classArray) {
            if (!clazz.isInstance(this)) continue;
            return ExternalProjectsStructure.DisplayKind.ALWAYS;
        }
        return ExternalProjectsStructure.DisplayKind.NEVER;
    }

    @NotNull
    public final ExternalSystemNode[] getChildren() {
        if (this.g == null) {
            this.g = this.b();
            this.onChildrenBuilt();
        }
        if (this.g == null) {
            ExternalSystemNode.a(2);
        }
        return this.g;
    }

    protected void onChildrenBuilt() {
    }

    @NotNull
    private ExternalSystemNode[] b() {
        List<ExternalSystemNode> list2 = this.doBuildChildren();
        if (list2.isEmpty()) {
            if (NO_CHILDREN == null) {
                ExternalSystemNode.a(3);
            }
            return NO_CHILDREN;
        }
        this.a(list2, true);
        this.sort(this.e);
        ArrayList arrayList = new ArrayList();
        for (ExternalSystemNode<?> externalSystemNode : this.e) {
            if (!externalSystemNode.isVisible()) continue;
            arrayList.add(externalSystemNode);
        }
        ExternalSystemNode[] externalSystemNodeArray = arrayList.toArray(new ExternalSystemNode[0]);
        if (externalSystemNodeArray == null) {
            ExternalSystemNode.a(4);
        }
        return externalSystemNodeArray;
    }

    public void cleanUpCache() {
        this.g = null;
        this.e.clear();
        this.b = null;
    }

    @Nullable
    protected ExternalSystemNode[] getCached() {
        return this.g;
    }

    protected void sort(List<? extends ExternalSystemNode> list2) {
        Collections.sort(list2, ORDER_AWARE_COMPARATOR);
    }

    public boolean addAll(Collection<? extends ExternalSystemNode> collection) {
        return this.a(collection, false);
    }

    private boolean a(Collection<? extends ExternalSystemNode> collection, boolean bl2) {
        if (collection.isEmpty()) {
            return false;
        }
        for (ExternalSystemNode externalSystemNode : collection) {
            externalSystemNode.setParent(this);
            this.e.add(externalSystemNode);
        }
        if (!bl2) {
            this.childrenChanged();
        }
        return true;
    }

    public boolean add(ExternalSystemNode externalSystemNode) {
        return this.addAll(ContainerUtil.list((Object[])new ExternalSystemNode[]{externalSystemNode}));
    }

    public boolean removeAll(Collection<ExternalSystemNode> collection) {
        return this.b(collection, false);
    }

    private boolean b(Collection<ExternalSystemNode> collection, boolean bl2) {
        if (collection.isEmpty()) {
            return false;
        }
        for (ExternalSystemNode externalSystemNode : collection) {
            externalSystemNode.setParent(null);
            this.e.remove(externalSystemNode);
        }
        if (!bl2) {
            this.childrenChanged();
        }
        return true;
    }

    public void remove(ExternalSystemNode externalSystemNode) {
        this.removeAll(ContainerUtil.list((Object[])new ExternalSystemNode[]{externalSystemNode}));
    }

    protected void childrenChanged() {
        for (ExternalSystemNode externalSystemNode2 = this; externalSystemNode2 != null; externalSystemNode2 = (ExternalSystemNode)externalSystemNode2.getParent()) {
            externalSystemNode2.b = null;
        }
        this.sort(this.e);
        List list2 = ContainerUtil.filter(this.e, externalSystemNode -> externalSystemNode.isVisible());
        this.g = list2.toArray(new ExternalSystemNode[0]);
        this.f.updateUpTo(this);
    }

    public boolean hasChildren() {
        return this.getChildren().length > 0;
    }

    @NotNull
    protected List<? extends ExternalSystemNode> doBuildChildren() {
        if (this.myDataNode != null && !this.myDataNode.getChildren().isEmpty()) {
            ExternalProjectsView externalProjectsView = this.getExternalProjectsView();
            List<ExternalSystemNode<?>> list2 = externalProjectsView.createNodes(externalProjectsView, this, this.myDataNode);
            if (list2 == null) {
                ExternalSystemNode.a(5);
            }
            return list2;
        }
        List<ExternalSystemNode<?>> list3 = this.e;
        if (list3 == null) {
            ExternalSystemNode.a(6);
        }
        return list3;
    }

    protected void setDataNode(DataNode<T> dataNode) {
        this.myDataNode = dataNode;
    }

    public ExternalProjectsStructure.ErrorLevel getTotalErrorLevel() {
        if (this.b == null) {
            this.b = this.a();
        }
        return this.b;
    }

    private ExternalProjectsStructure.ErrorLevel a() {
        ExternalProjectsStructure.ErrorLevel errorLevel = this.getChildrenErrorLevel();
        return errorLevel.compareTo(this.a) > 0 ? errorLevel : this.a;
    }

    public ExternalProjectsStructure.ErrorLevel getChildrenErrorLevel() {
        ExternalProjectsStructure.ErrorLevel errorLevel = ExternalProjectsStructure.ErrorLevel.NONE;
        for (ExternalSystemNode externalSystemNode : this.getChildren()) {
            ExternalProjectsStructure.ErrorLevel errorLevel2 = externalSystemNode.getTotalErrorLevel();
            if (errorLevel2.compareTo(errorLevel) <= 0) continue;
            errorLevel = errorLevel2;
        }
        return errorLevel;
    }

    public void setErrorLevel(ExternalProjectsStructure.ErrorLevel errorLevel, String ... stringArray) {
        if (this.a == errorLevel) {
            return;
        }
        this.a = errorLevel;
        this.c.clear();
        Collections.addAll(this.c, stringArray);
        this.f.updateUpTo(this);
    }

    protected void doUpdate() {
        this.setNameAndTooltip(this.getName(), null);
    }

    protected void setNameAndTooltip(String string, @Nullable String string2) {
        this.setNameAndTooltip(string, string2, (String)null);
    }

    protected void setNameAndTooltip(String string, @Nullable String string2, @Nullable String string3) {
        boolean bl2 = this.isIgnored();
        SimpleTextAttributes simpleTextAttributes = bl2 ? SimpleTextAttributes.GRAYED_ITALIC_ATTRIBUTES : this.getPlainAttributes();
        this.setNameAndTooltip(string, string2, simpleTextAttributes);
        if (!StringUtil.isEmptyOrSpaces((String)string3)) {
            this.addColoredFragment(" (" + string3 + ")", bl2 ? SimpleTextAttributes.GRAYED_ITALIC_ATTRIBUTES : SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
    }

    protected void setNameAndTooltip(String string, @Nullable String string2, SimpleTextAttributes simpleTextAttributes) {
        this.clearColoredText();
        this.addColoredFragment(string, this.a(simpleTextAttributes));
        String string3 = (string2 != null ? string2 + "\n\r" : "") + StringUtil.join(this.c, (String)"\n\r");
        this.getTemplatePresentation().setTooltip(string3);
    }

    private SimpleTextAttributes a(SimpleTextAttributes simpleTextAttributes) {
        ExternalProjectsStructure.ErrorLevel errorLevel = this.getTotalErrorLevel();
        JBColor jBColor = errorLevel == ExternalProjectsStructure.ErrorLevel.NONE ? null : JBColor.RED;
        int n2 = simpleTextAttributes.getStyle();
        if (jBColor != null) {
            n2 |= 8;
        }
        return new SimpleTextAttributes(simpleTextAttributes.getBgColor(), simpleTextAttributes.getFgColor(), (Color)jBColor, n2);
    }

    @Nullable
    @NonNls
    protected String getActionId() {
        return null;
    }

    @Nullable
    @NonNls
    protected String getMenuId() {
        return null;
    }

    protected String message(@NotNull String string, Object ... objectArray) {
        if (string == null) {
            ExternalSystemNode.a(7);
        }
        if (objectArray == null) {
            ExternalSystemNode.a(8);
        }
        return ExternalSystemBundle.message((String)string, (Object[])objectArray);
    }

    @Nullable
    public VirtualFile getVirtualFile() {
        return null;
    }

    @Nullable
    public Navigatable getNavigatable() {
        return null;
    }

    public void handleDoubleClickOrEnter(SimpleTree simpleTree, InputEvent inputEvent) {
        String string = this.getActionId();
        this.getExternalProjectsView().handleDoubleClickOrEnter(this, string, inputEvent);
    }

    @Override
    public int compareTo(@NotNull ExternalSystemNode externalSystemNode) {
        if (externalSystemNode == null) {
            ExternalSystemNode.a(9);
        }
        return StringUtil.compare((String)this.getName(), (String)externalSystemNode.getName(), (boolean)true);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalProjectsView";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/view/ExternalSystemNode";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/view/ExternalSystemNode";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildChildren";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "doBuildChildren";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "message";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

