/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.impl.builder;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.GraphUtil;
import com.intellij.openapi.graph.base.Edge;
import com.intellij.openapi.graph.base.Graph;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.base.NodeList;
import com.intellij.openapi.graph.builder.CustomGraphUpdater;
import com.intellij.openapi.graph.builder.DeleteProvider;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.GraphDataModel;
import com.intellij.openapi.graph.builder.GraphPresentationModel;
import com.intellij.openapi.graph.builder.NodesGroup;
import com.intellij.openapi.graph.builder.event.GraphBuilderEventManager;
import com.intellij.openapi.graph.builder.util.GraphViewUtil;
import com.intellij.openapi.graph.impl.builder.EdgeCreationPolicyAdapter;
import com.intellij.openapi.graph.impl.builder.GraphDataMaps;
import com.intellij.openapi.graph.impl.builder.GraphEditModeFactory;
import com.intellij.openapi.graph.impl.builder.GraphEventManager;
import com.intellij.openapi.graph.impl.builder.GraphImplUtil;
import com.intellij.openapi.graph.impl.builder.GraphUpdateModel;
import com.intellij.openapi.graph.impl.builder.YBundlesInitializer;
import com.intellij.openapi.graph.view.CellEditorMode;
import com.intellij.openapi.graph.view.EdgeLabel;
import com.intellij.openapi.graph.view.EdgeRealizer;
import com.intellij.openapi.graph.view.EditMode;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.Overview;
import com.intellij.openapi.graph.view.ViewMode;
import com.intellij.openapi.graph.view.hierarchy.GroupNodeRealizer;
import com.intellij.openapi.graph.view.hierarchy.HierarchyManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.DefaultFocusTraversalPolicy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GraphBuilderImpl<N, E>
extends GraphBuilder<N, E> {
    static final Logger LOG = Logger.getInstance((String)"com.intellij.openapi.graph.impl.builder.GraphBuilderImpl");
    private final Graph2D i;
    private final Graph2DView b;
    private final Project n;
    private final GraphDataMaps<N, E> d;
    private final GraphUpdateModel p;
    private final GraphDataModel<N, E> f;
    private final GraphPresentationModel<N, E> c;
    private final MergingUpdateQueue m;
    private Overview e;
    private boolean h;
    private boolean l;
    private final EditMode k;
    private final HierarchyManager g;
    private final List<CustomGraphUpdater> o = new ArrayList<CustomGraphUpdater>();
    private boolean j = false;
    private GraphBuilderEventManager a;

    public GraphBuilderImpl(Project project2, Graph2D graph2D, Graph2DView graph2DView, GraphDataModel<N, E> graphDataModel, GraphPresentationModel<N, E> graphPresentationModel) {
        this.n = project2;
        this.i = graph2D;
        this.b = graph2DView;
        this.d = new GraphDataMaps(this.i);
        this.g = GraphManager.getGraphManager().createHierarchyManager((Graph)this.getGraph());
        this.f = graphDataModel;
        this.c = graphPresentationModel;
        this.p = new GraphUpdateModel((Graph)graph2D);
        this.b.setGraph2D(this.getGraph());
        this.k = this.createEditMode();
        this.m = new MergingUpdateQueue("YFiles", 100, true, this.b.getJComponent());
        this.b.getJComponent().setFocusTraversalPolicy(new DefaultFocusTraversalPolicy());
        this.i();
        this.a = new GraphEventManager(this.k, this);
        Disposer.register((Disposable)this, this.f);
        Disposer.register((Disposable)this, this.c);
        Disposer.register((Disposable)this, (Disposable)this.m);
    }

    public final void initialize() {
        this.b();
        this.h = true;
        this.updateGraph();
    }

    public void updateGraph() {
        try {
            this.updateDataModel();
            this.updateView();
        }
        catch (ProcessCanceledException processCanceledException) {
            this.queueUpdate();
        }
    }

    public void updateDataModel() {
        if (!this.d()) {
            this.initialize();
        }
        this.buildModel();
        GraphImplUtil.updateDraggedNodesInfo(this);
        this.b((Graph)this.getGraph());
        this.a((Graph)this.getGraph());
    }

    private void a(Graph graph) {
        Set set = this.getDataMaps().getEdgeObjectDataMap().keySet();
        for (Edge edge : set.toArray(new Edge[set.size()])) {
            if (this.isEdgeWasUpdated(edge)) continue;
            this.getDataMaps().removeEdge(edge);
        }
        for (Edge edge : graph.getEdgeArray()) {
            if (this.isEdgeWasUpdated(edge) || !graph.contains(edge)) continue;
            graph.removeEdge(edge);
        }
    }

    private void a(Graph graph, Edge edge) {
        this.getDataMaps().removeEdge(edge);
        if (graph.contains(edge)) {
            graph.removeEdge(edge);
        }
    }

    private void b(Graph graph) {
        for (Node node : graph.getNodeArray()) {
            if (!this.isNodeWasUpdated(node) && !this.a(node)) {
                this.getDataMaps().removeNode(node);
                graph.removeNode(node);
            }
            if (!this.getHierarchyManager().isFolderNode(node)) continue;
            this.b(this.getHierarchyManager().getInnerGraph(node));
            this.a(this.getHierarchyManager().getInnerGraph(node));
        }
    }

    private void b() {
        this.f();
        this.getGraphPresentationModel().customizeSettings(this.getView(), this.k);
    }

    private void f() {
        Graph2DView graph2DView = this.getView();
        this.k.allowResizeNodes(false);
        this.k.allowNodeCreation(false);
        this.k.showNodeTips(true);
        this.k.showEdgeTips(true);
        this.k.allowEdgeCreation(true);
        this.k.allowMoveLabels(false);
        this.k.allowMovePorts(false);
        this.k.allowMoveSelection(true);
        graph2DView.setAntialiasedPainting(false);
        graph2DView.setFitContentOnResize(true);
        graph2DView.setGridVisible(false);
        graph2DView.setGridResolution(20.0);
        graph2DView.setGridColor(Color.LIGHT_GRAY);
        graph2DView.setGridType(Graph2DView.GRID_POINTS);
        graph2DView.addViewMode((ViewMode)this.k);
    }

    public Overview getOverview() {
        if (this.e == null) {
            this.e = GraphManager.getGraphManager().createOverview(this.getView());
        }
        return this.e;
    }

    protected EditMode createEditMode() {
        GraphEditModeFactory graphEditModeFactory = (GraphEditModeFactory)ServiceManager.getService((Project)this.getProject(), GraphEditModeFactory.class);
        EditMode editMode = graphEditModeFactory.createEditMode(this);
        editMode.setPopupMode((ViewMode)graphEditModeFactory.createPopupMode(this));
        editMode.setCreateEdgeMode(new EdgeCreationPolicyAdapter(this.getGraphPresentationModel().getEdgeCreationPolicy(), this));
        CellEditorMode cellEditorMode = graphEditModeFactory.createCellEditorMode(this);
        editMode.assignNodeLabel(false);
        editMode.setEditNodeMode((ViewMode)cellEditorMode);
        return editMode;
    }

    public void updateView() {
        this.updateRealizers(false);
        this.c();
        this.g();
        this.h();
        for (CustomGraphUpdater customGraphUpdater : this.o) {
            customGraphUpdater.update(this.getGraph(), this.getView());
        }
        this.getGraph().updateViews();
    }

    public void updateRealizers(boolean bl2) {
        for (Node node : GraphImplUtil.getNodes((Graph)this.getGraph())) {
            if (!GraphImplUtil.isGroupNode(this.getDataMaps(), node) && (bl2 || this.isNodeWasCreated(node))) {
                this.getGraph().setRealizer(node, this.getGraphPresentationModel().getNodeRealizer(this.getNodeObject(node)));
            }
            GraphViewUtil.setRenderedNodeSizes((Graph2D)this.getGraph(), (Graph2DView)this.getView(), (Node)node);
        }
        for (Edge edge : this.getGraph().getEdgeArray()) {
            if (this.isEdgeWasCreated(edge)) {
                this.getGraph().setRealizer(edge, this.getGraphPresentationModel().getEdgeRealizer(this.getEdgeObject(edge)));
                continue;
            }
            this.getGraph().setRealizer(edge, this.getGraph().getRealizer(edge));
        }
    }

    private List<Edge> e() {
        ArrayList<Edge> arrayList = new ArrayList<Edge>();
        for (Edge edge : this.getGraph().getEdgeArray()) {
            if (!this.isEdgeWasCreated(edge)) continue;
            arrayList.add(edge);
        }
        return arrayList;
    }

    private List<Node> a() {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (Node node : this.getGraph().getNodeArray()) {
            if (this.a(node) || !this.isNodeWasCreated(node)) continue;
            arrayList.add(node);
        }
        return arrayList;
    }

    private void c() {
        for (Edge edge : this.getGraph().getEdgeArray()) {
            EdgeLabel[] edgeLabelArray;
            EdgeRealizer edgeRealizer = this.getGraph().getRealizer(edge);
            GraphBuilderImpl.a(edgeRealizer);
            for (EdgeLabel edgeLabel : edgeLabelArray = this.getGraphPresentationModel().getEdgeLabels(this.getEdgeObject(edge), GraphImplUtil.getEdgeName(this.getDataMaps(), edge))) {
                edgeRealizer.addLabel(edgeLabel);
            }
        }
    }

    private static void a(EdgeRealizer edgeRealizer) {
        for (int i2 = 0; i2 < edgeRealizer.labelCount(); ++i2) {
            edgeRealizer.removeLabel(edgeRealizer.getLabel(i2));
        }
        edgeRealizer.setLabelText("");
    }

    private void h() {
        if (this.getGraph().getNodeArray().length > 0) {
            GraphUtil.doLayout((GraphBuilder)this);
            GraphViewUtil.updateWorldRect((Graph2DView)this.getView());
            this.getGraph().updateViews();
        }
    }

    public final boolean isUpdating() {
        return this.l;
    }

    public final synchronized void queueUpdate() {
        if (this.isUpdating()) {
            return;
        }
        final Cursor cursor = this.b.getJComponent().getCursor();
        this.b.getJComponent().setCursor(Cursor.getPredefinedCursor(3));
        this.l = true;
        this.m.queue(new Update("Update"){

            public void run() {
                GraphBuilderImpl.this.updateGraph();
                GraphBuilderImpl.this.l = false;
                GraphBuilderImpl.this.b.getJComponent().setCursor(cursor);
            }
        });
    }

    public GraphDataModel<N, E> getGraphDataModel() {
        return this.f;
    }

    @NotNull
    public String getNodeName(Node node) {
        String string = GraphImplUtil.getNodeName(this.getDataMaps(), node);
        if (string == null) {
            GraphBuilderImpl.a(0);
        }
        return string;
    }

    @Nullable
    public N getNodeObject(Node node) {
        return GraphImplUtil.getNodeObject(this.getDataMaps(), node);
    }

    @Nullable
    public E getEdgeObject(Edge edge) {
        return GraphImplUtil.getEdgeObject(this.getDataMaps(), edge);
    }

    public void buildModel() {
        this.getGraphUpdateModel().clearUpdateModel();
        this.createDataModel();
    }

    public void createDataModel() {
        GraphDataModel<N, E> graphDataModel = this.getGraphDataModel();
        Collection collection = graphDataModel.getNodes();
        for (Object e2 : collection) {
            this.addNode(graphDataModel.getNodeName(e2), e2);
        }
        for (Object e2 : graphDataModel.getEdges()) {
            this.addEdge(graphDataModel.getSourceNode(e2), graphDataModel.getTargetNode(e2), graphDataModel.getEdgeName(e2), e2);
        }
    }

    private void g() {
        NodeList nodeList;
        Object object3;
        Node node;
        NodesGroup nodesGroup2;
        Object object22;
        Collection<N> collection = this.getNodeObjects();
        GraphManager graphManager = GraphManager.getGraphManager();
        HashMap hashMap = new HashMap();
        for (Object object22 : collection) {
            nodesGroup2 = this.getGraphDataModel().getGroup(object22);
            if (nodesGroup2 == null) {
                Graph graph;
                node = this.getNode(object22);
                if (node == null || this.getHierarchyManager().isRootGraph(node.getGraph()) || (object3 = this.getHierarchyManager().getParentNode(node)) == null) continue;
                if (this.getHierarchyManager().isFolderNode(object3)) {
                    graph = node.getGraph();
                    nodeList = graphManager.createNodeList();
                    for (Node node2 : graph.getNodeArray()) {
                        if (this.a(node2)) continue;
                        nodeList.add((Object)node2);
                    }
                    this.getHierarchyManager().unfoldSubgraph(graph, nodeList);
                    continue;
                }
                if (!this.getHierarchyManager().isGroupNode(object3)) continue;
                graph = graphManager.createNodeList();
                graph.add((Object)node);
                this.getHierarchyManager().ungroupSubgraph((NodeList)graph);
                continue;
            }
            if (hashMap.get(nodesGroup2) == null) {
                hashMap.put(nodesGroup2, new ArrayList());
            }
            ((ArrayList)hashMap.get(nodesGroup2)).add(object22);
        }
        ArrayList arrayList = new ArrayList();
        for (NodesGroup nodesGroup2 : hashMap.keySet()) {
            boolean bl2;
            node = GraphImplUtil.getOrCreateGroupNode(this.getGraph(), this.g, nodesGroup2, this.getDataMaps());
            this.getGraphUpdateModel().setNodeWasViewed(node);
            object3 = GraphImplUtil.getGroup(this.getDataMaps(), node);
            boolean bl3 = bl2 = object3 != null ? object3.isClosed() : nodesGroup2.isClosed();
            if (bl2 && this.getHierarchyManager().isGroupNode(node)) {
                arrayList.add(node);
            }
            nodeList = graphManager.createNodeList();
            for (Object e2 : (ArrayList)hashMap.get(nodesGroup2)) {
                nodeList.add((Object)this.getNode(e2));
            }
            if (nodeList.size() <= 0 || !this.g.isGroupNode(node)) continue;
            this.g.groupSubgraph(nodeList, node);
        }
        object22 = arrayList.iterator();
        while (object22.hasNext()) {
            nodesGroup2 = (Node)object22.next();
            try {
                this.g.closeGroup((Node)nodesGroup2);
                node = this.getGraph().getRealizer((Node)nodesGroup2);
                if (!(node instanceof GroupNodeRealizer)) continue;
                ((GroupNodeRealizer)node).setGroupClosed(true);
                object3 = this.g.getInnerGraph((Node)nodesGroup2);
                if (!(object3 instanceof Graph2D)) continue;
                this.h();
            }
            catch (Throwable throwable) {
                LOG.error(throwable);
            }
        }
        for (Object object3 : this.getGraph().getNodeArray()) {
            if (this.isNodeWasUpdated((Node)object3) || !this.a((Node)object3)) continue;
            this.getGraph().removeNode(object3);
        }
    }

    private boolean a(Node node) {
        return this.g.isFolderNode(node) || this.g.isGroupNode(node);
    }

    public void addNode(N n2) {
        String string = this.getGraphDataModel().getNodeName(n2);
        this.addNode(string == null ? n2.toString() : string, n2);
    }

    public void addNode(@NotNull String string, N n2) {
        if (string == null) {
            GraphBuilderImpl.a(1);
        }
        this.addNode(string, n2, n2);
    }

    public void addNode(@NotNull String string, N n2, Object ... objectArray) {
        Node node;
        if (string == null) {
            GraphBuilderImpl.a(2);
        }
        if ((node = GraphImplUtil.getExistedNode(this.getDataMaps(), string, objectArray)) != null) {
            if (!this.getGraphUpdateModel().isNodeWasCreated(node)) {
                this.getGraphUpdateModel().setNodeWasViewed(node);
                GraphImplUtil.setNodeName(this.getDataMaps(), node, string);
            }
        } else {
            node = GraphImplUtil.createNode((Graph)this.getGraph(), this.b(n2), this.getDataMaps(), string, objectArray);
            this.getGraphUpdateModel().setNodeWasCreated(node);
        }
        GraphImplUtil.setNodeObject(this.getDataMaps(), node, n2);
    }

    @Nullable
    private Graph b(N n2) {
        NodesGroup nodesGroup = this.getGraphDataModel().getGroup(n2);
        if (nodesGroup != null) {
            Node node = GraphImplUtil.getOrCreateGroupNode(this.getGraph(), this.getHierarchyManager(), nodesGroup, this.getDataMaps());
            if (this.getHierarchyManager().isFolderNode(node)) {
                return this.getHierarchyManager().getInnerGraph(node);
            }
        }
        return null;
    }

    public Edge addEdge(@NotNull N n2, @NotNull N n3, E e2) {
        if (n2 == null) {
            GraphBuilderImpl.a(3);
        }
        if (n3 == null) {
            GraphBuilderImpl.a(4);
        }
        return this.addEdge(n2, n3, "", e2);
    }

    public Edge addEdge(@NotNull N n2, @NotNull N n3, @NotNull String string, E e2) {
        if (n2 == null) {
            GraphBuilderImpl.a(5);
        }
        if (n3 == null) {
            GraphBuilderImpl.a(6);
        }
        if (string == null) {
            GraphBuilderImpl.a(7);
        }
        return this.a(n2, n3, string, e2, e2);
    }

    private Edge a(@NotNull N n2, @NotNull N n3, @NotNull String string, E e2, Object ... objectArray) {
        if (n2 == null) {
            GraphBuilderImpl.a(8);
        }
        if (n3 == null) {
            GraphBuilderImpl.a(9);
        }
        if (string == null) {
            GraphBuilderImpl.a(10);
        }
        Node node = this.a(n2);
        Node node2 = this.a(n3);
        return this.a(node, node2, string, e2, objectArray);
    }

    private Edge a(@NotNull Node node, @NotNull Node node2, @NotNull String string, E e2, Object ... objectArray) {
        Edge edge;
        if (node == null) {
            GraphBuilderImpl.a(11);
        }
        if (node2 == null) {
            GraphBuilderImpl.a(12);
        }
        if (string == null) {
            GraphBuilderImpl.a(13);
        }
        if ((edge = GraphImplUtil.getExistedEdge(this.getDataMaps(), node, node2, string, objectArray)) != null) {
            if (!this.getGraphUpdateModel().isEdgeWasCreated(edge)) {
                this.getGraphUpdateModel().setEdgeWasViewed(edge);
            }
        } else {
            edge = GraphImplUtil.createEdge(this.getDataMaps(), node, node2, string, objectArray);
            this.getGraphUpdateModel().setEdgeWasCreated(edge);
        }
        GraphImplUtil.setEdgeObject(this.getDataMaps(), edge, e2);
        return edge;
    }

    private Node a(N n2) {
        Node node = this.getNode(n2);
        if (node == null) {
            this.addNode(n2);
            node = this.getNode(n2);
        }
        if (node == null) {
            LOG.error("null node for " + n2 + " in " + this.f);
        }
        return node;
    }

    public void dispose() {
        this.m.cancelAllUpdates();
        if (this.j) {
            return;
        }
        this.d.dispose();
        this.j = true;
    }

    @Nullable
    public String getNodeName(N n2) {
        Node node = this.getNode(n2);
        return node == null ? null : GraphImplUtil.getNodeName(this.getDataMaps(), node);
    }

    @Nullable
    public String getEdgeName(E e2) {
        Edge edge = this.getEdge(e2);
        return edge == null ? null : GraphImplUtil.getEdgeName(this.getDataMaps(), edge);
    }

    @Nullable
    public Node getNode(N n2) {
        return GraphImplUtil.getNode(this.getDataMaps(), n2);
    }

    @Nullable
    public Edge getEdge(E e2) {
        return GraphImplUtil.getEdge(this.getDataMaps(), e2);
    }

    public boolean isNodeWasCreated(Node node) {
        return node != null && this.getGraphUpdateModel().isNodeWasCreated(node);
    }

    public boolean isEdgeWasCreated(Edge edge) {
        return edge != null && this.getGraphUpdateModel().isEdgeWasCreated(edge);
    }

    public boolean isNodeWasUpdated(Node node) {
        return node != null && this.getGraphUpdateModel().isNodeWasUpdated(node);
    }

    public boolean isEdgeWasUpdated(Edge edge) {
        return edge != null && this.getGraphUpdateModel().isEdgeWasUpdated(edge);
    }

    public final Graph2D getGraph() {
        return this.i;
    }

    public Graph2DView getView() {
        return this.b;
    }

    public Project getProject() {
        return this.n;
    }

    public GraphUpdateModel getGraphUpdateModel() {
        return this.p;
    }

    public GraphPresentationModel<N, E> getGraphPresentationModel() {
        return this.c;
    }

    private boolean d() {
        return this.h;
    }

    private void i() {
        GraphViewUtil.addDataProvider((Graph2DView)this.getView(), (DataProvider)new DataProvider(){

            @Nullable
            public Object getData(@NonNls String string) {
                if (string.equals(DeleteProvider.GRAPH_DELETE_PROVIDER_KEY)) {
                    return GraphBuilderImpl.this.getGraphPresentationModel().getDeleteProvider();
                }
                if (string.equals(GraphBuilder.GRAPH_BUILDER_KEY)) {
                    return GraphBuilderImpl.this;
                }
                return null;
            }
        });
    }

    public HierarchyManager getHierarchyManager() {
        return this.g;
    }

    public void addCustomUpdater(CustomGraphUpdater customGraphUpdater) {
        this.o.add(customGraphUpdater);
    }

    public EditMode getEditMode() {
        return this.k;
    }

    public GraphDataMaps<N, E> getDataMaps() {
        return this.d;
    }

    public Collection<N> getNodeObjects() {
        return this.getDataMaps().getNodeObjectDataMap().values();
    }

    public Collection<E> getEdgeObjects() {
        return this.getDataMaps().getEdgeObjectDataMap().values();
    }

    public boolean removeNode(N n2) {
        Node node = this.getNode(n2);
        if (node != null) {
            this.getDataMaps().removeNode(node);
            node.getGraph().removeNode(node);
            return true;
        }
        return false;
    }

    public boolean removeEdge(E e2) {
        Edge edge = this.getEdge(e2);
        if (edge != null) {
            this.getGraph().removeEdge(edge);
            this.getDataMaps().removeEdge(edge);
            return true;
        }
        return false;
    }

    public GraphBuilderEventManager getEventManager() {
        return this.a;
    }

    static {
        YBundlesInitializer.init();
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/graph/impl/builder/GraphBuilderImpl";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeObject1";
                break;
            }
            case 4: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeObject2";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node1";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node2";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/graph/impl/builder/GraphBuilderImpl";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addNode";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addEdge";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createEdge";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

