/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.impl.builder;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.event.GraphBuilderEvent;
import com.intellij.openapi.graph.builder.event.GraphBuilderEventManager;
import com.intellij.openapi.graph.builder.event.GraphBuilderListener;
import com.intellij.openapi.graph.builder.util.GraphViewUtil;
import com.intellij.openapi.graph.view.EditMode;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.MagnifierViewMode;
import com.intellij.openapi.graph.view.NavigationMode;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.openapi.graph.view.ViewMode;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.components.Magnificator;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;

public class GraphEventManager
extends GraphBuilderEventManager {
    private final Graph2DView f;
    private final EditMode i;
    private final ViewMode a = new NavigationMode();
    private final MagnifierViewMode d = new MagnifierViewMode();
    private volatile boolean h = false;
    private volatile boolean e = false;
    private final List<GraphBuilderListener> g = new ArrayList<GraphBuilderListener>();
    private final GraphBuilder c;
    private boolean b = false;

    GraphEventManager(EditMode editMode, GraphBuilder graphBuilder) {
        this.c = graphBuilder;
        this.f = graphBuilder.getView();
        this.i = editMode;
        this.d.setMagnifierRadius(150);
        Disposer.register((Disposable)graphBuilder, (Disposable)this);
        JComponent jComponent = this.f.getCanvasComponent();
        jComponent.addMouseMotionListener((MouseMotionListener)((Object)this));
        jComponent.addKeyListener((KeyListener)((Object)this));
        jComponent.addMouseWheelListener((MouseWheelListener)((Object)this));
        jComponent.addFocusListener((FocusListener)((Object)this));
        jComponent.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (GraphEventManager.this.b) {
                    GraphEventManager.this.b = false;
                    GraphEventManager.this.a(GraphBuilderEvent.NODES_MOVED, false);
                }
            }
        });
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (mouseEvent.isControlDown() && !mouseEvent.isAltDown()) {
            this.b();
        } else if (mouseEvent.isAltDown() && !mouseEvent.isControlDown()) {
            this.c();
        } else {
            if (!this.b) {
                this.b = true;
                this.a(GraphBuilderEvent.NODES_MOVED, true);
            }
            this.a();
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (!mouseEvent.isAltDown() && this.e || !mouseEvent.isControlDown() && this.h) {
            this.a();
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n2 = keyEvent.getKeyCode();
        boolean bl2 = keyEvent.isAltDown();
        boolean bl3 = keyEvent.isControlDown();
        if (bl3 && GraphEventManager.b(n2)) {
            this.a(n2);
        } else if (n2 == 17 && !bl2) {
            this.b();
        } else if (n2 == 18 && !bl3) {
            this.c();
        } else {
            this.a();
        }
    }

    private void a(int n2) {
        Graph2D graph2D = this.f.getGraph2D();
        List list2 = GraphViewUtil.getSelectedNodes((Graph2D)graph2D);
        if (list2.size() > 0) {
            this.a(GraphBuilderEvent.NODES_MOVED_BY_KEYBOARD, true);
            for (Node node : list2) {
                NodeRealizer nodeRealizer = graph2D.getRealizer(node);
                nodeRealizer.setX(nodeRealizer.getX() + (double)(3 * (n2 == 37 ? -1 : (n2 == 39 ? 1 : 0))));
                nodeRealizer.setY(nodeRealizer.getY() + (double)(3 * (n2 == 38 ? -1 : (n2 == 40 ? 1 : 0))));
            }
            graph2D.updateViews();
            this.a(GraphBuilderEvent.NODES_MOVED_BY_KEYBOARD, false);
        }
    }

    private static boolean b(int n2) {
        return n2 == 37 || n2 == 39 || n2 == 40 || n2 == 38;
    }

    private synchronized void b() {
        if (!this.h) {
            this.f.setDrawingMode(Graph2DView.NORMAL_MODE);
            this.i.setEditing(false);
            this.i.reactivateParent();
            this.h = true;
            this.f.removeViewMode((ViewMode)(this.e ? this.d : this.i));
            this.e = false;
            this.f.addViewMode(this.a);
        }
    }

    private synchronized void c() {
        if (!this.e) {
            this.e = true;
            double d2 = this.f.getZoom();
            d2 = d2 < 1.0 ? 1.5 / d2 : 2.0 * d2;
            this.d.setMagnifierZoomFactor(d2);
            this.f.removeViewMode((ViewMode)(this.h ? this.a : this.i));
            this.h = false;
            this.f.addViewMode((ViewMode)this.d);
        }
    }

    private synchronized void a() {
        if (this.h) {
            this.a(GraphBuilderEvent.GRAPH_MOVED, false);
            this.h = false;
            this.f.removeViewMode(this.a);
            this.f.addViewMode((ViewMode)this.i);
        } else if (this.e) {
            this.e = false;
            this.f.removeViewMode((ViewMode)this.d);
            this.f.updateView();
            this.f.addViewMode((ViewMode)this.i);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 17 || keyEvent.getKeyCode() == 18) {
            this.a();
        }
    }

    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        int n2 = mouseWheelEvent.getWheelRotation();
        if (n2 == 0) {
            return;
        }
        if (mouseWheelEvent.isControlDown()) {
            double d2 = this.f.getZoom() - (double)n2 * 0.1;
            Magnificator magnificator = (Magnificator)UIUtil.getParentOfType(Magnificator.class, (Component)this.f.getCanvasComponent());
            if (magnificator != null) {
                magnificator.magnify(d2 / this.f.getZoom(), mouseWheelEvent.getPoint());
            }
        }
    }

    public double zoomView(double d2) {
        this.a(GraphBuilderEvent.ZOOM_CHANGED, true);
        double d3 = Math.min(10.0, Math.max(d2, 0.1));
        this.f.setZoom(d3);
        this.f.updateView();
        this.a(GraphBuilderEvent.ZOOM_CHANGED, false);
        return d3;
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        this.a();
    }

    public void subscribe(GraphBuilderListener graphBuilderListener) {
        if (!this.g.contains(graphBuilderListener)) {
            this.g.add(graphBuilderListener);
        }
    }

    public void dispose() {
        this.g.clear();
    }

    private void a(GraphBuilderEvent graphBuilderEvent, boolean bl2) {
        for (GraphBuilderListener graphBuilderListener : this.g) {
            if (bl2) {
                graphBuilderListener.beforeActionPerformed(this.c, graphBuilderEvent);
                continue;
            }
            graphBuilderListener.actionPerformed(this.c, graphBuilderEvent);
        }
    }
}

