/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.impl.builder;

import com.intellij.openapi.graph.base.Edge;
import com.intellij.openapi.graph.base.Graph;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.base.NodeCursor;
import com.intellij.openapi.graph.builder.NodesGroup;
import com.intellij.openapi.graph.impl.builder.ComparableEdge;
import com.intellij.openapi.graph.impl.builder.ComparableNode;
import com.intellij.openapi.graph.impl.builder.GraphBuilderImpl;
import com.intellij.openapi.graph.impl.builder.GraphDataMaps;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.openapi.graph.view.hierarchy.HierarchyManager;
import com.intellij.openapi.util.Key;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GraphImplUtil {
    public static Key NODE_DRAGGED_INFO = Key.create((String)"NODE_DRAGGED_INFO");

    private GraphImplUtil() {
    }

    @Nullable
    public static Node getExistedNode(@NotNull GraphDataMaps graphDataMaps, @NotNull String string, Object[] objectArray) {
        if (graphDataMaps == null) {
            GraphImplUtil.a(0);
        }
        if (string == null) {
            GraphImplUtil.a(1);
        }
        ComparableNode comparableNode = GraphImplUtil.a(string, objectArray);
        Map<Node, ComparableNode> map = graphDataMaps.getNodeEqualityDataMap();
        for (Node node : map.keySet()) {
            if (!comparableNode.equals(map.get(node))) continue;
            return node;
        }
        return null;
    }

    @Nullable
    public static <N, E> Edge getExistedEdge(GraphDataMaps<N, E> graphDataMaps, Node node, Node node2, @NotNull String string, Object ... objectArray) {
        if (string == null) {
            GraphImplUtil.a(2);
        }
        ComparableEdge comparableEdge = GraphImplUtil.a(graphDataMaps, string, node, node2, objectArray);
        Map<Edge, ComparableEdge> map = graphDataMaps.getEdgeEqualityDataMap();
        for (Edge edge : map.keySet()) {
            if (!comparableEdge.equals(map.get(edge))) continue;
            return edge;
        }
        return null;
    }

    public static List<Node> getNodes(Graph graph) {
        HierarchyManager hierarchyManager = HierarchyManager.Statics.getInstance((Graph)graph);
        ArrayList<Node> arrayList = new ArrayList<Node>(Arrays.asList(graph.getNodeArray()));
        for (Node node : graph.getNodeArray()) {
            if (!hierarchyManager.isFolderNode(node)) continue;
            arrayList.addAll(GraphImplUtil.getNodes(hierarchyManager.getInnerGraph(node)));
        }
        return arrayList;
    }

    public static List<Edge> getEdges(Graph graph) {
        HierarchyManager hierarchyManager = HierarchyManager.Statics.getInstance((Graph)graph);
        ArrayList<Edge> arrayList = new ArrayList<Edge>(Arrays.asList(graph.getEdgeArray()));
        for (Node node : graph.getNodeArray()) {
            if (!hierarchyManager.isFolderNode(node)) continue;
            arrayList.addAll(GraphImplUtil.getEdges(hierarchyManager.getInnerGraph(node)));
        }
        return arrayList;
    }

    public static Node createNode(@NotNull Graph graph, @NotNull GraphDataMaps graphDataMaps, @NotNull String string, Object ... objectArray) {
        if (graph == null) {
            GraphImplUtil.a(3);
        }
        if (graphDataMaps == null) {
            GraphImplUtil.a(4);
        }
        if (string == null) {
            GraphImplUtil.a(5);
        }
        return GraphImplUtil.createNode(graph, null, graphDataMaps, string, objectArray);
    }

    public static Node createNode(@NotNull Graph graph, @Nullable Graph graph2, @NotNull GraphDataMaps graphDataMaps, @NotNull String string, Object ... objectArray) {
        if (graph == null) {
            GraphImplUtil.a(6);
        }
        if (graphDataMaps == null) {
            GraphImplUtil.a(7);
        }
        if (string == null) {
            GraphImplUtil.a(8);
        }
        Node node = graph2 == null ? graph.createNode() : graph2.createNode();
        GraphImplUtil.setNodeName(graphDataMaps, node, string);
        graphDataMaps.getNodeEqualityDataMap().put(node, GraphImplUtil.a(string, objectArray));
        return node;
    }

    private static ComparableNode a(@NotNull String string, Object ... objectArray) {
        if (string == null) {
            GraphImplUtil.a(9);
        }
        return new ComparableNode("", objectArray);
    }

    private static <N, E> ComparableEdge a(GraphDataMaps<N, E> graphDataMaps, @NotNull String string, Node node, Node node2, Object ... objectArray) {
        if (string == null) {
            GraphImplUtil.a(10);
        }
        return new ComparableEdge(string, GraphImplUtil.a(graphDataMaps, node), GraphImplUtil.a(graphDataMaps, node2), objectArray);
    }

    private static <N, E> ComparableNode a(GraphDataMaps<N, E> graphDataMaps, Node node) {
        return GraphImplUtil.a(GraphImplUtil.getNodeName(graphDataMaps, node), GraphImplUtil.b(graphDataMaps, node));
    }

    @NotNull
    public static <N, E> String getNodeName(@NotNull GraphDataMaps<N, E> graphDataMaps, @NotNull Node node) {
        String string;
        if (graphDataMaps == null) {
            GraphImplUtil.a(11);
        }
        if (node == null) {
            GraphImplUtil.a(12);
        }
        String string2 = (string = graphDataMaps.getNodeNameDataMap().get(node)) == null ? "" : string;
        if (string2 == null) {
            GraphImplUtil.a(13);
        }
        return string2;
    }

    public static void setNodeName(GraphDataMaps graphDataMaps, Node node, @NotNull String string) {
        if (string == null) {
            GraphImplUtil.a(14);
        }
        graphDataMaps.getNodeNameDataMap().put(node, string);
    }

    public static <N, E> void setNodeObject(GraphDataMaps<N, E> graphDataMaps, Node node, N n2) {
        graphDataMaps.getNodeObjectDataMap().put((Object)node, n2);
    }

    public static <N, E> Node getOrCreateGroupNode(Graph2D graph2D, HierarchyManager hierarchyManager, NodesGroup nodesGroup, GraphDataMaps<N, E> graphDataMaps) {
        Node node = GraphImplUtil.a(graph2D, nodesGroup, hierarchyManager, graphDataMaps);
        if (node != null) {
            return node;
        }
        NodesGroup nodesGroup2 = nodesGroup.getParent();
        if (nodesGroup2 != null) {
            Node node2 = GraphImplUtil.a(graph2D, nodesGroup2, hierarchyManager, graphDataMaps);
            if (node2 == null) {
                node2 = GraphImplUtil.getOrCreateGroupNode(graph2D, hierarchyManager, nodesGroup.getParent(), graphDataMaps);
            }
            return GraphImplUtil.a(hierarchyManager, graph2D, nodesGroup, node2, graphDataMaps);
        }
        return GraphImplUtil.a(hierarchyManager, graph2D, nodesGroup, graphDataMaps);
    }

    @Nullable
    public static <N, E> NodesGroup getGroup(GraphDataMaps<N, E> graphDataMaps, Node node) {
        return graphDataMaps.getGroupNodeDataMap().get(node);
    }

    private static <N, E> Node a(HierarchyManager hierarchyManager, Graph2D graph2D, NodesGroup nodesGroup, GraphDataMaps<N, E> graphDataMaps) {
        return GraphImplUtil.a(hierarchyManager, graph2D, nodesGroup, null, graphDataMaps);
    }

    private static <N, E> Node a(HierarchyManager hierarchyManager, Graph2D graph2D, NodesGroup nodesGroup, Node node, GraphDataMaps<N, E> graphDataMaps) {
        Node node2 = node == null ? hierarchyManager.createGroupNode((Graph)graph2D) : hierarchyManager.createGroupNode(node);
        graph2D.setLabelText(node2, nodesGroup.getGroupName());
        if (nodesGroup.getGroupNodeRealizer() != null) {
            graph2D.setRealizer(node2, (NodeRealizer)nodesGroup.getGroupNodeRealizer());
        }
        graphDataMaps.getGroupNodeDataMap().put(node2, nodesGroup);
        return node2;
    }

    @Nullable
    private static <N, E> Node a(Graph2D graph2D, @NotNull NodesGroup nodesGroup, HierarchyManager hierarchyManager, GraphDataMaps<N, E> graphDataMaps) {
        if (nodesGroup == null) {
            GraphImplUtil.a(15);
        }
        for (Node node : graph2D.getNodeArray()) {
            if (!hierarchyManager.isFolderNode(node) && !hierarchyManager.isGroupNode(node)) continue;
            if (nodesGroup.equals(GraphImplUtil.getGroupNode(graphDataMaps, node))) {
                return node;
            }
            Node node2 = GraphImplUtil.a(nodesGroup, hierarchyManager, graph2D, hierarchyManager.getChildren(node), graphDataMaps);
            if (node2 == null) continue;
            return node2;
        }
        return null;
    }

    @Nullable
    private static <N, E> Node a(NodesGroup nodesGroup, HierarchyManager hierarchyManager, Graph2D graph2D, NodeCursor nodeCursor, GraphDataMaps<N, E> graphDataMaps) {
        while (nodeCursor.ok()) {
            Node node = nodeCursor.node();
            if (nodesGroup.equals(GraphImplUtil.getGroupNode(graphDataMaps, node))) {
                return node;
            }
            Node node2 = GraphImplUtil.a(nodesGroup, hierarchyManager, graph2D, hierarchyManager.getChildren(node), graphDataMaps);
            if (node2 != null) {
                return node2;
            }
            nodeCursor.next();
        }
        return null;
    }

    @Nullable
    public static <N, E> NodesGroup getGroupNode(GraphDataMaps<N, E> graphDataMaps, Node node) {
        return graphDataMaps.getGroupNodeDataMap().get(node);
    }

    public static <N, E> boolean isGroupNode(GraphDataMaps<N, E> graphDataMaps, Node node) {
        return graphDataMaps.getGroupNodeDataMap().get(node) != null;
    }

    public static <N, E> void setEdgeObject(GraphDataMaps<N, E> graphDataMaps, Edge edge, E e2) {
        graphDataMaps.getEdgeObjectDataMap().put((Object)edge, e2);
    }

    public static <N, E> String getEdgeName(@NotNull GraphDataMaps<N, E> graphDataMaps, @NotNull E e2) {
        if (graphDataMaps == null) {
            GraphImplUtil.a(16);
        }
        if (e2 == null) {
            GraphImplUtil.a(17);
        }
        return graphDataMaps.getEdgeNameDataMap().get(GraphImplUtil.getEdge(graphDataMaps, e2));
    }

    public static <N, E> String getEdgeName(@NotNull GraphDataMaps<N, E> graphDataMaps, @NotNull Edge edge) {
        String string;
        if (graphDataMaps == null) {
            GraphImplUtil.a(18);
        }
        if (edge == null) {
            GraphImplUtil.a(19);
        }
        return (string = graphDataMaps.getEdgeNameDataMap().get(edge)) == null ? "" : string;
    }

    public static <N, E> void setEdgeName(GraphDataMaps<N, E> graphDataMaps, Edge edge, @NotNull String string) {
        if (string == null) {
            GraphImplUtil.a(20);
        }
        graphDataMaps.getEdgeNameDataMap().put(edge, string);
    }

    public static <N, E> Edge createEdge(GraphDataMaps<N, E> graphDataMaps, Node node, Node node2, @NotNull String string, Object[] objectArray) {
        if (string == null) {
            GraphImplUtil.a(21);
        }
        Edge edge = HierarchyManager.Statics.getInstance((Graph)graphDataMaps.getGraph()).createEdge(node, node2);
        GraphImplUtil.setEdgeName(graphDataMaps, edge, string);
        graphDataMaps.getEdgeEqualityDataMap().put(edge, GraphImplUtil.a(graphDataMaps, string, node, node2, objectArray));
        return edge;
    }

    @Nullable
    public static <N, E> N getNodeObject(GraphDataMaps<N, E> graphDataMaps, Node node) {
        return (N)graphDataMaps.getNodeObjectDataMap().get((Object)node);
    }

    @Nullable
    public static <N, E> E getEdgeObject(GraphDataMaps<N, E> graphDataMaps, Edge edge) {
        return (E)graphDataMaps.getEdgeObjectDataMap().get((Object)edge);
    }

    @Nullable
    public static <N, E> Node getNode(GraphDataMaps<N, E> graphDataMaps, N n2) {
        return n2 == null ? null : (Node)ContainerUtil.getFirstItem((List)graphDataMaps.getNodeObjectDataMap().getKeysByValue(n2));
    }

    @Nullable
    public static <N, E> Edge getEdge(GraphDataMaps<N, E> graphDataMaps, @NotNull E e2) {
        if (e2 == null) {
            GraphImplUtil.a(22);
        }
        return (Edge)ContainerUtil.getFirstItem((List)graphDataMaps.getEdgeObjectDataMap().getKeysByValue(e2));
    }

    public static <N, E> void setNodeWasDragged(GraphDataMaps<N, E> graphDataMaps, Node node) {
        graphDataMaps.getDraggedNodesList().add(node);
    }

    public static <N, E> void updateDraggedNodesInfo(GraphBuilderImpl<N, E> graphBuilderImpl) {
        GraphDataMaps<N, E> graphDataMaps = graphBuilderImpl.getDataMaps();
        for (Node node : graphDataMaps.getGraph().getNodeArray()) {
            if (!graphDataMaps.getDraggedNodesList().contains(node)) continue;
            if ((graphBuilderImpl.getGraphUpdateModel().isNodeWasUpdated(node) || graphBuilderImpl.getGraphUpdateModel().isNodeWasCreated(node)) && !GraphImplUtil.a(graphBuilderImpl, node)) {
                graphBuilderImpl.getGraphUpdateModel().setNodeWasViewed(node);
                graphDataMaps.getDraggedNodesList().remove(node);
                continue;
            }
            GraphImplUtil.b(graphBuilderImpl, node);
        }
    }

    private static boolean a(GraphBuilderImpl graphBuilderImpl, Node node) {
        return NODE_DRAGGED_INFO.equals(graphBuilderImpl.getGraphUpdateModel().getNodeUpdatesDataMap().get((Object)node));
    }

    private static void b(GraphBuilderImpl graphBuilderImpl, Node node) {
        graphBuilderImpl.getGraphUpdateModel().getNodeUpdatesDataMap().set((Object)node, (Object)NODE_DRAGGED_INFO);
    }

    private static <N, E> ComparableNode b(GraphDataMaps<N, E> graphDataMaps, Node node) {
        return graphDataMaps.getNodeEqualityDataMap().get(node);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 13: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataMaps";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootGraph";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graphDataMaps";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/graph/impl/builder/GraphImplUtil";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edge";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/graph/impl/builder/GraphImplUtil";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeName";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getExistedNode";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getExistedEdge";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createNode";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createComparableNode";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createComparableEdge";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getNodeName";
                break;
            }
            case 13: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setNodeName";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findGroupNode";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getEdgeName";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "setEdgeName";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createEdge";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getEdge";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

