/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.ui;

import com.google.common.collect.Lists;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.SdkEditorAdditionalOptionsProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.AdditionalDataConfigurable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.impl.ProjectJdkImpl;
import com.intellij.openapi.projectRoots.impl.SdkConfigurationUtil;
import com.intellij.openapi.projectRoots.ui.PathEditor;
import com.intellij.openapi.projectRoots.ui.SdkPathEditor;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ui.OrderRootTypeUIFactory;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.TabbedPaneWrapper;
import com.intellij.ui.navigation.History;
import com.intellij.ui.navigation.Place;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SdkEditor
implements Configurable,
Place.Navigator {
    private static final Logger n = Logger.getInstance((String)"#com.intellij.openapi.projectRoots.ui.SdkEditor");
    private static final String e = "sdkTab";
    private Sdk f;
    private final Map<OrderRootType, SdkPathEditor> r = new HashMap<OrderRootType, SdkPathEditor>();
    private TextFieldWithBrowseButton p;
    private final Map<SdkType, List<AdditionalDataConfigurable>> j = new HashMap<SdkType, List<AdditionalDataConfigurable>>();
    private final Map<AdditionalDataConfigurable, JComponent> a = new HashMap<AdditionalDataConfigurable, JComponent>();
    private JPanel c;
    private final SdkModificator b = new EditedSdkModificator();
    private JPanel h;
    private TabbedPaneWrapper s;
    private final Project o;
    private final SdkModel g;
    private JLabel l;
    private String k;
    private String m;
    private String q;
    private final History d;
    private final Disposable i = Disposer.newDisposable();

    public SdkEditor(Project project2, SdkModel sdkModel, History history, ProjectJdkImpl projectJdkImpl) {
        this.o = project2;
        this.g = sdkModel;
        this.d = history;
        this.f = projectJdkImpl;
        this.c();
        this.b((Sdk)projectJdkImpl);
    }

    private void b(Sdk sdk) {
        this.f = sdk;
        if (this.f != null) {
            this.m = this.f.getName();
            this.q = this.f.getHomePath();
        } else {
            this.m = "";
            this.q = "";
        }
        for (AdditionalDataConfigurable additionalDataConfigurable : this.e()) {
            additionalDataConfigurable.setSdk(sdk);
        }
        if (this.h != null) {
            this.reset();
        }
    }

    public String getDisplayName() {
        return ProjectBundle.message((String)"sdk.configure.editor.title", (Object[])new Object[0]);
    }

    public String getHelpTopic() {
        return null;
    }

    public JComponent createComponent() {
        return this.h;
    }

    private void c() {
        this.h = new JPanel(new GridBagLayout());
        this.s = new TabbedPaneWrapper(this.i);
        for (OrderRootType orderRootType : OrderRootType.getAllTypes()) {
            SdkPathEditor sdkPathEditor;
            if (this.f != null && !this.showTabForType(orderRootType) || (sdkPathEditor = ((OrderRootTypeUIFactory)OrderRootTypeUIFactory.FACTORY.getByKey((Object)orderRootType)).createPathEditor(this.f)) == null) continue;
            sdkPathEditor.setAddBaseDir(this.f.getHomeDirectory());
            this.s.addTab(sdkPathEditor.getDisplayName(), sdkPathEditor.createComponent());
            this.r.put(orderRootType, sdkPathEditor);
        }
        this.s.addChangeListener(changeEvent -> this.d.pushQueryPlace());
        this.p = this.createHomeComponent();
        this.p.getTextField().setEditable(false);
        this.l = new JLabel(this.g());
        this.h.add((Component)this.l, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, (Insets)JBUI.insets((int)2, (int)10, (int)2, (int)2), 0, 0));
        this.h.add((Component)this.p, new GridBagConstraints(1, -1, 1, 1, 1.0, 0.0, 10, 2, (Insets)JBUI.insets((int)2, (int)2, (int)2, (int)10), 0, 0));
        this.c = new JPanel(new BorderLayout());
        this.h.add((Component)this.c, new GridBagConstraints(0, -1, 2, 1, 1.0, 0.0, 10, 1, (Insets)JBUI.insets((int)2, (int)10, (int)0, (int)10), 0, 0));
        this.h.add((Component)this.s.getComponent(), new GridBagConstraints(0, -1, 2, 1, 1.0, 1.0, 10, 1, (Insets)JBUI.insetsTop((int)2), 0, 0));
    }

    protected TextFieldWithBrowseButton createHomeComponent() {
        return new TextFieldWithBrowseButton(actionEvent -> this.a());
    }

    protected boolean showTabForType(@NotNull OrderRootType orderRootType) {
        if (orderRootType == null) {
            SdkEditor.a(0);
        }
        return ((SdkType)this.f.getSdkType()).isRootTypeApplicable(orderRootType);
    }

    private String g() {
        return this.f != null ? ((SdkType)this.f.getSdkType()).getHomeFieldLabel() : ProjectBundle.message((String)"sdk.configure.general.home.path", (Object[])new Object[0]);
    }

    public boolean isModified() {
        boolean bl2 = !Comparing.equal((String)(this.f == null ? null : this.f.getName()), (String)this.m);
        bl2 = bl2 || !Comparing.equal((String)FileUtil.toSystemIndependentName((String)this.d()), (String)FileUtil.toSystemIndependentName((String)this.q));
        for (PathEditor pathEditor : this.r.values()) {
            bl2 = bl2 || pathEditor.isModified();
        }
        for (AdditionalDataConfigurable additionalDataConfigurable : this.e()) {
            bl2 = bl2 || additionalDataConfigurable.isModified();
        }
        return bl2;
    }

    public void apply() throws ConfigurationException {
        if (!Comparing.equal((String)this.m, (String)(this.f == null ? "" : this.f.getName())) && (this.f == null || this.f.getName().isEmpty())) {
            throw new ConfigurationException(ProjectBundle.message((String)"sdk.list.name.required.error", (Object[])new Object[0]));
        }
        if (this.f != null) {
            this.m = this.f.getName();
            this.q = this.f.getHomePath();
            SdkModificator sdkModificator = this.f.getSdkModificator();
            sdkModificator.setHomePath(FileUtil.toSystemDependentName((String)this.d()));
            for (SdkPathEditor sdkPathEditor : this.r.values()) {
                sdkPathEditor.apply(sdkModificator);
            }
            ApplicationManager.getApplication().runWriteAction(() -> ((SdkModificator)sdkModificator).commitChanges());
            for (AdditionalDataConfigurable additionalDataConfigurable : this.e()) {
                if (additionalDataConfigurable == null) continue;
                additionalDataConfigurable.apply();
            }
        }
    }

    public void reset() {
        if (this.f == null) {
            this.a("");
            for (SdkPathEditor sdkPathEditor : this.r.values()) {
                sdkPathEditor.reset(null);
            }
        } else {
            SdkModificator sdkModificator = this.f.getSdkModificator();
            for (OrderRootType orderRootType : this.r.keySet()) {
                this.r.get(orderRootType).reset(sdkModificator);
            }
            sdkModificator.commitChanges();
            this.a(FileUtil.toSystemDependentName((String)((String)ObjectUtils.notNull((Object)this.f.getHomePath(), (Object)""))));
        }
        this.k = null;
        this.l.setText(this.g());
        this.b();
        for (AdditionalDataConfigurable additionalDataConfigurable : this.e()) {
            additionalDataConfigurable.reset();
        }
        this.p.setEnabled(this.f != null);
        for (int i2 = 0; i2 < this.s.getTabCount(); ++i2) {
            this.s.setEnabledAt(i2, this.f != null);
        }
    }

    public void disposeUIResources() {
        for (SdkType sdkType : this.j.keySet()) {
            for (AdditionalDataConfigurable additionalDataConfigurable : this.j.get(sdkType)) {
                additionalDataConfigurable.disposeUIResources();
            }
        }
        this.j.clear();
        this.a.clear();
        Disposer.dispose((Disposable)this.i);
    }

    private String d() {
        return this.p.getText().trim();
    }

    private void f() {
        for (PathEditor pathEditor : this.r.values()) {
            pathEditor.clearList();
        }
    }

    private void a(String string) {
        Color color;
        this.p.setText(string);
        if (string != null && !string.isEmpty() && this.f != null && this.f.getSdkType().isLocalSdk(this.f)) {
            File file = new File(string);
            boolean bl2 = ((SdkType)this.f.getSdkType()).getHomeChooserDescriptor().isChooseFolders();
            color = file.exists() && file.isDirectory() == bl2 ? UIUtil.getFieldForegroundColor() : PathEditor.INVALID_COLOR;
        } else {
            color = UIUtil.getFieldForegroundColor();
        }
        this.p.getTextField().setForeground(color);
    }

    private void a() {
        SdkType sdkType = (SdkType)this.f.getSdkType();
        SdkConfigurationUtil.selectSdkHome((SdkType)sdkType, string -> this.a((String)string, sdkType));
    }

    private void a(String string, SdkType sdkType) {
        if (string == null) {
            return;
        }
        this.a(string.replace('/', File.separatorChar));
        String string2 = this.b(string);
        ((ProjectJdkImpl)this.f).setName(string2);
        try {
            Sdk sdk = (Sdk)this.f.clone();
            SdkModificator sdkModificator = sdk.getSdkModificator();
            sdkModificator.setHomePath(string);
            sdkModificator.removeAllRoots();
            sdkModificator.commitChanges();
            sdkType.setupSdkPaths(sdk, this.g);
            this.f();
            this.k = sdk.getVersionString();
            if (this.k == null) {
                Messages.showMessageDialog((String)ProjectBundle.message((String)"sdk.java.corrupt.error", (Object[])new Object[]{string}), (String)ProjectBundle.message((String)"sdk.java.corrupt.title", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
            }
            sdkModificator = sdk.getSdkModificator();
            for (OrderRootType orderRootType : this.r.keySet()) {
                SdkPathEditor sdkPathEditor = this.r.get(orderRootType);
                sdkPathEditor.setAddBaseDir(sdk.getHomeDirectory());
                sdkPathEditor.addPaths(sdkModificator.getRoots(orderRootType));
            }
            this.g.getMulticaster().sdkHomeSelected(sdk, string);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            n.error((Throwable)cloneNotSupportedException);
        }
    }

    private String b(String string) {
        Sdk[] sdkArray;
        String string2;
        String string3 = this.f.getName();
        if (Comparing.equal((String)string3, (String)(string2 = ((SdkType)this.f.getSdkType()).suggestSdkName(string3, string)))) {
            return string3;
        }
        String string4 = string2;
        HashSet<String> hashSet = new HashSet<String>();
        for (Sdk sdk : sdkArray = this.g.getSdks()) {
            hashSet.add(sdk.getName());
        }
        int n2 = 0;
        while (hashSet.contains(string4)) {
            string4 = string2 + " (" + ++n2 + ")";
        }
        return string4;
    }

    private void b() {
        this.c.removeAll();
        for (AdditionalDataConfigurable additionalDataConfigurable : this.e()) {
            JComponent jComponent = this.a.get(additionalDataConfigurable);
            if (jComponent == null) {
                jComponent = additionalDataConfigurable.createComponent();
                this.a.put(additionalDataConfigurable, jComponent);
            }
            if (jComponent == null) continue;
            if (additionalDataConfigurable.getTabName() != null) {
                for (int i2 = 0; i2 < this.s.getTabCount(); ++i2) {
                    if (!additionalDataConfigurable.getTabName().equals(this.s.getTitleAt(i2))) continue;
                    this.s.removeTabAt(i2);
                }
                this.s.addTab(additionalDataConfigurable.getTabName(), jComponent);
                continue;
            }
            this.c.add((Component)jComponent, "Center");
        }
    }

    @NotNull
    private List<AdditionalDataConfigurable> e() {
        if (this.f == null) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                SdkEditor.a(1);
            }
            return list2;
        }
        List<AdditionalDataConfigurable> list3 = this.a(this.f);
        if (list3 == null) {
            SdkEditor.a(2);
        }
        return list3;
    }

    @NotNull
    private List<AdditionalDataConfigurable> a(Sdk sdk) {
        SdkType sdkType = (SdkType)sdk.getSdkType();
        ArrayList arrayList = this.j.get(sdkType);
        if (arrayList == null) {
            arrayList = Lists.newArrayList();
            this.j.put(sdkType, arrayList);
            AdditionalDataConfigurable additionalDataConfigurable = sdkType.createAdditionalDataConfigurable(this.g, this.b);
            if (additionalDataConfigurable != null) {
                arrayList.add(additionalDataConfigurable);
            }
            for (SdkEditorAdditionalOptionsProvider sdkEditorAdditionalOptionsProvider : SdkEditorAdditionalOptionsProvider.getSdkOptionsFactory(this.f.getSdkType())) {
                AdditionalDataConfigurable additionalDataConfigurable2 = sdkEditorAdditionalOptionsProvider.createOptions(this.o, this.f);
                if (additionalDataConfigurable2 == null) continue;
                arrayList.add(additionalDataConfigurable2);
            }
        }
        ArrayList arrayList2 = arrayList;
        if (arrayList2 == null) {
            SdkEditor.a(3);
        }
        return arrayList2;
    }

    public ActionCallback navigateTo(@Nullable Place place, boolean bl2) {
        if (place == null) {
            return ActionCallback.DONE;
        }
        this.s.setSelectedTitle((String)place.getPath(e));
        return ActionCallback.DONE;
    }

    public void queryPlace(@NotNull Place place) {
        if (place == null) {
            SdkEditor.a(4);
        }
        place.putPath(e, (Object)this.s.getSelectedTitle());
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/projectRoots/ui/SdkEditor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/projectRoots/ui/SdkEditor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalDataConfigurable";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "initAdditionalDataConfigurable";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "showTabForType";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "queryPlace";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class EditedSdkModificator
    implements SdkModificator {
        private EditedSdkModificator() {
        }

        public String getName() {
            return SdkEditor.this.f.getName();
        }

        public void setName(String string) {
            ((ProjectJdkImpl)SdkEditor.this.f).setName(string);
        }

        public String getHomePath() {
            return SdkEditor.this.d();
        }

        public void setHomePath(String string) {
            SdkEditor.this.a(string, (SdkType)SdkEditor.this.f.getSdkType());
        }

        public String getVersionString() {
            return SdkEditor.this.k != null ? SdkEditor.this.k : SdkEditor.this.f.getVersionString();
        }

        public void setVersionString(String string) {
            throw new UnsupportedOperationException();
        }

        public SdkAdditionalData getSdkAdditionalData() {
            return SdkEditor.this.f.getSdkAdditionalData();
        }

        public void setSdkAdditionalData(SdkAdditionalData sdkAdditionalData) {
            throw new UnsupportedOperationException();
        }

        @NotNull
        public VirtualFile[] getRoots(@NotNull OrderRootType orderRootType) {
            PathEditor pathEditor;
            if (orderRootType == null) {
                EditedSdkModificator.a(0);
            }
            if ((pathEditor = (PathEditor)SdkEditor.this.r.get(orderRootType)) == null) {
                throw new IllegalStateException("no editor for root type " + orderRootType);
            }
            VirtualFile[] virtualFileArray = pathEditor.getRoots();
            if (virtualFileArray == null) {
                EditedSdkModificator.a(1);
            }
            return virtualFileArray;
        }

        public void addRoot(@NotNull VirtualFile virtualFile, @NotNull OrderRootType orderRootType) {
            if (virtualFile == null) {
                EditedSdkModificator.a(2);
            }
            if (orderRootType == null) {
                EditedSdkModificator.a(3);
            }
            ((SdkPathEditor)SdkEditor.this.r.get(orderRootType)).addPaths(new VirtualFile[]{virtualFile});
        }

        public void removeRoot(@NotNull VirtualFile virtualFile, @NotNull OrderRootType orderRootType) {
            if (virtualFile == null) {
                EditedSdkModificator.a(4);
            }
            if (orderRootType == null) {
                EditedSdkModificator.a(5);
            }
            ((SdkPathEditor)SdkEditor.this.r.get(orderRootType)).removePaths(new VirtualFile[]{virtualFile});
        }

        public void removeRoots(@NotNull OrderRootType orderRootType) {
            if (orderRootType == null) {
                EditedSdkModificator.a(6);
            }
            ((SdkPathEditor)SdkEditor.this.r.get(orderRootType)).clearList();
        }

        public void removeAllRoots() {
            for (PathEditor pathEditor : SdkEditor.this.r.values()) {
                pathEditor.clearList();
            }
        }

        public void commitChanges() {
        }

        public boolean isWritable() {
            return true;
        }

        private static /* synthetic */ void a(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 1: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rootType";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/projectRoots/ui/SdkEditor$EditedSdkModificator";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/projectRoots/ui/SdkEditor$EditedSdkModificator";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRoots";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getRoots";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "addRoot";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "removeRoot";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "removeRoots";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

