/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.facet.impl.ProjectFacetsConfigurator;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleConfigurationEditor;
import com.intellij.openapi.module.impl.ModuleConfigurationStateImpl;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.ModuleConfigurableEP;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import com.intellij.openapi.roots.impl.ModuleRootManagerImpl;
import com.intellij.openapi.roots.impl.RootConfigurationAccessor;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.ui.configuration.FacetsProvider;
import com.intellij.openapi.roots.ui.configuration.ModificationOfImportedModelWarningComponent;
import com.intellij.openapi.roots.ui.configuration.ModuleConfigurableWrapper;
import com.intellij.openapi.roots.ui.configuration.ModuleConfigurationEditorProvider;
import com.intellij.openapi.roots.ui.configuration.ModuleConfigurationEditorProviderEx;
import com.intellij.openapi.roots.ui.configuration.ModuleConfigurationState;
import com.intellij.openapi.roots.ui.configuration.ModuleElementsEditor;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.roots.ui.configuration.UIRootConfigurationAccessor;
import com.intellij.ui.navigation.History;
import com.intellij.ui.navigation.Place;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ModuleEditor
implements Place.Navigator,
Disposable {
    private static final Logger i = Logger.getInstance(ModuleEditor.class);
    private static final ExtensionPointName<ModuleConfigurableEP> b = ExtensionPointName.create((String)"com.intellij.moduleConfigurable");
    public static final String SELECTED_EDITOR_NAME = "selectedEditor";
    private final Project l;
    private JPanel h;
    private ModificationOfImportedModelWarningComponent e;
    private ModifiableRootModel m;
    private final ModulesProvider f;
    private String j;
    private final Module a;
    protected final List<ModuleConfigurationEditor> myEditors;
    private ModifiableRootModel d;
    private final EventDispatcher<ChangeListener> c;
    @NonNls
    private static final String g = "commit";
    private boolean n;
    protected History myHistory;
    private static Set<Class<?>> k = new HashSet();

    public ModuleEditor(Project project2, ModulesProvider modulesProvider, @NotNull Module module2) {
        if (module2 == null) {
            ModuleEditor.a(0);
        }
        this.myEditors = new ArrayList<ModuleConfigurationEditor>();
        this.c = EventDispatcher.create(ChangeListener.class);
        this.l = project2;
        this.f = modulesProvider;
        this.a = module2;
        this.j = module2.getName();
    }

    public void init(History history) {
        this.myHistory = history;
        for (ModuleConfigurationEditor moduleConfigurationEditor : this.myEditors) {
            if (!(moduleConfigurationEditor instanceof ModuleElementsEditor)) continue;
            ((ModuleElementsEditor)moduleConfigurationEditor).setHistory(this.myHistory);
        }
        this.restoreSelectedEditor();
    }

    public abstract ProjectFacetsConfigurator getFacetsConfigurator();

    protected abstract JComponent createCenterPanel();

    @Nullable
    public abstract ModuleConfigurationEditor getSelectedEditor();

    public abstract void selectEditor(String var1);

    protected abstract void restoreSelectedEditor();

    @Nullable
    public abstract ModuleConfigurationEditor getEditor(@NotNull String var1);

    protected abstract void disposeCenterPanel();

    public void addChangeListener(ChangeListener changeListener) {
        this.c.addListener((EventListener)changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.c.removeListener((EventListener)changeListener);
    }

    @Nullable
    public Module getModule() {
        Module[] moduleArray;
        for (Module module2 : moduleArray = this.f.getModules()) {
            if (module2 != this.a) continue;
            return this.a;
        }
        return this.f.getModule(this.j);
    }

    public ModifiableRootModel getModifiableRootModel() {
        Module module2;
        if (this.m == null && (module2 = this.getModule()) != null) {
            this.m = ((ModuleRootManagerImpl)ModuleRootManager.getInstance((Module)module2)).getModifiableModel((RootConfigurationAccessor)new UIRootConfigurationAccessor(this.l));
        }
        return this.m;
    }

    public OrderEntry[] getOrderEntries() {
        if (this.m == null) {
            return ModuleRootManager.getInstance((Module)this.getModule()).getOrderEntries();
        }
        return this.m.getOrderEntries();
    }

    public ModifiableRootModel getModifiableRootModelProxy() {
        ModifiableRootModel modifiableRootModel;
        if (this.d == null && (modifiableRootModel = this.getModifiableRootModel()) != null) {
            this.d = (ModifiableRootModel)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{ModifiableRootModel.class}, (InvocationHandler)new ModifiableRootModelInvocationHandler(modifiableRootModel));
        }
        return this.d;
    }

    public ModuleRootModel getRootModel() {
        if (this.m != null) {
            return this.getModifiableRootModelProxy();
        }
        return ModuleRootManager.getInstance((Module)this.a);
    }

    public boolean isModified() {
        for (ModuleConfigurationEditor moduleConfigurationEditor : this.myEditors) {
            if (!moduleConfigurationEditor.isModified()) continue;
            return true;
        }
        return false;
    }

    private void a(@Nullable Module module2) {
        ModuleConfigurationEditor[] moduleConfigurationEditorArray;
        if (module2 == null) {
            return;
        }
        ModuleConfigurationState moduleConfigurationState = this.createModuleConfigurationState();
        for (ModuleConfigurationEditorProvider object : ModuleEditor.b(module2)) {
            moduleConfigurationEditorArray = object.createEditors(moduleConfigurationState);
            if (moduleConfigurationEditorArray.length > 0 && object instanceof ModuleConfigurationEditorProviderEx && ((ModuleConfigurationEditorProviderEx)object).isCompleteEditorSet()) {
                this.myEditors.clear();
                ContainerUtil.addAll(this.myEditors, (Object[])moduleConfigurationEditorArray);
                break;
            }
            ContainerUtil.addAll(this.myEditors, (Object[])moduleConfigurationEditorArray);
        }
        for (Configurable configurable : ServiceKt.getComponents((ComponentManager)module2, Configurable.class)) {
            ModuleEditor.a(configurable.getClass());
            this.myEditors.add(new ModuleConfigurableWrapper(configurable));
        }
        for (ModuleConfigurableEP moduleConfigurableEP : (ModuleConfigurableEP[])module2.getExtensions(b)) {
            if (!moduleConfigurableEP.canCreateConfigurable() || (moduleConfigurationEditorArray = (ModuleConfigurationEditor[])moduleConfigurableEP.createConfigurable()) == null) continue;
            ModuleEditor.a(moduleConfigurationEditorArray.getClass());
            this.myEditors.add(new ModuleConfigurableWrapper((Configurable)moduleConfigurationEditorArray));
        }
        for (ModuleConfigurationEditor moduleConfigurationEditor : this.myEditors) {
            if (!(moduleConfigurationEditor instanceof ModuleElementsEditor)) continue;
            ((ModuleElementsEditor)moduleConfigurationEditor).addListener(this::a);
        }
    }

    private static void a(Class<?> clazz) {
        if (k.add(clazz)) {
            i.warn(clazz.getName() + " uses deprecated way to register itself as a module editor. " + ModuleConfigurationEditorProvider.class.getName() + " extension point should be used instead");
        }
    }

    private static ModuleConfigurationEditorProvider[] b(@NotNull Module module2) {
        if (module2 == null) {
            ModuleEditor.a(1);
        }
        ArrayList arrayList = new ArrayList(ServiceKt.getComponents((ComponentManager)module2, ModuleConfigurationEditorProvider.class));
        for (ModuleConfigurationEditorProvider moduleConfigurationEditorProvider : arrayList) {
            ModuleEditor.a(moduleConfigurationEditorProvider.getClass());
        }
        ContainerUtil.addAll(arrayList, (Object[])Extensions.getExtensions((ExtensionPointName)ModuleConfigurationEditorProvider.EP_NAME, (AreaInstance)module2));
        return arrayList.toArray(new ModuleConfigurationEditorProvider[0]);
    }

    public ModuleConfigurationState createModuleConfigurationState() {
        return new ModuleConfigurationStateImpl(this.l, this.f){

            public ModifiableRootModel getRootModel() {
                return ModuleEditor.this.getModifiableRootModelProxy();
            }

            public FacetsProvider getFacetsProvider() {
                return ModuleEditor.this.getFacetsConfigurator();
            }
        };
    }

    private JPanel b() {
        this.getModifiableRootModel();
        this.getModifiableRootModelProxy();
        this.h = new ModuleEditorPanel();
        this.a(this.getModule());
        JComponent jComponent = this.createCenterPanel();
        this.h.add((Component)jComponent, "Center");
        this.e = new ModificationOfImportedModelWarningComponent();
        this.h.add((Component)this.e.getLabel(), "South");
        this.a();
        this.n = true;
        return this.h;
    }

    public JPanel getPanel() {
        if (this.h == null) {
            this.h = this.b();
        }
        return this.h;
    }

    public void moduleCountChanged() {
        this.a(false);
    }

    private void a(boolean bl2) {
        if (this.getModule() != null) {
            if (this.n || bl2) {
                this.getPanel();
                for (ModuleConfigurationEditor moduleConfigurationEditor : this.myEditors) {
                    moduleConfigurationEditor.moduleStateChanged();
                }
                this.a();
            }
            ((ChangeListener)this.c.getMulticaster()).moduleStateChanged(this.getModifiableRootModelProxy());
        }
    }

    private void a() {
        if (!this.n) {
            return;
        }
        ProjectModelExternalSource projectModelExternalSource = ModuleRootManager.getInstance((Module)this.a).getExternalSource();
        if (projectModelExternalSource != null && this.isModified()) {
            this.e.showWarning("Module '" + this.a.getName() + "'", projectModelExternalSource);
        } else {
            this.e.hideWarning();
        }
    }

    public void updateCompilerOutputPathChanged(String string, String string2) {
        if (this.h == null) {
            return;
        }
        for (ModuleConfigurationEditor moduleConfigurationEditor : this.myEditors) {
            if (!(moduleConfigurationEditor instanceof ModuleElementsEditor)) continue;
            ((ModuleElementsEditor)moduleConfigurationEditor).moduleCompileOutputChanged(string, string2);
        }
    }

    public void dispose() {
        try {
            for (ModuleConfigurationEditor moduleConfigurationEditor : this.myEditors) {
                moduleConfigurationEditor.disposeUIResources();
            }
            this.myEditors.clear();
            this.disposeCenterPanel();
            if (this.m != null) {
                this.m.dispose();
            }
            this.h = null;
        }
        finally {
            this.resetModifiableModel();
        }
    }

    public ModifiableRootModel apply() throws ConfigurationException {
        for (ModuleConfigurationEditor moduleConfigurationEditor : this.myEditors) {
            moduleConfigurationEditor.saveData();
            moduleConfigurationEditor.apply();
        }
        return this.m;
    }

    void resetModifiableModel() {
        this.m = null;
        this.d = null;
    }

    public void canApply() throws ConfigurationException {
        for (ModuleConfigurationEditor moduleConfigurationEditor : this.myEditors) {
            if (!(moduleConfigurationEditor instanceof ModuleElementsEditor)) continue;
            ((ModuleElementsEditor)moduleConfigurationEditor).canApply();
        }
    }

    public String getName() {
        return this.j;
    }

    private static Object[] a(Object[] objectArray) {
        if (objectArray == null || objectArray.length == 0) {
            return objectArray;
        }
        Object[] objectArray2 = new Object[objectArray.length];
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            InvocationHandler invocationHandler;
            Object object = objectArray[i2];
            if (object != null && Proxy.isProxyClass(object.getClass()) && (invocationHandler = Proxy.getInvocationHandler(object)) instanceof ProxyDelegateAccessor) {
                object = ((ProxyDelegateAccessor)((Object)invocationHandler)).getDelegate();
            }
            objectArray2[i2] = object;
        }
        return objectArray2;
    }

    @Nullable
    public String getHelpTopic() {
        if (this.myEditors.isEmpty()) {
            return null;
        }
        ModuleConfigurationEditor moduleConfigurationEditor = this.getSelectedEditor();
        return moduleConfigurationEditor != null ? moduleConfigurationEditor.getHelpTopic() : null;
    }

    public void setModuleName(String string) {
        this.j = string;
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "module";
        objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/ModuleEditor";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "collectProviders";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class ModuleEditorPanel
    extends JPanel
    implements DataProvider {
        public ModuleEditorPanel() {
            super(new BorderLayout());
        }

        public Object getData(String string) {
            if (LangDataKeys.MODULE_CONTEXT.is(string)) {
                return ModuleEditor.this.getModule();
            }
            return null;
        }
    }

    public static interface ProxyDelegateAccessor {
        public Object getDelegate();
    }

    private class LibraryTableModelInvocationHandler
    implements InvocationHandler,
    ProxyDelegateAccessor {
        private final LibraryTable.ModifiableModel a;

        LibraryTableModelInvocationHandler(LibraryTable.ModifiableModel modifiableModel) {
            this.a = modifiableModel;
        }

        @Override
        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            boolean bl2 = ModuleEditor.g.equals(method.getName());
            try {
                Object object2;
                Object object3 = method.invoke((Object)this.a, ModuleEditor.a(objectArray));
                if (object3 instanceof Library[]) {
                    object2 = (Library[])object3;
                    for (int i2 = 0; i2 < ((Library[])object2).length; ++i2) {
                        Library library = object2[i2];
                        object2[i2] = (Library)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{LibraryEx.class}, (InvocationHandler)new LibraryInvocationHandler(library));
                    }
                }
                if (object3 instanceof Library) {
                    object3 = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{LibraryEx.class}, (InvocationHandler)new LibraryInvocationHandler((Library)object3));
                }
                object2 = object3;
                return object2;
            }
            catch (InvocationTargetException invocationTargetException) {
                throw invocationTargetException.getCause();
            }
            finally {
                if (bl2) {
                    ModuleEditor.this.a(true);
                }
            }
        }

        @Override
        public Object getDelegate() {
            return this.a;
        }
    }

    private class LibraryModifiableModelInvocationHandler
    implements InvocationHandler,
    ProxyDelegateAccessor {
        private final Library.ModifiableModel a;

        LibraryModifiableModelInvocationHandler(Library.ModifiableModel modifiableModel) {
            this.a = modifiableModel;
        }

        @Override
        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            boolean bl2 = ModuleEditor.g.equals(method.getName());
            try {
                Object object2 = method.invoke((Object)this.a, ModuleEditor.a(objectArray));
                return object2;
            }
            catch (InvocationTargetException invocationTargetException) {
                throw invocationTargetException.getCause();
            }
            finally {
                if (bl2) {
                    ModuleEditor.this.a(true);
                }
            }
        }

        @Override
        public Object getDelegate() {
            return this.a;
        }
    }

    private class LibraryInvocationHandler
    implements InvocationHandler,
    ProxyDelegateAccessor {
        private final Library a;

        LibraryInvocationHandler(Library library) {
            this.a = library;
        }

        @Override
        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            try {
                Object object2 = method.invoke((Object)this.a, ModuleEditor.a(objectArray));
                if (object2 instanceof LibraryEx.ModifiableModelEx) {
                    return Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{LibraryEx.ModifiableModelEx.class}, (InvocationHandler)new LibraryModifiableModelInvocationHandler((Library.ModifiableModel)((LibraryEx.ModifiableModelEx)object2)));
                }
                return object2;
            }
            catch (InvocationTargetException invocationTargetException) {
                throw invocationTargetException.getCause();
            }
        }

        @Override
        public Object getDelegate() {
            return this.a;
        }
    }

    private class LibraryTableInvocationHandler
    implements InvocationHandler,
    ProxyDelegateAccessor {
        private final LibraryTable b;
        @NonNls
        private final Set<String> a = new THashSet(Collections.singletonList("removeLibrary"));

        LibraryTableInvocationHandler(LibraryTable libraryTable) {
            this.b = libraryTable;
        }

        @Override
        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            boolean bl2 = this.a.contains(method.getName());
            try {
                Library[] libraryArray;
                Library[] libraryArray2 = method.invoke((Object)this.b, ModuleEditor.a(objectArray));
                if (libraryArray2 instanceof Library) {
                    Object object2 = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{libraryArray2 instanceof LibraryEx ? LibraryEx.class : Library.class}, (InvocationHandler)new LibraryInvocationHandler((Library)libraryArray2));
                    return object2;
                }
                if (libraryArray2 instanceof LibraryTable.ModifiableModel) {
                    Object object3 = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{LibraryTable.ModifiableModel.class}, (InvocationHandler)new LibraryTableModelInvocationHandler((LibraryTable.ModifiableModel)libraryArray2));
                    return object3;
                }
                if (libraryArray2 instanceof Library[]) {
                    libraryArray = libraryArray2;
                    for (int i2 = 0; i2 < libraryArray.length; ++i2) {
                        Library library = libraryArray[i2];
                        libraryArray[i2] = (Library)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{library instanceof LibraryEx ? LibraryEx.class : Library.class}, (InvocationHandler)new LibraryInvocationHandler(library));
                    }
                }
                libraryArray = libraryArray2;
                return libraryArray;
            }
            catch (InvocationTargetException invocationTargetException) {
                throw invocationTargetException.getCause();
            }
            finally {
                if (bl2) {
                    ModuleEditor.this.a(true);
                }
            }
        }

        @Override
        public Object getDelegate() {
            return this.b;
        }
    }

    private class ModifiableRootModelInvocationHandler
    implements InvocationHandler,
    ProxyDelegateAccessor {
        private final ModifiableRootModel b;
        @NonNls
        private final Set<String> a = new HashSet<String>(Arrays.asList("addOrderEntry", "addLibraryEntry", "addInvalidLibrary", "addModuleOrderEntry", "addInvalidModuleEntry", "removeOrderEntry", "setSdk", "inheritSdk", "inheritCompilerOutputPath", "setExcludeOutput", "replaceEntryOfType", "rearrangeOrderEntries"));

        ModifiableRootModelInvocationHandler(ModifiableRootModel modifiableRootModel) {
            this.b = modifiableRootModel;
        }

        @Override
        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            boolean bl2 = this.a.contains(method.getName());
            try {
                Object object2 = method.invoke((Object)this.b, ModuleEditor.a(objectArray));
                if (object2 instanceof LibraryTable) {
                    Object object3 = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{LibraryTable.class}, (InvocationHandler)new LibraryTableInvocationHandler((LibraryTable)object2));
                    return object3;
                }
                Object object4 = object2;
                return object4;
            }
            catch (InvocationTargetException invocationTargetException) {
                throw invocationTargetException.getCause();
            }
            finally {
                if (bl2) {
                    ModuleEditor.this.a(true);
                }
            }
        }

        @Override
        public Object getDelegate() {
            return this.b;
        }
    }

    public static interface ChangeListener
    extends EventListener {
        public void moduleStateChanged(ModifiableRootModel var1);
    }
}

