/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ui.configuration.ClasspathEditor;
import com.intellij.openapi.roots.ui.configuration.JdkComboBox;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ModuleStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ModuleProjectStructureElement;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public abstract class ModuleJdkConfigurable
implements Disposable {
    private JdkComboBox b;
    private JPanel c;
    private ClasspathEditor e;
    private final ProjectSdksModel a;
    private boolean f = false;
    private final SdkModel.Listener d = new SdkModel.Listener(){

        public void sdkAdded(Sdk sdk) {
            ModuleJdkConfigurable.this.c();
        }

        public void beforeSdkRemove(Sdk sdk) {
            ModuleJdkConfigurable.this.c();
        }

        public void sdkChanged(Sdk sdk, String string) {
            ModuleJdkConfigurable.this.c();
        }

        public void sdkHomeSelected(Sdk sdk, String string) {
            ModuleJdkConfigurable.this.c();
        }
    };

    public ModuleJdkConfigurable(ClasspathEditor classpathEditor, ProjectSdksModel projectSdksModel) {
        this.e = classpathEditor;
        this.a = projectSdksModel;
        this.a.addListener(this.d);
        this.d();
    }

    public JComponent createComponent() {
        return this.c;
    }

    private void c() {
        this.f = true;
        this.b.reloadModel(new JdkComboBox.ProjectJdkComboBoxItem(), this.getRootModel().getModule().getProject());
        this.reset();
        this.f = false;
    }

    protected abstract ModifiableRootModel getRootModel();

    private void d() {
        this.c = new JPanel(new GridBagLayout());
        this.b = new JdkComboBox(this.a);
        this.b.insertItemAt(new JdkComboBox.ProjectJdkComboBoxItem(), 0);
        this.b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ModuleJdkConfigurable.this.f) {
                    return;
                }
                Sdk sdk = ModuleJdkConfigurable.this.b.getSelectedJdk();
                ModuleJdkConfigurable.this.e.setSdk(sdk);
                ModuleJdkConfigurable.this.a();
            }
        });
        this.c.add((Component)new JLabel(ProjectBundle.message((String)"module.libraries.target.jdk.module.radio", (Object[])new Object[0])), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, (Insets)JBUI.insetsRight((int)6), 0, 0));
        this.c.add((Component)((Object)this.b), new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 10, 0, (Insets)JBUI.insetsRight((int)4), 0, 0));
        Project project2 = this.getRootModel().getModule().getProject();
        JButton jButton = new JButton(ApplicationBundle.message((String)"button.new", (Object[])new Object[0]));
        this.b.setSetupButton(jButton, project2, this.a, (JdkComboBox.JdkComboBoxItem)new JdkComboBox.ProjectJdkComboBoxItem(), (Condition<Sdk>)((Condition)sdk -> {
            int n2;
            Sdk sdk2 = this.a.getProjectSdk();
            if (sdk2 == null && (n2 = Messages.showYesNoDialog((Component)this.c, (String)ProjectBundle.message((String)"project.roots.no.jdk.on.project.message", (Object[])new Object[0]), (String)ProjectBundle.message((String)"project.roots.no.jdk.on.project.title", (Object[])new Object[0]), (Icon)Messages.getInformationIcon())) == 0) {
                this.a.setProjectSdk(sdk);
                return true;
            }
            return false;
        }), true);
        this.c.add((Component)jButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, (Insets)JBUI.insetsRight((int)4), 0, 0));
        JButton jButton2 = new JButton(ApplicationBundle.message((String)"button.edit", (Object[])new Object[0]));
        this.b.setEditButton(jButton2, this.getRootModel().getModule().getProject(), (Computable<Sdk>)((Computable)() -> this.getRootModel().getSdk()));
        this.c.add((Component)jButton2, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 17, 0, (Insets)JBUI.emptyInsets(), 0, 0));
        this.c.setBorder(JBUI.Borders.empty((int)6));
    }

    private void a() {
        Module module2 = this.getRootModel().getModule();
        Project project2 = module2.getProject();
        StructureConfigurableContext structureConfigurableContext = ModuleStructureConfigurable.getInstance(project2).getContext();
        structureConfigurableContext.getDaemonAnalyzer().queueUpdate(new ModuleProjectStructureElement(structureConfigurableContext, module2));
    }

    public void reset() {
        this.f = true;
        String string = this.getRootModel().getSdkName();
        if (string != null && !this.getRootModel().isSdkInherited()) {
            Sdk sdk = this.a.findSdk(string);
            if (sdk != null) {
                this.b.setSelectedJdk(sdk);
            } else {
                this.b.setInvalidJdk(string);
                this.a();
            }
        } else {
            this.b.setSelectedJdk(null);
        }
        this.f = false;
    }

    public void dispose() {
        this.e = null;
        this.b = null;
        this.c = null;
        this.a.removeListener(this.d);
    }
}

