/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.core.JavaCoreBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.BrowseFilesListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.CompilerProjectExtension;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.impl.LanguageLevelProjectExtensionImpl;
import com.intellij.openapi.roots.ui.configuration.GeneralProjectSettingsElement;
import com.intellij.openapi.roots.ui.configuration.LanguageLevelCombo;
import com.intellij.openapi.roots.ui.configuration.ModuleEditor;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.roots.ui.configuration.ProjectJdkConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectStructureElementConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureDaemonAnalyzer;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.ui.DetailsComponent;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.project.ProjectKt;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.FieldPanel;
import com.intellij.ui.InsertPathAction;
import com.intellij.ui.components.fields.ExtendableTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectConfigurable
extends ProjectStructureElementConfigurable<Project>
implements DetailsComponent.Facade {
    private final Project h;
    private LanguageLevelCombo i;
    private ProjectJdkConfigurable j;
    private FieldPanel a;
    private JTextField f;
    private JPanel b;
    private final StructureConfigurableContext k;
    private final ModulesConfigurator c;
    private JPanel e;
    private boolean g = false;
    private DetailsComponent d;
    private final GeneralProjectSettingsElement l;

    public ProjectConfigurable(Project project2, StructureConfigurableContext structureConfigurableContext, ModulesConfigurator modulesConfigurator, ProjectSdksModel projectSdksModel) {
        this.h = project2;
        this.k = structureConfigurableContext;
        this.c = modulesConfigurator;
        this.b();
        this.l = new GeneralProjectSettingsElement(structureConfigurableContext);
        final ProjectStructureDaemonAnalyzer projectStructureDaemonAnalyzer = structureConfigurableContext.getDaemonAnalyzer();
        this.c.addAllModuleChangeListener(new ModuleEditor.ChangeListener(){

            @Override
            public void moduleStateChanged(ModifiableRootModel modifiableRootModel) {
                projectStructureDaemonAnalyzer.queueUpdate(ProjectConfigurable.this.l);
            }
        });
        this.a(projectSdksModel);
    }

    @Override
    public ProjectStructureElement getProjectStructureElement() {
        return this.l;
    }

    public DetailsComponent getDetailsComponent() {
        return this.d;
    }

    public JComponent createOptionsPanel() {
        this.d = new DetailsComponent(false, false);
        this.d.setContent((JComponent)this.b);
        this.d.setText(new String[]{this.getBannerSlogan()});
        this.j.createComponent();
        return this.d.getComponent();
    }

    private void a(ProjectSdksModel projectSdksModel) {
        this.b = new JPanel(new GridBagLayout());
        this.b.setPreferredSize((Dimension)JBUI.size((int)700, (int)500));
        if (ProjectKt.isDirectoryBased((Project)this.h)) {
            JPanel jPanel = new JPanel(new BorderLayout());
            JLabel jLabel = new JLabel("<html><body><b>Project name:</b></body></html>", 2);
            jPanel.add((Component)jLabel, "North");
            this.f = new JTextField();
            this.f.setColumns(40);
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BoxLayout(jPanel2, 0));
            jPanel2.add(Box.createHorizontalStrut(4));
            jPanel2.add(this.f);
            jPanel.add((Component)jPanel2, "Center");
            JPanel jPanel3 = new JPanel(new FlowLayout(0, 0, 0));
            jPanel3.add(jPanel);
            jPanel3.setAlignmentX(0.0f);
            this.b.add((Component)jPanel3, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, (Insets)JBUI.insets((int)4, (int)0, (int)10, (int)0), 0, 0));
        }
        this.j = new ProjectJdkConfigurable(this.h, projectSdksModel);
        this.b.add((Component)this.j.createComponent(), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, (Insets)JBUI.insetsTop((int)4), 0, 0));
        this.b.add((Component)this.e, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 18, 0, (Insets)JBUI.insetsTop((int)4), 0, 0));
        this.b.setBorder(new EmptyBorder(0, 10, 0, 10));
        this.a.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent documentEvent) {
                if (ProjectConfigurable.this.g) {
                    return;
                }
                ProjectConfigurable.this.c.processModuleCompilerOutputChanged(ProjectConfigurable.this.getCompilerOutputUrl());
            }
        });
        this.j.addChangeListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProjectConfigurable.this.i.sdkUpdated(ProjectConfigurable.this.j.getSelectedProjectJdk(), ProjectConfigurable.this.h.isDefault());
                LanguageLevelProjectExtensionImpl.getInstanceImpl((Project)ProjectConfigurable.this.h).setCurrentLevel(ProjectConfigurable.this.i.getSelectedLevel());
            }
        });
        this.i.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LanguageLevelProjectExtensionImpl.getInstanceImpl((Project)ProjectConfigurable.this.h).setCurrentLevel(ProjectConfigurable.this.i.getSelectedLevel());
            }
        });
    }

    public void disposeUIResources() {
        if (this.j != null) {
            this.j.disposeUIResources();
        }
    }

    public void reset() {
        this.g = true;
        try {
            this.j.reset();
            String string = this.a();
            if (string != null) {
                this.a.setText(FileUtil.toSystemDependentName((String)VfsUtilCore.urlToPath((String)string)));
            }
            this.i.reset(this.h);
            if (this.f != null) {
                this.f.setText(this.h.getName());
            }
        }
        finally {
            this.g = false;
        }
        this.k.getDaemonAnalyzer().queueUpdate(this.l);
    }

    public void apply() throws ConfigurationException {
        CompilerProjectExtension compilerProjectExtension = CompilerProjectExtension.getInstance((Project)this.h);
        assert (compilerProjectExtension != null) : this.h;
        if (this.f != null && StringUtil.isEmptyOrSpaces((String)this.f.getText())) {
            throw new ConfigurationException("Please, specify project name!");
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            String string = this.a.getText();
            if (string != null && string.length() > 0) {
                try {
                    string = FileUtil.resolveShortWindowsName((String)string);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                string = FileUtil.toSystemIndependentName((String)string);
                compilerProjectExtension.setCompilerOutputUrl(VfsUtilCore.pathToUrl((String)string));
            } else {
                compilerProjectExtension.setCompilerOutputPointer(null);
            }
            LanguageLevelProjectExtension languageLevelProjectExtension = LanguageLevelProjectExtension.getInstance((Project)this.h);
            LanguageLevel languageLevel = this.i.getSelectedLevel();
            if (languageLevel != null) {
                languageLevelProjectExtension.setLanguageLevel(languageLevel);
            }
            languageLevelProjectExtension.setDefault(Boolean.valueOf(this.i.isDefault()));
            this.j.apply();
            if (this.f != null) {
                ((ProjectEx)this.h).setProjectName(this.getProjectName());
                if (this.d != null) {
                    this.d.setText(new String[]{this.getBannerSlogan()});
                }
            }
        });
    }

    public void setDisplayName(String string) {
    }

    public Project getEditableObject() {
        return this.h;
    }

    public String getBannerSlogan() {
        return ProjectBundle.message((String)"project.roots.project.banner.text", (Object[])new Object[]{this.h.getName()});
    }

    public String getDisplayName() {
        return ProjectBundle.message((String)"project.roots.project.display.name", (Object[])new Object[0]);
    }

    public Icon getIcon(boolean bl2) {
        return AllIcons.Nodes.Project;
    }

    @Nullable
    @NonNls
    public String getHelpTopic() {
        return "reference.settingsdialog.project.structure.general";
    }

    public boolean isModified() {
        LanguageLevelProjectExtension languageLevelProjectExtension = LanguageLevelProjectExtension.getInstance((Project)this.h);
        if (languageLevelProjectExtension.isDefault() != this.i.isDefault() || !languageLevelProjectExtension.isDefault() && !languageLevelProjectExtension.getLanguageLevel().equals((Object)this.i.getSelectedLevel())) {
            return true;
        }
        String string = this.a();
        if (!Comparing.strEqual((String)FileUtil.toSystemIndependentName((String)VfsUtilCore.urlToPath((String)string)), (String)FileUtil.toSystemIndependentName((String)this.a.getText()))) {
            return true;
        }
        if (this.j.isModified()) {
            return true;
        }
        return !this.getProjectName().equals(this.h.getName());
    }

    @NotNull
    public String getProjectName() {
        String string = this.f != null ? this.f.getText().trim() : this.h.getName();
        if (string == null) {
            ProjectConfigurable.a(0);
        }
        return string;
    }

    @Nullable
    private String a() {
        CompilerProjectExtension compilerProjectExtension = CompilerProjectExtension.getInstance((Project)this.h);
        return compilerProjectExtension != null ? compilerProjectExtension.getCompilerOutputUrl() : null;
    }

    private void c() {
        this.i = new LanguageLevelCombo(JavaCoreBundle.message((String)"default.language.level.description", (Object[])new Object[0])){

            @Override
            protected LanguageLevel getDefaultLevel() {
                Sdk sdk = ProjectConfigurable.this.j.getSelectedProjectJdk();
                if (sdk == null) {
                    return null;
                }
                JavaSdkVersion javaSdkVersion = JavaSdk.getInstance().getVersion(sdk);
                return javaSdkVersion == null ? null : javaSdkVersion.getMaxLanguageLevel();
            }
        };
        ExtendableTextField extendableTextField = new ExtendableTextField();
        FileChooserDescriptor fileChooserDescriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        InsertPathAction.addTo((JTextComponent)extendableTextField, (FileChooserDescriptor)fileChooserDescriptor);
        fileChooserDescriptor.setHideIgnored(false);
        BrowseFilesListener browseFilesListener = new BrowseFilesListener((JTextField)extendableTextField, "", ProjectBundle.message((String)"project.compiler.output", (Object[])new Object[0]), fileChooserDescriptor);
        this.a = new FieldPanel((JTextField)extendableTextField, null, null, (ActionListener)browseFilesListener, EmptyRunnable.getInstance());
        FileChooserFactory.getInstance().installFileCompletion(this.a.getTextField(), fileChooserDescriptor, true, null);
    }

    public String getCompilerOutputUrl() {
        return VfsUtilCore.pathToUrl((String)this.a.getText().trim());
    }

    private static /* synthetic */ void a(int n2) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/ProjectConfigurable", "getProjectName"));
    }

    private /* synthetic */ void b() {
        JPanel jPanel;
        this.c();
        this.e = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, 5, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JLabel jLabel = new JLabel();
        this.a(jLabel, ResourceBundle.getBundle("messages/ProjectBundle").getString("project.language.level"));
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 4, 10, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        LanguageLevelCombo languageLevelCombo = this.i;
        jPanel2.add((Component)((Object)languageLevelCombo), new GridConstraints(0, 0, 1, 1, 8, 0, 7, 3, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.a(jLabel2, ResourceBundle.getBundle("messages/ProjectBundle").getString("project.compiler.output"));
        jPanel.add((Component)jLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 1, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 4, 10, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(3, 0, 1, 1, 0, 3, 6, 0, null, null, null));
        FieldPanel fieldPanel = this.a;
        jPanel3.add((Component)fieldPanel, new GridConstraints(0, 0, 1, 1, 0, 1, 6, 0, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.e;
    }

    private /* synthetic */ void a(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = false;
        char c2 = '\u0000';
        int n2 = -1;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            if (string.charAt(i2) == '&') {
                if (++i2 == string.length()) break;
                if (!bl2 && string.charAt(i2) != '&') {
                    bl2 = true;
                    c2 = string.charAt(i2);
                    n2 = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i2));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl2) {
            jLabel.setDisplayedMnemonic(c2);
            jLabel.setDisplayedMnemonicIndex(n2);
        }
    }
}

