/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts;

import com.intellij.facet.Facet;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.ModificationOfImportedModelWarningComponent;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactEditorImpl;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactProblemsHolderImpl;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactsStructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactsStructureConfigurableContextImpl;
import com.intellij.openapi.roots.ui.configuration.artifacts.UsageInArtifact;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.FacetProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.LibraryProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ModuleProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElementUsage;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureProblemsHolder;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.artifacts.PackagingElementPath;
import com.intellij.packaging.impl.artifacts.PackagingElementProcessor;
import com.intellij.packaging.impl.elements.ArtifactPackagingElement;
import com.intellij.packaging.impl.elements.FacetBasedPackagingElement;
import com.intellij.packaging.impl.elements.LibraryPackagingElement;
import com.intellij.packaging.impl.elements.ModuleOutputPackagingElement;
import com.intellij.packaging.ui.ArtifactProblemQuickFix;
import com.intellij.packaging.ui.ArtifactProblemsHolder;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArtifactProjectStructureElement
extends ProjectStructureElement {
    private final ArtifactsStructureConfigurableContext a;
    private final Artifact b;

    ArtifactProjectStructureElement(StructureConfigurableContext structureConfigurableContext, ArtifactsStructureConfigurableContext artifactsStructureConfigurableContext, Artifact artifact) {
        super(structureConfigurableContext);
        this.a = artifactsStructureConfigurableContext;
        this.b = artifactsStructureConfigurableContext.getOriginalArtifact(artifact);
    }

    @Override
    public void check(ProjectStructureProblemsHolder projectStructureProblemsHolder) {
        ProjectModelExternalSource projectModelExternalSource;
        ArtifactEditorImpl artifactEditorImpl;
        Artifact artifact = this.a.getArtifactModel().getArtifactByOriginal(this.b);
        ArtifactProblemsHolderImpl artifactProblemsHolderImpl = new ArtifactProblemsHolderImpl(this.a, this.b, projectStructureProblemsHolder);
        if (this.a instanceof ArtifactsStructureConfigurableContextImpl && (artifactEditorImpl = ((ArtifactsStructureConfigurableContextImpl)this.a).getArtifactEditor(artifact)) != null && (artifactEditorImpl.isModified() || this.a(artifact)) && (projectModelExternalSource = artifact.getExternalSource()) != null) {
            String string = ModificationOfImportedModelWarningComponent.getWarningText("Artifact '" + artifact.getName() + "'", projectModelExternalSource);
            artifactProblemsHolderImpl.registerWarning(string, "modification-of-imported-element", null, new ArtifactProblemQuickFix[0]);
        }
        artifact.getArtifactType().checkRootElement(this.a.getRootElement(this.b), artifact, (ArtifactProblemsHolder)artifactProblemsHolderImpl);
    }

    private boolean a(Artifact artifact) {
        ModifiableArtifactModel modifiableArtifactModel = ((ArtifactsStructureConfigurableContextImpl)this.a).getActualModifiableModel();
        return modifiableArtifactModel != null && artifact != modifiableArtifactModel.getOriginalArtifact(artifact);
    }

    public Artifact getOriginalArtifact() {
        return this.b;
    }

    @Override
    public List<ProjectStructureElementUsage> getUsagesInElement() {
        Artifact artifact = this.a.getArtifactModel().getArtifactByOriginal(this.b);
        final ArrayList<ProjectStructureElementUsage> arrayList = new ArrayList<ProjectStructureElementUsage>();
        final CompositePackagingElement<?> compositePackagingElement = this.a.getRootElement(artifact);
        ArtifactUtil.processPackagingElements(compositePackagingElement, null, new PackagingElementProcessor<PackagingElement<?>>(){

            @Override
            public boolean process(@NotNull PackagingElement<?> packagingElement, @NotNull PackagingElementPath packagingElementPath) {
                ProjectStructureElement projectStructureElement;
                if (packagingElement == null) {
                    1.a(0);
                }
                if (packagingElementPath == null) {
                    1.a(1);
                }
                if ((projectStructureElement = ArtifactProjectStructureElement.getProjectStructureElementFor(packagingElement, ArtifactProjectStructureElement.this.myContext, ArtifactProjectStructureElement.this.a)) != null) {
                    arrayList.add(ArtifactProjectStructureElement.this.a(packagingElement, projectStructureElement, packagingElementPath.getPathStringFrom("/", compositePackagingElement)));
                }
                return true;
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "packagingElement";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "path";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactProjectStructureElement$1";
                objectArray[2] = "process";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, this.a, false, artifact.getArtifactType());
        return arrayList;
    }

    @Nullable
    public static ProjectStructureElement getProjectStructureElementFor(PackagingElement<?> packagingElement, StructureConfigurableContext structureConfigurableContext, ArtifactsStructureConfigurableContext artifactsStructureConfigurableContext) {
        Facet facet;
        if (packagingElement instanceof ModuleOutputPackagingElement) {
            Module module2 = ((ModuleOutputPackagingElement)packagingElement).findModule(artifactsStructureConfigurableContext);
            if (module2 != null) {
                return new ModuleProjectStructureElement(structureConfigurableContext, module2);
            }
        } else if (packagingElement instanceof LibraryPackagingElement) {
            Library library = ((LibraryPackagingElement)packagingElement).findLibrary(artifactsStructureConfigurableContext);
            if (library != null) {
                return new LibraryProjectStructureElement(structureConfigurableContext, library);
            }
        } else if (packagingElement instanceof ArtifactPackagingElement) {
            Artifact artifact = ((ArtifactPackagingElement)packagingElement).findArtifact(artifactsStructureConfigurableContext);
            if (artifact != null) {
                return artifactsStructureConfigurableContext.getOrCreateArtifactElement(artifact);
            }
        } else if (packagingElement instanceof FacetBasedPackagingElement && (facet = ((FacetBasedPackagingElement)packagingElement).findFacet(artifactsStructureConfigurableContext)) != null) {
            return new FacetProjectStructureElement(structureConfigurableContext, facet);
        }
        return null;
    }

    private UsageInArtifact a(PackagingElement<?> packagingElement, ProjectStructureElement projectStructureElement, String string) {
        return new UsageInArtifact(this.b, this.a, projectStructureElement, this, string, packagingElement);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ArtifactProjectStructureElement)) {
            return false;
        }
        return this.b.equals(((ArtifactProjectStructureElement)object).b);
    }

    @Override
    public int hashCode() {
        return this.b.hashCode();
    }

    @Override
    public String getPresentableName() {
        return this.a();
    }

    @Override
    public String getTypeName() {
        return "Artifact";
    }

    @Override
    public String getId() {
        return "artifact:" + this.a();
    }

    private String a() {
        return this.a.getArtifactModel().getArtifactByOriginal(this.b).getName();
    }
}

