/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts;

import com.intellij.CommonBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.ui.configuration.ModuleEditor;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactConfigurable;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactConfigurableBase;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactEditorImpl;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactEditorSettings;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactStructureConfigurableState;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactsStructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactsStructureConfigurableContextImpl;
import com.intellij.openapi.roots.ui.configuration.artifacts.InvalidArtifactConfigurable;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditorListener;
import com.intellij.openapi.roots.ui.configuration.projectRoot.BaseStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.GlobalLibrariesConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ModuleStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectLibrariesConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.RemoveConfigurableHandler;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.ui.MasterDetailsComponent;
import com.intellij.openapi.ui.MasterDetailsState;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.openapi.util.Comparing;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactAdapter;
import com.intellij.packaging.artifacts.ArtifactTemplate;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.artifacts.ModifiableArtifact;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.artifacts.InvalidArtifact;
import com.intellij.packaging.impl.artifacts.PackagingElementPath;
import com.intellij.packaging.impl.artifacts.PackagingElementProcessor;
import com.intellij.packaging.impl.elements.LibraryElementType;
import com.intellij.packaging.impl.elements.LibraryPackagingElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArtifactsStructureConfigurable
extends BaseStructureConfigurable {
    private ArtifactsStructureConfigurableContextImpl b;
    private final ArtifactEditorSettings c;

    public ArtifactsStructureConfigurable(@NotNull Project project2) {
        if (project2 == null) {
            ArtifactsStructureConfigurable.b(0);
        }
        super(project2, new ArtifactStructureConfigurableState());
        this.c = new ArtifactEditorSettings();
    }

    protected String getComponentStateKey() {
        return "ArtifactsStructureConfigurable.UI";
    }

    public void init(StructureConfigurableContext structureConfigurableContext, ModuleStructureConfigurable moduleStructureConfigurable, ProjectLibrariesConfigurable projectLibrariesConfigurable, GlobalLibrariesConfigurable globalLibrariesConfigurable) {
        super.init(structureConfigurableContext);
        this.b = new ArtifactsStructureConfigurableContextImpl(this.myContext, this.myProject, this.c, new ArtifactAdapter(){

            public void artifactAdded(@NotNull Artifact artifact) {
                if (artifact == null) {
                    1.a(0);
                }
                MasterDetailsComponent.MyNode myNode = ArtifactsStructureConfigurable.this.a(artifact);
                ArtifactsStructureConfigurable.this.selectNodeInTree((DefaultMutableTreeNode)myNode);
                ArtifactsStructureConfigurable.this.myContext.getDaemonAnalyzer().queueUpdate(ArtifactsStructureConfigurable.this.b.getOrCreateArtifactElement(artifact));
            }

            private static /* synthetic */ void a(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactsStructureConfigurable$1", "artifactAdded"));
            }
        });
        structureConfigurableContext.getModulesConfigurator().addAllModuleChangeListener(new ModuleEditor.ChangeListener(){

            @Override
            public void moduleStateChanged(ModifiableRootModel modifiableRootModel) {
                for (ProjectStructureElement projectStructureElement : ArtifactsStructureConfigurable.this.getProjectStructureElements()) {
                    ArtifactsStructureConfigurable.this.myContext.getDaemonAnalyzer().queueUpdate(projectStructureElement);
                }
            }
        });
        MasterDetailsComponent.ItemsChangeListener itemsChangeListener = new MasterDetailsComponent.ItemsChangeListener(){

            public void itemChanged(@Nullable Object object) {
                if (object instanceof Library || object instanceof Module) {
                    ArtifactsStructureConfigurable.this.c();
                }
            }
        };
        moduleStructureConfigurable.addItemsChangeListener(itemsChangeListener);
        projectLibrariesConfigurable.addItemsChangeListener(itemsChangeListener);
        globalLibrariesConfigurable.addItemsChangeListener(itemsChangeListener);
        structureConfigurableContext.addLibraryEditorListener(new LibraryEditorListener(){

            @Override
            public void libraryRenamed(@NotNull Library library, String string, String string2) {
                Artifact[] artifactArray;
                if (library == null) {
                    4.a(0);
                }
                for (Artifact artifact : artifactArray = ArtifactsStructureConfigurable.this.b.getArtifactModel().getArtifacts()) {
                    ArtifactsStructureConfigurable.this.b(artifact, library, string, string2);
                }
            }

            private static /* synthetic */ void a(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactsStructureConfigurable$4", "libraryRenamed"));
            }
        });
    }

    private void b(Artifact artifact, final Library library, final String string, final String string2) {
        if (ArtifactUtil.processPackagingElements(this.b.getRootElement(artifact), LibraryElementType.LIBRARY_ELEMENT_TYPE, new PackagingElementProcessor<LibraryPackagingElement>(){

            @Override
            public boolean process(@NotNull LibraryPackagingElement libraryPackagingElement, @NotNull PackagingElementPath packagingElementPath) {
                if (libraryPackagingElement == null) {
                    5.a(0);
                }
                if (packagingElementPath == null) {
                    5.a(1);
                }
                return !ArtifactsStructureConfigurable.a(libraryPackagingElement, library, string);
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "path";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactsStructureConfigurable$5";
                objectArray[2] = "process";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, this.b, false, artifact.getArtifactType())) {
            return;
        }
        this.b.editLayout(artifact, () -> {
            ModifiableArtifact modifiableArtifact = this.b.getOrCreateModifiableArtifactModel().getOrCreateModifiableArtifact(artifact);
            ArtifactUtil.processPackagingElements((Artifact)modifiableArtifact, LibraryElementType.LIBRARY_ELEMENT_TYPE, new PackagingElementProcessor<LibraryPackagingElement>(){

                @Override
                public boolean process(@NotNull LibraryPackagingElement libraryPackagingElement, @NotNull PackagingElementPath packagingElementPath) {
                    if (libraryPackagingElement == null) {
                        6.a(0);
                    }
                    if (packagingElementPath == null) {
                        6.a(1);
                    }
                    if (ArtifactsStructureConfigurable.a(libraryPackagingElement, library, string)) {
                        libraryPackagingElement.setLibraryName(string2);
                    }
                    return true;
                }

                private static /* synthetic */ void a(int n2) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n2) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "element";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "path";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactsStructureConfigurable$6";
                    objectArray[2] = "process";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }, (PackagingElementResolvingContext)this.b, false);
        });
        ArtifactEditorImpl artifactEditorImpl = this.b.getArtifactEditor(artifact);
        if (artifactEditorImpl != null) {
            artifactEditorImpl.rebuildTries();
        }
    }

    private static boolean a(LibraryPackagingElement libraryPackagingElement, Library library, String string) {
        if (!libraryPackagingElement.getLibraryName().equals(string)) {
            return false;
        }
        LibraryTable libraryTable = library.getTable();
        if (libraryTable != null) {
            return libraryTable.getTableLevel().equals(libraryPackagingElement.getLevel());
        }
        return libraryPackagingElement.getLevel().equals("module");
    }

    private void c() {
        for (ArtifactEditorImpl artifactEditorImpl : this.b.getArtifactEditors()) {
            artifactEditorImpl.getSourceItemsTree().rebuildTree();
            artifactEditorImpl.queueValidation();
        }
    }

    protected MasterDetailsState getState() {
        ((ArtifactStructureConfigurableState)this.myState).setDefaultArtifactSettings(this.c.getState());
        return super.getState();
    }

    public void loadState(MasterDetailsState masterDetailsState) {
        super.loadState(masterDetailsState);
        this.c.loadState(((ArtifactStructureConfigurableState)this.myState).getDefaultArtifactSettings());
    }

    @Nls
    public String getDisplayName() {
        return ProjectBundle.message((String)"display.name.artifacts", (Object[])new Object[0]);
    }

    @Override
    protected void loadTree() {
        this.myTree.setRootVisible(false);
        this.myTree.setShowsRootHandles(false);
        for (Artifact artifact : this.b.getArtifactModel().getAllArtifactsIncludingInvalid()) {
            this.a(artifact);
        }
    }

    @Override
    @NotNull
    protected Collection<? extends ProjectStructureElement> getProjectStructureElements() {
        ArrayList<ArtifactProjectStructureElement> arrayList = new ArrayList<ArtifactProjectStructureElement>();
        for (Artifact artifact : this.b.getArtifactModel().getAllArtifactsIncludingInvalid()) {
            arrayList.add(this.b.getOrCreateArtifactElement(artifact));
        }
        ArrayList<ArtifactProjectStructureElement> arrayList2 = arrayList;
        if (arrayList2 == null) {
            ArtifactsStructureConfigurable.b(1);
        }
        return arrayList2;
    }

    private MasterDetailsComponent.MyNode a(Artifact artifact) {
        ArtifactConfigurableBase artifactConfigurableBase = artifact instanceof InvalidArtifact ? new InvalidArtifactConfigurable((InvalidArtifact)artifact, this.b, this.TREE_UPDATER) : new ArtifactConfigurable(artifact, this.b, this.TREE_UPDATER);
        MasterDetailsComponent.MyNode myNode = new MasterDetailsComponent.MyNode((NamedConfigurable)artifactConfigurableBase);
        this.addNode(myNode, this.myRoot);
        return myNode;
    }

    @Override
    public void reset() {
        this.loadComponentState();
        this.b.resetModifiableModel();
        super.reset();
    }

    public boolean isModified() {
        ModifiableArtifactModel modifiableArtifactModel = this.b.getActualModifiableModel();
        if (modifiableArtifactModel != null && modifiableArtifactModel.isModified()) {
            return true;
        }
        return this.b.getManifestFilesInfo().isManifestFilesModified() || super.isModified();
    }

    public ArtifactsStructureConfigurableContext getArtifactsStructureContext() {
        return this.b;
    }

    public ModifiableArtifactModel getModifiableArtifactModel() {
        return this.b.getOrCreateModifiableArtifactModel();
    }

    @Override
    protected BaseStructureConfigurable.AbstractAddGroup createAddAction() {
        return new BaseStructureConfigurable.AbstractAddGroup(ProjectBundle.message((String)"add.new.header.text", (Object[])new Object[0])){

            @NotNull
            public AnAction[] getChildren(@Nullable AnActionEvent anActionEvent) {
                ArtifactType[] artifactTypeArray = ArtifactType.getAllTypes();
                AnAction[] anActionArray = new AnAction[artifactTypeArray.length];
                for (int i2 = 0; i2 < artifactTypeArray.length; ++i2) {
                    anActionArray[i2] = ArtifactsStructureConfigurable.this.a(artifactTypeArray[i2]);
                }
                if (anActionArray == null) {
                    7.a(0);
                }
                return anActionArray;
            }

            private static /* synthetic */ void a(int n2) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactsStructureConfigurable$7", "getChildren"));
            }
        };
    }

    private AnAction a(final @NotNull ArtifactType artifactType) {
        if (artifactType == null) {
            ArtifactsStructureConfigurable.b(2);
        }
        List list2 = artifactType.getNewArtifactTemplates((PackagingElementResolvingContext)this.b);
        ArtifactTemplate artifactTemplate = new ArtifactTemplate(){

            public String getPresentableName() {
                return "Empty";
            }

            public ArtifactTemplate.NewArtifactConfiguration createArtifact() {
                String string = "unnamed";
                return new ArtifactTemplate.NewArtifactConfiguration(artifactType.createRootElement("unnamed"), "unnamed", artifactType);
            }
        };
        if (list2.isEmpty()) {
            return new AddArtifactAction(artifactType, artifactTemplate, artifactType.getPresentableName(), artifactType.getIcon());
        }
        DefaultActionGroup defaultActionGroup = new DefaultActionGroup(artifactType.getPresentableName(), true);
        defaultActionGroup.getTemplatePresentation().setIcon(artifactType.getIcon());
        defaultActionGroup.add((AnAction)new AddArtifactAction(artifactType, artifactTemplate, artifactTemplate.getPresentableName(), null));
        defaultActionGroup.addSeparator();
        for (ArtifactTemplate artifactTemplate2 : list2) {
            defaultActionGroup.add((AnAction)new AddArtifactAction(artifactType, artifactTemplate2, artifactTemplate2.getPresentableName(), null));
        }
        return defaultActionGroup;
    }

    private void a(@NotNull ArtifactType artifactType, @NotNull ArtifactTemplate artifactTemplate) {
        if (artifactType == null) {
            ArtifactsStructureConfigurable.b(3);
        }
        if (artifactTemplate == null) {
            ArtifactsStructureConfigurable.b(4);
        }
        Artifact artifact = ArtifactUtil.addArtifact(this.b.getOrCreateModifiableArtifactModel(), artifactType, artifactTemplate);
        this.selectNodeInTree((DefaultMutableTreeNode)ArtifactsStructureConfigurable.findNodeByObject((TreeNode)this.myRoot, (Object)artifact));
    }

    public void apply() throws ConfigurationException {
        this.b.saveEditorSettings();
        this.checkForEmptyAndDuplicatedNames("Artifact", CommonBundle.getErrorTitle(), ArtifactConfigurableBase.class);
        super.apply();
        this.b.getManifestFilesInfo().saveManifestFiles();
        final ModifiableArtifactModel modifiableArtifactModel = this.b.getActualModifiableModel();
        if (modifiableArtifactModel != null) {
            new WriteAction(){

                protected void run(@NotNull Result result2) {
                    if (result2 == null) {
                        9.a(0);
                    }
                    modifiableArtifactModel.commit();
                }

                private static /* synthetic */ void a(int n2) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactsStructureConfigurable$9", "run"));
                }
            }.execute();
        }
        this.b.resetModifiableModel();
        this.reloadTreeNodes();
        this.restoreLastSelection();
    }

    @Override
    public void disposeUIResources() {
        this.b.saveEditorSettings();
        super.disposeUIResources();
        this.b.disposeUIResources();
    }

    protected void updateSelection(@Nullable NamedConfigurable namedConfigurable) {
        ArtifactEditorImpl artifactEditorImpl;
        boolean bl2;
        boolean bl3 = bl2 = !Comparing.equal((Object)this.myCurrentConfigurable, (Object)namedConfigurable);
        if (bl2 && this.myCurrentConfigurable instanceof ArtifactConfigurable && (artifactEditorImpl = this.b.getArtifactEditor(((ArtifactConfigurable)this.myCurrentConfigurable).getArtifact())) != null) {
            artifactEditorImpl.getLayoutTreeComponent().saveElementProperties();
        }
        super.updateSelection(namedConfigurable);
        if (bl2 && namedConfigurable instanceof ArtifactConfigurable && (artifactEditorImpl = this.b.getArtifactEditor(((ArtifactConfigurable)namedConfigurable).getArtifact())) != null) {
            artifactEditorImpl.getLayoutTreeComponent().resetElementProperties();
        }
    }

    public String getHelpTopic() {
        String string = super.getHelpTopic();
        return string != null ? string : "reference.settingsdialog.project.structure.artifacts";
    }

    @Override
    protected List<? extends RemoveConfigurableHandler<?>> getRemoveHandlers() {
        return Collections.singletonList(new ArtifactRemoveHandler());
    }

    @NotNull
    public String getId() {
        if ("project.artifacts" == null) {
            ArtifactsStructureConfigurable.b(5);
        }
        return "project.artifacts";
    }

    public void dispose() {
    }

    private static /* synthetic */ void b(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 5: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactsStructureConfigurable";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactTemplate";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactsStructureConfigurable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectStructureElements";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 5: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createAddArtifactAction";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addArtifact";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class AddArtifactAction
    extends DumbAwareAction {
        private final ArtifactType b;
        private final ArtifactTemplate a;

        public AddArtifactAction(@NotNull ArtifactType artifactType, @NotNull ArtifactTemplate artifactTemplate, String string, Icon icon) {
            if (artifactType == null) {
                AddArtifactAction.a(0);
            }
            if (artifactTemplate == null) {
                AddArtifactAction.a(1);
            }
            if (string == null) {
                AddArtifactAction.a(2);
            }
            super(string, null, icon);
            this.b = artifactType;
            this.a = artifactTemplate;
        }

        public void actionPerformed(AnActionEvent anActionEvent) {
            ArtifactsStructureConfigurable.this.a(this.b, this.a);
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "artifactTemplate";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "actionText";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactsStructureConfigurable$AddArtifactAction";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ArtifactRemoveHandler
    extends RemoveConfigurableHandler<Artifact> {
        public ArtifactRemoveHandler() {
            super(ArtifactConfigurableBase.class);
        }

        @Override
        public boolean remove(@NotNull Collection<Artifact> collection) {
            if (collection == null) {
                ArtifactRemoveHandler.b(0);
            }
            for (Artifact artifact : collection) {
                ArtifactsStructureConfigurable.this.b.getOrCreateModifiableArtifactModel().removeArtifact(artifact);
                ArtifactsStructureConfigurable.this.myContext.getDaemonAnalyzer().removeElement(ArtifactsStructureConfigurable.this.b.getOrCreateArtifactElement(artifact));
            }
            return true;
        }

        private static /* synthetic */ void b(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifacts", "com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactsStructureConfigurable$ArtifactRemoveHandler", "remove"));
        }
    }
}

