/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactEditorEx;
import com.intellij.openapi.roots.ui.configuration.artifacts.LayoutTreeSelection;
import com.intellij.openapi.roots.ui.configuration.artifacts.nodes.PackagingElementNode;
import com.intellij.openapi.roots.ui.configuration.artifacts.nodes.PackagingNodeSource;
import java.util.Collection;

public class HideContentAction
extends DumbAwareAction {
    private final ArtifactEditorEx a;

    public HideContentAction(ArtifactEditorEx artifactEditorEx) {
        super("Hide Content");
        this.a = artifactEditorEx;
    }

    public void update(AnActionEvent anActionEvent) {
        Collection<PackagingNodeSource> collection;
        LayoutTreeSelection layoutTreeSelection = this.a.getLayoutTreeComponent().getSelection();
        PackagingElementNode<?> packagingElementNode = layoutTreeSelection.getNodeIfSingle();
        if (packagingElementNode != null && !(collection = packagingElementNode.getNodeSources()).isEmpty()) {
            String string = collection.size() == 1 ? "Hide Content of '" + collection.iterator().next().getPresentableName() + "'" : "Hide Content";
            anActionEvent.getPresentation().setVisible(true);
            anActionEvent.getPresentation().setText(string);
            return;
        }
        anActionEvent.getPresentation().setVisible(false);
    }

    public void actionPerformed(AnActionEvent anActionEvent) {
        LayoutTreeSelection layoutTreeSelection = this.a.getLayoutTreeComponent().getSelection();
        PackagingElementNode<?> packagingElementNode = layoutTreeSelection.getNodeIfSingle();
        if (packagingElementNode == null) {
            return;
        }
        Collection<PackagingNodeSource> collection = packagingElementNode.getNodeSources();
        for (PackagingNodeSource packagingNodeSource : collection) {
            this.a.getSubstitutionParameters().doNotSubstitute(packagingNodeSource.getSourceElement());
            this.a.getLayoutTreeComponent().getLayoutTree().addSubtreeToUpdate(packagingNodeSource.getSourceParentNode());
        }
    }
}

