/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactEditorEx;
import com.intellij.openapi.roots.ui.configuration.artifacts.LayoutTreeComponent;
import com.intellij.openapi.roots.ui.configuration.artifacts.LayoutTreeSelection;
import com.intellij.openapi.roots.ui.configuration.artifacts.nodes.CompositePackagingElementNode;
import com.intellij.openapi.roots.ui.configuration.artifacts.nodes.PackagingElementNode;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.elements.ArtifactRootElement;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.elements.ArtifactPackagingElement;
import com.intellij.packaging.ui.ArtifactEditorContext;
import java.util.Collection;
import java.util.Collections;

public class InlineArtifactAction
extends DumbAwareAction {
    private final ArtifactEditorEx a;

    public InlineArtifactAction(ArtifactEditorEx artifactEditorEx) {
        super(ProjectBundle.message((String)"action.name.inline.artifact", (Object[])new Object[0]));
        this.a = artifactEditorEx;
    }

    public void update(AnActionEvent anActionEvent) {
        LayoutTreeSelection layoutTreeSelection = this.a.getLayoutTreeComponent().getSelection();
        PackagingElementNode<?> packagingElementNode = layoutTreeSelection.getNodeIfSingle();
        PackagingElement<?> packagingElement = layoutTreeSelection.getElementIfSingle();
        anActionEvent.getPresentation().setEnabled(packagingElement instanceof ArtifactPackagingElement && packagingElementNode != null && packagingElementNode.getParentElement(packagingElement) != null);
    }

    public void actionPerformed(AnActionEvent anActionEvent) {
        LayoutTreeComponent layoutTreeComponent = this.a.getLayoutTreeComponent();
        LayoutTreeSelection layoutTreeSelection = layoutTreeComponent.getSelection();
        PackagingElement<?> packagingElement = layoutTreeSelection.getElementIfSingle();
        PackagingElementNode<?> packagingElementNode = layoutTreeSelection.getNodeIfSingle();
        if (packagingElementNode == null || !(packagingElement instanceof ArtifactPackagingElement)) {
            return;
        }
        CompositePackagingElement<?> compositePackagingElement = packagingElementNode.getParentElement(packagingElement);
        CompositePackagingElementNode compositePackagingElementNode = packagingElementNode.getParentNode();
        if (compositePackagingElement == null || compositePackagingElementNode == null) {
            return;
        }
        if (!layoutTreeComponent.checkCanModifyChildren((PackagingElement<?>)compositePackagingElement, compositePackagingElementNode, (Collection<? extends PackagingElementNode<?>>)Collections.singletonList(packagingElementNode))) {
            return;
        }
        layoutTreeComponent.editLayout(() -> {
            compositePackagingElement.removeChild(packagingElement);
            ArtifactEditorContext artifactEditorContext = this.a.getContext();
            Artifact artifact = ((ArtifactPackagingElement)packagingElement).findArtifact((PackagingElementResolvingContext)artifactEditorContext);
            if (artifact != null) {
                CompositePackagingElement compositePackagingElement2 = artifact.getRootElement();
                if (compositePackagingElement2 instanceof ArtifactRootElement) {
                    for (PackagingElement packagingElement2 : compositePackagingElement2.getChildren()) {
                        compositePackagingElement.addOrFindChild(ArtifactUtil.copyWithChildren(packagingElement2, artifactEditorContext.getProject()));
                    }
                } else {
                    compositePackagingElement.addOrFindChild(ArtifactUtil.copyWithChildren(compositePackagingElement2, artifactEditorContext.getProject()));
                }
            }
        });
        layoutTreeComponent.rebuildTree();
    }
}

