/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactEditorEx;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactEditorImpl;
import com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.SourceItemsTree;
import com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.actions.PutIntoDefaultLocationActionBase;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.artifacts.ParentElementProcessor;
import com.intellij.packaging.impl.elements.ManifestFileUtil;
import com.intellij.packaging.ui.ArtifactEditor;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.PackagingSourceItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PutSourceItemIntoParentAndLinkViaManifestAction
extends PutIntoDefaultLocationActionBase {
    public PutSourceItemIntoParentAndLinkViaManifestAction(SourceItemsTree sourceItemsTree, ArtifactEditorEx artifactEditorEx) {
        super(sourceItemsTree, artifactEditorEx);
    }

    public void update(AnActionEvent anActionEvent) {
        Presentation presentation = anActionEvent.getPresentation();
        Artifact artifact = this.myArtifactEditor.getArtifact();
        ParentElementsInfo parentElementsInfo = this.a(artifact);
        if (parentElementsInfo != null) {
            presentation.setText("Put Into '" + parentElementsInfo.getGrandparentArtifact().getName() + "' and link via manifest");
        }
        boolean bl2 = parentElementsInfo != null;
        boolean bl3 = false;
        for (PackagingSourceItem packagingSourceItem : this.mySourceItemsTree.getSelectedItems()) {
            bl3 |= packagingSourceItem.isProvideElements();
            if (packagingSourceItem.getKindOfProducedElements().containsJarFiles()) continue;
            bl2 = false;
            break;
        }
        presentation.setVisible(bl2 &= bl3);
        presentation.setEnabled(bl2);
    }

    @Nullable
    private ParentElementsInfo a(Artifact artifact) {
        final Ref ref = Ref.create(null);
        ArtifactUtil.processParents(artifact, (PackagingElementResolvingContext)this.myArtifactEditor.getContext(), new ParentElementProcessor(){

            @Override
            public boolean process(@NotNull CompositePackagingElement<?> compositePackagingElement, @NotNull List<Pair<Artifact, CompositePackagingElement<?>>> list2, @NotNull Artifact artifact) {
                if (compositePackagingElement == null) {
                    1.a(0);
                }
                if (list2 == null) {
                    1.a(1);
                }
                if (artifact == null) {
                    1.a(2);
                }
                if (list2.size() == 1) {
                    Pair<Artifact, CompositePackagingElement<?>> pair2 = list2.get(0);
                    ref.set((Object)new ParentElementsInfo((Artifact)pair2.getFirst(), (CompositePackagingElement)pair2.getSecond(), artifact, compositePackagingElement));
                    return false;
                }
                return true;
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "parents";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "artifact";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/openapi/roots/ui/configuration/artifacts/sourceItems/actions/PutSourceItemIntoParentAndLinkViaManifestAction$1";
                objectArray[2] = "process";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, 1);
        return (ParentElementsInfo)ref.get();
    }

    public void actionPerformed(AnActionEvent anActionEvent) {
        List<PackagingSourceItem> list2 = this.mySourceItemsTree.getSelectedItems();
        ParentElementsInfo parentElementsInfo = this.a(this.myArtifactEditor.getArtifact());
        if (parentElementsInfo == null) {
            return;
        }
        Artifact artifact = parentElementsInfo.getGrandparentArtifact();
        ArtifactEditorContext artifactEditorContext = this.myArtifactEditor.getContext();
        Runnable runnable = EmptyRunnable.getInstance();
        artifactEditorContext.editLayout(artifact, runnable);
        artifactEditorContext.editLayout(parentElementsInfo.getParentArtifact(), runnable);
        parentElementsInfo = this.a(this.myArtifactEditor.getArtifact());
        if (parentElementsInfo == null) {
            return;
        }
        CompositePackagingElement<?> compositePackagingElement = parentElementsInfo.getGrandparentElement();
        ArrayList arrayList = new ArrayList();
        artifactEditorContext.editLayout(artifact, () -> {
            for (PackagingSourceItem packagingSourceItem : list2) {
                List list4 = packagingSourceItem.createElements(artifactEditorContext);
                compositePackagingElement.addOrFindChildren((Collection)list4);
                arrayList.addAll(ManifestFileUtil.getClasspathForElements(list4, (PackagingElementResolvingContext)artifactEditorContext, artifact.getArtifactType()));
            }
        });
        ArtifactEditor artifactEditor = artifactEditorContext.getOrCreateEditor(parentElementsInfo.getParentArtifact());
        artifactEditor.addToClasspath(parentElementsInfo.getParentElement(), arrayList);
        ((ArtifactEditorImpl)artifactEditorContext.getOrCreateEditor(parentElementsInfo.getGrandparentArtifact())).rebuildTries();
    }

    private static class ParentElementsInfo {
        private final Artifact b;
        private final CompositePackagingElement<?> d;
        private final Artifact a;
        private final CompositePackagingElement<?> c;

        private ParentElementsInfo(Artifact artifact, CompositePackagingElement<?> compositePackagingElement, Artifact artifact2, CompositePackagingElement<?> compositePackagingElement2) {
            this.b = artifact;
            this.d = compositePackagingElement;
            this.a = artifact2;
            this.c = compositePackagingElement2;
        }

        public Artifact getParentArtifact() {
            return this.b;
        }

        public CompositePackagingElement<?> getParentElement() {
            return this.d;
        }

        public Artifact getGrandparentArtifact() {
            return this.a;
        }

        public CompositePackagingElement<?> getGrandparentElement() {
            return this.c;
        }
    }
}

