/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.classpath;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.impl.OrderEntryUtil;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.LibraryTableModifiableModelProvider;
import com.intellij.openapi.roots.ui.configuration.classpath.ChangeLibraryLevelActionBase;
import com.intellij.openapi.roots.ui.configuration.classpath.ClasspathPanel;
import com.intellij.openapi.vfs.VirtualFile;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ChangeLibraryLevelInClasspathAction
extends ChangeLibraryLevelActionBase {
    private final ClasspathPanel b;

    public ChangeLibraryLevelInClasspathAction(@NotNull ClasspathPanel classpathPanel, @NotNull String string, @NotNull String string2) {
        if (classpathPanel == null) {
            ChangeLibraryLevelInClasspathAction.b(0);
        }
        if (string == null) {
            ChangeLibraryLevelInClasspathAction.b(1);
        }
        if (string2 == null) {
            ChangeLibraryLevelInClasspathAction.b(2);
        }
        super(classpathPanel.getProject(), string, string2, string2.equals("module"));
        this.b = classpathPanel;
    }

    public void actionPerformed(AnActionEvent anActionEvent) {
        OrderEntry orderEntry = this.b.getSelectedEntry();
        if (!(orderEntry instanceof LibraryOrderEntry)) {
            return;
        }
        LibraryOrderEntry libraryOrderEntry = (LibraryOrderEntry)orderEntry;
        LibraryEx libraryEx = (LibraryEx)libraryOrderEntry.getLibrary();
        if (libraryEx == null) {
            return;
        }
        Library library = this.doCopy(libraryEx);
        if (library == null) {
            return;
        }
        if (!this.isConvertingToModuleLibrary()) {
            OrderEntryUtil.replaceLibrary((ModifiableRootModel)this.b.getRootModel(), (Library)libraryEx, (Library)library);
        } else {
            OrderEntryUtil.replaceLibraryEntryByAdded((ModifiableRootModel)this.b.getRootModel(), (LibraryOrderEntry)libraryOrderEntry);
        }
    }

    @Override
    protected boolean isEnabled() {
        LibraryOrderEntry libraryOrderEntry;
        OrderEntry orderEntry = this.b.getSelectedEntry();
        boolean bl2 = false;
        if (orderEntry instanceof LibraryOrderEntry && (libraryOrderEntry = (LibraryOrderEntry)orderEntry).getLibrary() != null) {
            boolean bl3;
            boolean bl4 = libraryOrderEntry.isModuleLevel();
            bl2 = bl4 != (bl3 = this.isConvertingToModuleLibrary());
        }
        return bl2;
    }

    @Override
    protected LibraryTableModifiableModelProvider getModifiableTableModelProvider() {
        return this.b.getModifiableModelProvider(this.myTargetTableLevel);
    }

    @Override
    protected JComponent getParentComponent() {
        return this.b.getComponent();
    }

    @Override
    @Nullable
    protected VirtualFile getBaseDir() {
        if (this.isConvertingToModuleLibrary()) {
            VirtualFile[] virtualFileArray = this.b.getRootModel().getContentRoots();
            if (virtualFileArray.length > 0) {
                return virtualFileArray[0];
            }
            VirtualFile virtualFile = this.b.getRootModel().getModule().getModuleFile();
            if (virtualFile != null) {
                return virtualFile.getParent();
            }
        }
        return super.getBaseDir();
    }

    private static /* synthetic */ void b(int n2) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "panel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "targetTableName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "targetTableLevel";
                break;
            }
        }
        objectArray[1] = "com/intellij/openapi/roots/ui/configuration/classpath/ChangeLibraryLevelInClasspathAction";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

