/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.classpath;

import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ui.configuration.ModuleConfigurationState;
import com.intellij.openapi.roots.ui.configuration.classpath.ClasspathPanelImpl;
import com.intellij.openapi.roots.ui.configuration.classpath.ClasspathTableItem;
import com.intellij.openapi.roots.ui.configuration.classpath.InvalidJdkItem;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ItemRemovable;
import com.intellij.util.ui.ListTableModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import org.jetbrains.annotations.Nullable;

class ClasspathTableModel
extends ListTableModel<ClasspathTableItem<?>>
implements ItemRemovable {
    static final String EXPORT_COLUMN_NAME = ProjectBundle.message((String)"modules.order.export.export.column", (Object[])new Object[0]);
    private static final ColumnInfo<ClasspathTableItem<?>, Boolean> d = new ColumnInfo<ClasspathTableItem<?>, Boolean>(EXPORT_COLUMN_NAME){

        @Nullable
        public Boolean valueOf(ClasspathTableItem<?> classpathTableItem) {
            return classpathTableItem.isExported();
        }

        public void setValue(ClasspathTableItem<?> classpathTableItem, Boolean bl2) {
            classpathTableItem.setExported(bl2);
        }

        public boolean isCellEditable(ClasspathTableItem<?> classpathTableItem) {
            return classpathTableItem.isExportable();
        }

        public Class getColumnClass() {
            return Boolean.class;
        }
    };
    private static final String g = ProjectBundle.message((String)"modules.order.export.scope.column", (Object[])new Object[0]);
    private static final Comparator<DependencyScope> b = (dependencyScope, dependencyScope2) -> dependencyScope.getDisplayName().compareToIgnoreCase(dependencyScope2.getDisplayName());
    private static final Comparator<ClasspathTableItem<?>> f = (classpathTableItem, classpathTableItem2) -> Comparing.compare((Object)classpathTableItem.getScope(), (Object)classpathTableItem2.getScope(), b);
    private static final ColumnInfo<ClasspathTableItem<?>, DependencyScope> c = new ColumnInfo<ClasspathTableItem<?>, DependencyScope>(g){

        @Nullable
        public DependencyScope valueOf(ClasspathTableItem<?> classpathTableItem) {
            return classpathTableItem.getScope();
        }

        public void setValue(ClasspathTableItem<?> classpathTableItem, DependencyScope dependencyScope) {
            classpathTableItem.setScope(dependencyScope);
        }

        public boolean isCellEditable(ClasspathTableItem<?> classpathTableItem) {
            return classpathTableItem.isExportable();
        }

        public Class getColumnClass() {
            return DependencyScope.class;
        }

        @Nullable
        public Comparator<ClasspathTableItem<?>> getComparator() {
            return f;
        }
    };
    public static final int EXPORT_COLUMN = 0;
    public static final int ITEM_COLUMN = 1;
    public static final int SCOPE_COLUMN = 2;
    private final ModuleConfigurationState a;
    private StructureConfigurableContext e;

    public ClasspathTableModel(ModuleConfigurationState moduleConfigurationState, StructureConfigurableContext structureConfigurableContext) {
        super(new ColumnInfo[]{d, new ClasspathTableItemClasspathColumnInfo(structureConfigurableContext), c});
        this.a = moduleConfigurationState;
        this.e = structureConfigurableContext;
        this.init();
    }

    public RowSorter.SortKey getDefaultSortKey() {
        return new RowSorter.SortKey(1, SortOrder.UNSORTED);
    }

    private ModifiableRootModel a() {
        return this.a.getRootModel();
    }

    public void init() {
        OrderEntry[] orderEntryArray = this.a().getOrderEntries();
        boolean bl2 = false;
        ArrayList arrayList = new ArrayList();
        for (OrderEntry orderEntry : orderEntryArray) {
            if (orderEntry instanceof JdkOrderEntry) {
                bl2 = true;
            }
            arrayList.add(ClasspathTableItem.createItem(orderEntry, this.e));
        }
        if (!bl2) {
            arrayList.add(0, new InvalidJdkItem());
        }
        this.setItems(arrayList);
    }

    public void exchangeRows(int n2, int n3) {
        super.exchangeRows(n2, n3);
        List<OrderEntry> list2 = this.b();
        this.a.getRootModel().rearrangeOrderEntries(list2.toArray(OrderEntry.EMPTY_ARRAY));
    }

    public void clear() {
        this.setItems(Collections.emptyList());
    }

    private List<OrderEntry> b() {
        int n2 = this.getRowCount();
        ArrayList<OrderEntry> arrayList = new ArrayList<OrderEntry>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            Object t2 = ((ClasspathTableItem)this.getItem(i2)).getEntry();
            if (t2 == null) continue;
            arrayList.add((OrderEntry)t2);
        }
        return arrayList;
    }

    private static class ClasspathTableItemClasspathColumnInfo
    extends ColumnInfo<ClasspathTableItem<?>, ClasspathTableItem<?>> {
        private final Comparator<ClasspathTableItem<?>> a = (classpathTableItem, classpathTableItem2) -> {
            String string = ClasspathPanelImpl.getCellAppearance(classpathTableItem, structureConfigurableContext, false).getText();
            String string2 = ClasspathPanelImpl.getCellAppearance(classpathTableItem2, structureConfigurableContext, false).getText();
            return string.compareToIgnoreCase(string2);
        };

        public ClasspathTableItemClasspathColumnInfo(StructureConfigurableContext structureConfigurableContext) {
            super("");
        }

        @Nullable
        public Comparator<ClasspathTableItem<?>> getComparator() {
            return this.a;
        }

        @Nullable
        public ClasspathTableItem<?> valueOf(ClasspathTableItem<?> classpathTableItem) {
            return classpathTableItem;
        }

        public Class getColumnClass() {
            return ClasspathTableItem.class;
        }
    }
}

