/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.libraries.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryDetectionManager;
import com.intellij.openapi.roots.libraries.LibraryKind;
import com.intellij.openapi.roots.libraries.LibraryPresentationProvider;
import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.roots.libraries.LibraryType;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.roots.ui.configuration.libraries.LibraryPresentationManager;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainer;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PlatformIcons;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibraryPresentationManagerImpl
extends LibraryPresentationManager {
    private Map<LibraryKind, LibraryPresentationProvider<?>> a;

    public static List<LibraryKind> getLibraryKinds(@NotNull Library library, @Nullable StructureConfigurableContext structureConfigurableContext) {
        if (library == null) {
            LibraryPresentationManagerImpl.a(0);
        }
        SmartList smartList = new SmartList();
        PersistentLibraryKind persistentLibraryKind = ((LibraryEx)library).getKind();
        if (persistentLibraryKind != null) {
            smartList.add(persistentLibraryKind);
        }
        VirtualFile[] virtualFileArray = LibraryPresentationManagerImpl.a(library, structureConfigurableContext);
        LibraryDetectionManager.getInstance().processProperties(Arrays.asList(virtualFileArray), new LibraryDetectionManager.LibraryPropertiesProcessor((List)smartList){
            final /* synthetic */ List val$result;
            {
                this.val$result = list2;
            }

            public <P extends LibraryProperties> boolean processProperties(@NotNull LibraryKind libraryKind, @NotNull P p2) {
                if (libraryKind == null) {
                    1.a(0);
                }
                if (p2 == null) {
                    1.a(1);
                }
                this.val$result.add(libraryKind);
                return true;
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "kind";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "properties";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/openapi/roots/ui/configuration/libraries/impl/LibraryPresentationManagerImpl$1";
                objectArray[2] = "processProperties";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        return smartList;
    }

    @NotNull
    private static VirtualFile[] a(@NotNull Library library, @Nullable StructureConfigurableContext structureConfigurableContext) {
        if (library == null) {
            LibraryPresentationManagerImpl.a(1);
        }
        if (((LibraryEx)library).isDisposed()) {
            if (VirtualFile.EMPTY_ARRAY == null) {
                LibraryPresentationManagerImpl.a(2);
            }
            return VirtualFile.EMPTY_ARRAY;
        }
        VirtualFile[] virtualFileArray = structureConfigurableContext != null ? structureConfigurableContext.getLibraryFiles(library, OrderRootType.CLASSES) : library.getFiles(OrderRootType.CLASSES);
        if (virtualFileArray == null) {
            LibraryPresentationManagerImpl.a(3);
        }
        return virtualFileArray;
    }

    private <P extends LibraryProperties> LibraryPresentationProvider<P> a(LibraryKind libraryKind) {
        if (this.a == null) {
            HashMap hashMap = new HashMap();
            for (LibraryType libraryType : (LibraryType[])LibraryType.EP_NAME.getExtensions()) {
                hashMap.put((LibraryKind)libraryType.getKind(), (LibraryPresentationProvider<?>)libraryType);
            }
            for (LibraryType libraryType : (LibraryPresentationProvider[])LibraryPresentationProvider.EP_NAME.getExtensions()) {
                hashMap.put(libraryType.getKind(), (LibraryPresentationProvider<?>)libraryType);
            }
            this.a = hashMap;
        }
        return this.a.get(libraryKind);
    }

    @Override
    @NotNull
    public Icon getNamedLibraryIcon(@NotNull Library library, @Nullable StructureConfigurableContext structureConfigurableContext) {
        Icon icon;
        if (library == null) {
            LibraryPresentationManagerImpl.a(4);
        }
        Icon icon2 = (icon = this.getCustomIcon(library, structureConfigurableContext)) != null ? icon : PlatformIcons.LIBRARY_ICON;
        if (icon2 == null) {
            LibraryPresentationManagerImpl.a(5);
        }
        return icon2;
    }

    @Override
    public Icon getCustomIcon(@NotNull Library library, StructureConfigurableContext structureConfigurableContext) {
        LibraryEx libraryEx;
        PersistentLibraryKind persistentLibraryKind;
        if (library == null) {
            LibraryPresentationManagerImpl.a(6);
        }
        if ((persistentLibraryKind = (libraryEx = (LibraryEx)library).getKind()) != null) {
            return LibraryType.findByKind((LibraryKind)persistentLibraryKind).getIcon(libraryEx.getProperties());
        }
        List<Icon> list2 = this.getCustomIcons(library, structureConfigurableContext);
        if (list2.size() == 1) {
            return list2.get(0);
        }
        return null;
    }

    @Override
    @NotNull
    public List<Icon> getCustomIcons(@NotNull Library library, StructureConfigurableContext structureConfigurableContext) {
        if (library == null) {
            LibraryPresentationManagerImpl.a(7);
        }
        VirtualFile[] virtualFileArray = LibraryPresentationManagerImpl.a(library, structureConfigurableContext);
        SmartList smartList = new SmartList();
        LibraryDetectionManager.getInstance().processProperties(Arrays.asList(virtualFileArray), new LibraryDetectionManager.LibraryPropertiesProcessor((List)smartList){
            final /* synthetic */ List val$icons;
            {
                this.val$icons = list2;
            }

            public <P extends LibraryProperties> boolean processProperties(@NotNull LibraryKind libraryKind, @NotNull P p2) {
                LibraryPresentationProvider libraryPresentationProvider;
                if (libraryKind == null) {
                    2.a(0);
                }
                if (p2 == null) {
                    2.a(1);
                }
                if ((libraryPresentationProvider = LibraryPresentationManagerImpl.this.a(libraryKind)) != null) {
                    ContainerUtil.addIfNotNull((Collection)this.val$icons, (Object)libraryPresentationProvider.getIcon(p2));
                }
                return true;
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "kind";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "properties";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/openapi/roots/ui/configuration/libraries/impl/LibraryPresentationManagerImpl$2";
                objectArray[2] = "processProperties";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        SmartList smartList2 = smartList;
        if (smartList2 == null) {
            LibraryPresentationManagerImpl.a(8);
        }
        return smartList2;
    }

    @Override
    public boolean isLibraryOfKind(@NotNull List<VirtualFile> list2, final @NotNull LibraryKind libraryKind) {
        if (list2 == null) {
            LibraryPresentationManagerImpl.a(9);
        }
        if (libraryKind == null) {
            LibraryPresentationManagerImpl.a(10);
        }
        return !LibraryDetectionManager.getInstance().processProperties(list2, new LibraryDetectionManager.LibraryPropertiesProcessor(){

            public <P extends LibraryProperties> boolean processProperties(@NotNull LibraryKind libraryKind2, @NotNull P p2) {
                if (libraryKind2 == null) {
                    3.a(0);
                }
                if (p2 == null) {
                    3.a(1);
                }
                return !libraryKind.equals(libraryKind2);
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "processedKind";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "properties";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/openapi/roots/ui/configuration/libraries/impl/LibraryPresentationManagerImpl$3";
                objectArray[2] = "processProperties";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @Override
    public boolean isLibraryOfKind(@NotNull Library library, @NotNull LibrariesContainer librariesContainer, final @NotNull Set<? extends LibraryKind> set) {
        PersistentLibraryKind persistentLibraryKind;
        if (library == null) {
            LibraryPresentationManagerImpl.a(11);
        }
        if (librariesContainer == null) {
            LibraryPresentationManagerImpl.a(12);
        }
        if (set == null) {
            LibraryPresentationManagerImpl.a(13);
        }
        if ((persistentLibraryKind = ((LibraryEx)library).getKind()) != null && set.contains(persistentLibraryKind)) {
            return true;
        }
        VirtualFile[] virtualFileArray = librariesContainer.getLibraryFiles(library, OrderRootType.CLASSES);
        return !LibraryDetectionManager.getInstance().processProperties(Arrays.asList(virtualFileArray), new LibraryDetectionManager.LibraryPropertiesProcessor(){

            public <P extends LibraryProperties> boolean processProperties(@NotNull LibraryKind libraryKind, @NotNull P p2) {
                if (libraryKind == null) {
                    4.a(0);
                }
                if (p2 == null) {
                    4.a(1);
                }
                return !set.contains(libraryKind);
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "processedKind";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "properties";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/openapi/roots/ui/configuration/libraries/impl/LibraryPresentationManagerImpl$4";
                objectArray[2] = "processProperties";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @Override
    @NotNull
    public List<String> getDescriptions(@NotNull Library library, StructureConfigurableContext structureConfigurableContext) {
        if (library == null) {
            LibraryPresentationManagerImpl.a(14);
        }
        VirtualFile[] virtualFileArray = LibraryPresentationManagerImpl.a(library, structureConfigurableContext);
        List<String> list2 = this.getDescriptions(virtualFileArray, Collections.emptySet());
        if (list2 == null) {
            LibraryPresentationManagerImpl.a(15);
        }
        return list2;
    }

    @Override
    @NotNull
    public List<String> getDescriptions(@NotNull VirtualFile[] virtualFileArray, final Set<LibraryKind> set) {
        if (virtualFileArray == null) {
            LibraryPresentationManagerImpl.a(16);
        }
        final SmartList smartList = new SmartList();
        LibraryDetectionManager.getInstance().processProperties(Arrays.asList(virtualFileArray), new LibraryDetectionManager.LibraryPropertiesProcessor(){

            public <P extends LibraryProperties> boolean processProperties(@NotNull LibraryKind libraryKind, @NotNull P p2) {
                LibraryPresentationProvider libraryPresentationProvider;
                if (libraryKind == null) {
                    5.a(0);
                }
                if (p2 == null) {
                    5.a(1);
                }
                if (!set.contains(libraryKind) && (libraryPresentationProvider = LibraryPresentationManagerImpl.this.a(libraryKind)) != null) {
                    ContainerUtil.addIfNotNull((Collection)smartList, (Object)libraryPresentationProvider.getDescription(p2));
                }
                return true;
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "kind";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "properties";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/openapi/roots/ui/configuration/libraries/impl/LibraryPresentationManagerImpl$5";
                objectArray[2] = "processProperties";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        SmartList smartList2 = smartList;
        if (smartList2 == null) {
            LibraryPresentationManagerImpl.a(17);
        }
        return smartList2;
    }

    @Override
    public List<Library> getLibraries(@NotNull Set<LibraryKind> set, @NotNull Project project2, @Nullable StructureConfigurableContext structureConfigurableContext) {
        Object object;
        if (set == null) {
            LibraryPresentationManagerImpl.a(18);
        }
        if (project2 == null) {
            LibraryPresentationManagerImpl.a(19);
        }
        ArrayList<Library> arrayList = new ArrayList<Library>();
        if (structureConfigurableContext != null) {
            Collections.addAll(arrayList, structureConfigurableContext.getProjectLibrariesProvider().getModifiableModel().getLibraries());
            Collections.addAll(arrayList, structureConfigurableContext.getGlobalLibrariesProvider().getModifiableModel().getLibraries());
        } else {
            object = LibraryTablesRegistrar.getInstance();
            Collections.addAll(arrayList, object.getLibraryTable(project2).getLibraries());
            Collections.addAll(arrayList, object.getLibraryTable().getLibraries());
        }
        object = arrayList.iterator();
        while (object.hasNext()) {
            Library library = (Library)object.next();
            List<LibraryKind> list2 = LibraryPresentationManagerImpl.getLibraryKinds(library, structureConfigurableContext);
            if (ContainerUtil.intersects(list2, set)) continue;
            object.remove();
        }
        return arrayList;
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 15: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 15: 
            case 17: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/libraries/impl/LibraryPresentationManagerImpl";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "librariesContainer";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "acceptedKinds";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classRoots";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kinds";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/libraries/impl/LibraryPresentationManagerImpl";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryFiles";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamedLibraryIcon";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomIcons";
                break;
            }
            case 15: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptions";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLibraryKinds";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getLibraryFiles";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 15: 
            case 17: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getNamedLibraryIcon";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getCustomIcon";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getCustomIcons";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isLibraryOfKind";
                break;
            }
            case 14: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getDescriptions";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getLibraries";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 15: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

