/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.libraryEditor;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryKind;
import com.intellij.openapi.roots.libraries.LibraryType;
import com.intellij.openapi.roots.libraries.LibraryTypeService;
import com.intellij.openapi.roots.libraries.NewLibraryConfiguration;
import com.intellij.openapi.roots.libraries.ui.LibraryRootsComponentDescriptor;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.libraries.LibraryEditingUtil;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.DefaultLibraryRootsComponentDescriptor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.NewLibraryEditor;
import com.intellij.openapi.roots.ui.configuration.projectRoot.BaseLibrariesConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesModifiableModel;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ModuleStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectLibrariesConfigurable;
import com.intellij.openapi.ui.MasterDetailsComponent;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PlatformIcons;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateNewLibraryAction
extends DumbAwareAction {
    @Nullable
    private final LibraryType b;
    private final BaseLibrariesConfigurable a;
    private final Project c;

    private CreateNewLibraryAction(@NotNull String string, @Nullable Icon icon, @Nullable LibraryType libraryType, @NotNull BaseLibrariesConfigurable baseLibrariesConfigurable, @NotNull Project project2) {
        if (string == null) {
            CreateNewLibraryAction.a(0);
        }
        if (baseLibrariesConfigurable == null) {
            CreateNewLibraryAction.a(1);
        }
        if (project2 == null) {
            CreateNewLibraryAction.a(2);
        }
        super(string, null, icon);
        this.b = libraryType;
        this.a = baseLibrariesConfigurable;
        this.c = project2;
    }

    @Nullable
    public static Library createLibrary(@Nullable LibraryType libraryType, @NotNull JComponent jComponent, @NotNull Project project2, @NotNull LibrariesModifiableModel librariesModifiableModel) {
        NewLibraryConfiguration newLibraryConfiguration;
        if (jComponent == null) {
            CreateNewLibraryAction.a(3);
        }
        if (project2 == null) {
            CreateNewLibraryAction.a(4);
        }
        if (librariesModifiableModel == null) {
            CreateNewLibraryAction.a(5);
        }
        if ((newLibraryConfiguration = CreateNewLibraryAction.createNewLibraryConfiguration(libraryType, jComponent, project2)) == null) {
            return null;
        }
        LibraryType libraryType2 = newLibraryConfiguration.getLibraryType();
        Library library = librariesModifiableModel.createLibrary(LibraryEditingUtil.suggestNewLibraryName(librariesModifiableModel, newLibraryConfiguration.getDefaultLibraryName()), libraryType2 != null ? libraryType2.getKind() : null);
        NewLibraryEditor newLibraryEditor = new NewLibraryEditor(libraryType2, newLibraryConfiguration.getProperties());
        newLibraryConfiguration.addRoots((LibraryEditor)newLibraryEditor);
        Library.ModifiableModel modifiableModel = library.getModifiableModel();
        newLibraryEditor.applyTo((LibraryEx.ModifiableModelEx)modifiableModel);
        WriteAction.run(() -> modifiableModel.commit());
        return library;
    }

    @Nullable
    public static NewLibraryConfiguration createNewLibraryConfiguration(@Nullable LibraryType libraryType, @NotNull JComponent jComponent, @NotNull Project project2) {
        if (jComponent == null) {
            CreateNewLibraryAction.a(6);
        }
        if (project2 == null) {
            CreateNewLibraryAction.a(7);
        }
        VirtualFile virtualFile = project2.getBaseDir();
        NewLibraryConfiguration newLibraryConfiguration = libraryType != null ? libraryType.createNewLibrary(jComponent, virtualFile, project2) : LibraryTypeService.getInstance().createLibraryFromFiles((LibraryRootsComponentDescriptor)new DefaultLibraryRootsComponentDescriptor(), jComponent, virtualFile, null, project2);
        if (newLibraryConfiguration == null) {
            return null;
        }
        return newLibraryConfiguration;
    }

    public static AnAction[] createActionOrGroup(@NotNull String string, @NotNull BaseLibrariesConfigurable baseLibrariesConfigurable, @NotNull Project project2) {
        Object object;
        if (string == null) {
            CreateNewLibraryAction.a(8);
        }
        if (baseLibrariesConfigurable == null) {
            CreateNewLibraryAction.a(9);
        }
        if (project2 == null) {
            CreateNewLibraryAction.a(10);
        }
        LibraryType[] libraryTypeArray = (LibraryType[])LibraryType.EP_NAME.getExtensions();
        ArrayList<LibraryType> arrayList = new ArrayList<LibraryType>();
        if (baseLibrariesConfigurable instanceof ProjectLibrariesConfigurable || !project2.isDefault()) {
            object = ModuleStructureConfigurable.getInstance(project2);
            for (LibraryType libraryType : libraryTypeArray) {
                if (LibraryEditingUtil.getSuitableModules((ModuleStructureConfigurable)((Object)object), (LibraryKind)libraryType.getKind(), null).isEmpty()) continue;
                arrayList.add(libraryType);
            }
        } else {
            Collections.addAll(arrayList, libraryTypeArray);
        }
        if (arrayList.isEmpty()) {
            return new AnAction[]{new CreateNewLibraryAction(string, PlatformIcons.LIBRARY_ICON, null, baseLibrariesConfigurable, project2)};
        }
        object = new ArrayList();
        object.add(new CreateNewLibraryAction(IdeBundle.message((String)"create.default.library.type.action.name", (Object[])new Object[0]), PlatformIcons.LIBRARY_ICON, null, baseLibrariesConfigurable, project2));
        for (LibraryType libraryType : arrayList) {
            String string2 = libraryType.getCreateActionName();
            if (string2 == null) continue;
            object.add(new CreateNewLibraryAction(string2, libraryType.getIcon(null), libraryType, baseLibrariesConfigurable, project2));
        }
        return object.toArray(AnAction.EMPTY_ARRAY);
    }

    public void actionPerformed(AnActionEvent anActionEvent) {
        Library library = CreateNewLibraryAction.createLibrary(this.b, (JComponent)this.a.getTree(), this.c, this.a.getModelProvider().getModifiableModel());
        if (library == null) {
            return;
        }
        BaseLibrariesConfigurable baseLibrariesConfigurable = ProjectStructureConfigurable.getInstance(this.c).getConfigurableFor(library);
        MasterDetailsComponent.MyNode myNode = MasterDetailsComponent.findNodeByObject((TreeNode)((TreeNode)baseLibrariesConfigurable.getTree().getModel().getRoot()), (Object)library);
        baseLibrariesConfigurable.selectNodeInTree((DefaultMutableTreeNode)myNode);
        LibraryEditingUtil.showDialogAndAddLibraryToDependencies(library, this.c, true);
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "librariesConfigurable";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentComponent";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifiableModel";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/libraryEditor/CreateNewLibraryAction";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "createLibrary";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "createNewLibraryConfiguration";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "createActionOrGroup";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

