/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.libraryEditor;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryDetectionManager;
import com.intellij.openapi.roots.libraries.LibraryKind;
import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryType;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditorBase;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditorListener;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExistingLibraryEditor
extends LibraryEditorBase
implements Disposable {
    private final LibraryEx a;
    private final LibraryEditorListener c;
    private String f;
    private LibraryProperties h;
    private LibraryProperties g;
    private LibraryEx.ModifiableModelEx e;
    private LibraryType<?> d;
    private boolean b;

    public ExistingLibraryEditor(@NotNull Library library, @Nullable LibraryEditorListener libraryEditorListener) {
        if (library == null) {
            ExistingLibraryEditor.b(0);
        }
        this.a = (LibraryEx)library;
        this.c = libraryEditorListener;
    }

    public Library getLibrary() {
        return this.a;
    }

    public String getName() {
        if (this.f != null) {
            return this.f;
        }
        return this.a.getName();
    }

    public LibraryType<?> getType() {
        PersistentLibraryKind persistentLibraryKind = this.a.getKind();
        if (persistentLibraryKind != null) {
            return LibraryType.findByKind((LibraryKind)persistentLibraryKind);
        }
        return this.a();
    }

    @Override
    @Nullable
    public ProjectModelExternalSource getExternalSource() {
        return this.a.getExternalSource();
    }

    @Override
    public void setType(@NotNull LibraryType<?> libraryType) {
        if (libraryType == null) {
            ExistingLibraryEditor.b(1);
        }
        this.getModel().setKind(libraryType.getKind());
    }

    private LibraryType a() {
        if (!this.b) {
            Pair pair2;
            LibraryTable libraryTable = this.a.getTable();
            if ((libraryTable == null || libraryTable.isEditable()) && (pair2 = LibraryDetectionManager.getInstance().detectType(Arrays.asList(this.getFiles(OrderRootType.CLASSES)))) != null) {
                this.d = (LibraryType)pair2.getFirst();
                this.g = (LibraryProperties)pair2.getSecond();
            }
            this.b = true;
        }
        return this.d;
    }

    public LibraryProperties getProperties() {
        LibraryType<?> libraryType = this.getType();
        if (libraryType == null) {
            return null;
        }
        if (this.d != null) {
            return this.g;
        }
        if (this.h == null) {
            this.h = libraryType.getKind().createDefaultProperties();
            this.h.loadState(this.b().getState());
        }
        return this.h;
    }

    @Override
    public void setProperties(LibraryProperties libraryProperties) {
        this.h = libraryProperties;
    }

    private LibraryProperties b() {
        return this.a.getProperties();
    }

    public void dispose() {
        if (this.e != null) {
            Disposer.dispose((Disposable)this.e);
        }
    }

    @NotNull
    public String[] getUrls(@NotNull OrderRootType orderRootType) {
        if (orderRootType == null) {
            ExistingLibraryEditor.b(2);
        }
        if (this.e != null) {
            String[] stringArray = this.e.getUrls(orderRootType);
            if (stringArray == null) {
                ExistingLibraryEditor.b(3);
            }
            return stringArray;
        }
        String[] stringArray = this.a.getUrls(orderRootType);
        if (stringArray == null) {
            ExistingLibraryEditor.b(4);
        }
        return stringArray;
    }

    @NotNull
    public VirtualFile[] getFiles(@NotNull OrderRootType orderRootType) {
        if (orderRootType == null) {
            ExistingLibraryEditor.b(5);
        }
        if (this.e != null) {
            VirtualFile[] virtualFileArray = this.e.getFiles(orderRootType);
            if (virtualFileArray == null) {
                ExistingLibraryEditor.b(6);
            }
            return virtualFileArray;
        }
        VirtualFile[] virtualFileArray = this.a.getFiles(orderRootType);
        if (virtualFileArray == null) {
            ExistingLibraryEditor.b(7);
        }
        return virtualFileArray;
    }

    @NotNull
    public String[] getExcludedRootUrls() {
        if (this.e != null) {
            String[] stringArray = this.e.getExcludedRootUrls();
            if (stringArray == null) {
                ExistingLibraryEditor.b(8);
            }
            return stringArray;
        }
        String[] stringArray = this.a.getExcludedRootUrls();
        if (stringArray == null) {
            ExistingLibraryEditor.b(9);
        }
        return stringArray;
    }

    public void setName(String string) {
        String string2 = this.getModel().getName();
        this.f = string;
        this.getModel().setName(string);
        if (this.c != null) {
            this.c.libraryRenamed((Library)this.a, string2, string);
        }
    }

    public void addRoot(@NotNull VirtualFile virtualFile, @NotNull OrderRootType orderRootType) {
        if (virtualFile == null) {
            ExistingLibraryEditor.b(10);
        }
        if (orderRootType == null) {
            ExistingLibraryEditor.b(11);
        }
        this.getModel().addRoot(virtualFile, orderRootType);
    }

    public void addRoot(@NotNull String string, @NotNull OrderRootType orderRootType) {
        if (string == null) {
            ExistingLibraryEditor.b(12);
        }
        if (orderRootType == null) {
            ExistingLibraryEditor.b(13);
        }
        this.getModel().addRoot(string, orderRootType);
    }

    public void addExcludedRoot(@NotNull String string) {
        if (string == null) {
            ExistingLibraryEditor.b(14);
        }
        this.getModel().addExcludedRoot(string);
    }

    public void addJarDirectory(@NotNull VirtualFile virtualFile, boolean bl2, @NotNull OrderRootType orderRootType) {
        if (virtualFile == null) {
            ExistingLibraryEditor.b(15);
        }
        if (orderRootType == null) {
            ExistingLibraryEditor.b(16);
        }
        this.getModel().addJarDirectory(virtualFile, bl2, orderRootType);
    }

    public void addJarDirectory(@NotNull String string, boolean bl2, @NotNull OrderRootType orderRootType) {
        if (string == null) {
            ExistingLibraryEditor.b(17);
        }
        if (orderRootType == null) {
            ExistingLibraryEditor.b(18);
        }
        this.getModel().addJarDirectory(string, bl2, orderRootType);
    }

    public void removeRoot(@NotNull String string, @NotNull OrderRootType orderRootType) {
        if (string == null) {
            ExistingLibraryEditor.b(19);
        }
        if (orderRootType == null) {
            ExistingLibraryEditor.b(20);
        }
        this.getModel().removeRoot(string, orderRootType);
    }

    public void removeExcludedRoot(@NotNull String string) {
        if (string == null) {
            ExistingLibraryEditor.b(21);
        }
        this.getModel().removeExcludedRoot(string);
    }

    public void commit() {
        if (this.e != null) {
            if (this.h != null) {
                this.e.setProperties(this.h);
            }
            this.e.commit();
            this.e = null;
            this.f = null;
            this.h = null;
        }
    }

    public LibraryEx.ModifiableModelEx getModel() {
        if (this.e == null) {
            this.e = this.a.getModifiableModel();
        }
        return this.e;
    }

    public boolean hasChanges() {
        if (this.e != null && this.e.isChanged()) {
            return true;
        }
        return this.h != null && !this.h.equals((Object)this.b());
    }

    public boolean isJarDirectory(@NotNull String string, @NotNull OrderRootType orderRootType) {
        if (string == null) {
            ExistingLibraryEditor.b(22);
        }
        if (orderRootType == null) {
            ExistingLibraryEditor.b(23);
        }
        if (this.e != null) {
            return this.e.isJarDirectory(string, orderRootType);
        }
        return this.a.isJarDirectory(string, orderRootType);
    }

    public boolean isValid(@NotNull String string, @NotNull OrderRootType orderRootType) {
        if (string == null) {
            ExistingLibraryEditor.b(24);
        }
        if (orderRootType == null) {
            ExistingLibraryEditor.b(25);
        }
        if (this.e != null) {
            return this.e.isValid(string, orderRootType);
        }
        return this.a.isValid(string, orderRootType);
    }

    @Override
    public Collection<OrderRootType> getOrderRootTypes() {
        return Arrays.asList(OrderRootType.getAllTypes());
    }

    private static /* synthetic */ void b(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: 
            case 5: 
            case 11: 
            case 13: 
            case 16: 
            case 18: 
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootType";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/libraryEditor/ExistingLibraryEditor";
                break;
            }
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 12: 
            case 14: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orderRootType";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/libraryEditor/ExistingLibraryEditor";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrls";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFiles";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludedRootUrls";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setType";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getUrls";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFiles";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addRoot";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addExcludedRoot";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addJarDirectory";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "removeRoot";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "removeExcludedRoot";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isJarDirectory";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isValid";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

