/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.libraryEditor;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.PersistentOrderRootType;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import com.intellij.openapi.roots.libraries.LibraryKind;
import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.roots.libraries.LibraryType;
import com.intellij.openapi.roots.libraries.ui.AttachRootButtonDescriptor;
import com.intellij.openapi.roots.libraries.ui.LibraryEditorComponent;
import com.intellij.openapi.roots.libraries.ui.LibraryPropertiesEditor;
import com.intellij.openapi.roots.libraries.ui.LibraryRootsComponentDescriptor;
import com.intellij.openapi.roots.libraries.ui.OrderRoot;
import com.intellij.openapi.roots.libraries.ui.impl.RootDetectionUtil;
import com.intellij.openapi.roots.ui.configuration.ModificationOfImportedModelWarningComponent;
import com.intellij.openapi.roots.ui.configuration.libraries.LibraryPresentationManager;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.DefaultLibraryRootsComponentDescriptor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.ExcludedRootElement;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.ExistingLibraryEditor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.ItemElement;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryRootsTreeSpeedSearch;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryTableTreeBuilder;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryTableTreeContentElement;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryTreeRenderer;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryTreeStructure;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.NewLibraryEditor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.OrderRootTypeElement;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.UrlComparator;
import com.intellij.openapi.ui.ex.MultiLineLabel;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IconUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FilteringIterator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibraryRootsComponent
implements Disposable,
LibraryEditorComponent {
    static final UrlComparator ourUrlComparator = new UrlComparator();
    private JPanel l;
    private JPanel o;
    private MultiLineLabel p;
    private JPanel f;
    private JPanel e;
    private LibraryPropertiesEditor m;
    private Tree d;
    private LibraryTableTreeBuilder n;
    private final ModificationOfImportedModelWarningComponent g;
    private VirtualFile h;
    private final Collection<Runnable> c;
    @Nullable
    private final Project a;
    private final Computable<LibraryEditor> b;
    private LibraryRootsComponentDescriptor i;
    private Module j;
    private AddExcludedRootActionButton k;

    public LibraryRootsComponent(@Nullable Project project2, @NotNull LibraryEditor libraryEditor) {
        if (libraryEditor == null) {
            LibraryRootsComponent.a(0);
        }
        this(project2, (Computable<LibraryEditor>)new Computable.PredefinedValueComputable((Object)libraryEditor));
    }

    public LibraryRootsComponent(@Nullable Project project2, @NotNull Computable<LibraryEditor> computable) {
        if (computable == null) {
            LibraryRootsComponent.a(1);
        }
        this.b();
        this.c = ContainerUtil.createLockFreeCopyOnWriteList();
        this.a = project2;
        this.b = computable;
        LibraryEditor libraryEditor = this.getLibraryEditor();
        LibraryType libraryType = libraryEditor.getType();
        if (libraryType != null) {
            this.i = libraryType.createLibraryRootsComponentDescriptor();
            this.m = libraryType.createPropertiesEditor((LibraryEditorComponent)this);
            if (this.m != null) {
                this.f.add((Component)this.m.createComponent(), "Center");
            }
        }
        if (this.i == null) {
            this.i = new DefaultLibraryRootsComponentDescriptor();
        }
        this.g = new ModificationOfImportedModelWarningComponent();
        this.e.add("Center", this.g.getLabel());
        this.a(new LibraryTreeStructure(this, this.i));
        this.updatePropertiesLabel();
        this.a();
    }

    private void a() {
        this.k.setEnabled(!this.c().isEmpty());
    }

    @NotNull
    public LibraryProperties getProperties() {
        LibraryProperties libraryProperties = this.getLibraryEditor().getProperties();
        if (libraryProperties == null) {
            LibraryRootsComponent.a(2);
        }
        return libraryProperties;
    }

    public boolean isNewLibrary() {
        return this.getLibraryEditor() instanceof NewLibraryEditor;
    }

    public void updatePropertiesLabel() {
        StringBuilder stringBuilder = new StringBuilder();
        LibraryType libraryType = this.getLibraryEditor().getType();
        Set<LibraryKind> set = libraryType != null ? Collections.singleton(libraryType.getKind()) : Collections.emptySet();
        for (String string : LibraryPresentationManager.getInstance().getDescriptions(this.getLibraryEditor().getFiles(OrderRootType.CLASSES), set)) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("\n");
            }
            stringBuilder.append(string);
        }
        this.p.setText(stringBuilder.toString());
    }

    private void a(AbstractTreeStructure abstractTreeStructure) {
        this.d = new Tree((TreeModel)new DefaultTreeModel(new DefaultMutableTreeNode()));
        this.d.setRootVisible(false);
        this.d.setShowsRootHandles(true);
        new LibraryRootsTreeSpeedSearch(this.d);
        this.d.setCellRenderer((TreeCellRenderer)((Object)new LibraryTreeRenderer()));
        this.n = new LibraryTableTreeBuilder((JTree)this.d, (DefaultTreeModel)this.d.getModel(), abstractTreeStructure);
        this.o.setLayout(new BorderLayout());
        ToolbarDecorator toolbarDecorator = ToolbarDecorator.createDecorator((JTree)this.d).disableUpDownActions().setRemoveActionName(ProjectBundle.message((String)"library.remove.action", (Object[])new Object[0])).disableRemoveAction();
        toolbarDecorator.setPanelBorder((Border)new CustomLineBorder(1, 0, 0, 0));
        final ArrayList<AttachRootButtonDescriptor> arrayList = new ArrayList<AttachRootButtonDescriptor>();
        for (AttachRootButtonDescriptor attachRootButtonDescriptor : this.i.createAttachButtons()) {
            Icon icon = attachRootButtonDescriptor.getToolbarIcon();
            if (icon != null) {
                AttachItemAction attachItemAction = new AttachItemAction(attachRootButtonDescriptor, attachRootButtonDescriptor.getButtonText(), icon);
                toolbarDecorator.addExtraAction(AnActionButton.fromAction((AnAction)attachItemAction));
                continue;
            }
            arrayList.add(attachRootButtonDescriptor);
        }
        this.k = new AddExcludedRootActionButton();
        toolbarDecorator.addExtraAction((AnActionButton)this.k);
        toolbarDecorator.addExtraAction(new AnActionButton("Remove", IconUtil.getRemoveIcon()){

            public void actionPerformed(AnActionEvent anActionEvent) {
                Object[] objectArray = LibraryRootsComponent.this.g();
                if (objectArray.length == 0) {
                    return;
                }
                ApplicationManager.getApplication().runWriteAction(() -> {
                    for (Object object : objectArray) {
                        ItemElement itemElement;
                        if (object instanceof ItemElement) {
                            itemElement = (ItemElement)((Object)((Object)object));
                            LibraryRootsComponent.this.getLibraryEditor().removeRoot(itemElement.getUrl(), itemElement.getRootType());
                            continue;
                        }
                        if (object instanceof OrderRootTypeElement) {
                            String[] stringArray;
                            itemElement = ((OrderRootTypeElement)((Object)((Object)object))).getOrderRootType();
                            for (String string : stringArray = LibraryRootsComponent.this.getLibraryEditor().getUrls((OrderRootType)itemElement)) {
                                LibraryRootsComponent.this.getLibraryEditor().removeRoot(string, (OrderRootType)itemElement);
                            }
                            continue;
                        }
                        if (!(object instanceof ExcludedRootElement)) continue;
                        LibraryRootsComponent.this.getLibraryEditor().removeExcludedRoot(((ExcludedRootElement)((Object)((Object)object))).getUrl());
                    }
                });
                LibraryRootsComponent.this.a(true);
            }

            public void updateButton(AnActionEvent anActionEvent) {
                super.updateButton(anActionEvent);
                Object[] objectArray = LibraryRootsComponent.this.g();
                Presentation presentation = anActionEvent.getPresentation();
                if (ContainerUtil.and((Object[])objectArray, (Condition)new FilteringIterator.InstanceOf(ExcludedRootElement.class))) {
                    presentation.setText("Cancel Exclusion");
                } else {
                    presentation.setText(this.getTemplatePresentation().getText());
                }
            }

            public ShortcutSet getShortcut() {
                return CommonShortcuts.getDelete();
            }
        });
        toolbarDecorator.setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton anActionButton) {
                if (arrayList.isEmpty()) {
                    new AttachFilesAction(LibraryRootsComponent.this.i.getAttachFilesActionName()).actionPerformed(null);
                    return;
                }
                ArrayList<AttachItemActionBase> arrayList2 = new ArrayList<AttachItemActionBase>();
                arrayList2.add(new AttachFilesAction(LibraryRootsComponent.this.i.getAttachFilesActionName()));
                for (AttachRootButtonDescriptor attachRootButtonDescriptor : arrayList) {
                    arrayList2.add(new AttachItemAction(attachRootButtonDescriptor, attachRootButtonDescriptor.getButtonText(), null));
                }
                DefaultActionGroup defaultActionGroup = new DefaultActionGroup(arrayList2);
                JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)defaultActionGroup, DataManager.getInstance().getDataContext((Component)anActionButton.getContextComponent()), JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, true).show(anActionButton.getPreferredPopupPoint());
            }
        });
        this.o.add((Component)toolbarDecorator.createPanel(), "Center");
        Disposer.register((Disposable)this, (Disposable)this.n);
    }

    public JComponent getComponent() {
        return this.l;
    }

    @Nullable
    public Project getProject() {
        return this.a;
    }

    public void setContextModule(Module module2) {
        this.j = module2;
    }

    @Nullable
    public VirtualFile getExistingRootDirectory() {
        for (PersistentOrderRootType persistentOrderRootType : OrderRootType.getAllPersistentTypes()) {
            VirtualFile[] virtualFileArray = this.getLibraryEditor().getFiles((OrderRootType)persistentOrderRootType);
            if (virtualFileArray.length <= 0) continue;
            VirtualFile virtualFile = virtualFileArray[0];
            if (virtualFile.getFileSystem() instanceof JarFileSystem) {
                virtualFile = JarFileSystem.getInstance().getVirtualFileForJar(virtualFile);
            }
            if (virtualFile == null) continue;
            if (virtualFile.isDirectory()) {
                return virtualFile;
            }
            return virtualFile.getParent();
        }
        return null;
    }

    @Nullable
    public VirtualFile getBaseDirectory() {
        if (this.a != null) {
            return this.a.getBaseDir();
        }
        return null;
    }

    public LibraryEditor getLibraryEditor() {
        return (LibraryEditor)this.b.compute();
    }

    public boolean hasChanges() {
        if (this.m != null && this.m.isModified()) {
            return true;
        }
        return this.getLibraryEditor().hasChanges();
    }

    private Object[] g() {
        if (this.n == null || this.n.isDisposed()) {
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        TreePath[] treePathArray = this.n.getTree().getSelectionPaths();
        if (treePathArray == null) {
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (TreePath treePath : treePathArray) {
            Object object = LibraryRootsComponent.a(treePath);
            if (object == null) continue;
            arrayList.add(object);
        }
        return ArrayUtil.toObjectArray(arrayList);
    }

    public void onLibraryRenamed() {
        this.e();
    }

    @Nullable
    private static Object a(TreePath treePath) {
        if (treePath == null) {
            return null;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        if (defaultMutableTreeNode == null) {
            return null;
        }
        Object object = defaultMutableTreeNode.getUserObject();
        if (!(object instanceof NodeDescriptor)) {
            return null;
        }
        Object object2 = ((NodeDescriptor)object).getElement();
        if (!(object2 instanceof LibraryTableTreeContentElement)) {
            return null;
        }
        return object2;
    }

    public void renameLibrary(String string) {
        LibraryEditor libraryEditor = this.getLibraryEditor();
        libraryEditor.setName(string);
        this.a(false);
    }

    public void dispose() {
        if (this.m != null) {
            this.m.disposeUIResources();
        }
        this.n = null;
    }

    public void resetProperties() {
        if (this.m != null) {
            this.m.reset();
        }
    }

    public void applyProperties() {
        if (this.m != null && this.m.isModified()) {
            this.m.apply();
        }
    }

    public void updateRootsTree() {
        if (this.n != null) {
            this.n.queueUpdate();
        }
    }

    @Nullable
    private VirtualFile d() {
        if (this.h != null) {
            return this.h;
        }
        VirtualFile virtualFile = this.getExistingRootDirectory();
        if (virtualFile != null) {
            return virtualFile;
        }
        return this.getBaseDirectory();
    }

    private List<OrderRoot> c(List<OrderRoot> list2) {
        List<OrderRoot> list3 = this.b(list2);
        if (!list3.isEmpty()) {
            ApplicationManager.getApplication().runWriteAction(() -> this.getLibraryEditor().addRoots((Collection)list3));
            this.updatePropertiesLabel();
            this.a();
            this.n.queueUpdate();
        }
        return list3;
    }

    private List<OrderRoot> b(@NotNull List<OrderRoot> list2) {
        if (list2 == null) {
            LibraryRootsComponent.a(3);
        }
        ArrayList<OrderRoot> arrayList = new ArrayList<OrderRoot>();
        for (OrderRoot orderRoot : list2) {
            Object[] objectArray = this.getLibraryEditor().getFiles(orderRoot.getType());
            if (ArrayUtil.contains((Object)orderRoot.getFile(), (Object[])objectArray)) continue;
            arrayList.add(orderRoot);
        }
        return arrayList;
    }

    private void a(boolean bl2) {
        this.a();
        this.updatePropertiesLabel();
        this.n.queueUpdate();
        if (bl2) {
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.d, true));
        }
        this.f();
    }

    private void f() {
        for (Runnable runnable : this.c) {
            runnable.run();
        }
        this.e();
    }

    private void e() {
        LibraryEditor libraryEditor = this.getLibraryEditor();
        ProjectModelExternalSource projectModelExternalSource = libraryEditor.getExternalSource();
        if (projectModelExternalSource != null && this.hasChanges()) {
            String string = libraryEditor instanceof ExistingLibraryEditor ? ((ExistingLibraryEditor)libraryEditor).getLibrary().getName() : libraryEditor.getName();
            this.g.showWarning(string != null ? "Library '" + string + "'" : "Library", projectModelExternalSource);
        } else {
            this.g.hideWarning();
        }
    }

    public void addListener(Runnable runnable) {
        this.c.add(runnable);
    }

    public void removeListener(Runnable runnable) {
        this.c.remove(runnable);
    }

    private Set<VirtualFile> c() {
        LinkedHashSet<VirtualFile> linkedHashSet = new LinkedHashSet<VirtualFile>();
        String[] stringArray = this.getLibraryEditor().getExcludedRootUrls();
        HashSet hashSet = new HashSet();
        for (String string : stringArray) {
            ContainerUtil.addIfNotNull(hashSet, (Object)VirtualFileManager.getInstance().findFileByUrl(string));
        }
        for (String string : OrderRootType.getAllPersistentTypes()) {
            VirtualFile[] virtualFileArray;
            for (VirtualFile virtualFile : virtualFileArray = this.getLibraryEditor().getFiles((OrderRootType)string)) {
                if (VfsUtilCore.isUnder((VirtualFile)virtualFile, hashSet)) continue;
                linkedHashSet.add(VfsUtil.getLocalFile((VirtualFile)virtualFile));
            }
        }
        return linkedHashSet;
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryEditor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryEditorComputable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/libraryEditor/LibraryRootsComponent";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/libraryEditor/LibraryRootsComponent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProperties";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "filterAlreadyAdded";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void b() {
        JPanel jPanel;
        JPanel jPanel2;
        MultiLineLabel multiLineLabel;
        JPanel jPanel3;
        JPanel jPanel4;
        this.l = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, 2, false, false));
        this.o = jPanel3 = new JPanel();
        jPanel4.add((Component)jPanel3, new GridConstraints(2, 0, 1, 1, 0, 3, 7, 7, null, new Dimension(300, -1), null));
        this.p = multiLineLabel = new MultiLineLabel();
        jPanel4.add((Component)multiLineLabel, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        this.f = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.e = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.l;
    }

    private class AddExcludedRootActionButton
    extends AnActionButton {
        public AddExcludedRootActionButton() {
            super("Exclude", null, AllIcons.Modules.AddExcludedRoot);
        }

        public void actionPerformed(AnActionEvent anActionEvent) {
            FileChooserDescriptor fileChooserDescriptor = FileChooserDescriptorFactory.createMultipleJavaPathDescriptor();
            fileChooserDescriptor.setTitle("Exclude from Library");
            fileChooserDescriptor.setDescription("Select directories which should be excluded from the library content. Content of excluded directories won't be processed by IDE.");
            Set set = LibraryRootsComponent.this.c();
            fileChooserDescriptor.setRoots(set.toArray(VirtualFile.EMPTY_ARRAY));
            if (set.size() < 2) {
                fileChooserDescriptor.withTreeRootVisible(true);
            }
            VirtualFile virtualFile = null;
            Object[] objectArray = LibraryRootsComponent.this.g();
            int n2 = objectArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Object object;
                Object object2 = objectArray[i2];
                Object object3 = object = object2 instanceof ExcludedRootElement ? ((ExcludedRootElement)((Object)object2)).getParentDescriptor() : object2;
                if (!(object instanceof ItemElement)) continue;
                virtualFile = VirtualFileManager.getInstance().findFileByUrl(((ItemElement)((Object)object)).getUrl());
                break;
            }
            if ((objectArray = FileChooser.chooseFiles((FileChooserDescriptor)fileChooserDescriptor, (Component)LibraryRootsComponent.this.l, (Project)LibraryRootsComponent.this.a, virtualFile)).length > 0) {
                ApplicationManager.getApplication().runWriteAction(() -> this.a((VirtualFile[])objectArray));
                LibraryRootsComponent.this.h = (VirtualFile)objectArray[0];
                LibraryRootsComponent.this.a(true);
            }
        }

        private /* synthetic */ void a(VirtualFile[] virtualFileArray) {
            for (VirtualFile virtualFile : virtualFileArray) {
                LibraryRootsComponent.this.getLibraryEditor().addExcludedRoot(virtualFile.getUrl());
            }
        }
    }

    private class AttachItemAction
    extends AttachItemActionBase {
        private final AttachRootButtonDescriptor a;

        protected AttachItemAction(AttachRootButtonDescriptor attachRootButtonDescriptor, String string, Icon icon) {
            super(string);
            this.getTemplatePresentation().setIcon(icon);
            this.a = attachRootButtonDescriptor;
        }

        @Override
        protected List<OrderRoot> selectRoots(@Nullable VirtualFile virtualFile) {
            VirtualFile[] virtualFileArray = this.a.selectFiles((JComponent)LibraryRootsComponent.this.l, virtualFile, LibraryRootsComponent.this.j, LibraryRootsComponent.this.getLibraryEditor());
            if (virtualFileArray.length == 0) {
                return Collections.emptyList();
            }
            ArrayList<OrderRoot> arrayList = new ArrayList<OrderRoot>();
            for (VirtualFile virtualFile2 : this.a.scanForActualRoots(virtualFileArray, (JComponent)LibraryRootsComponent.this.l)) {
                arrayList.add(new OrderRoot(virtualFile2, this.a.getRootType(), this.a.addAsJarDirectories()));
            }
            return arrayList;
        }
    }

    public abstract class AttachItemActionBase
    extends DumbAwareAction {
        protected AttachItemActionBase(String string) {
            super(string);
        }

        public void actionPerformed(@Nullable AnActionEvent anActionEvent) {
            VirtualFile virtualFile = LibraryRootsComponent.this.d();
            List<OrderRoot> list2 = this.selectRoots(virtualFile);
            if (list2.isEmpty()) {
                return;
            }
            List list3 = LibraryRootsComponent.this.c(list2);
            OrderRoot orderRoot = (OrderRoot)ContainerUtil.getFirstItem((List)list3);
            if (orderRoot != null) {
                LibraryRootsComponent.this.h = orderRoot.getFile();
            }
            LibraryRootsComponent.this.f();
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)LibraryRootsComponent.this.d, true));
        }

        protected abstract List<OrderRoot> selectRoots(@Nullable VirtualFile var1);
    }

    private class AttachFilesAction
    extends AttachItemActionBase {
        public AttachFilesAction(String string) {
            super(string);
        }

        @Override
        protected List<OrderRoot> selectRoots(@Nullable VirtualFile virtualFile) {
            VirtualFile[] virtualFileArray;
            String string = LibraryRootsComponent.this.getLibraryEditor().getName();
            FileChooserDescriptor fileChooserDescriptor = LibraryRootsComponent.this.i.createAttachFilesChooserDescriptor(string);
            if (LibraryRootsComponent.this.j != null) {
                fileChooserDescriptor.putUserData(LangDataKeys.MODULE_CONTEXT, (Object)LibraryRootsComponent.this.j);
            }
            if ((virtualFileArray = FileChooser.chooseFiles((FileChooserDescriptor)fileChooserDescriptor, (Component)LibraryRootsComponent.this.l, (Project)LibraryRootsComponent.this.a, (VirtualFile)virtualFile)).length == 0) {
                return Collections.emptyList();
            }
            return RootDetectionUtil.detectRoots(Arrays.asList(virtualFileArray), (Component)LibraryRootsComponent.this.l, (Project)LibraryRootsComponent.this.a, (LibraryRootsComponentDescriptor)LibraryRootsComponent.this.i);
        }
    }
}

