/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.libraryEditor;

import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.roots.libraries.LibraryType;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditorBase;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.impl.LightFilePointer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NewLibraryEditor
extends LibraryEditorBase {
    private String a;
    private final MultiMap<OrderRootType, LightFilePointer> d;
    private final Set<LightFilePointer> e;
    private final MultiMap<OrderRootType, String> f = new MultiMap();
    private final MultiMap<OrderRootType, String> g = new MultiMap();
    private LibraryType b;
    private LibraryProperties h;
    private boolean c = true;

    public NewLibraryEditor() {
        this(null, null);
    }

    public NewLibraryEditor(@Nullable LibraryType libraryType, @Nullable LibraryProperties libraryProperties) {
        this.b = libraryType;
        this.h = libraryProperties;
        this.d = new MultiMap();
        this.e = new LinkedHashSet<LightFilePointer>();
    }

    public void setKeepInvalidUrls(boolean bl2) {
        this.c = bl2;
    }

    @Override
    public Collection<OrderRootType> getOrderRootTypes() {
        return this.d.keySet();
    }

    @Nullable
    public LibraryType<?> getType() {
        return this.b;
    }

    @Override
    public void setType(@NotNull LibraryType<?> libraryType) {
        if (libraryType == null) {
            NewLibraryEditor.b(0);
        }
        this.b = libraryType;
    }

    public LibraryProperties getProperties() {
        return this.h;
    }

    @Override
    public void setProperties(LibraryProperties libraryProperties) {
        this.h = libraryProperties;
    }

    public String getName() {
        return this.a;
    }

    @NotNull
    public String[] getUrls(@NotNull OrderRootType orderRootType) {
        if (orderRootType == null) {
            NewLibraryEditor.b(1);
        }
        String[] stringArray = NewLibraryEditor.a(this.d.get((Object)orderRootType));
        if (stringArray == null) {
            NewLibraryEditor.b(2);
        }
        return stringArray;
    }

    private static String[] a(Collection<LightFilePointer> collection) {
        ArrayList<String> arrayList = new ArrayList<String>(collection.size());
        for (LightFilePointer lightFilePointer : collection) {
            arrayList.add(lightFilePointer.getUrl());
        }
        return ArrayUtil.toStringArray(arrayList);
    }

    @NotNull
    public VirtualFile[] getFiles(@NotNull OrderRootType orderRootType) {
        if (orderRootType == null) {
            NewLibraryEditor.b(3);
        }
        ArrayList<VirtualFile> arrayList = new ArrayList<VirtualFile>();
        for (LightFilePointer lightFilePointer : this.d.get((Object)orderRootType)) {
            String string;
            VirtualFile virtualFile = lightFilePointer.getFile();
            if (virtualFile == null) continue;
            if (virtualFile.isDirectory() && this.isJarDirectory(string = virtualFile.getUrl(), orderRootType)) {
                boolean bl2 = this.g.get((Object)orderRootType).contains(string);
                NewLibraryEditor.a(virtualFile, arrayList, bl2);
                continue;
            }
            arrayList.add(virtualFile);
        }
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray(arrayList);
        if (virtualFileArray == null) {
            NewLibraryEditor.b(4);
        }
        return virtualFileArray;
    }

    @NotNull
    public String[] getExcludedRootUrls() {
        String[] stringArray = NewLibraryEditor.a(this.e);
        if (stringArray == null) {
            NewLibraryEditor.b(5);
        }
        return stringArray;
    }

    public void setName(String string) {
        this.a = string;
    }

    public void addRoot(@NotNull VirtualFile virtualFile, @NotNull OrderRootType orderRootType) {
        if (virtualFile == null) {
            NewLibraryEditor.b(6);
        }
        if (orderRootType == null) {
            NewLibraryEditor.b(7);
        }
        this.d.putValue((Object)orderRootType, (Object)new LightFilePointer(virtualFile));
    }

    public void addRoot(@NotNull String string, @NotNull OrderRootType orderRootType) {
        if (string == null) {
            NewLibraryEditor.b(8);
        }
        if (orderRootType == null) {
            NewLibraryEditor.b(9);
        }
        this.d.putValue((Object)orderRootType, (Object)new LightFilePointer(string));
    }

    public void addJarDirectory(@NotNull VirtualFile virtualFile, boolean bl2, @NotNull OrderRootType orderRootType) {
        if (virtualFile == null) {
            NewLibraryEditor.b(10);
        }
        if (orderRootType == null) {
            NewLibraryEditor.b(11);
        }
        this.addJarDirectory(virtualFile.getUrl(), bl2, orderRootType);
    }

    public void addExcludedRoot(@NotNull String string) {
        if (string == null) {
            NewLibraryEditor.b(12);
        }
        this.e.add(new LightFilePointer(string));
    }

    public void removeExcludedRoot(@NotNull String string) {
        if (string == null) {
            NewLibraryEditor.b(13);
        }
        this.e.remove(new LightFilePointer(string));
    }

    public void addJarDirectory(@NotNull String string, boolean bl2, @NotNull OrderRootType orderRootType) {
        if (string == null) {
            NewLibraryEditor.b(14);
        }
        if (orderRootType == null) {
            NewLibraryEditor.b(15);
        }
        this.addRoot(string, orderRootType);
        (bl2 ? this.g : this.f).putValue((Object)orderRootType, (Object)string);
    }

    public void removeRoot(@NotNull String string, @NotNull OrderRootType orderRootType) {
        if (string == null) {
            NewLibraryEditor.b(16);
        }
        if (orderRootType == null) {
            NewLibraryEditor.b(17);
        }
        this.d.remove((Object)orderRootType, (Object)new LightFilePointer(string));
        this.e.removeIf(lightFilePointer -> !this.a(lightFilePointer.getUrl()));
        this.f.remove((Object)orderRootType, (Object)string);
        this.g.remove((Object)orderRootType, (Object)string);
    }

    private boolean a(@NotNull String string) {
        if (string == null) {
            NewLibraryEditor.b(18);
        }
        for (LightFilePointer lightFilePointer : this.d.values()) {
            if (!VfsUtilCore.isEqualOrAncestor((String)lightFilePointer.getUrl(), (String)string)) continue;
            return true;
        }
        return false;
    }

    public boolean hasChanges() {
        return true;
    }

    public boolean isJarDirectory(@NotNull String string, @NotNull OrderRootType orderRootType) {
        if (string == null) {
            NewLibraryEditor.b(19);
        }
        if (orderRootType == null) {
            NewLibraryEditor.b(20);
        }
        return this.f.get((Object)orderRootType).contains(string) || this.g.get((Object)orderRootType).contains(string);
    }

    public boolean isValid(@NotNull String string, @NotNull OrderRootType orderRootType) {
        if (string == null) {
            NewLibraryEditor.b(21);
        }
        if (orderRootType == null) {
            NewLibraryEditor.b(22);
        }
        Collection collection = this.d.get((Object)orderRootType);
        for (LightFilePointer lightFilePointer : collection) {
            if (!lightFilePointer.getUrl().equals(string)) continue;
            return lightFilePointer.isValid();
        }
        return false;
    }

    public void applyTo(@NotNull LibraryEx.ModifiableModelEx modifiableModelEx) {
        if (modifiableModelEx == null) {
            NewLibraryEditor.b(23);
        }
        modifiableModelEx.setProperties(this.h);
        this.a(arg_0 -> ((LibraryEx.ModifiableModelEx)modifiableModelEx).getUrls(arg_0), (arg_0, arg_1) -> ((LibraryEx.ModifiableModelEx)modifiableModelEx).isValid(arg_0, arg_1), (arg_0, arg_1) -> ((LibraryEx.ModifiableModelEx)modifiableModelEx).removeRoot(arg_0, arg_1), (arg_0, arg_1) -> ((LibraryEx.ModifiableModelEx)modifiableModelEx).addRoot(arg_0, arg_1), (arg_0, arg_1, arg_2) -> ((LibraryEx.ModifiableModelEx)modifiableModelEx).addJarDirectory(arg_0, arg_1, arg_2));
    }

    public void applyTo(@NotNull LibraryEditorBase libraryEditorBase) {
        if (libraryEditorBase == null) {
            NewLibraryEditor.b(24);
        }
        libraryEditorBase.setProperties(this.h);
        this.a(arg_0 -> ((LibraryEditorBase)libraryEditorBase).getUrls(arg_0), (arg_0, arg_1) -> ((LibraryEditorBase)libraryEditorBase).isValid(arg_0, arg_1), (arg_0, arg_1) -> ((LibraryEditorBase)libraryEditorBase).removeRoot(arg_0, arg_1), (arg_0, arg_1) -> ((LibraryEditorBase)libraryEditorBase).addRoot(arg_0, arg_1), (arg_0, arg_1, arg_2) -> ((LibraryEditorBase)libraryEditorBase).addJarDirectory(arg_0, arg_1, arg_2));
    }

    private void a(Function<OrderRootType, String[]> function, BiFunction<String, OrderRootType, Boolean> biFunction, BiConsumer<String, OrderRootType> biConsumer, BiConsumer<String, OrderRootType> biConsumer2, TriConsumer<String, Boolean, OrderRootType> triConsumer) {
        for (OrderRootType object : OrderRootType.getAllTypes()) {
            for (String string : function.apply(object)) {
                if (this.c && !biFunction.apply(string, object).booleanValue()) continue;
                biConsumer.accept(string, object);
            }
        }
        for (OrderRootType orderRootType : this.d.keySet()) {
            for (LightFilePointer lightFilePointer : this.d.get((Object)orderRootType)) {
                if (this.isJarDirectory(lightFilePointer.getUrl(), orderRootType)) continue;
                biConsumer2.accept(lightFilePointer.getUrl(), orderRootType);
            }
        }
        for (Map.Entry entry : this.f.entrySet()) {
            OrderRootType orderRootType = (OrderRootType)entry.getKey();
            for (String string : (Collection)entry.getValue()) {
                triConsumer.accept(string, false, orderRootType);
            }
        }
        for (Map.Entry entry : this.g.entrySet()) {
            OrderRootType orderRootType = (OrderRootType)entry.getKey();
            for (String string : (Collection)entry.getValue()) {
                triConsumer.accept(string, true, orderRootType);
            }
        }
    }

    private static void a(@NotNull VirtualFile virtualFile, final @NotNull List<VirtualFile> list2, boolean bl2) {
        if (virtualFile == null) {
            NewLibraryEditor.b(25);
        }
        if (list2 == null) {
            NewLibraryEditor.b(26);
        }
        VfsUtilCore.visitChildrenRecursively((VirtualFile)virtualFile, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[]{VirtualFileVisitor.SKIP_ROOT, bl2 ? null : VirtualFileVisitor.ONE_LEVEL_DEEP}){

            public boolean visitFile(@NotNull VirtualFile virtualFile) {
                VirtualFile virtualFile2;
                if (virtualFile == null) {
                    1.a(0);
                }
                if (!virtualFile.isDirectory() && FileTypeRegistry.getInstance().getFileTypeByFileName(virtualFile.getName()) == ArchiveFileType.INSTANCE && (virtualFile2 = StandardFileSystems.jar().findFileByPath(virtualFile.getPath() + "!/")) != null) {
                    list2.add(virtualFile2);
                    return false;
                }
                return true;
            }

            private static /* synthetic */ void a(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/ui/configuration/libraryEditor/NewLibraryEditor$1", "visitFile"));
            }
        });
    }

    private static /* synthetic */ void b(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 9: 
            case 11: 
            case 15: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootType";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/libraryEditor/NewLibraryEditor";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orderRootType";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/libraryEditor/NewLibraryEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrls";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFiles";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludedRootUrls";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setType";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getUrls";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getFiles";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addRoot";
                break;
            }
            case 10: 
            case 11: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addJarDirectory";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addExcludedRoot";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "removeExcludedRoot";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "removeRoot";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isUnderRoots";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isJarDirectory";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isValid";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "applyTo";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "collectJarFiles";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @FunctionalInterface
    private static interface TriConsumer<T, U, P> {
        public void accept(T var1, U var2, P var3);
    }
}

