/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot;

import com.intellij.CommonBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.impl.libraries.LibraryImpl;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablePresentation;
import com.intellij.openapi.roots.ui.configuration.libraries.LibraryEditingUtil;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.CreateNewLibraryAction;
import com.intellij.openapi.roots.ui.configuration.projectRoot.AddLibraryToModuleDependenciesAction;
import com.intellij.openapi.roots.ui.configuration.projectRoot.BaseStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ChangeLibraryLevelAction;
import com.intellij.openapi.roots.ui.configuration.projectRoot.GlobalLibrariesConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesModifiableModel;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibraryConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectLibrariesConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.RemoveConfigurableHandler;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureLibraryTableModifiableModelProvider;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.LibraryProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureDaemonAnalyzer;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElementUsage;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.MasterDetailsComponent;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.openapi.ui.NonEmptyInputValidator;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.tree.TreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseLibrariesConfigurable
extends BaseStructureConfigurable {
    protected final String myLevel;

    protected BaseLibrariesConfigurable(@NotNull Project project2, @NotNull String string) {
        if (project2 == null) {
            BaseLibrariesConfigurable.b(0);
        }
        if (string == null) {
            BaseLibrariesConfigurable.b(1);
        }
        super(project2);
        this.myLevel = string;
    }

    public static BaseLibrariesConfigurable getInstance(@NotNull Project project2, @NotNull String string) {
        if (project2 == null) {
            BaseLibrariesConfigurable.b(2);
        }
        if (string == null) {
            BaseLibrariesConfigurable.b(3);
        }
        if (string.equals("project")) {
            return ProjectLibrariesConfigurable.getInstance(project2);
        }
        return GlobalLibrariesConfigurable.getInstance(project2);
    }

    public abstract LibraryTablePresentation getLibraryTablePresentation();

    @Nullable
    @NonNls
    public String getHelpTopic() {
        return "reference.settingsdialog.project.structure.library";
    }

    public boolean isModified() {
        boolean bl2 = false;
        for (LibrariesModifiableModel librariesModifiableModel : this.myContext.myLevel2Providers.values()) {
            bl2 |= librariesModifiableModel.isChanged();
        }
        return bl2 || super.isModified();
    }

    @Override
    public void checkCanApply() throws ConfigurationException {
        super.checkCanApply();
        this.checkForEmptyAndDuplicatedNames("Library", CommonBundle.getErrorTitle(), LibraryConfigurable.class);
        for (LibraryConfigurable libraryConfigurable : this.a()) {
            if (!libraryConfigurable.getDisplayName().isEmpty()) continue;
            ((LibraryProjectStructureElement)libraryConfigurable.getProjectStructureElement()).navigate();
            throw new ConfigurationException("Library name is not specified");
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.myTree.setRootVisible(false);
    }

    @Override
    protected void loadTree() {
        this.a(this.myContext.createModifiableModelProvider(this.myLevel));
    }

    @Override
    @NotNull
    protected Collection<? extends ProjectStructureElement> getProjectStructureElements() {
        ArrayList<LibraryProjectStructureElement> arrayList = new ArrayList<LibraryProjectStructureElement>();
        for (LibraryConfigurable libraryConfigurable : this.a()) {
            arrayList.add(new LibraryProjectStructureElement(this.myContext, libraryConfigurable.getEditableObject()));
        }
        ArrayList<LibraryProjectStructureElement> arrayList2 = arrayList;
        if (arrayList2 == null) {
            BaseLibrariesConfigurable.b(4);
        }
        return arrayList2;
    }

    private List<LibraryConfigurable> a() {
        ArrayList<LibraryConfigurable> arrayList = new ArrayList<LibraryConfigurable>();
        for (int i2 = 0; i2 < this.myRoot.getChildCount(); ++i2) {
            NamedConfigurable namedConfigurable;
            TreeNode treeNode = this.myRoot.getChildAt(i2);
            if (!(treeNode instanceof MasterDetailsComponent.MyNode) || !((namedConfigurable = ((MasterDetailsComponent.MyNode)treeNode).getConfigurable()) instanceof LibraryConfigurable)) continue;
            arrayList.add((LibraryConfigurable)namedConfigurable);
        }
        return arrayList;
    }

    private void a(StructureLibraryTableModifiableModelProvider structureLibraryTableModifiableModelProvider) {
        Library[] libraryArray;
        for (Library library : libraryArray = structureLibraryTableModifiableModelProvider.getModifiableModel().getLibraries()) {
            this.myRoot.add((MutableTreeNode)new MasterDetailsComponent.MyNode((NamedConfigurable)new LibraryConfigurable(structureLibraryTableModifiableModelProvider, library, this.myContext, this.TREE_UPDATER)));
        }
        TreeUtil.sortRecursively((MutableTreeNode)this.myRoot, (myNode, myNode2) -> myNode.getDisplayName().compareToIgnoreCase(myNode2.getDisplayName()));
        ((DefaultTreeModel)this.myTree.getModel()).reload((TreeNode)this.myRoot);
    }

    public void apply() throws ConfigurationException {
        super.apply();
        ApplicationManager.getApplication().runWriteAction(() -> {
            for (LibrariesModifiableModel librariesModifiableModel : this.myContext.myLevel2Providers.values()) {
                librariesModifiableModel.deferredCommit();
            }
        });
    }

    public String getLevel() {
        return this.myLevel;
    }

    public void createLibraryNode(Library library) {
        LibraryTable libraryTable = library.getTable();
        if (libraryTable != null) {
            String string = libraryTable.getTableLevel();
            LibraryConfigurable libraryConfigurable = new LibraryConfigurable(this.myContext.createModifiableModelProvider(string), library, this.myContext, this.TREE_UPDATER);
            MasterDetailsComponent.MyNode myNode = new MasterDetailsComponent.MyNode((NamedConfigurable)libraryConfigurable);
            this.addNode(myNode, this.myRoot);
            ProjectStructureDaemonAnalyzer projectStructureDaemonAnalyzer = this.myContext.getDaemonAnalyzer();
            projectStructureDaemonAnalyzer.queueUpdate(new LibraryProjectStructureElement(this.myContext, library));
            projectStructureDaemonAnalyzer.queueUpdateForAllElementsWithErrors();
        }
    }

    public void removeLibraryNode(@NotNull Library library) {
        if (library == null) {
            BaseLibrariesConfigurable.b(5);
        }
        this.removeLibrary(new LibraryProjectStructureElement(this.myContext, library));
    }

    public void dispose() {
        if (this.myContext != null) {
            for (LibrariesModifiableModel librariesModifiableModel : this.myContext.myLevel2Providers.values()) {
                Disposer.dispose((Disposable)librariesModifiableModel);
            }
        }
    }

    @Override
    @NotNull
    protected List<? extends AnAction> createCopyActions(boolean bl2) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add((Object)new CopyLibraryAction());
        if (bl2) {
            BaseLibrariesConfigurable baseLibrariesConfigurable = this.getOppositeGroup();
            arrayList.add((Object)new ChangeLibraryLevelAction(this.myProject, (JComponent)this.myTree, this, baseLibrariesConfigurable));
            arrayList.add((Object)new AddLibraryToModuleDependenciesAction(this.myProject, this));
        }
        ArrayList<Object> arrayList2 = arrayList;
        if (arrayList2 == null) {
            BaseLibrariesConfigurable.b(6);
        }
        return arrayList2;
    }

    @Override
    protected BaseStructureConfigurable.AbstractAddGroup createAddAction() {
        return new BaseStructureConfigurable.AbstractAddGroup(this.getAddText()){

            @NotNull
            public AnAction[] getChildren(@Nullable AnActionEvent anActionEvent) {
                AnAction[] anActionArray = CreateNewLibraryAction.createActionOrGroup(BaseLibrariesConfigurable.this.getAddText(), BaseLibrariesConfigurable.this, BaseLibrariesConfigurable.this.myProject);
                if (anActionArray == null) {
                    1.a(0);
                }
                return anActionArray;
            }

            private static /* synthetic */ void a(int n2) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/projectRoot/BaseLibrariesConfigurable$1", "getChildren"));
            }
        };
    }

    protected abstract String getAddText();

    public abstract StructureLibraryTableModifiableModelProvider getModelProvider();

    public abstract BaseLibrariesConfigurable getOppositeGroup();

    protected void updateSelection(@Nullable NamedConfigurable namedConfigurable) {
        boolean bl2;
        boolean bl3 = bl2 = !Comparing.equal((Object)this.myCurrentConfigurable, (Object)namedConfigurable);
        if (this.myCurrentConfigurable instanceof LibraryConfigurable && bl2) {
            ((LibraryConfigurable)this.myCurrentConfigurable).onUnselected();
        }
        super.updateSelection(namedConfigurable);
        if (this.myCurrentConfigurable instanceof LibraryConfigurable && bl2) {
            ((LibraryConfigurable)this.myCurrentConfigurable).onSelected();
        }
    }

    @Override
    public void onStructureUnselected() {
        if (this.myCurrentConfigurable instanceof LibraryConfigurable) {
            ((LibraryConfigurable)this.myCurrentConfigurable).onUnselected();
        }
    }

    @Override
    public void onStructureSelected() {
        if (this.myCurrentConfigurable instanceof LibraryConfigurable) {
            ((LibraryConfigurable)this.myCurrentConfigurable).onSelected();
        }
    }

    public void removeLibrary(@NotNull LibraryProjectStructureElement libraryProjectStructureElement) {
        if (libraryProjectStructureElement == null) {
            BaseLibrariesConfigurable.b(7);
        }
        this.removeLibraries(Collections.singletonList(libraryProjectStructureElement));
    }

    public void removeLibraries(@NotNull List<LibraryProjectStructureElement> list2) {
        if (list2 == null) {
            BaseLibrariesConfigurable.b(8);
        }
        ArrayList<TreePath> arrayList = new ArrayList<TreePath>();
        for (LibraryProjectStructureElement libraryProjectStructureElement : list2) {
            this.getModelProvider().getModifiableModel().removeLibrary(libraryProjectStructureElement.getLibrary());
            MasterDetailsComponent.MyNode myNode = BaseLibrariesConfigurable.findNodeByObject((TreeNode)this.myRoot, (Object)libraryProjectStructureElement.getLibrary());
            if (myNode == null) continue;
            arrayList.add(TreeUtil.getPathFromRoot((TreeNode)myNode));
        }
        this.myContext.getDaemonAnalyzer().removeElements(list2);
        this.removePaths(arrayList.toArray(new TreePath[0]));
    }

    @Override
    protected List<? extends RemoveConfigurableHandler<?>> getRemoveHandlers() {
        return Collections.singletonList(new RemoveConfigurableHandler<Library>(LibraryConfigurable.class){

            @Override
            public boolean remove(@NotNull Collection<Library> collection) {
                if (collection == null) {
                    2.b(0);
                }
                ArrayList<Pair> arrayList = new ArrayList<Pair>();
                String string = null;
                String string2 = null;
                int n2 = 0;
                Object object = collection.iterator();
                while (object.hasNext()) {
                    Library library = object.next();
                    LibraryTable libraryTable = library.getTable();
                    if (libraryTable == null) continue;
                    Object object2 = new LibraryProjectStructureElement(BaseLibrariesConfigurable.this.myContext, library);
                    ArrayList<ProjectStructureElementUsage> arrayList2 = new ArrayList<ProjectStructureElementUsage>(BaseLibrariesConfigurable.this.myContext.getDaemonAnalyzer().getUsages((ProjectStructureElement)object2));
                    if (arrayList2.size() > 0) {
                        if (n2 == 0) {
                            MultiMap multiMap = new MultiMap();
                            for (ProjectStructureElementUsage projectStructureElementUsage : arrayList2) {
                                multiMap.putValue((Object)projectStructureElementUsage.getContainingElement().getTypeName(), (Object)projectStructureElementUsage);
                            }
                            ArrayList arrayList3 = new ArrayList(multiMap.keySet());
                            Collections.sort(arrayList3);
                            StringBuilder stringBuilder = new StringBuilder("Library '");
                            Library library2 = BaseLibrariesConfigurable.this.myContext.getLibraryModel(library);
                            stringBuilder.append(library2 != null ? library2.getName() : library.getName()).append("' is used in ");
                            for (int i2 = 0; i2 < arrayList3.size(); ++i2) {
                                if (i2 > 0 && i2 == arrayList3.size() - 1) {
                                    stringBuilder.append(" and in ");
                                } else if (i2 > 0) {
                                    stringBuilder.append(", in ");
                                }
                                String string3 = (String)arrayList3.get(i2);
                                Collection collection2 = multiMap.get((Object)string3);
                                if (collection2.size() > 1) {
                                    stringBuilder.append(collection2.size()).append(" ").append(StringUtil.decapitalize((String)StringUtil.pluralize((String)string3)));
                                    continue;
                                }
                                stringBuilder.append(StringUtil.decapitalize((String)((ProjectStructureElementUsage)collection2.iterator().next()).getContainingElement().getPresentableText()));
                            }
                            string2 = library.getName();
                            string = stringBuilder.toString();
                        }
                        ++n2;
                    }
                    arrayList.add(Pair.create((Object)object2, arrayList2));
                }
                if (n2 > 0 && 0 != Messages.showOkCancelDialog((Project)BaseLibrariesConfigurable.this.myProject, (String)(object = n2 == 1 ? string + ".\nAre you sure you want to delete this library?" : ProjectBundle.message((String)"libraries.remove.confirmation.text", (Object[])new Object[]{string2, n2 - 1})), (String)ProjectBundle.message((String)"libraries.remove.confirmation.title", (Object[])new Object[]{n2}), (Icon)Messages.getQuestionIcon())) {
                    return false;
                }
                for (Pair pair2 : arrayList) {
                    for (Object object2 : (Collection)pair2.getSecond()) {
                        ((ProjectStructureElementUsage)object2).removeSourceElement();
                    }
                    BaseLibrariesConfigurable.this.getModelProvider().getModifiableModel().removeLibrary(((LibraryProjectStructureElement)pair2.getFirst()).getLibrary());
                    BaseLibrariesConfigurable.this.myContext.getDaemonAnalyzer().removeElement((ProjectStructureElement)pair2.getFirst());
                }
                return true;
            }

            @Override
            public boolean canBeRemoved(@NotNull Collection<Library> collection) {
                if (collection == null) {
                    2.b(1);
                }
                for (Library library : collection) {
                    LibraryTable libraryTable = library.getTable();
                    if (libraryTable == null || libraryTable.isEditable()) continue;
                    return false;
                }
                return true;
            }

            private static /* synthetic */ void b(int n2) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "libraries";
                objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/projectRoot/BaseLibrariesConfigurable$2";
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "remove";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "canBeRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @Nullable
    protected String getEmptySelectionString() {
        return "Select a library to view or edit its details here";
    }

    private static /* synthetic */ void b(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 4: 
            case 6: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryTableLevel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tableLevel";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/projectRoot/BaseLibrariesConfigurable";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraries";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/projectRoot/BaseLibrariesConfigurable";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectStructureElements";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createCopyActions";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removeLibraryNode";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "removeLibrary";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "removeLibraries";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class CopyLibraryAction
    extends AnAction {
        private CopyLibraryAction() {
            super(CommonBundle.message((String)"button.copy", (Object[])new Object[0]), CommonBundle.message((String)"button.copy", (Object[])new Object[0]), COPY_ICON);
        }

        public void actionPerformed(AnActionEvent anActionEvent) {
            Object object = BaseLibrariesConfigurable.this.getSelectedObject();
            if (object instanceof LibraryEx) {
                LibraryEx libraryEx = (LibraryEx)object;
                String string = Messages.showInputDialog((String)"Enter library name:", (String)"Copy Library", null, (String)(libraryEx.getName() + "2"), (InputValidator)new NonEmptyInputValidator());
                if (string == null) {
                    return;
                }
                BaseLibrariesConfigurable baseLibrariesConfigurable = BaseLibrariesConfigurable.this;
                LibraryEx libraryEx2 = (LibraryEx)BaseLibrariesConfigurable.this.myContext.getLibrary(libraryEx.getName(), BaseLibrariesConfigurable.this.myLevel);
                LOG.assertTrue(libraryEx2 != null);
                LibrariesModifiableModel librariesModifiableModel = baseLibrariesConfigurable.getModelProvider().getModifiableModel();
                Library library = librariesModifiableModel.createLibrary(string, libraryEx2.getKind());
                LibraryEx.ModifiableModelEx modifiableModelEx = librariesModifiableModel.getLibraryEditor(library).getModel();
                LibraryEditingUtil.copyLibrary(libraryEx2, Collections.emptyMap(), modifiableModelEx);
            }
        }

        public void update(AnActionEvent anActionEvent) {
            if (BaseLibrariesConfigurable.this.myTree.getSelectionPaths() == null || BaseLibrariesConfigurable.this.myTree.getSelectionPaths().length != 1) {
                anActionEvent.getPresentation().setEnabled(false);
            } else {
                anActionEvent.getPresentation().setEnabled(BaseLibrariesConfigurable.this.getSelectedObject() instanceof LibraryImpl);
            }
        }
    }
}

