/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import com.intellij.openapi.roots.impl.libraries.LibraryImpl;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.ExistingLibraryEditor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditorListener;
import com.intellij.openapi.roots.ui.configuration.projectRoot.BaseLibrariesConfigurable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibrariesModifiableModel
implements LibraryTable.ModifiableModel {
    private final Map<Library, ExistingLibraryEditor> a = ContainerUtil.newIdentityTroveMap();
    private final Set<Library> c = ContainerUtil.newIdentityTroveSet();
    private LibraryTable.ModifiableModel b;
    private final Project d;
    private final LibraryTable e;
    private final LibraryEditorListener f;

    public LibrariesModifiableModel(LibraryTable libraryTable, Project project2, LibraryEditorListener libraryEditorListener) {
        this.d = project2;
        this.e = libraryTable;
        this.f = libraryEditorListener;
    }

    @NotNull
    public Library createLibrary(String string) {
        Library library = this.createLibrary(string, null);
        if (library == null) {
            LibrariesModifiableModel.a(0);
        }
        return library;
    }

    @NotNull
    public Library createLibrary(String string, @Nullable PersistentLibraryKind persistentLibraryKind) {
        Library library = this.createLibrary(string, persistentLibraryKind, null);
        if (library == null) {
            LibrariesModifiableModel.a(1);
        }
        return library;
    }

    @NotNull
    public Library createLibrary(String string, @Nullable PersistentLibraryKind persistentLibraryKind, @Nullable ProjectModelExternalSource projectModelExternalSource) {
        Library library = this.b().createLibrary(string, persistentLibraryKind, projectModelExternalSource);
        BaseLibrariesConfigurable baseLibrariesConfigurable = ProjectStructureConfigurable.getInstance(this.d).getConfigurableFor(library);
        baseLibrariesConfigurable.createLibraryNode(library);
        Library library2 = library;
        if (library2 == null) {
            LibrariesModifiableModel.a(2);
        }
        return library2;
    }

    public void removeLibrary(@NotNull Library library) {
        if (library == null) {
            LibrariesModifiableModel.a(3);
        }
        if (this.b().getLibraryByName(library.getName()) == null) {
            return;
        }
        this.a(library);
        Library library2 = this.e.getLibraryByName(library.getName());
        this.b().removeLibrary(library);
        BaseLibrariesConfigurable baseLibrariesConfigurable = ProjectStructureConfigurable.getInstance(this.d).getConfigurableFor(library);
        baseLibrariesConfigurable.removeLibraryNode(library);
        if (library2 == library) {
            this.c.add(library);
        } else {
            Disposer.dispose((Disposable)library);
        }
    }

    public void commit() {
    }

    @NotNull
    public Iterator<Library> getLibraryIterator() {
        Iterator iterator = this.b().getLibraryIterator();
        if (iterator == null) {
            LibrariesModifiableModel.a(4);
        }
        return iterator;
    }

    public Library getLibraryByName(@NotNull String string) {
        if (string == null) {
            LibrariesModifiableModel.a(5);
        }
        return this.b().getLibraryByName(string);
    }

    @NotNull
    public Library[] getLibraries() {
        Library[] libraryArray = this.b().getLibraries();
        if (libraryArray == null) {
            LibrariesModifiableModel.a(6);
        }
        return libraryArray;
    }

    public boolean isChanged() {
        for (LibraryEditor libraryEditor : this.a.values()) {
            if (!libraryEditor.hasChanges()) continue;
            return true;
        }
        return this.b().isChanged();
    }

    public void deferredCommit() {
        ArrayList<ExistingLibraryEditor> arrayList = new ArrayList<ExistingLibraryEditor>(this.a.values());
        this.a.clear();
        for (ExistingLibraryEditor existingLibraryEditor : arrayList) {
            existingLibraryEditor.commit();
            Disposer.dispose((Disposable)existingLibraryEditor);
        }
        if (!arrayList.isEmpty() || !this.c.isEmpty() || this.b != null && this.b.isChanged()) {
            this.b().commit();
            this.b = null;
        }
        this.c.clear();
    }

    public boolean wasLibraryRemoved(Library library) {
        return this.c.contains(library);
    }

    public boolean hasLibraryEditor(Library library) {
        return this.a.containsKey(library);
    }

    public ExistingLibraryEditor getLibraryEditor(Library library) {
        Library library2 = ((LibraryImpl)library).getSource();
        if (library2 != null) {
            return this.getLibraryEditor(library2);
        }
        ExistingLibraryEditor existingLibraryEditor = this.a.get(library);
        if (existingLibraryEditor == null) {
            existingLibraryEditor = this.b(library);
        }
        return existingLibraryEditor;
    }

    private ExistingLibraryEditor b(Library library) {
        ExistingLibraryEditor existingLibraryEditor = new ExistingLibraryEditor(library, this.f);
        this.a.put(library, existingLibraryEditor);
        return existingLibraryEditor;
    }

    private void a(Library library) {
        ExistingLibraryEditor existingLibraryEditor = this.a.remove(library);
        if (existingLibraryEditor != null) {
            Disposer.dispose((Disposable)existingLibraryEditor);
        }
    }

    public Library.ModifiableModel getLibraryModifiableModel(Library library) {
        return this.getLibraryEditor(library).getModel();
    }

    private LibraryTable.ModifiableModel b() {
        if (this.b == null) {
            this.b = this.e.getModifiableModel();
        }
        return this.b;
    }

    public void dispose() {
        if (this.b != null) {
            Disposer.dispose((Disposable)this.b);
            this.b = null;
        }
        this.a();
    }

    private void a() {
        for (Library library : new ArrayList<Library>(this.a.keySet())) {
            ExistingLibraryEditor existingLibraryEditor;
            Library library2 = this.e.getLibraryByName(library.getName());
            if (library2 != library) {
                Disposer.dispose((Disposable)library);
            }
            if ((existingLibraryEditor = this.a.get(library)) == null) continue;
            Disposer.dispose((Disposable)existingLibraryEditor);
        }
        this.a.clear();
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 3: 
            case 5: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesModifiableModel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createLibrary";
                break;
            }
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesModifiableModel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryIterator";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraries";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "removeLibrary";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getLibraryByName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

