/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.ui.configuration.libraries.LibraryPresentationManager;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryRootsComponent;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectStructureElementConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureLibraryTableModifiableModelProvider;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.LibraryProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibraryConfigurable
extends ProjectStructureElementConfigurable<Library> {
    private LibraryRootsComponent g;
    private final Library d;
    private final StructureLibraryTableModifiableModelProvider h;
    private final StructureConfigurableContext f;
    private final Project a;
    private final LibraryProjectStructureElement e;
    private boolean c;
    private boolean b;

    protected LibraryConfigurable(StructureLibraryTableModifiableModelProvider structureLibraryTableModifiableModelProvider, Library library, StructureConfigurableContext structureConfigurableContext, Runnable runnable) {
        super(true, runnable);
        this.h = structureLibraryTableModifiableModelProvider;
        this.f = structureConfigurableContext;
        this.a = structureConfigurableContext.getProject();
        this.d = library;
        this.e = new LibraryProjectStructureElement(structureConfigurableContext, this.d);
    }

    public JComponent createOptionsPanel() {
        this.g = new LibraryRootsComponent(this.a, (Computable<LibraryEditor>)((Computable)() -> this.getLibraryEditor()));
        this.g.addListener(() -> {
            this.f.getDaemonAnalyzer().queueUpdate(this.e);
            this.updateName();
        });
        return this.g.getComponent();
    }

    public boolean isModified() {
        return this.g != null && this.g.hasChanges();
    }

    @Override
    @NotNull
    public ProjectStructureElement getProjectStructureElement() {
        LibraryProjectStructureElement libraryProjectStructureElement = this.e;
        if (libraryProjectStructureElement == null) {
            LibraryConfigurable.a(0);
        }
        return libraryProjectStructureElement;
    }

    public void apply() {
        this.c();
    }

    public void reset() {
        this.a();
    }

    public void disposeUIResources() {
        if (this.g != null) {
            Disposer.dispose((Disposable)this.g);
            this.g = null;
        }
    }

    public void setDisplayName(String string) {
        if (!this.c) {
            this.getLibraryEditor().setName(string);
            if (this.g != null) {
                this.g.onLibraryRenamed();
            }
            this.f.getDaemonAnalyzer().queueUpdateForAllElementsWithErrors();
        }
    }

    protected LibraryEditor getLibraryEditor() {
        return this.h.getModifiableModel().getLibraryEditor(this.d);
    }

    public void updateName() {
        this.c = true;
        try {
            super.updateName();
        }
        finally {
            this.c = false;
        }
    }

    public Library getEditableObject() {
        return this.d;
    }

    public String getBannerSlogan() {
        LibraryTable libraryTable = this.d.getTable();
        String string = libraryTable == null ? ProjectBundle.message((String)"module.library.display.name", (Object[])new Object[]{1}) : libraryTable.getPresentation().getDisplayName(false);
        return ProjectBundle.message((String)"project.roots.library.banner.text", (Object[])new Object[]{this.getDisplayName(), string});
    }

    public String getDisplayName() {
        if (this.h.getModifiableModel().hasLibraryEditor(this.d)) {
            return this.getLibraryEditor().getName();
        }
        return this.d.getName();
    }

    public void onSelected() {
        this.a();
    }

    public void onUnselected() {
        this.c();
    }

    private void a() {
        if (this.g != null) {
            this.g.updatePropertiesLabel();
            this.g.resetProperties();
            this.b = true;
        }
    }

    private void c() {
        if (this.g != null && this.b) {
            this.g.applyProperties();
            this.b = false;
        }
    }

    public Icon getIcon(boolean bl2) {
        return LibraryPresentationManager.getInstance().getNamedLibraryIcon(this.d, this.f);
    }

    @Nullable
    @NonNls
    public String getHelpTopic() {
        return "preferences.jdkGlobalLibs";
    }

    public void updateComponent() {
        if (this.g != null) {
            this.g.updateRootsTree();
        }
    }

    private static /* synthetic */ void a(int n2) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/projectRoot/LibraryConfigurable", "getProjectStructureElement"));
    }
}

