/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot.daemon;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectConfigurationProblems;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureDaemonAnalyzerListener;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElementUsage;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureProblemDescription;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureProblemsHolderImpl;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureValidator;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.MultiValuesMap;
import com.intellij.util.Alarm;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectStructureDaemonAnalyzer
implements Disposable {
    private static final Logger b = Logger.getInstance((String)"#com.intellij.openapi.roots.ui.configuration.projectRoot.validation.ProjectStructureDaemonAnalyzer");
    private final Map<ProjectStructureElement, ProjectStructureProblemsHolderImpl> h = new HashMap<ProjectStructureElement, ProjectStructureProblemsHolderImpl>();
    private final MultiValuesMap<ProjectStructureElement, ProjectStructureElementUsage> a = new MultiValuesMap();
    private final MultiValuesMap<ProjectStructureElement, ProjectStructureElementUsage> g = new MultiValuesMap();
    private final Set<ProjectStructureElement> l = new HashSet<ProjectStructureElement>();
    private final Set<ProjectStructureElement> c = new HashSet<ProjectStructureElement>();
    private final Map<ProjectStructureElement, ProjectStructureProblemDescription> e = new HashMap<ProjectStructureElement, ProjectStructureProblemDescription>();
    private final MergingUpdateQueue k;
    private final MergingUpdateQueue f;
    private final EventDispatcher<ProjectStructureDaemonAnalyzerListener> j = EventDispatcher.create(ProjectStructureDaemonAnalyzerListener.class);
    private final AtomicBoolean d = new AtomicBoolean(false);
    private final ProjectConfigurationProblems i;

    public ProjectStructureDaemonAnalyzer(StructureConfigurableContext structureConfigurableContext) {
        Disposer.register((Disposable)structureConfigurableContext, (Disposable)this);
        this.i = new ProjectConfigurationProblems(this, structureConfigurableContext);
        this.k = new MergingUpdateQueue("Project Structure Daemon Analyzer", 300, false, null, (Disposable)this, null, Alarm.ThreadToUse.POOLED_THREAD);
        this.f = new MergingUpdateQueue("Project Structure Analysis Results Updater", 300, false, MergingUpdateQueue.ANY_COMPONENT, (Disposable)this, null, Alarm.ThreadToUse.SWING_THREAD);
    }

    private void a(ProjectStructureElement projectStructureElement, boolean bl2, boolean bl3) {
        if (this.d.get()) {
            return;
        }
        if (bl2) {
            this.a(projectStructureElement);
        }
        if (bl3) {
            this.b(projectStructureElement);
        }
    }

    private void a(final ProjectStructureElement projectStructureElement) {
        final ProjectStructureProblemsHolderImpl projectStructureProblemsHolderImpl = new ProjectStructureProblemsHolderImpl();
        new ReadAction(){

            protected void run(@NotNull Result result2) {
                if (result2 == null) {
                    1.a(0);
                }
                if (ProjectStructureDaemonAnalyzer.this.d.get()) {
                    return;
                }
                if (b.isDebugEnabled()) {
                    b.debug("checking " + projectStructureElement);
                }
                ProjectStructureValidator.check(projectStructureElement, projectStructureProblemsHolderImpl);
            }

            private static /* synthetic */ void a(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/openapi/roots/ui/configuration/projectRoot/daemon/ProjectStructureDaemonAnalyzer$1", "run"));
            }
        }.execute();
        this.f.queue((Update)new ProblemsComputedUpdate(projectStructureElement, projectStructureProblemsHolderImpl));
    }

    private void b(final ProjectStructureElement projectStructureElement) {
        List list2 = (List)new ReadAction<List<ProjectStructureElementUsage>>(){

            protected void run(@NotNull Result<List<ProjectStructureElementUsage>> result2) {
                if (result2 == null) {
                    2.a(0);
                }
                if (ProjectStructureDaemonAnalyzer.this.d.get()) {
                    return;
                }
                if (b.isDebugEnabled()) {
                    b.debug("collecting usages in " + projectStructureElement);
                }
                result2.setResult((Object)ProjectStructureDaemonAnalyzer.c(projectStructureElement));
            }

            private static /* synthetic */ void a(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/openapi/roots/ui/configuration/projectRoot/daemon/ProjectStructureDaemonAnalyzer$2", "run"));
            }
        }.execute().getResultObject();
        if (list2 != null) {
            this.f.queue((Update)new UsagesCollectedUpdate(projectStructureElement, list2));
        }
    }

    private static List<ProjectStructureElementUsage> c(ProjectStructureElement projectStructureElement) {
        return ProjectStructureValidator.getUsagesInElement(projectStructureElement);
    }

    private void a(ProjectStructureElement projectStructureElement, List<ProjectStructureElementUsage> list2) {
        this.d(projectStructureElement);
        for (ProjectStructureElementUsage projectStructureElementUsage : list2) {
            this.a(projectStructureElementUsage);
        }
        this.l.remove(projectStructureElement);
        this.f.queue((Update)new ReportUnusedElementsUpdate());
    }

    public void queueUpdate(@NotNull ProjectStructureElement projectStructureElement) {
        if (projectStructureElement == null) {
            ProjectStructureDaemonAnalyzer.a(0);
        }
        this.b(projectStructureElement, true, true);
    }

    private void b(@NotNull ProjectStructureElement projectStructureElement, boolean bl2, boolean bl3) {
        if (projectStructureElement == null) {
            ProjectStructureDaemonAnalyzer.a(1);
        }
        if (b.isDebugEnabled()) {
            b.debug("start " + (bl2 ? "checking " : "") + (bl3 ? "collecting usages " : "") + "for " + projectStructureElement);
        }
        if (bl3) {
            this.l.add(projectStructureElement);
        }
        if (projectStructureElement.shouldShowWarningIfUnused()) {
            this.c.add(projectStructureElement);
        }
        this.k.queue((Update)new AnalyzeElementUpdate(projectStructureElement, bl2, bl3));
    }

    public void removeElement(ProjectStructureElement projectStructureElement) {
        this.removeElements(Collections.singletonList(projectStructureElement));
    }

    public void removeElements(@NotNull List<? extends ProjectStructureElement> list2) {
        if (list2 == null) {
            ProjectStructureDaemonAnalyzer.a(2);
        }
        this.l.removeAll(list2);
        this.c.removeAll(list2);
        for (ProjectStructureElement projectStructureElement : list2) {
            this.e.remove(projectStructureElement);
            this.h.remove(projectStructureElement);
            Collection collection = this.a.removeAll((Object)projectStructureElement);
            if (collection != null) {
                for (ProjectStructureElementUsage projectStructureElementUsage : collection) {
                    this.h.remove(projectStructureElementUsage.getContainingElement());
                }
            }
            this.d(projectStructureElement);
            ((ProjectStructureDaemonAnalyzerListener)this.j.getMulticaster()).problemsChanged(projectStructureElement);
        }
        this.f.queue((Update)new ReportUnusedElementsUpdate());
    }

    private void a() {
        if (!this.l.isEmpty()) {
            return;
        }
        for (ProjectStructureElement projectStructureElement : this.c) {
            Collection collection = this.a.get((Object)projectStructureElement);
            ProjectStructureProblemDescription projectStructureProblemDescription = collection == null || collection.isEmpty() ? projectStructureElement.createUnusedElementWarning() : null;
            ProjectStructureProblemDescription projectStructureProblemDescription2 = this.e.put(projectStructureElement, projectStructureProblemDescription);
            ProjectStructureProblemsHolderImpl projectStructureProblemsHolderImpl = this.h.get(projectStructureElement);
            if (projectStructureProblemsHolderImpl == null) {
                projectStructureProblemsHolderImpl = new ProjectStructureProblemsHolderImpl();
                this.h.put(projectStructureElement, projectStructureProblemsHolderImpl);
            }
            if (projectStructureProblemDescription2 != null) {
                projectStructureProblemsHolderImpl.removeProblem(projectStructureProblemDescription2);
            }
            if (projectStructureProblemDescription != null) {
                projectStructureProblemsHolderImpl.registerProblem(projectStructureProblemDescription);
            }
            if (projectStructureProblemDescription2 == null && projectStructureProblemDescription == null) continue;
            ((ProjectStructureDaemonAnalyzerListener)this.j.getMulticaster()).problemsChanged(projectStructureElement);
        }
    }

    private void d(ProjectStructureElement projectStructureElement) {
        Collection collection = this.g.removeAll((Object)projectStructureElement);
        if (collection != null) {
            for (ProjectStructureElementUsage projectStructureElementUsage : collection) {
                this.a.remove((Object)projectStructureElementUsage.getSourceElement(), (Object)projectStructureElementUsage);
            }
        }
    }

    private void a(@NotNull ProjectStructureElementUsage projectStructureElementUsage) {
        if (projectStructureElementUsage == null) {
            ProjectStructureDaemonAnalyzer.a(3);
        }
        this.a.put((Object)projectStructureElementUsage.getSourceElement(), (Object)projectStructureElementUsage);
        this.g.put((Object)projectStructureElementUsage.getContainingElement(), (Object)projectStructureElementUsage);
    }

    public void stop() {
        b.debug("analyzer stopped");
        this.d.set(true);
        this.k.cancelAllUpdates();
        this.f.cancelAllUpdates();
        this.clearCaches();
        this.k.deactivate();
        this.f.deactivate();
    }

    public void clearCaches() {
        b.debug("clear caches");
        this.h.clear();
    }

    public void queueUpdateForAllElementsWithErrors() {
        ArrayList<ProjectStructureElement> arrayList = new ArrayList<ProjectStructureElement>();
        for (Map.Entry<ProjectStructureElement, ProjectStructureProblemsHolderImpl> entry : this.h.entrySet()) {
            if (!entry.getValue().containsProblems()) continue;
            arrayList.add(entry.getKey());
        }
        this.h.clear();
        b.debug("Adding to queue updates for " + arrayList.size() + " problematic elements");
        for (ProjectStructureElement projectStructureElement : arrayList) {
            this.queueUpdate(projectStructureElement);
        }
    }

    public void dispose() {
        this.d.set(true);
        this.k.cancelAllUpdates();
        this.f.cancelAllUpdates();
    }

    @Nullable
    public ProjectStructureProblemsHolderImpl getProblemsHolder(ProjectStructureElement projectStructureElement) {
        return this.h.get(projectStructureElement);
    }

    public Collection<ProjectStructureElementUsage> getUsages(ProjectStructureElement projectStructureElement) {
        ProjectStructureElement[] projectStructureElementArray;
        for (ProjectStructureElement projectStructureElement2 : projectStructureElementArray = this.l.toArray(new ProjectStructureElement[0])) {
            this.a(projectStructureElement2, ProjectStructureDaemonAnalyzer.c(projectStructureElement2));
        }
        List<ProjectStructureElementUsage> list2 = this.a.get((Object)projectStructureElement);
        return list2 != null ? list2 : Collections.emptyList();
    }

    public void addListener(ProjectStructureDaemonAnalyzerListener projectStructureDaemonAnalyzerListener) {
        b.debug("listener added " + projectStructureDaemonAnalyzerListener);
        this.j.addListener((EventListener)projectStructureDaemonAnalyzerListener);
    }

    public void reset() {
        b.debug("analyzer started");
        this.k.activate();
        this.f.activate();
        this.k.queue(new Update("reset"){

            public void run() {
                ProjectStructureDaemonAnalyzer.this.d.set(false);
            }
        });
    }

    public void clear() {
        this.e.clear();
        this.c.clear();
        this.a.clear();
        this.g.clear();
        this.l.clear();
        this.i.clearProblems();
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usage";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/projectRoot/daemon/ProjectStructureDaemonAnalyzer";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "queueUpdate";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "removeElements";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "addUsage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class ReportUnusedElementsUpdate
    extends Update {
        private ReportUnusedElementsUpdate() {
            super((Object)"unused elements");
        }

        public void run() {
            ProjectStructureDaemonAnalyzer.this.a();
        }
    }

    private class ProblemsComputedUpdate
    extends Update {
        private final ProjectStructureElement c;
        private final ProjectStructureProblemsHolderImpl b;
        private final Object[] a;

        public ProblemsComputedUpdate(ProjectStructureElement projectStructureElement, ProjectStructureProblemsHolderImpl projectStructureProblemsHolderImpl) {
            super((Object)projectStructureElement);
            this.c = projectStructureElement;
            this.b = projectStructureProblemsHolderImpl;
            this.a = new Object[]{projectStructureElement, "problems computed"};
        }

        @NotNull
        public Object[] getEqualityObjects() {
            if (this.a == null) {
                ProblemsComputedUpdate.a(0);
            }
            return this.a;
        }

        public void run() {
            ProjectStructureProblemDescription projectStructureProblemDescription;
            if (ProjectStructureDaemonAnalyzer.this.d.get()) {
                return;
            }
            if (b.isDebugEnabled()) {
                b.debug("updating problems for " + this.c);
            }
            if ((projectStructureProblemDescription = (ProjectStructureProblemDescription)ProjectStructureDaemonAnalyzer.this.e.get(this.c)) != null) {
                this.b.registerProblem(projectStructureProblemDescription);
            }
            ProjectStructureDaemonAnalyzer.this.h.put(this.c, this.b);
            ((ProjectStructureDaemonAnalyzerListener)ProjectStructureDaemonAnalyzer.this.j.getMulticaster()).problemsChanged(this.c);
        }

        private static /* synthetic */ void a(int n2) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/projectRoot/daemon/ProjectStructureDaemonAnalyzer$ProblemsComputedUpdate", "getEqualityObjects"));
        }
    }

    private class UsagesCollectedUpdate
    extends Update {
        private final ProjectStructureElement b;
        private final List<ProjectStructureElementUsage> c;
        private final Object[] a;

        public UsagesCollectedUpdate(ProjectStructureElement projectStructureElement, List<ProjectStructureElementUsage> list2) {
            super((Object)projectStructureElement);
            this.b = projectStructureElement;
            this.c = list2;
            this.a = new Object[]{projectStructureElement, "usages collected"};
        }

        @NotNull
        public Object[] getEqualityObjects() {
            if (this.a == null) {
                UsagesCollectedUpdate.a(0);
            }
            return this.a;
        }

        public void run() {
            if (ProjectStructureDaemonAnalyzer.this.d.get()) {
                return;
            }
            if (b.isDebugEnabled()) {
                b.debug("updating usages for " + this.b);
            }
            ProjectStructureDaemonAnalyzer.this.a(this.b, this.c);
        }

        private static /* synthetic */ void a(int n2) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/projectRoot/daemon/ProjectStructureDaemonAnalyzer$UsagesCollectedUpdate", "getEqualityObjects"));
        }
    }

    private class AnalyzeElementUpdate
    extends Update {
        private final ProjectStructureElement b;
        private final boolean d;
        private final boolean c;
        private final Object[] a;

        public AnalyzeElementUpdate(ProjectStructureElement projectStructureElement, boolean bl2, boolean bl3) {
            super((Object)projectStructureElement);
            this.b = projectStructureElement;
            this.d = bl2;
            this.c = bl3;
            this.a = new Object[]{this.b, this.d, this.c};
        }

        public boolean canEat(Update update) {
            if (!(update instanceof AnalyzeElementUpdate)) {
                return false;
            }
            AnalyzeElementUpdate analyzeElementUpdate = (AnalyzeElementUpdate)update;
            return !(!this.b.equals(analyzeElementUpdate.b) || analyzeElementUpdate.d && !this.d || analyzeElementUpdate.c && !this.c);
        }

        @NotNull
        public Object[] getEqualityObjects() {
            if (this.a == null) {
                AnalyzeElementUpdate.a(0);
            }
            return this.a;
        }

        public void run() {
            try {
                ProjectStructureDaemonAnalyzer.this.a(this.b, this.d, this.c);
            }
            catch (Throwable throwable) {
                b.error(throwable);
            }
        }

        private static /* synthetic */ void a(int n2) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/projectRoot/daemon/ProjectStructureDaemonAnalyzer$AnalyzeElementUpdate", "getEqualityObjects"));
        }
    }
}

