/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.artifacts;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.MultiValuesMap;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.elements.ComplexPackagingElementType;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementFactory;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.impl.artifacts.ArtifactBySourceFileFinder;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.artifacts.PackagingElementPath;
import com.intellij.packaging.impl.artifacts.PackagingElementProcessor;
import com.intellij.packaging.impl.elements.FileOrDirectoryCopyPackagingElement;
import com.intellij.packaging.impl.elements.ModuleOutputPackagingElement;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class ArtifactBySourceFileFinderImpl
extends ArtifactBySourceFileFinder {
    private CachedValue<MultiValuesMap<VirtualFile, Artifact>> a;
    private final Project b;

    public ArtifactBySourceFileFinderImpl(Project project2) {
        this.b = project2;
    }

    public CachedValue<MultiValuesMap<VirtualFile, Artifact>> getFileToArtifactsMap() {
        if (this.a == null) {
            this.a = CachedValuesManager.getManager((Project)this.b).createCachedValue(() -> {
                MultiValuesMap<VirtualFile, Artifact> multiValuesMap = this.b();
                ArrayList<ModificationTracker> arrayList = new ArrayList<ModificationTracker>();
                arrayList.add(ArtifactManager.getInstance((Project)this.b).getModificationTracker());
                for (ComplexPackagingElementType complexPackagingElementType : PackagingElementFactory.getInstance().getComplexElementTypes()) {
                    ContainerUtil.addIfNotNull(arrayList, (Object)complexPackagingElementType.getAllSubstitutionsModificationTracker(this.b));
                }
                return CachedValueProvider.Result.create(multiValuesMap, arrayList);
            }, false);
        }
        return this.a;
    }

    private MultiValuesMap<VirtualFile, Artifact> b() {
        final MultiValuesMap multiValuesMap = new MultiValuesMap();
        ArtifactManager artifactManager = ArtifactManager.getInstance((Project)this.b);
        for (final Artifact artifact : artifactManager.getArtifacts()) {
            final PackagingElementResolvingContext packagingElementResolvingContext = artifactManager.getResolvingContext();
            ArtifactUtil.processPackagingElements(artifact, null, new PackagingElementProcessor<PackagingElement<?>>(){

                @Override
                public boolean process(@NotNull PackagingElement<?> packagingElement, @NotNull PackagingElementPath packagingElementPath) {
                    if (packagingElement == null) {
                        1.a(0);
                    }
                    if (packagingElementPath == null) {
                        1.a(1);
                    }
                    if (packagingElement instanceof FileOrDirectoryCopyPackagingElement) {
                        VirtualFile virtualFile = ((FileOrDirectoryCopyPackagingElement)packagingElement).findFile();
                        if (virtualFile != null) {
                            multiValuesMap.put((Object)virtualFile, (Object)artifact);
                        }
                    } else if (packagingElement instanceof ModuleOutputPackagingElement) {
                        for (VirtualFile virtualFile : ((ModuleOutputPackagingElement)packagingElement).getSourceRoots(packagingElementResolvingContext)) {
                            multiValuesMap.put((Object)virtualFile, (Object)artifact);
                        }
                    }
                    return true;
                }

                private static /* synthetic */ void a(int n2) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n2) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "element";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "path";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/packaging/impl/artifacts/ArtifactBySourceFileFinderImpl$1";
                    objectArray[2] = "process";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }, packagingElementResolvingContext, true);
        }
        return multiValuesMap;
    }

    @Override
    public Collection<? extends Artifact> findArtifacts(@NotNull VirtualFile virtualFile) {
        MultiValuesMap multiValuesMap;
        if (virtualFile == null) {
            ArtifactBySourceFileFinderImpl.b(0);
        }
        if ((multiValuesMap = (MultiValuesMap)this.getFileToArtifactsMap().getValue()).isEmpty()) {
            return Collections.emptyList();
        }
        SmartList smartList = null;
        for (VirtualFile virtualFile2 = virtualFile; virtualFile2 != null; virtualFile2 = virtualFile2.getParent()) {
            Collection collection = multiValuesMap.get((Object)virtualFile2);
            if (collection == null) continue;
            if (smartList == null) {
                smartList = new SmartList();
            }
            smartList.addAll(collection);
        }
        return smartList != null ? smartList : Collections.emptyList();
    }

    private static /* synthetic */ void b(int n2) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceFile", "com/intellij/packaging/impl/artifacts/ArtifactBySourceFileFinderImpl", "findArtifacts"));
    }
}

