/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.artifacts;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.CompilerProjectExtension;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.artifacts.ArtifactProperties;
import com.intellij.packaging.artifacts.ArtifactTemplate;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.artifacts.ModifiableArtifact;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import com.intellij.packaging.elements.ArtifactRootElement;
import com.intellij.packaging.elements.ComplexPackagingElement;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.elements.PackagingElementType;
import com.intellij.packaging.impl.artifacts.PackagingElementPath;
import com.intellij.packaging.impl.artifacts.PackagingElementProcessor;
import com.intellij.packaging.impl.artifacts.ParentElementProcessor;
import com.intellij.packaging.impl.elements.ArtifactElementType;
import com.intellij.packaging.impl.elements.ArtifactPackagingElement;
import com.intellij.packaging.impl.elements.DirectoryCopyPackagingElement;
import com.intellij.packaging.impl.elements.DirectoryPackagingElement;
import com.intellij.packaging.impl.elements.ExtractedDirectoryPackagingElement;
import com.intellij.packaging.impl.elements.FileCopyPackagingElement;
import com.intellij.packaging.impl.elements.FileOrDirectoryCopyPackagingElement;
import com.intellij.packaging.impl.elements.ModuleOutputPackagingElement;
import com.intellij.packaging.impl.elements.PackagingElementFactoryImpl;
import com.intellij.packaging.impl.elements.ProductionModuleOutputPackagingElement;
import com.intellij.util.PathUtil;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FList;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArtifactUtil {
    private ArtifactUtil() {
    }

    public static CompositePackagingElement<?> copyFromRoot(@NotNull CompositePackagingElement<?> compositePackagingElement, @NotNull Project project2) {
        if (compositePackagingElement == null) {
            ArtifactUtil.a(0);
        }
        if (project2 == null) {
            ArtifactUtil.a(1);
        }
        CompositePackagingElement compositePackagingElement2 = (CompositePackagingElement)ArtifactUtil.a(compositePackagingElement, project2);
        ArtifactUtil.copyChildren(compositePackagingElement, compositePackagingElement2, project2);
        return compositePackagingElement2;
    }

    public static void copyChildren(CompositePackagingElement<?> compositePackagingElement, CompositePackagingElement<?> compositePackagingElement2, @NotNull Project project2) {
        if (project2 == null) {
            ArtifactUtil.a(2);
        }
        for (PackagingElement packagingElement : compositePackagingElement.getChildren()) {
            compositePackagingElement2.addOrFindChild(ArtifactUtil.copyWithChildren(packagingElement, project2));
        }
    }

    @NotNull
    public static <S> PackagingElement<S> copyWithChildren(@NotNull PackagingElement<S> packagingElement, @NotNull Project project2) {
        if (packagingElement == null) {
            ArtifactUtil.a(3);
        }
        if (project2 == null) {
            ArtifactUtil.a(4);
        }
        PackagingElement<S> packagingElement2 = ArtifactUtil.a(packagingElement, project2);
        if (packagingElement instanceof CompositePackagingElement) {
            ArtifactUtil.copyChildren((CompositePackagingElement)packagingElement, (CompositePackagingElement)packagingElement2, project2);
        }
        PackagingElement<S> packagingElement3 = packagingElement2;
        if (packagingElement3 == null) {
            ArtifactUtil.a(5);
        }
        return packagingElement3;
    }

    @NotNull
    private static <S> PackagingElement<S> a(@NotNull PackagingElement<S> packagingElement, @NotNull Project project2) {
        if (packagingElement == null) {
            ArtifactUtil.a(6);
        }
        if (project2 == null) {
            ArtifactUtil.a(7);
        }
        PackagingElement packagingElement2 = packagingElement.getType().createEmpty(project2);
        Object object = packagingElement.getState();
        if (object != null) {
            packagingElement2.loadState(object);
        } else {
            packagingElement2.noStateLoaded();
        }
        PackagingElement packagingElement3 = packagingElement2;
        if (packagingElement3 == null) {
            ArtifactUtil.a(8);
        }
        return packagingElement3;
    }

    public static <E extends PackagingElement<?>> boolean processPackagingElements(@NotNull Artifact artifact, @Nullable PackagingElementType<E> packagingElementType, final @NotNull Processor<? super E> processor, @NotNull PackagingElementResolvingContext packagingElementResolvingContext, boolean bl2) {
        if (artifact == null) {
            ArtifactUtil.a(9);
        }
        if (processor == null) {
            ArtifactUtil.a(10);
        }
        if (packagingElementResolvingContext == null) {
            ArtifactUtil.a(11);
        }
        return ArtifactUtil.processPackagingElements(artifact, packagingElementType, new PackagingElementProcessor<E>(){

            @Override
            public boolean process(@NotNull E e2, @NotNull PackagingElementPath packagingElementPath) {
                if (e2 == null) {
                    1.a(0);
                }
                if (packagingElementPath == null) {
                    1.a(1);
                }
                return processor.process(e2);
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "e";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "path";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/packaging/impl/artifacts/ArtifactUtil$1";
                objectArray[2] = "process";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, packagingElementResolvingContext, bl2);
    }

    public static <E extends PackagingElement<?>> boolean processPackagingElements(@NotNull Artifact artifact, @Nullable PackagingElementType<E> packagingElementType, @NotNull PackagingElementProcessor<? super E> packagingElementProcessor, @NotNull PackagingElementResolvingContext packagingElementResolvingContext, boolean bl2) {
        if (artifact == null) {
            ArtifactUtil.a(12);
        }
        if (packagingElementProcessor == null) {
            ArtifactUtil.a(13);
        }
        if (packagingElementResolvingContext == null) {
            ArtifactUtil.a(14);
        }
        return ArtifactUtil.processPackagingElements(artifact.getRootElement(), packagingElementType, packagingElementProcessor, packagingElementResolvingContext, bl2, artifact.getArtifactType());
    }

    public static <E extends PackagingElement<?>> boolean processPackagingElements(PackagingElement<?> packagingElement, @Nullable PackagingElementType<E> packagingElementType, @NotNull PackagingElementProcessor<? super E> packagingElementProcessor, @NotNull PackagingElementResolvingContext packagingElementResolvingContext, boolean bl2, ArtifactType artifactType) {
        if (packagingElementProcessor == null) {
            ArtifactUtil.a(15);
        }
        if (packagingElementResolvingContext == null) {
            ArtifactUtil.a(16);
        }
        return ArtifactUtil.a(packagingElement, packagingElementType, packagingElementProcessor, packagingElementResolvingContext, bl2, artifactType, PackagingElementPath.EMPTY, new HashSet());
    }

    private static <E extends PackagingElement<?>> boolean a(List<? extends PackagingElement<?>> list2, @Nullable PackagingElementType<E> packagingElementType, @NotNull PackagingElementProcessor<? super E> packagingElementProcessor, @NotNull PackagingElementResolvingContext packagingElementResolvingContext, boolean bl2, ArtifactType artifactType, @NotNull PackagingElementPath packagingElementPath, Set<PackagingElement<?>> set) {
        if (packagingElementProcessor == null) {
            ArtifactUtil.a(17);
        }
        if (packagingElementResolvingContext == null) {
            ArtifactUtil.a(18);
        }
        if (packagingElementPath == null) {
            ArtifactUtil.a(19);
        }
        for (PackagingElement<?> packagingElement : list2) {
            if (ArtifactUtil.a(packagingElement, packagingElementType, packagingElementProcessor, packagingElementResolvingContext, bl2, artifactType, packagingElementPath, set)) continue;
            return false;
        }
        return true;
    }

    public static void processRecursivelySkippingIncludedArtifacts(Artifact artifact, final Processor<PackagingElement<?>> processor, PackagingElementResolvingContext packagingElementResolvingContext) {
        ArtifactUtil.processPackagingElements(artifact.getRootElement(), null, new PackagingElementProcessor<PackagingElement<?>>(){

            @Override
            public boolean process(@NotNull PackagingElement<?> packagingElement, @NotNull PackagingElementPath packagingElementPath) {
                if (packagingElement == null) {
                    2.a(0);
                }
                if (packagingElementPath == null) {
                    2.a(1);
                }
                return processor.process(packagingElement);
            }

            @Override
            public boolean shouldProcessSubstitution(ComplexPackagingElement<?> complexPackagingElement) {
                return !(complexPackagingElement instanceof ArtifactPackagingElement);
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "path";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/packaging/impl/artifacts/ArtifactUtil$2";
                objectArray[2] = "process";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, packagingElementResolvingContext, true, artifact.getArtifactType());
    }

    private static <E extends PackagingElement<?>> boolean a(@NotNull PackagingElement<?> packagingElement, @Nullable PackagingElementType<E> packagingElementType, @NotNull PackagingElementProcessor<? super E> packagingElementProcessor, @NotNull PackagingElementResolvingContext packagingElementResolvingContext, boolean bl2, ArtifactType artifactType, @NotNull PackagingElementPath packagingElementPath, Set<PackagingElement<?>> set) {
        List list2;
        ComplexPackagingElement complexPackagingElement;
        if (packagingElement == null) {
            ArtifactUtil.a(20);
        }
        if (packagingElementProcessor == null) {
            ArtifactUtil.a(21);
        }
        if (packagingElementResolvingContext == null) {
            ArtifactUtil.a(22);
        }
        if (packagingElementPath == null) {
            ArtifactUtil.a(23);
        }
        if (!packagingElementProcessor.shouldProcess(packagingElement) || !set.add(packagingElement)) {
            return true;
        }
        if ((packagingElementType == null || packagingElement.getType().equals(packagingElementType)) && !packagingElementProcessor.process(packagingElement, packagingElementPath)) {
            return false;
        }
        if (packagingElement instanceof CompositePackagingElement) {
            CompositePackagingElement compositePackagingElement = (CompositePackagingElement)packagingElement;
            return ArtifactUtil.a(compositePackagingElement.getChildren(), packagingElementType, packagingElementProcessor, packagingElementResolvingContext, bl2, artifactType, packagingElementPath.appendComposite(compositePackagingElement), set);
        }
        if (packagingElement instanceof ComplexPackagingElement && bl2 && packagingElementProcessor.shouldProcessSubstitution(complexPackagingElement = (ComplexPackagingElement)packagingElement) && (list2 = complexPackagingElement.getSubstitution(packagingElementResolvingContext, artifactType)) != null) {
            return ArtifactUtil.a(list2, packagingElementType, packagingElementProcessor, packagingElementResolvingContext, bl2, artifactType, packagingElementPath.appendComplex(complexPackagingElement), set);
        }
        return true;
    }

    public static void removeDuplicates(@NotNull CompositePackagingElement<?> compositePackagingElement) {
        if (compositePackagingElement == null) {
            ArtifactUtil.a(24);
        }
        ArrayList<PackagingElement> arrayList = new ArrayList<PackagingElement>();
        ArrayList<PackagingElement> arrayList2 = new ArrayList<PackagingElement>();
        for (PackagingElement packagingElement : compositePackagingElement.getChildren()) {
            if (packagingElement instanceof CompositePackagingElement) {
                ArtifactUtil.removeDuplicates((CompositePackagingElement)packagingElement);
            }
            boolean bl2 = false;
            for (PackagingElement packagingElement2 : arrayList) {
                if (!packagingElement.isEqualTo(packagingElement2)) continue;
                if (packagingElement instanceof CompositePackagingElement) {
                    for (PackagingElement packagingElement3 : ((CompositePackagingElement)packagingElement).getChildren()) {
                        ((CompositePackagingElement)packagingElement2).addOrFindChild(packagingElement3);
                    }
                }
                bl2 = true;
                break;
            }
            if (bl2) {
                arrayList2.add(packagingElement);
                continue;
            }
            arrayList.add(packagingElement);
        }
        for (PackagingElement packagingElement : arrayList2) {
            compositePackagingElement.removeChild(packagingElement);
        }
    }

    public static <S> void copyProperties(ArtifactProperties<?> artifactProperties, ArtifactProperties<S> artifactProperties2) {
        artifactProperties2.loadState(artifactProperties.getState());
    }

    @Nullable
    public static String getDefaultArtifactOutputPath(@NotNull String string, @NotNull Project project2) {
        CompilerProjectExtension compilerProjectExtension;
        if (string == null) {
            ArtifactUtil.a(25);
        }
        if (project2 == null) {
            ArtifactUtil.a(26);
        }
        if ((compilerProjectExtension = CompilerProjectExtension.getInstance((Project)project2)) == null) {
            return null;
        }
        String string2 = compilerProjectExtension.getCompilerOutputUrl();
        if (string2 == null || string2.length() == 0) {
            VirtualFile virtualFile = project2.getBaseDir();
            if (virtualFile == null) {
                return null;
            }
            string2 = virtualFile.getUrl() + "/out";
        }
        return VfsUtilCore.urlToPath((String)string2) + "/artifacts/" + FileUtil.sanitizeFileName((String)string);
    }

    public static <E extends PackagingElement<?>> boolean processElementsWithSubstitutions(@NotNull List<? extends PackagingElement<?>> list2, @NotNull PackagingElementResolvingContext packagingElementResolvingContext, @NotNull ArtifactType artifactType, @NotNull PackagingElementPath packagingElementPath, @NotNull PackagingElementProcessor<E> packagingElementProcessor) {
        if (list2 == null) {
            ArtifactUtil.a(27);
        }
        if (packagingElementResolvingContext == null) {
            ArtifactUtil.a(28);
        }
        if (artifactType == null) {
            ArtifactUtil.a(29);
        }
        if (packagingElementPath == null) {
            ArtifactUtil.a(30);
        }
        if (packagingElementProcessor == null) {
            ArtifactUtil.a(31);
        }
        return ArtifactUtil.a(list2, packagingElementResolvingContext, artifactType, packagingElementPath, packagingElementProcessor, new THashSet());
    }

    private static <E extends PackagingElement<?>> boolean a(@NotNull List<? extends PackagingElement<?>> list2, @NotNull PackagingElementResolvingContext packagingElementResolvingContext, @NotNull ArtifactType artifactType, @NotNull PackagingElementPath packagingElementPath, @NotNull PackagingElementProcessor<E> packagingElementProcessor, Set<PackagingElement<?>> set) {
        if (list2 == null) {
            ArtifactUtil.a(32);
        }
        if (packagingElementResolvingContext == null) {
            ArtifactUtil.a(33);
        }
        if (artifactType == null) {
            ArtifactUtil.a(34);
        }
        if (packagingElementPath == null) {
            ArtifactUtil.a(35);
        }
        if (packagingElementProcessor == null) {
            ArtifactUtil.a(36);
        }
        for (PackagingElement<?> packagingElement : list2) {
            ComplexPackagingElement complexPackagingElement;
            List list3;
            if (!set.add(packagingElement) || !(packagingElement instanceof ComplexPackagingElement && packagingElementProcessor.shouldProcessSubstitution((ComplexPackagingElement)packagingElement) ? (list3 = (complexPackagingElement = (ComplexPackagingElement)packagingElement).getSubstitution(packagingElementResolvingContext, artifactType)) != null && !ArtifactUtil.a(list3, packagingElementResolvingContext, artifactType, packagingElementPath.appendComplex(complexPackagingElement), packagingElementProcessor, set) : !packagingElementProcessor.process(packagingElement, packagingElementPath))) continue;
            return false;
        }
        return true;
    }

    public static List<PackagingElement<?>> findByRelativePath(@NotNull CompositePackagingElement<?> compositePackagingElement, @NotNull String string, @NotNull PackagingElementResolvingContext packagingElementResolvingContext, @NotNull ArtifactType artifactType) {
        if (compositePackagingElement == null) {
            ArtifactUtil.a(37);
        }
        if (string == null) {
            ArtifactUtil.a(38);
        }
        if (packagingElementResolvingContext == null) {
            ArtifactUtil.a(39);
        }
        if (artifactType == null) {
            ArtifactUtil.a(40);
        }
        final ArrayList arrayList = new ArrayList();
        ArtifactUtil.processElementsByRelativePath(compositePackagingElement, string, packagingElementResolvingContext, artifactType, PackagingElementPath.EMPTY, new PackagingElementProcessor<PackagingElement<?>>(){

            @Override
            public boolean process(@NotNull PackagingElement<?> packagingElement, @NotNull PackagingElementPath packagingElementPath) {
                if (packagingElement == null) {
                    3.a(0);
                }
                if (packagingElementPath == null) {
                    3.a(1);
                }
                arrayList.add(packagingElement);
                return true;
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "packagingElement";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "path";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/packaging/impl/artifacts/ArtifactUtil$3";
                objectArray[2] = "process";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        return arrayList;
    }

    public static boolean processElementsByRelativePath(@NotNull CompositePackagingElement<?> compositePackagingElement, @NotNull String string, final @NotNull PackagingElementResolvingContext packagingElementResolvingContext, final @NotNull ArtifactType artifactType, @NotNull PackagingElementPath packagingElementPath, final @NotNull PackagingElementProcessor<PackagingElement<?>> packagingElementProcessor) {
        if (compositePackagingElement == null) {
            ArtifactUtil.a(41);
        }
        if (string == null) {
            ArtifactUtil.a(42);
        }
        if (packagingElementResolvingContext == null) {
            ArtifactUtil.a(43);
        }
        if (artifactType == null) {
            ArtifactUtil.a(44);
        }
        if (packagingElementPath == null) {
            ArtifactUtil.a(45);
        }
        if (packagingElementProcessor == null) {
            ArtifactUtil.a(46);
        }
        if ((string = StringUtil.trimStart((String)string, (String)"/")).isEmpty()) {
            return true;
        }
        int n2 = string.indexOf(47);
        final String string2 = n2 != -1 ? string.substring(0, n2) : string;
        final String string3 = n2 != -1 ? string.substring(n2 + 1) : "";
        return ArtifactUtil.processElementsWithSubstitutions(compositePackagingElement.getChildren(), packagingElementResolvingContext, artifactType, packagingElementPath.appendComposite(compositePackagingElement), new PackagingElementProcessor<PackagingElement<?>>(){

            @Override
            public boolean process(@NotNull PackagingElement<?> packagingElement, @NotNull PackagingElementPath packagingElementPath) {
                FileCopyPackagingElement fileCopyPackagingElement;
                if (packagingElement == null) {
                    4.a(0);
                }
                if (packagingElementPath == null) {
                    4.a(1);
                }
                boolean bl2 = false;
                if (packagingElement instanceof CompositePackagingElement && string2.equals(((CompositePackagingElement)packagingElement).getName())) {
                    bl2 = true;
                } else if (packagingElement instanceof FileCopyPackagingElement && string2.equals((fileCopyPackagingElement = (FileCopyPackagingElement)packagingElement).getOutputFileName())) {
                    bl2 = true;
                }
                if (bl2) {
                    if (string3.length() == 0) {
                        if (!packagingElementProcessor.process(packagingElement, packagingElementPath)) {
                            return false;
                        }
                    } else if (packagingElement instanceof CompositePackagingElement) {
                        return ArtifactUtil.processElementsByRelativePath((CompositePackagingElement)packagingElement, string3, packagingElementResolvingContext, artifactType, packagingElementPath, packagingElementProcessor);
                    }
                }
                return true;
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "path";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/packaging/impl/artifacts/ArtifactUtil$4";
                objectArray[2] = "process";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public static boolean processDirectoryChildren(@NotNull CompositePackagingElement<?> compositePackagingElement, @NotNull PackagingElementPath packagingElementPath, @NotNull String string, final @NotNull PackagingElementResolvingContext packagingElementResolvingContext, final @NotNull ArtifactType artifactType, final @NotNull PackagingElementProcessor<PackagingElement<?>> packagingElementProcessor) {
        if (compositePackagingElement == null) {
            ArtifactUtil.a(47);
        }
        if (packagingElementPath == null) {
            ArtifactUtil.a(48);
        }
        if (string == null) {
            ArtifactUtil.a(49);
        }
        if (packagingElementResolvingContext == null) {
            ArtifactUtil.a(50);
        }
        if (artifactType == null) {
            ArtifactUtil.a(51);
        }
        if (packagingElementProcessor == null) {
            ArtifactUtil.a(52);
        }
        return ArtifactUtil.processElementsByRelativePath(compositePackagingElement, string, packagingElementResolvingContext, artifactType, packagingElementPath, new PackagingElementProcessor<PackagingElement<?>>(){

            @Override
            public boolean process(@NotNull PackagingElement<?> packagingElement, @NotNull PackagingElementPath packagingElementPath) {
                List list2;
                if (packagingElement == null) {
                    5.a(0);
                }
                if (packagingElementPath == null) {
                    5.a(1);
                }
                return !(packagingElement instanceof DirectoryPackagingElement) || ArtifactUtil.processElementsWithSubstitutions(list2 = ((DirectoryPackagingElement)packagingElement).getChildren(), packagingElementResolvingContext, artifactType, packagingElementPath.appendComposite((DirectoryPackagingElement)packagingElement), packagingElementProcessor);
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "path";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/packaging/impl/artifacts/ArtifactUtil$5";
                objectArray[2] = "process";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public static void processFileOrDirectoryCopyElements(Artifact artifact, PackagingElementProcessor<FileOrDirectoryCopyPackagingElement<?>> packagingElementProcessor, PackagingElementResolvingContext packagingElementResolvingContext, boolean bl2) {
        ArtifactUtil.processPackagingElements(artifact, PackagingElementFactoryImpl.FILE_COPY_ELEMENT_TYPE, packagingElementProcessor, packagingElementResolvingContext, bl2);
        ArtifactUtil.processPackagingElements(artifact, PackagingElementFactoryImpl.DIRECTORY_COPY_ELEMENT_TYPE, packagingElementProcessor, packagingElementResolvingContext, bl2);
        ArtifactUtil.processPackagingElements(artifact, PackagingElementFactoryImpl.EXTRACTED_DIRECTORY_ELEMENT_TYPE, packagingElementProcessor, packagingElementResolvingContext, bl2);
    }

    public static Collection<Trinity<Artifact, PackagingElementPath, String>> findContainingArtifactsWithOutputPaths(final @NotNull VirtualFile virtualFile, @NotNull Project project2, Artifact[] artifactArray) {
        if (virtualFile == null) {
            ArtifactUtil.a(53);
        }
        if (project2 == null) {
            ArtifactUtil.a(54);
        }
        final boolean bl2 = CompilerConfiguration.getInstance((Project)project2).isResourceFile(virtualFile);
        final ArrayList<Trinity<Artifact, PackagingElementPath, String>> arrayList = new ArrayList<Trinity<Artifact, PackagingElementPath, String>>();
        final PackagingElementResolvingContext packagingElementResolvingContext = ArtifactManager.getInstance((Project)project2).getResolvingContext();
        for (final Artifact artifact : artifactArray) {
            ArtifactUtil.processPackagingElements(artifact, null, new PackagingElementProcessor<PackagingElement<?>>(){

                @Override
                public boolean process(@NotNull PackagingElement<?> packagingElement, @NotNull PackagingElementPath packagingElementPath) {
                    String string;
                    if (packagingElement == null) {
                        6.a(0);
                    }
                    if (packagingElementPath == null) {
                        6.a(1);
                    }
                    if (packagingElement instanceof FileOrDirectoryCopyPackagingElement) {
                        VirtualFile virtualFile2 = ((FileOrDirectoryCopyPackagingElement)packagingElement).findFile();
                        if (virtualFile2 != null && VfsUtilCore.isAncestor((VirtualFile)virtualFile2, (VirtualFile)virtualFile, (boolean)false)) {
                            String string2 = virtualFile2.equals(virtualFile) && packagingElement instanceof FileCopyPackagingElement ? ((FileCopyPackagingElement)packagingElement).getOutputFileName() : VfsUtilCore.getRelativePath((VirtualFile)virtualFile, (VirtualFile)virtualFile2, (char)'/');
                            arrayList.add(Trinity.create((Object)artifact, (Object)packagingElementPath, (Object)string2));
                            return false;
                        }
                    } else if (bl2 && packagingElement instanceof ModuleOutputPackagingElement && (string = ArtifactUtil.a(virtualFile, (ModuleOutputPackagingElement)packagingElement, packagingElementResolvingContext)) != null) {
                        arrayList.add(Trinity.create((Object)artifact, (Object)packagingElementPath, (Object)string));
                        return false;
                    }
                    return true;
                }

                private static /* synthetic */ void a(int n2) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n2) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "element";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "path";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/packaging/impl/artifacts/ArtifactUtil$6";
                    objectArray[2] = "process";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }, packagingElementResolvingContext, true);
        }
        return arrayList;
    }

    @Nullable
    private static String a(@NotNull VirtualFile virtualFile, @NotNull ModuleOutputPackagingElement moduleOutputPackagingElement, @NotNull PackagingElementResolvingContext packagingElementResolvingContext) {
        if (virtualFile == null) {
            ArtifactUtil.a(55);
        }
        if (moduleOutputPackagingElement == null) {
            ArtifactUtil.a(56);
        }
        if (packagingElementResolvingContext == null) {
            ArtifactUtil.a(57);
        }
        for (VirtualFile virtualFile2 : moduleOutputPackagingElement.getSourceRoots(packagingElementResolvingContext)) {
            if (!VfsUtilCore.isAncestor((VirtualFile)virtualFile2, (VirtualFile)virtualFile, (boolean)true)) continue;
            return VfsUtilCore.getRelativePath((VirtualFile)virtualFile, (VirtualFile)virtualFile2, (char)'/');
        }
        return null;
    }

    @Nullable
    public static VirtualFile findSourceFileByOutputPath(Artifact artifact, String string, PackagingElementResolvingContext packagingElementResolvingContext) {
        List<VirtualFile> list2 = ArtifactUtil.findSourceFilesByOutputPath(artifact.getRootElement(), string, packagingElementResolvingContext, artifact.getArtifactType());
        return list2.isEmpty() ? null : list2.get(0);
    }

    @Nullable
    public static VirtualFile findSourceFileByOutputPath(CompositePackagingElement<?> compositePackagingElement, String string, PackagingElementResolvingContext packagingElementResolvingContext, ArtifactType artifactType) {
        List<VirtualFile> list2 = ArtifactUtil.findSourceFilesByOutputPath(compositePackagingElement, string, packagingElementResolvingContext, artifactType);
        return list2.isEmpty() ? null : list2.get(0);
    }

    public static List<VirtualFile> findSourceFilesByOutputPath(CompositePackagingElement<?> compositePackagingElement, String string, PackagingElementResolvingContext packagingElementResolvingContext, ArtifactType artifactType) {
        String string2 = StringUtil.trimStart((String)string, (String)"/");
        if (string2.isEmpty()) {
            return Collections.emptyList();
        }
        int n2 = string2.indexOf(47);
        final String string3 = n2 != -1 ? string2.substring(0, n2) : string2;
        String string4 = n2 != -1 ? string2.substring(n2 + 1) : "";
        SmartList smartList = new SmartList();
        ArtifactUtil.processElementsWithSubstitutions(compositePackagingElement.getChildren(), packagingElementResolvingContext, artifactType, PackagingElementPath.EMPTY, new PackagingElementProcessor<PackagingElement<?>>((List)smartList, string4, packagingElementResolvingContext, artifactType, string2){
            final /* synthetic */ List val$result;
            final /* synthetic */ String val$tail;
            final /* synthetic */ PackagingElementResolvingContext val$context;
            final /* synthetic */ ArtifactType val$artifactType;
            final /* synthetic */ String val$path;
            {
                this.val$result = list2;
                this.val$tail = string2;
                this.val$context = packagingElementResolvingContext;
                this.val$artifactType = artifactType;
                this.val$path = string32;
            }

            @Override
            public boolean process(@NotNull PackagingElement<?> packagingElement, @NotNull PackagingElementPath packagingElementPath) {
                if (packagingElement == null) {
                    7.a(0);
                }
                if (packagingElementPath == null) {
                    7.a(1);
                }
                if (packagingElement instanceof CompositePackagingElement) {
                    CompositePackagingElement compositePackagingElement = (CompositePackagingElement)packagingElement;
                    if (string3.equals(compositePackagingElement.getName())) {
                        this.val$result.addAll(ArtifactUtil.findSourceFilesByOutputPath(compositePackagingElement, this.val$tail, this.val$context, this.val$artifactType));
                    }
                } else if (packagingElement instanceof FileCopyPackagingElement) {
                    FileCopyPackagingElement fileCopyPackagingElement = (FileCopyPackagingElement)packagingElement;
                    if (string3.equals(fileCopyPackagingElement.getOutputFileName()) && this.val$tail.isEmpty()) {
                        ContainerUtil.addIfNotNull((Collection)this.val$result, (Object)fileCopyPackagingElement.findFile());
                    }
                } else if (packagingElement instanceof DirectoryCopyPackagingElement || packagingElement instanceof ExtractedDirectoryPackagingElement) {
                    VirtualFile virtualFile = ((FileOrDirectoryCopyPackagingElement)packagingElement).findFile();
                    if (virtualFile != null) {
                        ContainerUtil.addIfNotNull((Collection)this.val$result, (Object)virtualFile.findFileByRelativePath(this.val$path));
                    }
                } else if (packagingElement instanceof ModuleOutputPackagingElement) {
                    CompilerConfiguration compilerConfiguration = CompilerConfiguration.getInstance((Project)this.val$context.getProject());
                    for (VirtualFile virtualFile : ((ModuleOutputPackagingElement)packagingElement).getSourceRoots(this.val$context)) {
                        VirtualFile virtualFile2 = virtualFile.findFileByRelativePath(this.val$path);
                        if (virtualFile2 == null || !compilerConfiguration.isResourceFile(virtualFile2)) continue;
                        this.val$result.add(virtualFile2);
                    }
                }
                return true;
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "elementPath";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/packaging/impl/artifacts/ArtifactUtil$7";
                objectArray[2] = "process";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        return smartList;
    }

    public static boolean processParents(@NotNull Artifact artifact, @NotNull PackagingElementResolvingContext packagingElementResolvingContext, @NotNull ParentElementProcessor parentElementProcessor, int n2) {
        if (artifact == null) {
            ArtifactUtil.a(58);
        }
        if (packagingElementResolvingContext == null) {
            ArtifactUtil.a(59);
        }
        if (parentElementProcessor == null) {
            ArtifactUtil.a(60);
        }
        return ArtifactUtil.a(artifact, packagingElementResolvingContext, parentElementProcessor, FList.emptyList(), n2, (Set<Artifact>)new THashSet());
    }

    private static boolean a(final @NotNull Artifact artifact, final @NotNull PackagingElementResolvingContext packagingElementResolvingContext, final @NotNull ParentElementProcessor parentElementProcessor, FList<Pair<Artifact, CompositePackagingElement<?>>> fList, final int n2, final Set<Artifact> set) {
        FList fList2;
        if (artifact == null) {
            ArtifactUtil.a(61);
        }
        if (packagingElementResolvingContext == null) {
            ArtifactUtil.a(62);
        }
        if (parentElementProcessor == null) {
            ArtifactUtil.a(63);
        }
        if (!set.add(artifact)) {
            return true;
        }
        CompositePackagingElement compositePackagingElement = artifact.getRootElement();
        if (compositePackagingElement instanceof ArtifactRootElement) {
            fList2 = fList;
        } else {
            if (!parentElementProcessor.process((CompositePackagingElement<?>)compositePackagingElement, (List<Pair<Artifact, CompositePackagingElement<?>>>)fList, artifact)) {
                return false;
            }
            fList2 = fList.prepend((Object)new Pair((Object)artifact, (Object)compositePackagingElement));
        }
        if (fList2.size() > n2) {
            return true;
        }
        for (final Artifact artifact2 : packagingElementResolvingContext.getArtifactModel().getArtifacts()) {
            PackagingElementProcessor<ArtifactPackagingElement> packagingElementProcessor;
            if (set.contains(artifact2) || ArtifactUtil.processPackagingElements(artifact2, ArtifactElementType.ARTIFACT_ELEMENT_TYPE, packagingElementProcessor = new PackagingElementProcessor<ArtifactPackagingElement>(){

                @Override
                public boolean shouldProcessSubstitution(ComplexPackagingElement<?> complexPackagingElement) {
                    return !(complexPackagingElement instanceof ArtifactPackagingElement);
                }

                @Override
                public boolean process(@NotNull ArtifactPackagingElement artifactPackagingElement, @NotNull PackagingElementPath packagingElementPath) {
                    if (artifactPackagingElement == null) {
                        8.a(0);
                    }
                    if (packagingElementPath == null) {
                        8.a(1);
                    }
                    if (artifact.getName().equals(artifactPackagingElement.getArtifactName())) {
                        CompositePackagingElement<?> compositePackagingElement;
                        FList fList = fList2;
                        List<CompositePackagingElement<?>> list2 = packagingElementPath.getParents();
                        int n22 = list2.size();
                        for (int i2 = 0; i2 < n22 - 1; ++i2) {
                            CompositePackagingElement<?> compositePackagingElement2 = list2.get(i2);
                            if (!parentElementProcessor.process(compositePackagingElement2, (List<Pair<Artifact, CompositePackagingElement<?>>>)fList, artifact2)) {
                                return false;
                            }
                            if ((fList = fList.prepend((Object)new Pair((Object)artifact2, compositePackagingElement2))).size() <= n2) continue;
                            return true;
                        }
                        if (!list2.isEmpty() && (compositePackagingElement = list2.get(list2.size() - 1)) instanceof ArtifactRootElement && !parentElementProcessor.process(compositePackagingElement, (List<Pair<Artifact, CompositePackagingElement<?>>>)fList, artifact2)) {
                            return false;
                        }
                        return ArtifactUtil.a(artifact2, packagingElementResolvingContext, parentElementProcessor, fList, n2, set);
                    }
                    return true;
                }

                private static /* synthetic */ void a(int n22) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n22) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "element";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "path";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/packaging/impl/artifacts/ArtifactUtil$8";
                    objectArray[2] = "process";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }, packagingElementResolvingContext, true)) continue;
            return false;
        }
        return true;
    }

    public static void removeChildrenRecursively(@NotNull CompositePackagingElement<?> compositePackagingElement, @NotNull Condition<PackagingElement<?>> condition) {
        if (compositePackagingElement == null) {
            ArtifactUtil.a(64);
        }
        if (condition == null) {
            ArtifactUtil.a(65);
        }
        ArrayList<PackagingElement> arrayList = new ArrayList<PackagingElement>();
        for (PackagingElement packagingElement : compositePackagingElement.getChildren()) {
            if (packagingElement instanceof CompositePackagingElement) {
                CompositePackagingElement compositePackagingElement2 = (CompositePackagingElement)packagingElement;
                ArtifactUtil.removeChildrenRecursively(compositePackagingElement2, condition);
                if (!compositePackagingElement2.getChildren().isEmpty()) continue;
                arrayList.add(packagingElement);
                continue;
            }
            if (!condition.value((Object)packagingElement)) continue;
            arrayList.add(packagingElement);
        }
        compositePackagingElement.removeChildren(arrayList);
    }

    public static boolean shouldClearArtifactOutputBeforeRebuild(Artifact artifact) {
        String string = artifact.getOutputPath();
        return !StringUtil.isEmpty((String)string) && artifact.getRootElement() instanceof ArtifactRootElement;
    }

    public static Set<Module> getModulesIncludedInArtifacts(@NotNull Collection<? extends Artifact> collection, @NotNull Project project2) {
        if (collection == null) {
            ArtifactUtil.a(66);
        }
        if (project2 == null) {
            ArtifactUtil.a(67);
        }
        THashSet tHashSet = new THashSet();
        PackagingElementResolvingContext packagingElementResolvingContext = ArtifactManager.getInstance((Project)project2).getResolvingContext();
        for (Artifact artifact : collection) {
            ArtifactUtil.processPackagingElements(artifact, null, arg_0 -> ArtifactUtil.a((Set)tHashSet, packagingElementResolvingContext, arg_0), packagingElementResolvingContext, true);
        }
        return tHashSet;
    }

    public static Collection<Artifact> getArtifactsContainingModuleOutput(@NotNull Module module2) {
        if (module2 == null) {
            ArtifactUtil.a(68);
        }
        ArtifactManager artifactManager = ArtifactManager.getInstance((Project)module2.getProject());
        PackagingElementResolvingContext packagingElementResolvingContext = artifactManager.getResolvingContext();
        HashSet<Artifact> hashSet = new HashSet<Artifact>();
        Processor processor = packagingElement -> {
            if (module2 == null) {
                ArtifactUtil.a(72);
            }
            if (packagingElement instanceof ProductionModuleOutputPackagingElement && module2.equals(((ProductionModuleOutputPackagingElement)packagingElement).findModule(packagingElementResolvingContext))) {
                return false;
            }
            return !(packagingElement instanceof ArtifactPackagingElement) || !hashSet.contains(((ArtifactPackagingElement)((Object)packagingElement)).findArtifact(packagingElementResolvingContext));
        };
        for (Artifact artifact : artifactManager.getSortedArtifacts()) {
            boolean bl2;
            boolean bl3 = bl2 = !ArtifactUtil.processPackagingElements(artifact, null, processor, packagingElementResolvingContext, true);
            if (!bl2) continue;
            hashSet.add(artifact);
        }
        return hashSet;
    }

    public static List<Artifact> getArtifactWithOutputPaths(Project project2) {
        ArrayList<Artifact> arrayList = new ArrayList<Artifact>();
        for (Artifact artifact : ArtifactManager.getInstance((Project)project2).getSortedArtifacts()) {
            if (StringUtil.isEmpty((String)artifact.getOutputPath())) continue;
            arrayList.add(artifact);
        }
        return arrayList;
    }

    public static String suggestArtifactFileName(String string) {
        return PathUtil.suggestFileName((String)string, (boolean)true, (boolean)true);
    }

    @Nullable
    public static Artifact addArtifact(@NotNull ModifiableArtifactModel modifiableArtifactModel, @NotNull ArtifactType artifactType, @NotNull ArtifactTemplate artifactTemplate) {
        String string;
        ArtifactTemplate.NewArtifactConfiguration newArtifactConfiguration;
        if (modifiableArtifactModel == null) {
            ArtifactUtil.a(69);
        }
        if (artifactType == null) {
            ArtifactUtil.a(70);
        }
        if (artifactTemplate == null) {
            ArtifactUtil.a(71);
        }
        if ((newArtifactConfiguration = artifactTemplate.createArtifact()) == null) {
            return null;
        }
        String string2 = string = newArtifactConfiguration.getArtifactName();
        int n2 = 2;
        while (modifiableArtifactModel.findArtifact(string2) != null) {
            string2 = string + n2;
            ++n2;
        }
        ArtifactType artifactType2 = newArtifactConfiguration.getArtifactType();
        if (artifactType2 == null) {
            artifactType2 = artifactType;
        }
        ModifiableArtifact modifiableArtifact = modifiableArtifactModel.addArtifact(string2, artifactType2, newArtifactConfiguration.getRootElement());
        artifactTemplate.setUpArtifact((Artifact)modifiableArtifact, newArtifactConfiguration);
        return modifiableArtifact;
    }

    private static /* synthetic */ boolean a(Set set, PackagingElementResolvingContext packagingElementResolvingContext, PackagingElement packagingElement) {
        if (packagingElement instanceof ModuleOutputPackagingElement) {
            ContainerUtil.addIfNotNull((Collection)set, (Object)((ModuleOutputPackagingElement)packagingElement).findModule(packagingElementResolvingContext));
        }
        return true;
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 5: 
            case 8: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldRoot";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 26: 
            case 54: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 6: 
            case 20: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/packaging/impl/artifacts/ArtifactUtil";
                break;
            }
            case 9: 
            case 12: 
            case 58: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 10: 
            case 13: 
            case 15: 
            case 17: 
            case 21: 
            case 31: 
            case 36: 
            case 46: 
            case 52: 
            case 60: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 11: 
            case 14: 
            case 16: 
            case 18: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvingContext";
                break;
            }
            case 19: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 24: 
            case 37: 
            case 41: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactName";
                break;
            }
            case 27: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 28: 
            case 33: 
            case 39: 
            case 43: 
            case 50: 
            case 57: 
            case 59: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 29: 
            case 34: 
            case 40: 
            case 44: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactType";
                break;
            }
            case 30: 
            case 35: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentPath";
                break;
            }
            case 38: 
            case 42: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathToParent";
                break;
            }
            case 53: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleElement";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifacts";
                break;
            }
            case 68: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactModel";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactTemplate";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/packaging/impl/artifacts/ArtifactUtil";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "copyWithChildren";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "copyElement";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "copyFromRoot";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "copyChildren";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "copyWithChildren";
                break;
            }
            case 5: 
            case 8: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "copyElement";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "processPackagingElements";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "processElementsRecursively";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "processElementRecursively";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "removeDuplicates";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultArtifactOutputPath";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "processElementsWithSubstitutions";
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "findByRelativePath";
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "processElementsByRelativePath";
                break;
            }
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "processDirectoryChildren";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "findContainingArtifactsWithOutputPaths";
                break;
            }
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "getRelativePathInSources";
                break;
            }
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "processParents";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "removeChildrenRecursively";
                break;
            }
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "getModulesIncludedInArtifacts";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "getArtifactsContainingModuleOutput";
                break;
            }
            case 69: 
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "addArtifact";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getArtifactsContainingModuleOutput$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

