/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.artifacts;

import com.intellij.CommonBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.RootModelProvider;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.ArtifactTemplate;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.elements.ArtifactRootElement;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementFactory;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.artifacts.JarArtifactFromModulesDialog;
import com.intellij.packaging.impl.artifacts.JarArtifactType;
import com.intellij.packaging.impl.artifacts.PlainArtifactType;
import com.intellij.packaging.impl.elements.LibraryPackagingElement;
import com.intellij.packaging.impl.elements.ManifestFileUtil;
import com.intellij.packaging.impl.elements.ProductionModuleOutputElementType;
import com.intellij.packaging.impl.elements.TestModuleOutputElementType;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import gnu.trove.THashSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class JarFromModulesTemplate
extends ArtifactTemplate {
    private static final Logger b = Logger.getInstance((String)"#com.intellij.packaging.impl.artifacts.JarFromModulesTemplate");
    private PackagingElementResolvingContext a;

    public JarFromModulesTemplate(PackagingElementResolvingContext packagingElementResolvingContext) {
        this.a = packagingElementResolvingContext;
    }

    public ArtifactTemplate.NewArtifactConfiguration createArtifact() {
        JarArtifactFromModulesDialog jarArtifactFromModulesDialog = new JarArtifactFromModulesDialog(this.a);
        if (!jarArtifactFromModulesDialog.showAndGet()) {
            return null;
        }
        return this.doCreateArtifact(jarArtifactFromModulesDialog.getSelectedModules(), jarArtifactFromModulesDialog.getMainClassName(), jarArtifactFromModulesDialog.getDirectoryForManifest(), jarArtifactFromModulesDialog.isExtractLibrariesToJar(), jarArtifactFromModulesDialog.isIncludeTests());
    }

    @Nullable
    public ArtifactTemplate.NewArtifactConfiguration doCreateArtifact(Module[] moduleArray, String string, final String string2, boolean bl2, boolean bl3) {
        String string3;
        VirtualFile virtualFile = null;
        Project project2 = this.a.getProject();
        if (string != null && !string.isEmpty() || !bl2) {
            try {
                string3 = (VirtualFile)ApplicationManager.getApplication().runWriteAction((ThrowableComputable)new ThrowableComputable<VirtualFile, IOException>(){

                    public VirtualFile compute() throws IOException {
                        return VfsUtil.createDirectoryIfMissing((String)string2);
                    }
                });
            }
            catch (IOException iOException) {
                b.info((Throwable)iOException);
                Messages.showErrorDialog((Project)project2, (String)("Cannot create directory '" + string2 + "': " + iOException.getMessage()), (String)CommonBundle.getErrorTitle());
                return null;
            }
            if (string3 == null) {
                return null;
            }
            virtualFile = ManifestFileUtil.createManifestFile((VirtualFile)string3, project2);
            if (virtualFile == null) {
                return null;
            }
            ManifestFileUtil.updateManifest(virtualFile, string, null, true);
        }
        string3 = moduleArray.length == 1 ? moduleArray[0].getName() : project2.getName();
        PackagingElementFactory packagingElementFactory = PackagingElementFactory.getInstance();
        CompositePackagingElement compositePackagingElement = packagingElementFactory.createArchive(ArtifactUtil.suggestArtifactFileName(string3) + ".jar");
        OrderEnumerator orderEnumerator = ProjectRootManager.getInstance((Project)project2).orderEntries(Arrays.asList(moduleArray));
        THashSet tHashSet = new THashSet();
        if (!bl3) {
            orderEnumerator = orderEnumerator.productionOnly();
        }
        ModulesProvider modulesProvider = this.a.getModulesProvider();
        OrderEnumerator orderEnumerator2 = orderEnumerator.using((RootModelProvider)modulesProvider).withoutSdk().runtimeOnly().recursively();
        orderEnumerator2.forEachLibrary((Processor)new CommonProcessors.CollectProcessor((Collection)tHashSet));
        orderEnumerator2.forEachModule(module2 -> {
            if (ProductionModuleOutputElementType.ELEMENT_TYPE.isSuitableModule(modulesProvider, (Module)module2)) {
                compositePackagingElement.addOrFindChild(packagingElementFactory.createModuleOutput(module2));
            }
            if (bl3 && TestModuleOutputElementType.ELEMENT_TYPE.isSuitableModule(modulesProvider, (Module)module2)) {
                compositePackagingElement.addOrFindChild(packagingElementFactory.createTestModuleOutput(module2));
            }
            return true;
        });
        JarArtifactType jarArtifactType = JarArtifactType.getInstance();
        if (virtualFile != null && !virtualFile.equals(ManifestFileUtil.findManifestFile(compositePackagingElement, this.a, jarArtifactType))) {
            compositePackagingElement.addFirstChild(packagingElementFactory.createFileCopyWithParentDirectories(virtualFile.getPath(), ManifestFileUtil.MANIFEST_DIR_NAME));
        }
        String string4 = string3 + ":jar";
        if (bl2) {
            JarFromModulesTemplate.a(compositePackagingElement, packagingElementFactory, (Set<Library>)tHashSet);
            return new ArtifactTemplate.NewArtifactConfiguration(compositePackagingElement, string4, (ArtifactType)jarArtifactType);
        }
        ArtifactRootElement artifactRootElement = packagingElementFactory.createArtifactRootElement();
        ArrayList<String> arrayList = new ArrayList<String>();
        artifactRootElement.addOrFindChild((PackagingElement)compositePackagingElement);
        this.a((Set<Library>)tHashSet, artifactRootElement, compositePackagingElement, arrayList);
        ManifestFileUtil.updateManifest(virtualFile, string, arrayList, true);
        return new ArtifactTemplate.NewArtifactConfiguration((CompositePackagingElement)artifactRootElement, string4, (ArtifactType)PlainArtifactType.getInstance());
    }

    private void a(Set<Library> set, ArtifactRootElement<?> artifactRootElement, CompositePackagingElement<?> compositePackagingElement, List<String> list2) {
        PackagingElementFactory packagingElementFactory = PackagingElementFactory.getInstance();
        for (Library library : set) {
            if (LibraryPackagingElement.getKindForLibrary(library).containsDirectoriesWithClasses()) {
                for (VirtualFile virtualFile : library.getFiles(OrderRootType.CLASSES)) {
                    if (virtualFile.isInLocalFileSystem()) {
                        compositePackagingElement.addOrFindChild(packagingElementFactory.createDirectoryCopyWithParentDirectories(virtualFile.getPath(), "/"));
                        continue;
                    }
                    PackagingElement packagingElement = packagingElementFactory.createFileCopyWithParentDirectories(VfsUtil.getLocalFile((VirtualFile)virtualFile).getPath(), "/");
                    artifactRootElement.addOrFindChild(packagingElement);
                    list2.addAll(ManifestFileUtil.getClasspathForElements(Collections.singletonList(packagingElement), this.a, PlainArtifactType.getInstance()));
                }
                continue;
            }
            List list3 = packagingElementFactory.createLibraryElements(library);
            list2.addAll(ManifestFileUtil.getClasspathForElements(list3, this.a, PlainArtifactType.getInstance()));
            artifactRootElement.addOrFindChildren((Collection)list3);
        }
    }

    private static void a(CompositePackagingElement<?> compositePackagingElement, PackagingElementFactory packagingElementFactory, Set<Library> set) {
        for (Library library : set) {
            if (LibraryPackagingElement.getKindForLibrary(library).containsJarFiles()) {
                for (VirtualFile virtualFile : library.getFiles(OrderRootType.CLASSES)) {
                    if (virtualFile.isInLocalFileSystem()) {
                        compositePackagingElement.addOrFindChild(packagingElementFactory.createDirectoryCopyWithParentDirectories(virtualFile.getPath(), "/"));
                        continue;
                    }
                    compositePackagingElement.addOrFindChild(packagingElementFactory.createExtractedDirectory(virtualFile));
                }
                continue;
            }
            compositePackagingElement.addOrFindChildren((Collection)packagingElementFactory.createLibraryElements(library));
        }
    }

    public String getPresentableName() {
        return "From modules with dependencies...";
    }
}

